package Spidy::Database::Sybase;

use Spidy::Database;
@ISA = ('Spidy::Database');
use DBD::Sybase;
use strict;

sub get_dbh {
  my $self = shift;
  return $self->{'dbh'} 
    if $self->{'dbh'} && $self->{'dbh'}->ping;
  my @opts;
  push @opts, "database=$self->{'database'}" if $self->{'database'};
  push @opts, "server=$self->{'server'}"     if $self->{'server'};
  my $opts = join ";", @opts;
  $self->{'dbh'} = DBI->connect( 
    "dbi:Sybase:$opts", 
    $self->{'user'}, 
    $self->{'password'}
  ) or die "Login Failed: $DBI::errstr";
  return $self->{'dbh'};
}

sub format_column_type {
  my $self = shift;
  my $col = shift;
  return "NUMERIC(9,0)"            if $col->{'type'} eq 'int';
  return "BIT"                     if $col->{'type'} eq 'bool';
  return $self->SUPER::format_column_type($col);
}

sub format_null_value {
  my $self = shift;
  my $col = shift;
  return if $col->{'type'} eq 'bool';
  return $self->SUPER::format_null_value($col);
}

sub format_column_value {
  my $self = shift;
  my $col = shift;
  if( $col->{'value'} eq 'auto' ) {
    return (
      undef,
      "IDENTITY",
      undef,
    );
  } else {
    return $self->SUPER::format_column_value($col)
  }
}

#
# no values for "IDENTITY" rows
#
sub filter_insert_cols {
  my $self = shift;
  return grep {
    $_->{'value'} ne 'auto'
  } @_;
}


sub format_value {
  my $self = shift;
  my $col  = shift;
  my $data = shift;
  
  if( $col->{'type'} eq 'bool' ) {
    return $data ? '1' : '0';
  }
  return $self->SUPER::format_value($col, $data);
}

1;
