package Spidy::List;

use Spidy::Object;
push @ISA, 'Spidy::Object';

use strict;
use Carp;

sub autoload_members {
    return {
        'next'        => 'scalar:object=Spidy::List',
        'previous'    => 'scalar:object=Spidy::List',
    };
}

sub link {
  my $self = shift;
  my $package;
  if( ref( $self ) ) {
    $package = ref($self) =~ /HASH|ARRAY/ ? __PACKAGE__  : ref($self);
  } else {
    $package = $self;
  }
  my $cursor = my $first = shift;
  return unless $first;
  confess( "can't bless non reference value: \"$cursor\"" ) unless ref($cursor);
  bless $cursor, $package unless UNIVERSAL::isa($cursor, $package );
  while( my $next = shift ) {
    confess( "can't bless non reference value" ) unless ref($next);
    bless $next, $package unless UNIVERSAL::isa($next, $package );
    $cursor->{'next'} = $next;
    $next->{'previous'} = $cursor;
    $cursor = $next;
  }
  delete $first->{'previous'};
  delete $cursor->{'next'};
  return $first;
}

sub first {
  my $self = shift;
  while(  my $prev = $self->{'previous'} ) {
    $self = $prev;
  }
  return $self;
}

sub last {
  my $self = shift;
  while( my $next = $self->{'next'} ) {
    $self = $next;
  }
  return $self;
}

sub append {
  my $self = shift;
  my $last = $self->last();
  my $list = $self->link(@_);
  $last->{'next'} = $list;
  $list->{'previous'} = $last;
  return $self;
}

sub prepend {
  my $self = shift;
  my $first = $self->first();
  my $list = $self->link(@_);
  my $last = $list->last();
  $first->{'previous'} = $last;
  $last->{'next'} = $first;
  return $list;
}

sub insert {
  my $self = shift;
  my $list = $self->link(@_);
  my $last = $list->last();
  $last->{'next'} = $self->{'next'};
  if( defined $self->{'next'} ) {  
    $self->{'next'}->{'previous'} = $last;
  }
  $self->{'next'} = $list;
  $list->{'previous'} = $self;
  return $self;
}  

sub replace {
  my $self = shift;
  my $list = $self->link(@_);
  my $last = $list->last();
  $last->{'next'} = $self->{'next'};
  if( defined $self->{'next'} ) {  
    $self->{'next'}->{'previous'} = $last;
  }
  $list->{'previous'} = $self->{'previous'};
  if( defined $self->{'previous'} ) {
    $self->{'previous'}->{'next'} = $list;
  }
  return $list;
  
}

sub remove { 
  my $self = shift;
  
  my $first = $self->first();
  if( $self == $first ) {
    $first = $self->{'next'};
  }
  if( defined $self->{'next'} ) {
    $self->{'next'}->{'previous'} = $self->{'previous'};
  }
  if( defined $self->{'previous'} ) {
    $self->{'previous'}->{'next'} = $self->{'next'};
  }
  # clean up dangling pointers
  $self->{'previous'} = undef;
  $self->{'next'} = undef;
  
  #return head pointer (may be new)
  return $first;
}

sub list {
  my $cur = shift->first();
  my @list = ($cur);
  while( $cur = $cur->{'next'} ) {
    push @list, $cur;
  }
  return wantarray ? @list : \@list;
}

sub count {
  my $cur = shift->first();
  my $count;
  ++$count and $cur = $cur->{'next'} while $cur;
  return $count;
}

sub pos {
  my $self = shift;
  my $cur = $self->first();
  my $pos=0;
  while( $cur ) {
    $pos++;
    last if $self == $cur;
    $cur = $cur->{'next'};
  }
  return $pos;
}

  

# sub DESTROY {
#   my $self = shift;
#   warn "DESTROY ", $count++, " ", ref($self), "\n";
#   if( $self->{'next'} ) {
#     $self->{'next'}->{'prev'} = undef;
#   }
#   if( $self->{'prev'} ) {
#     $self->{'prev'}->{'next'} = undef;
#   }
# }

1;
