package Spidy::Registry;
use Apache::Constants qw(:common REDIRECT);
use Spidy;
use CGI qw(:unescape);

use strict;
use constant GROUP_OBJECT => "Spidy::CGI::Group";
use constant IMAGE_OBJECT => "Spidy::CGI::Image";

my $NO  = '^(?i)(no|false)$';  # regular expression
my $YES = '^(?i)(yes|true)$';  # regular expression

sub handler ($$) {
  my $self = new(@_);
  return DECLINED unless -d $self->r->filename;
  
  chdir($self->r->filename());
  
  if( $self->r->method eq 'POST' ) {
    #
    # hack to get CGI to cache the POST'd data
    #
    my $content = $self->r->content();
    while( $content =~ /([^=&;]+)=([^&;]+)(?:&|;|$)/g ) {
      push @CGI::QUERY_PARAM, $1;
      $CGI::QUERY_PARAM{$1} = unescape($2);
    }
    $self->r->args($content);
  }

  unless ($self->r->path_info){
    #Issue an external redirect if the dir isn't tailed with a '/'
    my $uri = $self->r->uri;
    my $query = $self->r->args;
    $query = "?" . $query if defined $query;
    $self->r->header_out(Location => "$uri/$query");
    return REDIRECT;
  }

  return $self->run();
}

sub run {
  my $self = shift;
  $self->r->send_http_header('text/html');
  $self->r->print($self->s->get_html());
  return OK;
}

sub init {
  my $self = shift;
  return new Spidy(
    "file"                => $self->config_file(),
    "image_path"          => $self->image_path(),
    "sizes"               => $self->sizes(),
    "input_image_path"    => $self->input_image_path(),
    "output_image_path"   => $self->output_image_path(),
    "parent_url"          => $self->parent_url(),
    "group"               => $self->group_object(),
    "image"               => $self->image_object(),
    
    "group_template_file" => $self->group_template_file(),
    "image_template_file" => $self->image_template_file(),
    "bg_color"            => $self->bg_color(),
    "fg_color"            => $self->fg_color(),

    "database_server"     => $self->database_server(),
    "database_name"       => $self->database_name(),
    "database_user"       => $self->database_user(),
    "database_password"   => $self->database_password(),
    "database_port"       => $self->database_port(),
    "database_type"       => $self->database_type(),
    "warning_sql"         => $self->warning_sql(),
  );
}

my $r;
sub new {
  my $class = shift;
  $r = shift;
  return bless {}, $class;
}

sub r {
  return $r;
}

# this will be only instanciated once!  Each
# subsequent request will get the same config
# on a per directory basis
my %s;
sub s {
  my $self = shift;
  my $key = $self->base_url()."/".$self->config_file();
  my $time = (stat($self->config_file()))[9];
  return $s{$key}->{obj} if $s{$key}->{obj} && $s{$key}->{time} == $time;
  $s{$key}->{obj} = $self->init();
  $s{$key}->{time} = $time;
  return $s{$key}->{obj};
}

sub config_file {
  my $self = shift;
  my $file = $self->r->dir_config("ConfigFile");
  return undef unless $file;
  if( substr($file, 0, 1 ) eq '/' ) {
    return $file;
  } else {
    return $self->r->filename . "/" . $file;
  }
}

sub sizes {
  my $self = shift;
  my $size_str = $self->r->dir_config("Sizes");
  return undef unless $size_str;
  return [ split ',', $size_str ];
}

sub parent_url {
  my $self = shift;
  return $self->r->dir_config("ParentUrl");
}

sub group_object {
  my $self = shift;
  return $self->r->dir_config("GroupObject") || GROUP_OBJECT;
}

sub image_object {
  my $self = shift;
  return $self->r->dir_config("ImageObject") || IMAGE_OBJECT;
}

sub group_template_file {
  my $self = shift;
  return $self->r->dir_config("GroupTemplateFile");
}

sub image_template_file {
  my $self = shift;
  return $self->r->dir_config("ImageTemplateFile");
}

sub bg_color {
  my $self = shift;
  return $self->r->dir_config("BgColor");
}

sub fg_color {
  my $self = shift;
  return $self->r->dir_config("FgColor");
}

sub database_name {
  shift->r->dir_config("DatabaseName");
}

sub database_user {
  shift->r->dir_config("DatabaseUser");
}

sub database_password {
  shift->r->dir_config("DatabasePassword");
}

sub database_server {
  shift->r->dir_config("DatabaseServer");
}

sub database_port {
  shift->r->dir_config("DatabasePort");
}

sub database_type {
  shift->r->dir_config("DatabaseType");
}

sub warning_sql {
  return shift->r->dir_config("WarningSql") =~ /$YES/ ? 1 : 0;
}

sub base_url { 
  my $r = shift->r;
  my $base_url =  $r->dir_config("BaseUrl");
  if( substr($base_url, 0, 7) eq 'http://' ) {
    return $base_url;
  } elsif( $base_url ) {
    return 'http://' . $r->hostname . $base_url;
  } else {  
    return 'http://' . $r->hostname . $r->location;
  }
}

sub image_path {
  shift->r->dir_config("ImagePath");
}
sub output_image_path {
  my $self = shift;
  return $self->r->dir_config("OutputImagePath") || $self->r->filename . "/images";
}
sub input_image_path {
  shift->r->dir_config("InputImagePath");
}
1;
