/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ReflectionTestUtils {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final Log logger = LogFactory.getLog((Class)ReflectionTestUtils.class);

    public static void setField(Object target, String name, Object value) {
        ReflectionTestUtils.setField(target, name, value, null);
    }

    public static void setField(Object target, String name, Object value, Class type) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name, (Class)type);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting field [" + name + "] on target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }

    public static Object getField(Object target, String name) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting field [" + name + "] from target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }

    public static void invokeSetterMethod(Object target, String name, Object value) {
        ReflectionTestUtils.invokeSetterMethod(target, name, value, null);
    }

    public static void invokeSetterMethod(Object target, String name, Object value, Class type) {
        Method method;
        Class[] classArray;
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.notNull((Object)name, (String)"Method name must not be empty");
        if (type != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        } else {
            classArray = null;
        }
        Class[] paramTypes = classArray;
        String setterMethodName = name;
        if (!name.startsWith(SETTER_PREFIX)) {
            setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)name);
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), (String)setterMethodName, (Class[])paramTypes)) == null && !setterMethodName.equals(name)) {
            setterMethodName = name;
            method = ReflectionUtils.findMethod(target.getClass(), (String)setterMethodName, (Class[])paramTypes);
        }
        if (method == null) {
            throw new IllegalArgumentException("Could not find setter method [" + setterMethodName + "] on target [" + target + "] with parameter type [" + type + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking setter method [" + setterMethodName + "] on target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Method)method);
        ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{value});
    }

    public static Object invokeGetterMethod(Object target, String name) {
        Method method;
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Assert.notNull((Object)name, (String)"Method name must not be empty");
        String getterMethodName = name;
        if (!name.startsWith(GETTER_PREFIX)) {
            getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)name);
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), (String)getterMethodName)) == null && !getterMethodName.equals(name)) {
            getterMethodName = name;
            method = ReflectionUtils.findMethod(target.getClass(), (String)getterMethodName);
        }
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + getterMethodName + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking getter method [" + getterMethodName + "] on target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Method)method);
        return ReflectionUtils.invokeMethod((Method)method, (Object)target);
    }
}

