/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.IntroductionInfo;
import org.springframework.util.ClassUtils;

public class IntroductionInfoSupport
implements IntroductionInfo,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Set publishedInterfaces = new HashSet();
    private transient Map rememberedMethods = this.createRememberedMethodMap();

    public void suppressInterface(Class intf) {
        this.publishedInterfaces.remove(intf);
    }

    public Class[] getInterfaces() {
        return this.publishedInterfaces.toArray(new Class[this.publishedInterfaces.size()]);
    }

    public boolean implementsInterface(Class intf) {
        Iterator it = this.publishedInterfaces.iterator();
        while (it.hasNext()) {
            Class pubIntf = (Class)it.next();
            if (!intf.isInterface() || !intf.isAssignableFrom(pubIntf)) continue;
            return true;
        }
        return false;
    }

    protected void implementInterfacesOnObject(Object delegate) {
        this.publishedInterfaces.addAll(ClassUtils.getAllInterfacesAsSet((Object)delegate));
    }

    private Map createRememberedMethodMap() {
        return new IdentityHashMap(32);
    }

    protected final boolean isMethodOnIntroducedInterface(MethodInvocation mi) {
        Boolean rememberedResult = (Boolean)this.rememberedMethods.get(mi.getMethod());
        if (rememberedResult != null) {
            return rememberedResult;
        }
        boolean result = this.implementsInterface(mi.getMethod().getDeclaringClass());
        this.rememberedMethods.put(mi.getMethod(), result ? Boolean.TRUE : Boolean.FALSE);
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
        this.rememberedMethods = this.createRememberedMethodMap();
    }
}

