/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletWebRequest
extends ServletRequestAttributes
implements NativeWebRequest {
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private HttpServletResponse response;
    private boolean notModified = false;

    public ServletWebRequest(HttpServletRequest request) {
        super(request);
    }

    public ServletWebRequest(HttpServletRequest request, HttpServletResponse response) {
        super(request);
        this.response = response;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    public Object getNativeRequest() {
        return this.getRequest();
    }

    public Object getNativeResponse() {
        return this.getResponse();
    }

    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    public Map getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public boolean checkNotModified(long lastModifiedTimestamp) {
        if (!(lastModifiedTimestamp < 0L || this.notModified || this.response != null && this.response.containsHeader(HEADER_LAST_MODIFIED))) {
            long ifModifiedSince = this.getRequest().getDateHeader(HEADER_IF_MODIFIED_SINCE);
            boolean bl = this.notModified = ifModifiedSince >= lastModifiedTimestamp / 1000L * 1000L;
            if (this.response != null) {
                if (this.notModified) {
                    this.response.setStatus(304);
                } else {
                    this.response.setDateHeader(HEADER_LAST_MODIFIED, lastModifiedTimestamp);
                }
            }
        }
        return this.notModified;
    }

    public boolean isNotModified() {
        return this.notModified;
    }

    public String getDescription(boolean includeClientInfo) {
        HttpServletRequest request = this.getRequest();
        StringBuffer buffer = new StringBuffer();
        buffer.append("uri=").append(request.getRequestURI());
        if (includeClientInfo) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength(client)) {
                buffer.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                buffer.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength(user = request.getRemoteUser())) {
                buffer.append(";user=").append(user);
            }
        }
        return buffer.toString();
    }

    public String toString() {
        return "ServletWebRequest: " + this.getDescription(true);
    }
}

