/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInfo;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultIntroductionAdvisor
implements IntroductionAdvisor,
ClassFilter,
Ordered,
Serializable {
    private final Advice advice;
    private final Set interfaces = new HashSet();
    private int order = Integer.MAX_VALUE;

    public DefaultIntroductionAdvisor(Advice advice) {
        this(advice, advice instanceof IntroductionInfo ? (IntroductionInfo)advice : null);
    }

    public DefaultIntroductionAdvisor(Advice advice, IntroductionInfo introductionInfo) {
        Assert.notNull((Object)advice, (String)"Advice must not be null");
        this.advice = advice;
        if (introductionInfo != null) {
            Class[] introducedInterfaces = introductionInfo.getInterfaces();
            if (introducedInterfaces.length == 0) {
                throw new IllegalArgumentException("IntroductionAdviceSupport implements no interfaces");
            }
            for (int i = 0; i < introducedInterfaces.length; ++i) {
                this.addInterface(introducedInterfaces[i]);
            }
        }
    }

    public DefaultIntroductionAdvisor(DynamicIntroductionAdvice advice, Class intf) {
        Assert.notNull((Object)advice, (String)"Advice must not be null");
        this.advice = advice;
        this.addInterface(intf);
    }

    public void addInterface(Class intf) {
        Assert.notNull((Object)intf, (String)"Interface must not be null");
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("Specified class [" + intf.getName() + "] must be an interface");
        }
        this.interfaces.add(intf);
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public void validateInterfaces() throws IllegalArgumentException {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class ifc = (Class)it.next();
            if (!(this.advice instanceof DynamicIntroductionAdvice) || ((DynamicIntroductionAdvice)this.advice).implementsInterface(ifc)) continue;
            throw new IllegalArgumentException("DynamicIntroductionAdvice [" + this.advice + "] " + "does not implement interface [" + ifc.getName() + "] specified for introduction");
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public boolean isPerInstance() {
        return true;
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultIntroductionAdvisor)) {
            return false;
        }
        DefaultIntroductionAdvisor otherAdvisor = (DefaultIntroductionAdvisor)other;
        return this.advice.equals(otherAdvisor.advice) && ((Object)this.interfaces).equals(otherAdvisor.interfaces);
    }

    public int hashCode() {
        return this.advice.hashCode() * 13 + ((Object)this.interfaces).hashCode();
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + ": advice [" + this.advice + "]; interfaces " + ClassUtils.classNamesToString((Collection)this.interfaces);
    }
}

