/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.WindowState;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.bind.PortletRequestBindingException;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;
import org.springframework.web.portlet.handler.PortletRequestMethodNotSupportedException;
import org.springframework.web.portlet.mvc.annotation.PortletAnnotationMappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationHandlerMapping
extends AbstractMapBasedHandlerMapping<PortletMode> {
    private final Map<Class, RequestMapping> cachedMappings = new HashMap<Class, RequestMapping>();

    @Override
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        String[] beanNames;
        ApplicationContext context = this.getApplicationContext();
        String[] stringArray = beanNames = context.getBeanNamesForType(Object.class);
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Class handlerType = context.getType(beanName);
            RequestMapping mapping = (RequestMapping)context.findAnnotationOnBean(beanName, RequestMapping.class);
            if (mapping != null) {
                this.cachedMappings.put(handlerType, mapping);
                String[] modeKeys = mapping.value();
                String[] params = mapping.params();
                boolean registerHandlerType = true;
                if (modeKeys.length == 0 || params.length == 0) {
                    boolean bl = registerHandlerType = !this.detectHandlerMethods(handlerType, beanName, mapping);
                }
                if (registerHandlerType) {
                    TypeLevelMappingPredicate predicate = new TypeLevelMappingPredicate(params, mapping.headers(), mapping.method());
                    String[] stringArray2 = modeKeys;
                    int n3 = modeKeys.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String modeKey = stringArray2[n4];
                        this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                        ++n4;
                    }
                }
            } else if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) != null) {
                this.detectHandlerMethods(handlerType, beanName, mapping);
            }
            ++n2;
        }
    }

    protected boolean detectHandlerMethods(Class<?> handlerType, final String beanName, final RequestMapping typeMapping) {
        final HashSet handlersRegistered = new HashSet(1);
        LinkedHashSet handlerTypes = new LinkedHashSet();
        handlerTypes.add(handlerType);
        handlerTypes.addAll((Collection)Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate predicate = null;
                    String[] modeKeys = new String[]{};
                    String[] params = new String[]{};
                    if (typeMapping != null) {
                        params = StringUtils.mergeStringArrays((String[])typeMapping.params(), (String[])params);
                    }
                    ActionMapping actionMapping = (ActionMapping)AnnotationUtils.findAnnotation((Method)method, ActionMapping.class);
                    RenderMapping renderMapping = (RenderMapping)AnnotationUtils.findAnnotation((Method)method, RenderMapping.class);
                    ResourceMapping resourceMapping = (ResourceMapping)AnnotationUtils.findAnnotation((Method)method, ResourceMapping.class);
                    EventMapping eventMapping = (EventMapping)AnnotationUtils.findAnnotation((Method)method, EventMapping.class);
                    RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                    if (actionMapping != null) {
                        params = StringUtils.mergeStringArrays((String[])params, (String[])actionMapping.params());
                        predicate = new ActionMappingPredicate(actionMapping.value(), params);
                    } else if (renderMapping != null) {
                        params = StringUtils.mergeStringArrays((String[])params, (String[])renderMapping.params());
                        predicate = new RenderMappingPredicate(renderMapping.value(), params);
                    } else if (resourceMapping != null) {
                        predicate = new ResourceMappingPredicate(resourceMapping.value());
                    } else if (eventMapping != null) {
                        predicate = new EventMappingPredicate(eventMapping.value());
                    }
                    if (requestMapping != null) {
                        modeKeys = requestMapping.value();
                        if (typeMapping != null && !PortletAnnotationMappingUtils.validateModeMapping(modeKeys, typeMapping.value())) {
                            throw new IllegalStateException("Mode mappings conflict between method and type level: " + Arrays.asList(modeKeys) + " versus " + Arrays.asList(typeMapping.value()));
                        }
                        params = StringUtils.mergeStringArrays((String[])params, (String[])requestMapping.params());
                        if (predicate == null) {
                            predicate = new MethodLevelMappingPredicate(params);
                        }
                    }
                    if (predicate != null) {
                        if (modeKeys.length == 0) {
                            if (typeMapping != null) {
                                modeKeys = typeMapping.value();
                            }
                            if (modeKeys.length == 0) {
                                throw new IllegalStateException("No portlet mode mappings specified - neither at type nor at method level");
                            }
                        }
                        String[] stringArray = modeKeys;
                        int n = modeKeys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String modeKey = stringArray[n2];
                            DefaultAnnotationHandlerMapping.this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                            handlersRegistered.add(Boolean.TRUE);
                            ++n2;
                        }
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return !handlersRegistered.isEmpty();
    }

    @Override
    protected PortletMode getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }

    protected void validateHandler(Object handler, PortletRequest request) throws Exception {
        RequestMapping mapping = this.cachedMappings.get(handler.getClass());
        if (mapping == null) {
            mapping = (RequestMapping)AnnotationUtils.findAnnotation(handler.getClass(), RequestMapping.class);
        }
        if (mapping != null) {
            this.validateMapping(mapping, request);
        }
    }

    protected void validateMapping(RequestMapping mapping, PortletRequest request) throws Exception {
        RequestMethod[] mappedMethods = mapping.method();
        if (!PortletAnnotationMappingUtils.checkRequestMethod(mappedMethods, request)) {
            String[] supportedMethods = new String[mappedMethods.length];
            int i = 0;
            while (i < mappedMethods.length) {
                supportedMethods[i] = mappedMethods[i].name();
                ++i;
            }
            if (request instanceof ClientDataRequest) {
                throw new PortletRequestMethodNotSupportedException(((ClientDataRequest)request).getMethod(), supportedMethods);
            }
            throw new PortletRequestMethodNotSupportedException(supportedMethods);
        }
        Object[] mappedHeaders = mapping.headers();
        if (!PortletAnnotationMappingUtils.checkHeaders((String[])mappedHeaders, request)) {
            throw new PortletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])mappedHeaders, (String)", ") + "\" not met for actual request");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractParameterMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate {
        protected final String[] params;

        public AbstractParameterMappingPredicate(String[] params) {
            this.params = params;
        }

        @Override
        public boolean match(PortletRequest request) {
            return PortletAnnotationMappingUtils.checkParameters(this.params, request);
        }
    }

    private static class ActionMappingPredicate
    extends AbstractParameterMappingPredicate
    implements SpecialRequestTypePredicate {
        private final String actionName;

        public ActionMappingPredicate(String actionName, String[] params) {
            super(params);
            this.actionName = actionName;
        }

        public boolean match(PortletRequest request) {
            return "ACTION_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && ("".equals(this.actionName) || this.actionName.equals(request.getParameter("javax.portlet.action"))) && super.match(request);
        }

        public void validate(PortletRequest request) {
        }

        public int compareTo(Object other) {
            if (other instanceof TypeLevelMappingPredicate) {
                return 1;
            }
            if (other instanceof ActionMappingPredicate) {
                boolean otherHasActionName;
                ActionMappingPredicate otherAction = (ActionMappingPredicate)other;
                boolean hasActionName = "".equals(this.actionName);
                if (hasActionName != (otherHasActionName = "".equals(otherAction.actionName))) {
                    return hasActionName ? -1 : 1;
                }
                return new Integer(otherAction.params.length).compareTo(this.params.length);
            }
            return other instanceof SpecialRequestTypePredicate ? 0 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate,
    SpecialRequestTypePredicate {
        private final String eventName;

        public EventMappingPredicate(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public boolean match(PortletRequest request) {
            if (!"EVENT_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase"))) {
                return false;
            }
            if ("".equals(this.eventName)) {
                return true;
            }
            Event event = ((EventRequest)request).getEvent();
            return this.eventName.equals(event.getName()) || this.eventName.equals(event.getQName().toString());
        }

        @Override
        public void validate(PortletRequest request) {
        }

        public int compareTo(Object other) {
            boolean otherHasEventName;
            boolean hasEventName;
            if (other instanceof EventMappingPredicate && (hasEventName = "".equals(this.eventName)) != (otherHasEventName = "".equals(((EventMappingPredicate)other).eventName))) {
                return hasEventName ? -1 : 1;
            }
            return other instanceof SpecialRequestTypePredicate ? 0 : -1;
        }
    }

    private static class MethodLevelMappingPredicate
    extends AbstractParameterMappingPredicate {
        public MethodLevelMappingPredicate(String[] params) {
            super(params);
        }

        public void validate(PortletRequest request) throws PortletException {
        }

        public int compareTo(Object other) {
            if (other instanceof SpecialRequestTypePredicate) {
                return 1;
            }
            if (other instanceof AbstractParameterMappingPredicate) {
                return new Integer(((AbstractParameterMappingPredicate)other).params.length).compareTo(this.params.length);
            }
            return 0;
        }
    }

    private static class RenderMappingPredicate
    extends AbstractParameterMappingPredicate
    implements SpecialRequestTypePredicate {
        private final WindowState windowState;

        public RenderMappingPredicate(String windowState, String[] params) {
            super(params);
            this.windowState = "".equals(windowState) ? null : new WindowState(windowState);
        }

        public boolean match(PortletRequest request) {
            return "RENDER_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && (this.windowState == null || this.windowState.equals((Object)request.getWindowState())) && super.match(request);
        }

        public void validate(PortletRequest request) {
        }

        public int compareTo(Object other) {
            if (other instanceof TypeLevelMappingPredicate) {
                return 1;
            }
            if (other instanceof RenderMappingPredicate) {
                boolean otherHasWindowState;
                RenderMappingPredicate otherRender = (RenderMappingPredicate)other;
                boolean hasWindowState = this.windowState != null;
                boolean bl = otherHasWindowState = otherRender.windowState != null;
                if (hasWindowState != otherHasWindowState) {
                    return hasWindowState ? -1 : 1;
                }
                return new Integer(otherRender.params.length).compareTo(this.params.length);
            }
            return other instanceof SpecialRequestTypePredicate ? 0 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate,
    SpecialRequestTypePredicate {
        private final String resourceId;

        public ResourceMappingPredicate(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public boolean match(PortletRequest request) {
            return "RESOURCE_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && ("".equals(this.resourceId) || this.resourceId.equals(((ResourceRequest)request).getResourceID()));
        }

        @Override
        public void validate(PortletRequest request) {
        }

        public int compareTo(Object other) {
            boolean otherHasResourceId;
            boolean hasResourceId;
            if (other instanceof ResourceMappingPredicate && (hasResourceId = "".equals(this.resourceId)) != (otherHasResourceId = "".equals(((ResourceMappingPredicate)other).resourceId))) {
                return hasResourceId ? -1 : 1;
            }
            return other instanceof SpecialRequestTypePredicate ? 0 : -1;
        }
    }

    private static interface SpecialRequestTypePredicate {
    }

    private static class TypeLevelMappingPredicate
    extends AbstractParameterMappingPredicate {
        private final String[] headers;
        private final Set<String> methods = new HashSet<String>();

        public TypeLevelMappingPredicate(String[] params, String[] headers, RequestMethod[] methods) {
            super(params);
            this.headers = headers;
            if (methods != null) {
                RequestMethod[] requestMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    RequestMethod method = requestMethodArray[n2];
                    this.methods.add(method.name());
                    ++n2;
                }
            }
        }

        public void validate(PortletRequest request) throws PortletException {
            if (!PortletAnnotationMappingUtils.checkHeaders(this.headers, request)) {
                throw new PortletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])this.headers, (String)", ") + "\" not met for actual request");
            }
            if (!this.methods.isEmpty()) {
                if (!(request instanceof ClientDataRequest)) {
                    throw new PortletRequestMethodNotSupportedException(StringUtils.toStringArray(this.methods));
                }
                String method = ((ClientDataRequest)request).getMethod();
                if (!this.methods.contains(method)) {
                    throw new PortletRequestMethodNotSupportedException(method, StringUtils.toStringArray(this.methods));
                }
            }
        }

        public int compareTo(Object other) {
            if (other instanceof AbstractParameterMappingPredicate) {
                return new Integer(((AbstractParameterMappingPredicate)other).params.length).compareTo(this.params.length);
            }
            return other instanceof SpecialRequestTypePredicate ? -1 : 0;
        }
    }
}

