/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.factory.support;

import java.util.Map;
import org.springframework.asm.ClassReader;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.config.java.internal.factory.JavaConfigBeanFactory;
import org.springframework.config.java.internal.factory.support.ConfigurationModelBeanDefinitionReader;
import org.springframework.config.java.internal.factory.support.JavaConfigBeanDefinitionReader;
import org.springframework.config.java.internal.model.ConfigurationModel;
import org.springframework.config.java.internal.parsing.asm.AsmConfigurationParser;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmJavaConfigBeanDefinitionReader
implements JavaConfigBeanDefinitionReader {
    private final ConfigurationModelBeanDefinitionReader modelBeanDefinitionReader;
    private final JavaConfigBeanFactory beanFactory;

    public AsmJavaConfigBeanDefinitionReader(JavaConfigBeanFactory registry) {
        this.beanFactory = registry;
        this.modelBeanDefinitionReader = new ConfigurationModelBeanDefinitionReader(this.beanFactory);
    }

    @Override
    public int loadBeanDefinitions(Map<String, ClassPathResource> configClassResources) throws BeanDefinitionStoreException {
        ConfigurationModel model = new ConfigurationModel();
        AsmConfigurationParser parser = new AsmConfigurationParser(model);
        for (String id : configClassResources.keySet()) {
            String resourcePath = configClassResources.get(id).getPath();
            ClassReader configClassReader = AsmUtils.newClassReader(AsmUtils.getClassAsStream(resourcePath));
            parser.parse((Object)configClassReader, id);
        }
        model.assertIsValid();
        return this.modelBeanDefinitionReader.loadBeanDefinitions(model);
    }
}

