/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.lang.annotation.Annotation;
import java.util.List;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.aop.ScopedProxy;
import org.springframework.config.java.internal.model.AbstractValidatableAnnotatedMethod;
import org.springframework.config.java.internal.model.JavaConfigMethod;
import org.springframework.config.java.internal.model.UsageError;
import org.springframework.config.java.internal.util.AnnotationExtractionUtils;
import org.springframework.config.java.internal.util.MethodAnnotationPrototype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMethod
extends AbstractValidatableAnnotatedMethod<Bean> {
    private static final Bean DEFAULT_BEAN_ANNOTATION = AnnotationExtractionUtils.extractMethodAnnotation(Bean.class, new MethodAnnotationPrototype(){

        @Bean
        public void targetMethod() {
        }
    }.getClass());

    public BeanMethod(String name, Annotation ... annotations) {
        this(name, 0, annotations);
    }

    public BeanMethod(String name, int modifiers, Annotation ... annotations) {
        super(name, modifiers, annotations);
    }

    BeanMethod(String name) {
        this(name, DEFAULT_BEAN_ANNOTATION);
    }

    BeanMethod(String name, int modifiers) {
        this(name, modifiers, DEFAULT_BEAN_ANNOTATION);
    }

    public static boolean identifyAsBeanMethod(Annotation[] annotations) {
        return AnnotationExtractionUtils.findAnnotation(Bean.class, annotations) != null;
    }

    public boolean isScopedProxy() {
        return this.getScopedProxyMetadata() != null;
    }

    public ScopedProxy getScopedProxyMetadata() {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ScopedProxy) {
                return (ScopedProxy)annotation;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void detectUsageErrors(List<UsageError> errors) {
        super.detectUsageErrors(errors);
        Object[] compatibleAnnotationTypes = new Object[]{Bean.class, ScopedProxy.class};
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (!this.arrayContains(compatibleAnnotationTypes, anno.annotationType())) {
                errors.add(new JavaConfigMethod.IncompatibleAnnotationError(this, anno));
            }
            ++n2;
        }
        if (this.isScopedProxy() && (((Bean)this.getMetadata()).scope().equals("singleton") || ((Bean)this.getMetadata()).scope().equals("prototype"))) {
            errors.add(new InvalidScopedProxyDeclarationError());
        }
    }

    private boolean arrayContains(Object[] array, Object item) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object candidate = objectArray[n2];
            if (candidate.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public class InvalidScopedProxyDeclarationError
    extends UsageError {
        public InvalidScopedProxyDeclarationError() {
            super(BeanMethod.this.getDeclaringClass(), BeanMethod.this.getLineNumber());
        }

        public String getDescription() {
            return String.format("method %s contains an invalid annotation declaration: @%s cannot be used on a singleton/prototype bean", BeanMethod.this.getName(), ScopedProxy.class.getSimpleName());
        }
    }
}

