/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;

public class OperationFuture<T>
extends SpyObject
implements Future<T> {
    private final CountDownLatch latch;
    private final AtomicReference<T> objRef;
    protected OperationStatus status;
    private final long timeout;
    private Operation op;
    private final String key;
    private Long cas;

    public OperationFuture(String k, CountDownLatch l, long opTimeout) {
        this(k, l, new AtomicReference<Object>(null), opTimeout);
    }

    public OperationFuture(String k, CountDownLatch l, AtomicReference<T> oref, long opTimeout) {
        this.latch = l;
        this.objRef = oref;
        this.status = null;
        this.timeout = opTimeout;
        this.key = k;
        this.cas = null;
    }

    @Override
    public boolean cancel(boolean ign) {
        assert (this.op != null) : "No operation";
        this.op.cancel();
        return this.op.getState() == OperationState.WRITE_QUEUED;
    }

    public boolean cancel() {
        assert (this.op != null) : "No operation";
        this.op.cancel();
        return this.op.getState() == OperationState.WRITE_QUEUED;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(duration, units)) {
            MemcachedConnection.opTimedOut(this.op);
            if (this.op != null) {
                this.op.timeOut();
            }
            throw new CheckedOperationTimeoutException("Timed out waiting for operation", this.op);
        }
        MemcachedConnection.opSucceeded(this.op);
        if (this.op != null && this.op.hasErrored()) {
            throw new ExecutionException(this.op.getException());
        }
        if (this.isCancelled()) {
            throw new ExecutionException(new RuntimeException("Cancelled"));
        }
        if (this.op != null && this.op.isTimedOut()) {
            throw new ExecutionException(new CheckedOperationTimeoutException("Operation timed out.", this.op));
        }
        return this.objRef.get();
    }

    public String getKey() {
        return this.key;
    }

    public void setCas(long inCas) {
        this.cas = inCas;
    }

    public long getCas() {
        if (this.isDone() && this.getStatus().isSuccess() && this.cas == null) {
            throw new UnsupportedOperationException("ASCII Protocol does not return a CAS value");
        }
        return this.cas;
    }

    public OperationStatus getStatus() {
        if (this.status == null) {
            try {
                this.get();
            }
            catch (InterruptedException e) {
                this.status = new OperationStatus(false, "Interrupted");
                Thread.currentThread().isInterrupted();
            }
            catch (ExecutionException e) {
                this.getLogger().warn((Object)"Error getting status of operation", e);
            }
        }
        return this.status;
    }

    public void set(T o, OperationStatus s) {
        this.objRef.set(o);
        this.status = s;
    }

    public void setOperation(Operation to) {
        this.op = to;
    }

    @Override
    public boolean isCancelled() {
        assert (this.op != null) : "No operation";
        return this.op.isCancelled();
    }

    @Override
    public boolean isDone() {
        assert (this.op != null) : "No operation";
        return this.latch.getCount() == 0L || this.op.isCancelled() || this.op.getState() == OperationState.COMPLETE;
    }
}

