
(* This generated code requires the following version of MenhirLib: *)

let () =
  MenhirLib.StaticVersion.require_20231231

module MenhirBasics = struct
  
  exception Error
  
  let _eRR =
    fun _s ->
      raise Error
  
  type token = 
    | WHILE
    | VOID
    | VECTOR
    | UPPER
    | UNREACHABLE
    | UNITVECTOR
    | TUPLE
    | TRUNCATE
    | TRANSPOSE
    | TRANSFORMEDPARAMETERSBLOCK
    | TRANSFORMEDDATABLOCK
    | TIMESASSIGN
    | TIMES
    | TILDE
    | TARGET
    | STRINGLITERAL of (
# 93 "src/frontend/parser.mly"
       (string)
# 35 "src/frontend/parser.ml"
  )
    | SIMPLEX
    | SEMICOLON
    | RPAREN
    | ROWVECTOR
    | RETURN
    | REJECT
    | REALNUMERAL of (
# 91 "src/frontend/parser.mly"
       (string)
# 46 "src/frontend/parser.ml"
  )
    | REAL
    | RBRACK
    | RBRACE
    | RABRACK
    | QMARK
    | PROFILE
    | PRINT
    | POSITIVEORDERED
    | PLUSASSIGN
    | PLUS
    | PARAMETERSBLOCK
    | ORDERED
    | OR
    | OFFSET
    | NEQUALS
    | MULTIPLIER
    | MODULO
    | MODELBLOCK
    | MINUSASSIGN
    | MINUS
    | MATRIX
    | LPAREN
    | LOWER
    | LEQ
    | LDIVIDE
    | LBRACK
    | LBRACE
    | LABRACK
    | JACOBIAN
    | INTNUMERAL of (
# 90 "src/frontend/parser.mly"
       (string)
# 80 "src/frontend/parser.ml"
  )
    | INT
    | IN
    | IMAGNUMERAL of (
# 92 "src/frontend/parser.mly"
       (string)
# 87 "src/frontend/parser.ml"
  )
    | IF
    | IDIVIDE
    | IDENTIFIER of (
# 94 "src/frontend/parser.mly"
       (string)
# 94 "src/frontend/parser.ml"
  )
    | HAT
    | GEQ
    | GENERATEDQUANTITIESBLOCK
    | FUNCTIONBLOCK
    | FOR
    | FATAL_ERROR
    | EQUALS
    | EOF
    | ELTTIMESASSIGN
    | ELTTIMES
    | ELTPOW
    | ELTDIVIDEASSIGN
    | ELTDIVIDE
    | ELSE
    | DOTNUMERAL of (
# 91 "src/frontend/parser.mly"
       (string)
# 113 "src/frontend/parser.ml"
  )
    | DIVIDEASSIGN
    | DIVIDE
    | DATABLOCK
    | COVMATRIX
    | CORRMATRIX
    | CONTINUE
    | COMPLEXVECTOR
    | COMPLEXROWVECTOR
    | COMPLEXMATRIX
    | COMPLEX
    | COMMA
    | COLON
    | CHOLESKYFACTORCOV
    | CHOLESKYFACTORCORR
    | BREAK
    | BAR
    | BANG
    | ASSIGN
    | ARRAY
    | AND
  
end

include MenhirBasics

# 3 "src/frontend/parser.mly"
  
open Core
open Middle
open Ast
open Debugging
open Preprocessor

(* Takes a sized_basic_type and a list of sizes and repeatedly applies then
   SArray constructor, taking sizes off the list *)
let reducearray (sbt, l) =
  List.fold_right l ~f:(fun z y -> SizedType.SArray (y, z)) ~init:sbt

let build_id id loc =
  grammar_logger ("identifier " ^ id) ;
  {name= id; id_loc= location_span_of_positions loc}

let reserved (name, loc, _) =
  raise
    (Errors.SyntaxError
       (Errors.Parsing
          ( "Expected a new identifier but found reserved keyword '" ^ name
            ^ "'.\n"
          , location_span_of_positions loc ) ) )

let reserved_decl (name, loc, is_type) =
  if is_type then
    raise
      (Errors.SyntaxError
         (Errors.Parsing
            ( "Found a type ('" ^ name
              ^ "') where an identifier was expected.\n\
                 All variables declared in a comma-separated list must be of \
                 the same type.\n"
            , location_span_of_positions loc ) ) )
  else reserved (name, loc, is_type)

let build_expr expr loc = {expr; emeta= {loc= location_span_of_positions loc}}
let rec iterate_n f x = function 0 -> x | n -> iterate_n f (f x) (n - 1)

let parse_tuple_slot ix_str loc =
  match int_of_string_opt (String.drop_prefix ix_str 1) with
  | None ->
      raise
        (Errors.SyntaxError
           (Errors.Parsing
              ( "Failed to parse integer from string '" ^ ix_str
                ^ "' in tuple index. \nThe index is likely too large.\n"
              , location_span_of_positions loc ) ) )
  | Some ix -> ix

(** Given a parsed expression, try to convert it to
    a valid assignable lvalue. Raises a syntax error on failure *)
let try_convert_to_lvalue expr loc =
  match Ast.lvalue_of_expr_opt expr with
  | Some l -> l
  | None ->
    raise
        (Errors.SyntaxError
           (Errors.Parsing
              ( "Expected an assignable value but found a general expression.\n"
              , location_span_of_positions loc ) ) )

let nest_unsized_array basic_type n =
  iterate_n (fun t -> UnsizedType.UArray t) basic_type n


# 207 "src/frontend/parser.ml"

module Tables = struct
  
  include MenhirBasics
  
  let token2terminal : token -> int =
    fun _tok ->
      match _tok with
      | AND ->
          94
      | ARRAY ->
          93
      | ASSIGN ->
          92
      | BANG ->
          91
      | BAR ->
          90
      | BREAK ->
          89
      | CHOLESKYFACTORCORR ->
          88
      | CHOLESKYFACTORCOV ->
          87
      | COLON ->
          86
      | COMMA ->
          85
      | COMPLEX ->
          84
      | COMPLEXMATRIX ->
          83
      | COMPLEXROWVECTOR ->
          82
      | COMPLEXVECTOR ->
          81
      | CONTINUE ->
          80
      | CORRMATRIX ->
          79
      | COVMATRIX ->
          78
      | DATABLOCK ->
          77
      | DIVIDE ->
          76
      | DIVIDEASSIGN ->
          75
      | DOTNUMERAL _ ->
          74
      | ELSE ->
          73
      | ELTDIVIDE ->
          72
      | ELTDIVIDEASSIGN ->
          71
      | ELTPOW ->
          70
      | ELTTIMES ->
          69
      | ELTTIMESASSIGN ->
          68
      | EOF ->
          67
      | EQUALS ->
          66
      | FATAL_ERROR ->
          65
      | FOR ->
          64
      | FUNCTIONBLOCK ->
          63
      | GENERATEDQUANTITIESBLOCK ->
          62
      | GEQ ->
          61
      | HAT ->
          60
      | IDENTIFIER _ ->
          59
      | IDIVIDE ->
          58
      | IF ->
          57
      | IMAGNUMERAL _ ->
          56
      | IN ->
          55
      | INT ->
          54
      | INTNUMERAL _ ->
          53
      | JACOBIAN ->
          52
      | LABRACK ->
          51
      | LBRACE ->
          50
      | LBRACK ->
          49
      | LDIVIDE ->
          48
      | LEQ ->
          47
      | LOWER ->
          46
      | LPAREN ->
          45
      | MATRIX ->
          44
      | MINUS ->
          43
      | MINUSASSIGN ->
          42
      | MODELBLOCK ->
          41
      | MODULO ->
          40
      | MULTIPLIER ->
          39
      | NEQUALS ->
          38
      | OFFSET ->
          37
      | OR ->
          36
      | ORDERED ->
          35
      | PARAMETERSBLOCK ->
          34
      | PLUS ->
          33
      | PLUSASSIGN ->
          32
      | POSITIVEORDERED ->
          31
      | PRINT ->
          30
      | PROFILE ->
          29
      | QMARK ->
          28
      | RABRACK ->
          27
      | RBRACE ->
          26
      | RBRACK ->
          25
      | REAL ->
          24
      | REALNUMERAL _ ->
          23
      | REJECT ->
          22
      | RETURN ->
          21
      | ROWVECTOR ->
          20
      | RPAREN ->
          19
      | SEMICOLON ->
          18
      | SIMPLEX ->
          17
      | STRINGLITERAL _ ->
          16
      | TARGET ->
          15
      | TILDE ->
          14
      | TIMES ->
          13
      | TIMESASSIGN ->
          12
      | TRANSFORMEDDATABLOCK ->
          11
      | TRANSFORMEDPARAMETERSBLOCK ->
          10
      | TRANSPOSE ->
          9
      | TRUNCATE ->
          8
      | TUPLE ->
          7
      | UNITVECTOR ->
          6
      | UNREACHABLE ->
          5
      | UPPER ->
          4
      | VECTOR ->
          3
      | VOID ->
          2
      | WHILE ->
          1
  
  and error_terminal =
    0
  
  and token2value : token -> Obj.t =
    fun _tok ->
      match _tok with
      | AND ->
          Obj.repr ()
      | ARRAY ->
          Obj.repr ()
      | ASSIGN ->
          Obj.repr ()
      | BANG ->
          Obj.repr ()
      | BAR ->
          Obj.repr ()
      | BREAK ->
          Obj.repr ()
      | CHOLESKYFACTORCORR ->
          Obj.repr ()
      | CHOLESKYFACTORCOV ->
          Obj.repr ()
      | COLON ->
          Obj.repr ()
      | COMMA ->
          Obj.repr ()
      | COMPLEX ->
          Obj.repr ()
      | COMPLEXMATRIX ->
          Obj.repr ()
      | COMPLEXROWVECTOR ->
          Obj.repr ()
      | COMPLEXVECTOR ->
          Obj.repr ()
      | CONTINUE ->
          Obj.repr ()
      | CORRMATRIX ->
          Obj.repr ()
      | COVMATRIX ->
          Obj.repr ()
      | DATABLOCK ->
          Obj.repr ()
      | DIVIDE ->
          Obj.repr ()
      | DIVIDEASSIGN ->
          Obj.repr ()
      | DOTNUMERAL _v ->
          Obj.repr _v
      | ELSE ->
          Obj.repr ()
      | ELTDIVIDE ->
          Obj.repr ()
      | ELTDIVIDEASSIGN ->
          Obj.repr ()
      | ELTPOW ->
          Obj.repr ()
      | ELTTIMES ->
          Obj.repr ()
      | ELTTIMESASSIGN ->
          Obj.repr ()
      | EOF ->
          Obj.repr ()
      | EQUALS ->
          Obj.repr ()
      | FATAL_ERROR ->
          Obj.repr ()
      | FOR ->
          Obj.repr ()
      | FUNCTIONBLOCK ->
          Obj.repr ()
      | GENERATEDQUANTITIESBLOCK ->
          Obj.repr ()
      | GEQ ->
          Obj.repr ()
      | HAT ->
          Obj.repr ()
      | IDENTIFIER _v ->
          Obj.repr _v
      | IDIVIDE ->
          Obj.repr ()
      | IF ->
          Obj.repr ()
      | IMAGNUMERAL _v ->
          Obj.repr _v
      | IN ->
          Obj.repr ()
      | INT ->
          Obj.repr ()
      | INTNUMERAL _v ->
          Obj.repr _v
      | JACOBIAN ->
          Obj.repr ()
      | LABRACK ->
          Obj.repr ()
      | LBRACE ->
          Obj.repr ()
      | LBRACK ->
          Obj.repr ()
      | LDIVIDE ->
          Obj.repr ()
      | LEQ ->
          Obj.repr ()
      | LOWER ->
          Obj.repr ()
      | LPAREN ->
          Obj.repr ()
      | MATRIX ->
          Obj.repr ()
      | MINUS ->
          Obj.repr ()
      | MINUSASSIGN ->
          Obj.repr ()
      | MODELBLOCK ->
          Obj.repr ()
      | MODULO ->
          Obj.repr ()
      | MULTIPLIER ->
          Obj.repr ()
      | NEQUALS ->
          Obj.repr ()
      | OFFSET ->
          Obj.repr ()
      | OR ->
          Obj.repr ()
      | ORDERED ->
          Obj.repr ()
      | PARAMETERSBLOCK ->
          Obj.repr ()
      | PLUS ->
          Obj.repr ()
      | PLUSASSIGN ->
          Obj.repr ()
      | POSITIVEORDERED ->
          Obj.repr ()
      | PRINT ->
          Obj.repr ()
      | PROFILE ->
          Obj.repr ()
      | QMARK ->
          Obj.repr ()
      | RABRACK ->
          Obj.repr ()
      | RBRACE ->
          Obj.repr ()
      | RBRACK ->
          Obj.repr ()
      | REAL ->
          Obj.repr ()
      | REALNUMERAL _v ->
          Obj.repr _v
      | REJECT ->
          Obj.repr ()
      | RETURN ->
          Obj.repr ()
      | ROWVECTOR ->
          Obj.repr ()
      | RPAREN ->
          Obj.repr ()
      | SEMICOLON ->
          Obj.repr ()
      | SIMPLEX ->
          Obj.repr ()
      | STRINGLITERAL _v ->
          Obj.repr _v
      | TARGET ->
          Obj.repr ()
      | TILDE ->
          Obj.repr ()
      | TIMES ->
          Obj.repr ()
      | TIMESASSIGN ->
          Obj.repr ()
      | TRANSFORMEDDATABLOCK ->
          Obj.repr ()
      | TRANSFORMEDPARAMETERSBLOCK ->
          Obj.repr ()
      | TRANSPOSE ->
          Obj.repr ()
      | TRUNCATE ->
          Obj.repr ()
      | TUPLE ->
          Obj.repr ()
      | UNITVECTOR ->
          Obj.repr ()
      | UNREACHABLE ->
          Obj.repr ()
      | UPPER ->
          Obj.repr ()
      | VECTOR ->
          Obj.repr ()
      | VOID ->
          Obj.repr ()
      | WHILE ->
          Obj.repr ()
  
  and default_reduction =
    (16, "\000\000\000\240\000\030\000\000\000\000\000\031\000\028\000 \000\027\000!\000\"\000#\000\029\000\000\000\000\000\000\000\128\000\000\0015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\007\000\000\0018\000\000\0017\0016\000\000\000\000\000\000\001:\000\241\000\000\000\206\000\211\000\215\000\238\000\224\000\234\000v\000\232\000\223\000\216\000\203\000\230\000\213\000\233\000\229\000\222\000\201\000\221\000\235\000\236\000\202\000\217\000\237\000o\000\212\000\208\000\204\000u\000\199\000\207\000\231\000\205\000\200\000\228\000\227\000\210\000\218\000\219\000\220\000\214\000\226\000\225\000\209\000\239\000P\000O\000w\000\000\000\000\000\155\000\138\000\000\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\000\000,\000&\000\000\000\000\000\000\000\000\000\000\000%\000(\000'\000\000\000\000\000\000\000\140\000\000\000+\000\000\000j\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0000\000\000\000\000\000\000\000\000\000\000\000/\000\000\000\245\000\000\000\000\000\000\000-\000\000\000\000\000)\000\000\000*\000\000\0001\000\000\000\000\000.\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\011\000\000\000\000\000\000\000\000\000\000\001\012\001\t\000\000\000\000\000\000\000\000\000\000\001\r\001\b\000\000\000\000\000\000\001\014\000\000\000\000\000\000\001\015\000\000\000\000\000\000\000\000\000\000\001\016\001\n\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\251\000\000\000\000\000\249\000\000\000\006\000\005\000\250\000\000\001.\000\000\000\000\000\000\001/\000\000\000\000\000\000\001-\000\000\000\000\000\000\000\018\000\026\000\000\000\025\000\000\000\024\000\000\000\000\001\019\000\188\000\000\000\000\000\022\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023\000\000\000\020\000\000\000\019\000\146\001=\000\000\000\000\000\000\000\197\000R\000Q\000\000\000\000\001\003\000\000\000\000\000\000\000r\000\184\000\175\000\000\000E\000\000\000q\001<\000\000\000\000\000\000\000F\000\000\000\000\000\000\000C\001\018\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001,\000\000\000\183\000\000\000\017\001;\000\000\000\000\000\000\000\012\000\000\000\000\000\n\000\000\000\000\000\011\000\000\000\000\000\014\000\000\000\000\000\015\000\000\000\000\000\r\000\000\000\000\000\t\001\017\000\000\000\000\000\000\000D\000\000\000\000\000\000\000\145\000\000\000\000\000\142\000\000\000\136\000\000\000\148\000\000\000\000\000\147\000\144\000m\000\000\000\000\000\243\000\000\000n\000\001\000\000\000\130\000\000\000\000\000\000\000\000\000l\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\196\000\000\0014\000\000\000\000\000\000\001\026\0013\000\000\000\000\000\000\001#\000\000\000\000\000\000\000\000\000\000\001\"\000\000\000\000\000\000\000\000\001\027\000\000\001\024\000\000\000\000\000\000\001!\000\000\000\000\000\000\001 \000\000\000\000\000\000\000\000\000\000\000\000\001\028\000\000\000\000\001\023\000\000\000\000\000\000\001'\000\000\000\000\000\000\001&\000\000\000\000\000\000\000\000\001\029\000\000\000\000\000\000\000\000\001\030\000\000\000\000\000\000\000\000\000\000\000\000\001\031\000\000\001\025\000\000\000\000\000\000\000\000\000\000\000\000\001%\000\000\000\000\000\000\001$\000\000\000\000\000\000\000\000\000\000\000\000\001\001\000\000\000\000\000\255\000\000\000\b\000\007\001\000\000\000\0011\000\000\000\000\000\000\0012\000\000\000\000\000\000\0010\001\022\000\000\000\000\000\000\000\198\000\000\000\000\001\005\000\000\000\000\000\149\000\169\000t\000\185\000\177\000\000\000M\000\000\000s\000\000\000\000\000\000\000N\000\000\000\000\000\000\000K\000\000\000\132\001\021\000\000\000\000\000\000\000L\000\000\000B\000\000\000\000\000\000\000\000\000\000\000\000\000I\000\000\000\000\000\000\000\000\000J\000\000\000\000\000\000\000G\001)\001(\000\134\001\020\000\000\000\000\000\000\000H\000\000\001*\000\179\000\000\000\000\000\000\000\000\000\186\000\173\000\000\000\000\000\000\000\000\001+\000\181\000\000\000\000\000\000\000\000\000\141\000\000\000\000\000\000\000\000\000p\000\000\000\190\000\163\000\165\000\157\000\161")
  
  and error =
    (95, "1\000\b\128\000\b\002\000\016\000x\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\001\016\000\136\000\000\128 \000\000\007\128@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\001\000\000\000\000 \000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\136\000D\000\000@\016\000\000\003\192\000\000\000\000\000\000@\000\000\000\000\000\002 \001\016\000\001\000@\000\000\015\000\128\000\000\000\000\000\000\000\000\000\001\000\b\128\004@\000\004\001\000\000\000<\002\000\000\016\000\000\000\000\000\000\000\004\000\"\000\017\000\000\016\004\000\000\000\240\b\000\000\000\000\000\000\000\000\000\000\000\003\220\n\2449\170RZ\142\002?\238 \000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\"\000\017\000\000\016\004\000\000\000\240\b\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015p)\208\230\169Aj8\b\2558\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\004@\006 \000\002\000\128\000\001\030\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\"\000\017\000\000\016\004\000\000\000\240\t\238\005:\028\213(-G\001\031\231\016\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\b\016$\224\200\002\141\154\024\004\016\n\000\000\000\000\000\001\000\000\000\000\000\000\000@\128\128 \n6H\000\016\000\b\000\000\000\000\000\004\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\016  \b\002\141\146\000\004\000\002\000 @@\016\005\027$\000\b\000\004\000@\128\160 \n6H\000\016\000\b\000\129\001\000@\020l\144\000 \000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\198\015\tR\186\005\132\213\000\196@ D@\016\005\027$\000\b\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\016@a*F@\176\154 \016\136\000\000\000\000\000\000\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\198\015\tR2\005\132\209\000\196@ @@\016\005\027$\000\b\000\004\000#\024<%H\200\022\019D\003\017\000\129\001\000@\020l\144\000 \000\016\000\140`\240\149# XM\016\012D\002\004\004\001\000Q\178@\000\128\000@\0021\131\194T\140\129a4@1\016\004c\007\132\169\029\002\194j\128b \016 (\b\002\141\146\000\004\000\194\000 @P\016\005\027$\000\b\001\004\000\"\000,%H\200\022\019D\002\001\000\129\001\000@\020l\144\000 \000\016\000\140`\240\149# XM\016\012D\002\004\004\001\000Q\178@\000\128\000@\0021\131\194T\140\129a4@1\016\b\016\016\004\001F\201\000\002\000\001\000\b\198\015\tR2\005\132\209\000\196@ @@\016\005\027$\000\b\000\004\000#\024<%H\200\022\019D\003\017\000\129\001\000@\020l\144\000 \000\016\000\140`\240\149# XM\016\012D\002\004\004\001\000Q\178@\000\128\000@\0021\131\194T\140\129a4@1\016\b\016\016\004\001F\201\000\002\000\001\000\b\198\015\tR2\005\132\209\000\196@ @@\016\005\027$\000\b\000\004\000#\024<%H\200\022\019D\003\017\000\129\001\000@\020l\144\000 \000\016\000\136\0000\149# XM\016\004\004\002\004\004\001\000Q\178@\000\128\000@\0021\131\194T\140\129a4@1\016\b\016\016\004\001F\201\000\002\000\001\000\b\198\015\tR2\005\132\209\000\196@ @@\016\005\027$\000\b\000\004\000#\024<%H\200\022\019D\003\017\000\129\001\000@\020l\144\000 \000\016\000\140`\240\149# XM\016\012D\002\004\004\001\000Q\178@\000\128\000@\0021\131\194T\140\129a4@1\016\b\016\016\004\001F\201\000\002\000\001\000\b\198\015\tR2\005\132\209\000\196@ @@\016\005\027$\000\b\000\004\000#\024<%H\200\022\019D\003\017\000\129\001\000@\020l\144\000 \000\016\000\140`\240\149# XM\016\012D\000\000\001\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\b\016\020\004\001F\201\000\002\000a\000\000\000\b\000\000\000\000\000\000\000\128\000\017\000\022\018\164d\011\t\162\001\128\128@\128\160 \n6H\000\016\002\b\000D\000XJ\145\144,&\136\004\002\000\000\000\000\000\000\000\000\000\000\000\000\002\004\004\001\000Q\178@\000\128\000@\000\000\000\000\000\000\000\000\000\000\000\000\004A\007\132\169\025\002\194h\128@ \016\" \b\002\141\146\000\004\000\002\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000F0xJ\145\144,&\136\006\"\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\130\003\tR2\005\132\209\000\128@\000\000\000\000\000\000\000\000\000\000\000\000@\128\128 \n6H\000\016\000\b\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\024\193\225*F@\176\154 \024\136\0021\131\194T\140\129a4@1\016\004A\001\132\169\025\002\194h\128\000*0%\240\200\003\141\218\024\004\031\n\128\000\000\000\000\000\016\000\000\000\000\000\000@\128\128 \n6H\000\016\000\b\000D\000XJ\145\144,&\136\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\136\000D\000\000@\016\000\000\003\192 \000\000\000\000\000\004\000\000\000\000\000\000\016  \b\002\141\146\000\004\000\002\000\017\000\022\018\164d\011\t\162\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\002\004\004\001\000Q\178@\000\128\000@\002 \000\194T\140\129a4@ \016\b\016\016\004\001F\201\000\002\000\001\000\b\128\011\tR2\005\132\209\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\001\002\002\000\128(\217 \000@\000 \001\016\001a*F@\176\154 \000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\016  \b\002\141\146\000\004\000\002\000\017\000\022\018\164d\011\t\162\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\001\002\002\000\128(\217 \000@\000 \001\016\000a*F@\176\154 \016\b\004\b\b\002\000\163d\128\001\000\000\128\004@\005\132\169\025\002\194h\128\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\129\001\000@\020l\144\000 \000\016\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \001\016\000\136\000\000\128 \000\000\007\128@\000\002\000\000\000\000\000\000\000\000\128\004@\002 \000\002\000\128\000\000\030\001\000\000\b\000\000\000\000\000\000\000\002\000\017\000\b\128\000\b\002\000\000\000x\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\016\000\136\000D\000\000@\016\000\000\003\192 \000\000\000\000\000\000\000\000\000\000\000\002 \001\016\000\001\000@\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \001\016\000\136\000\000\128 \000\000\007\128@\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\017\000\b\128\000\b\002\000\000\000x\004\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000 \000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\132\003\tR2\005\132\209\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\129!\000@\020l\144\000 \000\016\000\000\000\000\000\000\000\000\000\000\000\000\001\016\128a*F@\176\154 \000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\0160 \b\002\141\146\000\004\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\004\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\012\b\002\000\163d\128\001\000\000\128\000\001\000\000\000\000\000\000\000\000@\000\b\130\003\tR2\005\132\209\000\128@\000\000\000\000\001\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\001F\004\190\153\000q\187C\000\131\225P\000\000\000\000\000 \000\000\000\000\000\000\b\024\016\004\001F\201\000\002\000\001\000\000\002\000\000\000\000\000\000\000\000\128\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q\129/\166@\028n\208\192 \248T\000\000\000\000\000\b\000\000\000\000\000\000\002\004\004\001\000Q\178@\000\128\000@\002 \128\194T\140\129a4@\000\021\024\018\248d\001\198\237\012\002\015\133@\000\000\000\000\000\128\000\000\000\000\000\000 \000\000\000\000\002\004\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\129\001\000@\020l\144\000 \000\016\000\136 0\149# XM\016\004\005F\004\190\025\000q\187C\000\131\225P\000\000\000\000\000 \000\000\000\000\000\000\b\024\016\004\001F\201\000\002\000\001\000\000\002\000\000\000\000\000\000\000\000\128\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\224S\161\205R\130\212p\017\254q\000\000\016\000\000\000\000\000\000\000\002\000{\129N\1355J\011Q\192G\249\196\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000@\015p)\208\230\169Aj8\b\2558\128\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\002\004\000\129\001\000@\020l\144\000 \000\016\000\136@0\149# XM\016\b\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\002\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\238\005:\028\213(-G\001\031\231\016\000\001\000\000\000\000\000\000\000\000 \000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\016\000\000\000\001\002\000@\128\128 \n6H\000\016\000\b\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002p\001\198U\174\129a}\192 P\b\017\016\004\001F\201\000\002\000\001\000\000\002\000\000\000\000\000\000\000\000\000\000\019\136\0142\172t\011\011\238\001\002\128\000\000\000\000\000\000\000\000\000\000\000\000F\000\024J\145\144,&\136\000\002\001\000\000\000\000\000\016 \000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\004\b\136\002\000\163d\128\001\000\000\128\000\001\000\000\000\000\000\000\000\000\000\000\016\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000@\128\128 \n6H\000\016\002\b\000\000\000\000\000\000\000\000\000\000\004\000\001\002\002\128\128(\217 \000@\000 \000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004@\005\132\169\025\002\194h\128@ \000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\156\000q\149c\160X_p\b\020\002\004\004\001\000Q\178@\000\128\000@\002!\000\194T\140\129a4@\000\016\000\000\000\000\000\000\000\000\000\000\000\000\016  \b\002\141\146\000\004\000\002\000\017\b\006\018\164d\011\t\162\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\129\001\000@\020l\144\000 \000\016\000\136@0\149# XM\016\000\004\000\000\000\000\000\000\000\000\000\000\000\000\004\b\b\002\000\163d\128\001\000\000\128\004B\001\132\169\025\002\194h\128\000 \000\000\000\000\000\000\000\000\000\000\000\000 @@\016\005\027$\000\b\000\004\000\"\016\012%H\200\022\019D\000\001\000\000\000\000\000\000\000\000\000\000\000\000\001\002\002\000\128(\217 \000@\000 \001\016\128a*F@\176\154 \000\b\000\000\000\000\000\000\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\132\003\tR2\005\132\209\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000{\129N\1355J\011Q\192G\249\196\000\000@\000\000\000\000\000\000\000\b\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\130\003\tR2\005\132\209\000\000T`K\225\144\007\027\1800\b>\021\000\000\000\000\000\000\000\000\000\000\000\000s\129o\167P\028n\208\208c\249\212\163\002_\012\1288\221\161\128A\240\168\000\000\000\000\000\000\000\000\000\000\000\002\140\t}2\000\227v\134\001\007\194\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000#\000\028%H\200\022\019D\002\001\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000@\002 \001\016\000\001\000@\000\000\143\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\196\000\"\128\000 \b\000@\001\224\016\000\000\000\000\000\000\000\000\000\000\000\000\003\000\000\002\004\000\0001\000@\000\000\000\000\000\000\000\004\000\000\000\000\000\012@\002(\000\002\000\128\000\000\030\001\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\192\000\000\129\000\000\b@\016\000\000\000\000\000\000\000\001\000\000\000\000\000\0010\006\138\017\000\128 \000\0007\152@\000\000\000\000\000\n\000\000\000\000\000\002\000\000\000\001@\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\129\001\000@\020l\144\000 \000\016\001\002\002\000\128(\217 \000@\000 \002\004\004\001\000Q\178@\000\128\000@\004\b\b\002\000\163d\128\001\000\000\128\004@\001\004\t\b\002\128h\128@\000\000\000\000\000\000\000\000\000\000\000\000\000 @@\016\005\027$\000\b\000\004\000\"\000\b H@\020\003D\002\000\000\129\001\000@\020l\144\000 \000\016\000\136\000 \129!\000P\r\016\b\000\001\016\000A\002C\000\160\026\160\016\000\002 \000\130\004\132\001@4@ \000\004@\001\004\t\b\002\128h\128@\000\b\128\002\b\018\016\005\000\209\000\128\000 @@\016\005\027$\000\b\000\004\000\"\000\b H@\020\003D\002\000\000\129\001\000@\020l\144\000 \000\016\000\136\000 \129!\000P\r\016\b\000\002\004\004\001\000Q\178@\000\128\000@\002 \000\130\004\132\001@4@ \000\b\016\016\004\001F\201\000\002\000\001\000\b\128\002\b\018\016\005\000\209\000\128\000 @@\016\005\027$\000\b\000\004\000\"\000\b H@\020\003D\002\000\000\129\001\000@\020l\144\000 \000\016\000\136\000 \129!\000P\r\016\b\000\002\004\004\001\000Q\178@\000\128\000@\002 \000\130\004\132\001@4@ \000\b\016\016\004\001F\201\000\002\000\001\000\b\128\002\b\018\016\005\000\209\000\128\000 @@\016\005\027$\000\b\000\004\000\"\000\b H@\020\003D\002\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\002\004\004\001\000Q\178@\000\128\000@\002 \000\130\004\132\001@4@\000\000\000\000\000\000\000\000\000\000\000\000\000\128\016  \b\002\141\146\000\004\000\002\000\017\000\004\016$ \n\001\162\001\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\001\002\002\000\128(\217 \000@\000 \001\016\000A\002B\000\160\026 \000\000\000\000\000\000\000\000\000\000\000\000\000@\b\016\016\004\001F\201\000\002\000\001\000\b\128\002\b\018\016\005\000\209\000\128\000\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\129\001\000@\020l\144\000 \000\016\000\136\000 \129!\000P\r\016\000\000\000\000\000\000\000\000\000\000\000\000\000 \004\b\b\002\000\163d\128\001\000\000\128\004@\001\004\t\b\002\128h\128@\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000@\128\128 \n6H\000\016\000\b\000D\000\016@\144\128(\006\136\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000 @@\016\005\027$\000\b\000\004\000\"\000,%H\200\022\019D\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\004\b\b\002\000\163d\128\001\000\000\128\004@\005\132\169\025\002\194h\128\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\t\128$@\136\004\001\000\000\001\188\194\000\000\000\000\000\000@\000\000\000\000\000\001\002\002\000\128(\217 \000@\000 \001\016\001a*F@\176\154 \000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000 @@\016\005\027$\000\b\000\004\000\"\000,%H\200\022\019D\000\001\000\000\000\000\000\000\000\000\000\000\000\000\247\002\189\014j\1486\163\128\143\251\136\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\128\011\tR2\005\132\209\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\129\001\000@\020l\144\000 \000\016\000\136\000\176\149# XM\016\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\128\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\016  \b\002\141\146\000\004\000\002\000\017\000\006\018\164d\011\t\162\001\000\128@\128\128 \n6H\000\016\000\b\000D\000XJ\145\144,&\136\000\002\000\000\000\000\000\000\000\000\000\000\000\001\238\005z\028\213(mG\001\031\247\016@\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\b\000\000\000\000\000\000 @@\016\005\027$\000\b\000\004\000\"\000,%H\200\022\019D\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\002\004\004\001\000Q\178@\000\128\000@\002 \002\194T\140\129a4@\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\n\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000@\128\128 \n6H\000\016\000\b\000D\000XJ\145\144,&\136\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001@\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\b\016\016\004\001F\201\000\002\000\001\000\b\128\011\tR2\005\132\209\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000(\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\001\002\002\000\128(\217 \000@\000 \001\016\000a*F@\176\154 \016\b\004\b\b\002\000\163d\128\001\000\000\128\004@\005\132\169\025\002\194h\128\000 \000\000\000\000\000\000\000\000\000\000\000\030\224W\161\205R\134\212p\017\255q\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\001\002\002\000\128(\217 \000@\000 \001\016\001a*F@\176\154 \016\b\004\b\b\002\000\163d\128\001\000\000\128\004@\005\132\169\025\002\194h\128\000 \000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\129\001\000@\020l\144\000 \000\016\000\136\000\176\149# XM\016\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \0010\004\136\017\000\128 \000\0007\152@\000\002\000\000\000\000\000\000\000\000\128\004\192\018 D\002\000\128\000\000\222a\000\000\b\000\000\000\000\000\000\000\002\000\019\000H\129\016\b\002\000\000\003y\132\000\000\000\000\000\000\000\000\000\000\000\000\000\000@\000\000\000\000\000\000\000\016\000\152\002D\b\128@\016\000\000\027\204 \000\000\000\000\000\000\000\000\000\000\000\002`\t\016\"\001\000@\000\000o0\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \0010\004\136\017\000\128 \000\0007\152@\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\019\000H\129\016\b\002\000\000\003y\132\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\184\020\232sT\160\181\028\004\127\156@\000\004\000\000\000\000\000\000\000\000\128\030\224S\161\205R\130\212p\017\254q\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\000\000\004\000\247\002\157\014j\148\022\163\128\143\243\136\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000 @@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000@\128\000\000\000\000\000\000\000\000\000\000\000\030\224S\161\205R\130\212p\017\254q\000\000\016\000\000\000\000\000\000\000\002\000\000\000 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\001\000\000\000\000\016 \004\b\b\002\000\163d\128\001\000\000\128\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\192\026(D\002\000\128\000\000\222a\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\247\002\157\014j\148\022\163\128\143\243\136\000\000\128\000\000\000\000\000\000\000\016\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\024\000\000\016 \000\001\b\000\000\000\000\000\000\000\000\000 \000\000\000\000\000\167\002\223N\1608\221\161\128G\243\169\238\005:\028\213(-G\001\031\231\016\000\001\000\000\000\000\000\000\000\000 \000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\224[\233\212\007\027\1800\b\254u=\192\167C\154\165\005\168\224#\252\226\000\000 \000\000\000\000\000\000\000\004\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\002\000\000\000\000 @\b\016\016\004\001F\201\000\002\000\001\000\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\220\nt9\170PZ\142\002?\206 \000\002\000\000\000\000\000\000\000\000@\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\128\000\000\129\000\000\b@\000\000\000\000\000\000\000\000\001\000\000\000\000\000\0010\006\138\017\000\128 \000\0007\152@\000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000 \000\000\000@\000\002\016\000\000\000\000\000\000\000\000\000@\000\000\000\000\001N\005\190\157@q\187C\000\143\231P\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\132\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000Q\129/\166@\028n\208\192 \248T\000\000\000@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\128\000\000\000\000\000\000\000\000\002\000\000\000\000\000\np-\244\234\003\141\218\024\004\127:\128\000\000\b\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")
  
  and start =
    2
  
  and action =
    ((16, "\029R\000\000\000\000\000S\029R\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000-\000\031\000\031\000\000\000\020\000\000$\232\000:\029R\000\000\029R\000\021\029R\000\000\000\184\000\000\000\140\000\000\000\000\000\012\029R\000\202\000\000\000\000\002\226\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\188$:\000\000\000\000\029R\002\226\000\000\000\246\002(\000\200\029\192\000\029\001\014\000\000\000\000\029\192\029\192\029\192\031\028\029\192\000\000\000\000\000\000\029\192\005\218\029\192\000\000\001\026\000\000\019h\000\000\029\192\006\242\029\192\007~\029\192\b\n\029\192\b\150\006f\029\192\030\030\020D\029\192\t\"\029\192\t\174\029\192\n:\029\192\n\198\029\192\011R\029\192\011\222\029\192\012j\029\192\012\246\029\192\002\226\029\192\r\130\029\192\014\014\029\192\014\154\029\192\015&\029\192\015\178\029\192\016>\029\192\016\202\029\192\017V\000\029\000\000\029\192\000\003\019\214\030t\020\168\000\000\029\192\000\000\002\226\029\192\001(\000\000\017\226\0010\000\000\001:\000\000\021\022\000\000\029\192\001b\000\000\018n\018\250\019\214\003\148\001(\029\192\019h\000\000\0012\003\148\001,\029\192\021\022\000\000\000\000\0014\029\192\023(\029\192\021\132\000\000\000\000\001F\029\192\021\242\000\000\001H\029\192\023(\000\000\001d\029\192\023\140\029\192\023\140\000\000\000\000\001j\029\192\001\162\000\000\001<\003\148\000V\003\148\000\196\003\148\000\000\000\198\003\148\000\000\003\148\000\000\000\000\000\000\001\196\000\000\001P\003\148\001\214\000\000\001T\003\148\001\224\000\000\000\029\029\192\002\226\000\000\000\000\029\192\000\000\019h\000\000\001\224\029\192\000\000\000\000\001\024\002 \000\000\029\192\001&\021\132\001\238\002.\0028\001\252\003\148\002\014\029\192\001\152\002L\000\000\003\148\002\026\029\192\020D\003\148\002\028\000\011\002\n\029\192\021\242\003\148\002,\029\192\001\176\002x\000\000\002|\000\000\002~\000\000\000\000\000\000\002\226\000&\002\226\000\000\000\000\000\000\000N\002\226\000\000\000$\029\192\021\242\000\000\000\000\000\000\002\136\000\000\000$\000\000\000\000\002\226\000&\002\140\000\000\000$\029\192\002\128\000\000\000\000\004:\029\192\002\142\004\196\000\000\002\226\000\011\002^\029\192\002\152\000@\002^\031\028\002(\031r\002\162\000\000\022`\000\000\002\184\000\000\000\000\005N\029\192\019\214\000\000\029\192\020D\000\000\029\192\020\168\000\000\029\192\021\022\000\000\029\192\021\132\000\000\029\192\022`\000\000\029\192\022\196\000\000\000\000\002\226\000&\002\188\000\000\029\192\022`\003\148\000\000\000\003\003\148\000\000\003\148\000\000\002\184\000\000\002\226\002\194\000\000\000\000\000\000\001\200$:\000\000\002r\000\000\000\000\031\182\000\000\002(\002\150\031\182\002\238\000\000\000\000\003\148\002\210\029b\000I\000,\002\132\031\208\031\208\031\208\031\208 2\000\000\031\208 X\031\208 ~\030\172 \218!\000!&\031\208!\130\031\208!\168\031\208!\206\031\208\"*\031\208\"P\031\208\"v\031\208\"\210\031\208\"\248\031\208#\030\002\232\002\142\031\208\000\184\002\148\031\208#z\003\004\002\166\031\208$\"\002\176\031\208#\160\003 \002\184\031\208$r\002\190\031\208#\198\003p\002\224\031\208$\210\003j\000\000\003p\000\000\003J\029\192\023\240\000\000\000\000\003L\029\192\024T\000\000\003V\002(\003R\029\192\024\184\000\000\000I\003T\029\192\025\028\000\000\001r\000\000\003X\029\192\025\128\000\000\003d\029\192\025\228\000\000\000I\003h\029\192\023\240\029\192\026H\000\000\001v\000,\000\000\003j\029\192\026\172\000\000\003p\029\192\027\016\000\000\000I\003r\029\192\027t\000\000\000I\003x\029\192\027\216\000\000\000I\003z\029\192\024T\029\192\028<\000\000\001r\000\000\003|\029\192\022\196\029\192\028\160\003\174\000\000\003\128\029\192\029\004\000\000\003:\002(\001\218\002(\001\228\002(\000\000\002\012\002(\000\000\002(\000\000\000\000\000\000\003\194\000\000\003F\002(\003\204\000\000\003J\002(\003\212\000\000\000\000\002\226\000\232\002\226\000\000\000\250\002\226\000\000\000.\003\248\000\000\000\000\000\000\000\000\000\000\003\228\000\000\000.\000\000\002\226\000\232\003\232\000\000\001\222\029\192\003\220\000\000\029b\000\000\000\000\002\226\000\232\003\238\000\000\003\228\000\000\000F\003\184\002(\002\226\000&\003\250\000\000\002(\002\226\000&\003\252\000\000\002X\029\192\003\240\000\000\000\000\000\000\000\000\000\000\002\226\000&\004\000\000\000\003\242\000\000\000\000\000\192\003\198\029b\003\248\000\000\000\000\000\005\003\204\002(\003\254\000\000\000\000\000;\003\218\003\148\004\012\000\000\000\172\003\222\002(\004\016\000\000\003\194\000\000\000\000\000\000\000\000\000\000"), (16, "\0029\0029\0029\000\178\000\018\0029\0029\0029\n&\004\021\001\249\002\142\n>\003\t\0029\006z\0029\0029\003\242\0029\0029\0029\0029\0029\001\245\0029\006~\000:\0029\0029\0029\001\134\0029\002\141\0029\000J\002\149\002\181\002\141\002\205\005Z\002\157\0029\0029\0029\002\197\t\162\000\246\0029\0029\002\213\0029\0029\0029\001\006\0029\0029\004\005\0029\007\018\002\205\007.\003\217\0029\0029\002\205\0029\005\030\007J\002\197\000>\002\146\006\006\0029\000V\000f\002\197\0029\0029\0029\0029\0029\0029\0029\002\146\000^\0029\0029\0029\000z\0029\000\134\0029\004\225\004\225\004\225\004\225\002\197\004\225\004\225\004\225\006\150\002\197\002\149\004\194\006\186\002\173\004\225\002\157\004\225\004\226\004\225\004\225\004\225\004\225\t2\004\225\003\221\003\213\002\253\000\142\004\225\004\225\004\225\004\214\006\210\004\225\004\225\003\154\004\225\n\014\004\225\006\218\004\225\002\189\006\250\004\225\002\173\004\225\001Z\006\194\000:\001v\004\r\004\225\001~\004\225\004\225\nR\004\225\006\202\004\225\006\154\002\133\001\138\004\225\004\225\004\225\002\173\004&\001\198\006\226\006\162\002\173\006\234\004\225\002\241\002\190\006\242\004\225\004\225\004\225\004\225\004\225\004\225\004\225\004\225\004\225\002\202\004\225\004\225\004\225\002\210\003\162\003\174\004\225\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\002\230\002\254\003\014\003\022\003\t\t\026\003\t\003*\003\t\003\t\003\t\003\t\003\t\003\t\t&\003\t\003F\003V\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\004Z\003\t\004.\003\t\003f\003\t\003\t\003\130\003\t\004.\003\t\003\138\004\154\006z\003\t\b\014\003\t\003\t\003\t\003\t\003\146\003\t\003\202\003\t\003\197\003\t\003\t\003\t\003\t\003\t\003\210\003\218\003\226\003\241\002\157\003\t\003\234\003\t\003\245\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\003\t\001z\003\t\006v\003\t\003\237\007\138\007\154\000\178\004\022\002}\002}\tn\004.\004*\003\238\004>\007\162\003\254\004\026\007\178\004\002\004\018\001\142\007\198\004.\002\017\004F\004J\004:\004N\007\206\004R\001\146\002}\007\222\004^\0066\004j\004z\004\130\002}\002\149\001\150\007\238\001\154\b\186\004\146\002\157\001\158\004b\b\194\000\246\001\166\b\n\t2\001\170\004f\004\158\001\006\004\166\004\174\002}\006V\004v\004\142\004\250\002}\005\022\005&\005:\b\206\005N\t\210\001\174\005V\005^\002}\b\022\b&\004\162\b6\bJ\b^\bz\005f\005n\b\130\b\158\004\170\005~\001\178\005\238\003~\000\154\000\158\000\162\000\166\006\026\000\170\000\174\000\178\001\206\006&\006C\006Z\001\210\005F\000\182\002\149\000\186\003\250\003\205\000\190\000\194\000\198\004\226\000\202\003\205\003\205\002\002\002B\000\206\000\210\000\214\006b\002\n\000\218\000\222\002J\000\226\002R\000\230\002\018\000\234\006r\002:\000\238\006\130\000\242\002Z\001\218\007\006\007\n\002b\000\246\007\022\000\250\000\254\007\"\001\002\002\026\001\006\001\226\002j\007&\001\n\001\014\001\018\002r\0072\007>\002\"\001\234\007B\002*\001\022\007N\007Z\0022\001\026\001\030\001\"\001&\001*\001.\0012\0016\002\170\002\130\001:\001>\001B\001z\007^\002\250\001F\002z\007j\003\n\000\178\007r\002m\002m\007z\007\142\007\158\003\238\007\166\007\186\003\254\007\210\003\018\004\002\004\018\001\142\003\"\007\226\002\025\007\246\b\026\004:\004N\b*\b>\001\146\002m\bR\bf\b\134\b\154\b\162\b\178\002m\b\234\001\150\003&\001\154\b\242\b\250\t\002\001\158\004b\t\n\000\246\001\166\003>\t6\001\170\004f\tN\001\006\tf\tv\002m\t\146\004v\004\142\t\154\002m\t\166\t\182\t\202\t\218\t\250\n\002\001\174\n\018\n\026\006n\n*\n2\004\162\003B\003R\003b\003z\nB\nJ\nV\n^\004\170\ng\001\178\000\141\003~\000\000\000\141\000\141\000\141\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\141\000\141\000\141\000\000\000\000\000\000\000\141\000\141\000\000\000\000\000\141\000\000\000\141\000\000\000\141\000\000\000\141\000\141\000\000\0052\000\000\000\141\000\141\000\141\000\000\000\141\000\000\000\000\000\000\000\000\000\000\000\000\000\141\000\000\000\141\000\141\000\000\000\000\000\000\000\000\000\141\000\000\000\141\000\141\000\141\000\141\000\141\000\000\000\141\000\141\000\141\000\000\000\169\000\000\000\000\000\169\000\169\000\169\000\000\000\141\000\000\005>\000\000\000\000\000\000\000\000\000\141\000\000\000\141\000\169\000\169\000\169\000\000\000\000\000\000\000\169\000\169\000\000\000\000\000\169\000\000\000\169\000\000\000\169\000\000\000\169\000\169\000\000\000\000\000\000\000\169\000\169\000\169\000\000\000\169\000\000\000\000\000\000\000\000\000\000\000\000\000\169\000\000\000\169\000\169\000\000\000\000\000\000\000\000\000\169\000\000\000\169\000\169\000\169\000\169\000\169\000\000\000\169\000\169\000\169\000\000\001\169\000\000\000\000\005\138\001\169\001\169\000\000\000\169\000\000\000\000\000\000\000\000\000\000\000\000\000\169\000\000\000\169\001\169\001\169\001\169\000\000\000\000\000\000\005\150\001\169\000\000\000\000\001\169\000\000\001\169\000\000\001\169\000\000\005\162\001\169\000\000\000\000\000\000\001\169\001\169\001\246\000\000\001\169\000\000\000\000\000\000\000\000\000\000\000\000\001\169\000\000\001\169\001\169\000\000\000\000\000\000\000\000\001\169\000\000\005\174\001\169\001\169\005\186\001\169\000\000\002\166\005\198\001\169\000\000\000\000\000\141\000\000\000\000\000\000\000\141\000\141\001\169\000\000\000\000\000\141\000\141\000\000\000\000\005\210\000\000\001\169\000\141\000\141\000\141\000\141\000\000\000\000\000\000\000\000\000\141\000\000\000\000\000\141\000\000\000\141\000\000\000\141\000\000\000\000\000\141\000\000\001\186\000\000\000\141\000\141\000\141\000\000\000\141\000\000\000\000\000\000\000\000\000\000\000\000\000\141\000\000\000\141\000\141\000\000\000\000\000\000\000\000\000\141\000\000\000\000\000\141\000\141\000\000\000\141\000\000\000\141\000\000\000\141\000\000\000\000\001\169\000\000\000\000\000\000\001\169\001\169\000\141\000\141\000\000\001\169\001\169\000\141\000\000\000\000\000\000\000\141\001\169\001\169\001\169\001\169\000\000\000\000\000\000\000\000\001\169\000\000\000\000\001\169\000\000\001\169\000\000\001\169\000\000\000\000\001\169\000\000\000\000\000\000\001\169\001\169\001\246\000\000\001\169\000\000\000\000\000\000\000\000\000\000\000\000\001\169\000\000\001\169\001\169\000\000\000\000\000\000\000\000\001\169\000\000\000\000\001\169\001\169\000\000\001\169\000\000\002\166\000\000\001\169\000\000\000\000\001\206\000\000\000\000\000\000\001U\001U\001\169\001\169\000\000\001U\001U\001\169\000\000\000\000\000\000\001\169\001U\001U\001U\001U\000\000\000\000\000\000\000\000\001U\000\000\000\000\001U\000\000\001U\000\000\001U\000\000\000\000\001U\000\000\000\000\000\000\001U\001\218\000\000\000\000\001U\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001U\000\000\000\000\000\000\000\000\001U\000\000\000\000\001U\001\234\000\000\001U\000\000\000\000\000\000\001U\000\000\000\000\001\206\000\000\000\000\000\000\001e\001e\001U\001U\000\000\001e\001e\001U\000\000\000\000\000\000\001U\001e\001e\001e\001e\000\000\000\000\000\000\000\000\001e\000\000\000\000\001e\000\000\001e\000\000\001e\000\000\000\000\001e\000\000\000\000\000\000\001e\001e\000\000\000\000\001e\000\000\000\000\000\000\000\000\000\000\000\000\001e\000\000\001\226\001e\000\000\000\000\000\000\000\000\001e\000\000\000\000\001e\001\234\000\000\001e\000\000\000\000\000\000\001e\000\000\000\000\001\206\000\000\000\000\000\000\001q\001q\001e\001e\000\000\001q\001q\001e\000\000\000\000\000\000\001e\001q\001q\001q\001q\000\000\000\000\000\000\000\000\001q\000\000\000\000\001q\000\000\001q\000\000\001q\000\000\000\000\001q\000\000\000\000\000\000\001q\001q\000\000\000\000\001q\000\000\000\000\000\000\000\000\000\000\000\000\001q\000\000\001\226\001q\000\000\000\000\000\000\000\000\001q\000\000\000\000\001q\001\234\000\000\001q\000\000\000\000\000\000\001q\000\000\000\000\001\206\000\000\000\000\000\000\001u\001u\001q\001q\000\000\001u\001u\001q\000\000\000\000\000\000\001q\001u\001u\001u\001u\000\000\000\000\000\000\000\000\001u\000\000\000\000\001u\000\000\001u\000\000\001u\000\000\000\000\001u\000\000\000\000\000\000\001u\001u\000\000\000\000\001u\000\000\000\000\000\000\000\000\000\000\000\000\001u\000\000\001\226\001u\000\000\000\000\000\000\000\000\001u\000\000\000\000\001u\001\234\000\000\001u\000\000\000\000\000\000\001u\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001\145\001u\001u\000\000\001\145\001\145\001u\000\000\000\000\000\000\001u\001\145\001\145\001\145\001\145\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001\145\000\000\001\145\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\001\145\001\218\000\000\000\000\001\145\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001\145\000\000\000\000\000\000\000\000\001\145\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001M\001\145\001\145\000\000\001M\001M\001\145\000\000\000\000\000\000\001\145\001M\001M\001M\001M\000\000\000\000\000\000\000\000\001M\000\000\000\000\001M\000\000\001M\000\000\002\018\000\000\000\000\001M\000\000\000\000\000\000\001M\001\218\000\000\000\000\001M\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001M\000\000\000\000\000\000\000\000\001M\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001a\001a\001M\001M\000\000\001a\001a\001M\000\000\000\000\000\000\001M\001a\001a\001a\001a\000\000\000\000\000\000\000\000\001a\000\000\000\000\001a\000\000\001a\000\000\001a\000\000\000\000\001a\000\000\000\000\000\000\001a\001\218\000\000\000\000\001a\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001a\000\000\000\000\000\000\000\000\001a\000\000\000\000\001a\001\234\000\000\001a\000\000\000\000\000\000\001a\000\000\000\000\001\206\000\000\000\000\000\000\001]\001]\001a\001a\000\000\001]\001]\001a\000\000\000\000\000\000\001a\001]\001]\001]\001]\000\000\000\000\000\000\000\000\001]\000\000\000\000\001]\000\000\001]\000\000\001]\000\000\000\000\001]\000\000\000\000\000\000\001]\001]\000\000\000\000\001]\000\000\000\000\000\000\000\000\000\000\000\000\001]\000\000\001\226\001]\000\000\000\000\000\000\000\000\001]\000\000\000\000\001]\001\234\000\000\001]\000\000\000\000\000\000\001]\000\000\000\000\001\206\000\000\000\000\000\000\001i\001i\001]\001]\000\000\001i\001i\001]\000\000\000\000\000\000\001]\001i\001i\001i\001i\000\000\000\000\000\000\000\000\001i\000\000\000\000\001i\000\000\001i\000\000\001i\000\000\000\000\001i\000\000\000\000\000\000\001i\001\218\000\000\000\000\001i\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001i\000\000\000\000\000\000\000\000\001i\000\000\000\000\001i\001\234\000\000\001i\000\000\000\000\000\000\001i\000\000\000\000\001\206\000\000\000\000\000\000\001m\001m\001i\001i\000\000\001m\001m\001i\000\000\000\000\000\000\001i\001m\001m\001m\001m\000\000\000\000\000\000\000\000\001m\000\000\000\000\001m\000\000\001m\000\000\001m\000\000\000\000\001m\000\000\000\000\000\000\001m\001\218\000\000\000\000\001m\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001m\000\000\000\000\000\000\000\000\001m\000\000\000\000\001m\001\234\000\000\001m\000\000\000\000\000\000\001m\000\000\000\000\001\206\000\000\000\000\000\000\001Y\001Y\001m\001m\000\000\001Y\001Y\001m\000\000\000\000\000\000\001m\001Y\001Y\001Y\001Y\000\000\000\000\000\000\000\000\001Y\000\000\000\000\001Y\000\000\001Y\000\000\001Y\000\000\000\000\001Y\000\000\000\000\000\000\001Y\001\218\000\000\000\000\001Y\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001Y\000\000\000\000\000\000\000\000\001Y\000\000\000\000\001Y\001\234\000\000\001Y\000\000\000\000\000\000\001Y\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001Q\001Y\001Y\000\000\001Q\001Q\001Y\000\000\000\000\000\000\001Y\001Q\001Q\001Q\001Q\000\000\000\000\000\000\000\000\001Q\000\000\000\000\001Q\000\000\001Q\000\000\002\018\000\000\000\000\001Q\000\000\000\000\000\000\001Q\001\218\000\000\000\000\001Q\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001Q\000\000\000\000\000\000\000\000\001Q\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001y\001Q\001Q\000\000\001y\001y\001Q\000\000\000\000\000\000\001Q\001y\001y\002\002\001y\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001y\000\000\002R\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001\133\001y\001y\000\000\001\133\001\133\001y\000\000\000\000\000\000\002z\001\133\001\133\002\002\001\133\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001\133\000\000\001\133\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\000\000\000\000\001\133\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001\141\001\133\001\133\000\000\001\141\001\141\001\133\000\000\000\000\000\000\001\133\001\141\001\141\001\141\001\141\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001\141\000\000\001\141\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\001\141\001\218\000\000\000\000\001\141\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001\141\000\000\000\000\000\000\000\000\001\141\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001\137\001\141\001\141\000\000\001\137\001\137\001\141\000\000\000\000\000\000\001\141\001\137\001\137\001\137\001\137\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001\137\000\000\001\137\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\001\137\001\218\000\000\000\000\001\137\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001\137\000\000\000\000\000\000\000\000\001\137\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001\149\001\137\001\137\000\000\001\149\001\149\001\137\000\000\000\000\000\000\001\137\001\149\001\149\001\149\001\149\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001\149\000\000\001\149\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\001\149\001\218\000\000\000\000\001\149\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\001\149\000\000\000\000\000\000\000\000\001\149\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001\129\001\149\001\149\000\000\001\129\001\129\001\149\000\000\000\000\000\000\001\149\001\129\001\129\002\002\001\129\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001\129\000\000\001\129\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\000\000\000\000\001\129\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001}\001\129\001\129\000\000\001}\001}\001\129\000\000\000\000\000\000\001\129\001}\001}\002\002\001}\000\000\000\000\000\000\000\000\002\n\000\000\000\000\001}\000\000\002R\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\210\001I\001}\001}\000\000\001I\001I\001}\000\000\000\000\000\000\001}\001I\001I\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\000\000\0022\000\000\000\000\001\206\000\000\000\000\000\000\001\153\001\153\001I\001I\000\000\001\153\001\153\001I\000\000\000\000\000\000\002z\001\153\001\153\001\153\001\153\000\000\000\000\000\000\000\000\001\153\000\000\000\000\001\153\000\000\001\153\000\000\001\153\000\000\000\000\001\153\000\000\000\000\000\000\001\153\001\153\000\000\000\000\001\153\000\000\000\000\000\000\000\000\000\000\000\000\001\153\000\000\001\226\001\153\000\000\000\000\000\000\000\000\001\153\000\000\000\000\001\153\001\234\000\000\001\153\000\000\000\000\000\000\001\153\000\000\000\000\001\206\000\000\000\000\000\000\001\157\001\157\001\153\001\153\000\000\001\157\001\157\001\153\000\000\000\000\000\000\001\153\001\157\001\157\001\157\001\157\000\000\000\000\000\000\000\000\001\157\000\000\000\000\001\157\000\000\001\157\000\000\001\157\000\000\000\000\001\157\000\000\000\000\000\000\001\157\001\157\000\000\000\000\001\157\000\000\000\000\000\000\000\000\000\000\000\000\001\157\000\000\001\226\001\157\000\000\000\000\000\000\000\000\001\157\000\000\000\000\001\157\001\234\000\000\001\157\000\000\000\000\000\000\001\157\000\000\000\000\001\206\000\000\000\000\000\000\001\161\001\161\001\157\001\157\000\000\001\161\001\161\001\157\000\000\000\000\000\000\001\157\001\161\001\161\001\161\001\161\000\000\000\000\000\000\000\000\001\161\000\000\000\000\001\161\000\000\001\161\000\000\001\161\000\000\000\000\001\161\000\000\000\000\000\000\001\161\001\161\000\000\000\000\001\161\000\000\000\000\000\000\000\000\000\000\000\000\001\161\000\000\001\226\001\161\000\000\000\000\001\206\000\000\001\161\000\000\001\210\001\161\001\234\000\000\001\161\004\014\003\205\000\000\001\161\000\000\000\000\000\000\003\006\000\000\002\002\002B\000\000\001\161\001\161\000\000\002\n\000\000\001\161\002J\000\000\002R\001\161\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\001\206\000\000\002r\000\000\001\210\002\"\001\234\000\000\002*\005\146\002\246\000\000\0022\000\000\000\000\000\000\001\229\000\000\002\002\002B\000\000\002\170\000\000\000\000\002\n\000\000\002\182\002J\000\000\002R\002z\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\001\206\000\000\002r\000\000\001\210\002\"\001\234\000\000\002*\005\158\004r\000\000\0022\000\000\000\000\000\000\001\237\000\000\002\002\002B\000\000\001\229\002\158\000\000\002\n\000\000\000\000\002J\000\000\002R\002z\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\005\170\002\"\001\234\000\000\002*\000\000\000\000\001\241\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\001\237\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\001\206\000\000\002r\000\000\001\210\002\"\001\234\000\000\002*\005\182\002\218\000\000\0022\000\000\000\000\000\000\003\030\000\000\002\002\002B\000\000\001\241\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\002z\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\001\206\000\000\002r\000\000\001\210\002\"\001\234\000\000\002*\005\194\002\233\000\000\0022\000\000\000\000\000\000\003:\000\000\002\002\002B\000\000\002\222\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\002z\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\001\206\000\000\002r\000\000\001\210\002\"\001\234\000\000\002*\002\153\004\138\000\000\0022\000\000\000\000\000\000\003N\000\000\002\002\002B\000\000\002\233\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\002z\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\000\000\001\226\002j\000\000\000\000\001\206\000\000\002r\000\000\001\210\002\"\001\234\000\000\002*\005\206\005\250\000\000\0022\000\000\000\000\000\000\002y\000\000\002\002\002B\000\000\002\153\005\242\000\000\002\n\000\000\000\000\002J\000\000\002R\002z\002\018\000\000\000\000\002:\000\000\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\005\218\002\"\001\234\000\000\002*\000\000\000\000\002\165\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\002y\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\003^\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\b\142\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\003v\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\0032\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\007\130\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\003n\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\007\150\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\007\254\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\007\174\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\bn\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\007\194\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\007\218\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\007\234\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\b\006\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\b\"\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\b2\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\bF\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\bZ\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\bv\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\002\169\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\000\000\000\002:\002z\000\000\000\000\002Z\001\218\000\000\000\000\002b\000\000\000\000\000\000\000\000\000\000\000\000\002\026\001\206\001\226\002j\000\000\001\210\000\000\000\000\002r\000\000\000\000\002\"\001\234\000\000\002*\000\000\000\000\b\170\0022\002\002\002B\000\000\000\000\000\000\000\000\002\n\000\000\000\000\002J\000\000\002R\000\000\002\018\000\006\000\n\002:\002z\000\000\000\014\002Z\001\218\000\000\006v\002b\000\000\007\138\007\154\000\000\000\000\000\000\002\026\000\022\001\226\002j\000\000\000\026\007\162\t\014\002r\007\178\000\000\002\"\001\234\007\198\002*\002\t\000\000\000\000\0022\000\000\007\206\000\000\000\000\000\000\007\222\000\030\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\238\000\000\000\"\002z\000\000\000\000\000\000\000\000\000\000\000\000\b\n\000\178\000\000\000\000\000\000\002\001\000\000\000\000\001\130\004\026\000\000\004\006\002)\000\000\000\000\000\000\001\142\000\000\001\221\000&\000*\000.\0002\000\000\b\022\b&\001\146\b6\bJ\b^\bz\0006\000\000\b\130\b\158\000\000\001\150\000\000\001\154\003~\000\000\000\000\001\158\001\162\000\000\000\246\001\166\000\000\000\178\001\170\000\000\000\000\001\006\000\000\000\000\001\130\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\142\000\000\001\225\000\000\001\174\000\000\000\000\000\000\000\000\000\000\001\146\000\000\000\000\000\000\000\000\001\221\001\250\000\000\000\000\000\000\001\150\001\178\001\154\000\000\000\000\000\000\001\158\001\162\000\178\000\246\001\166\000\000\000\000\001\170\000\000\001\130\001\006\000\000\000\000\000\000\000\000\000\000\000\000\001\142\000\000\001\233\000\000\000\000\000\000\000\000\000\000\001\174\000\000\001\146\000\000\000\000\000\000\001\001\000\000\000\000\000\000\001\001\001\225\001\150\000\000\001\154\000\000\000\000\001\178\001\158\001\162\000\000\000\246\001\166\000\000\001\001\001\170\000\000\000\000\001\006\000\000\001\001\000\000\000\000\000\000\000\000\000\000\000\000\001\001\000\000\000\000\001\001\000\000\000\000\001\174\000\000\001\001\001\246\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\233\001\001\000\000\001\001\000\000\000\000\001\178\000\178\000\000\000\000\000\000\000\000\001\001\001\001\001\130\001\001\000\000\002\166\000\000\001\001\000\000\000\000\001\142\000\000\002)\000\000\000\000\000\000\001\001\000\000\000\000\000\000\001\146\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\150\000\000\001\154\000\000\000\000\000\000\001\158\001\162\000\178\000\246\001\166\000\000\000\000\001\170\000\000\001\130\001\006\000\000\000\000\000\000\000\000\000\000\000\000\001\142\000\000\002u\000\000\000\000\000\000\000\000\000\000\001\174\000\000\001\146\000\000\000\000\000\006\000\n\000\000\000\000\000\000\000\014\002u\001\150\000\000\001\154\000\000\000\000\001\178\001\158\001\162\000\000\000\246\001\166\000\022\000\178\001\170\000\000\000\026\001\006\002\001\000\000\001\130\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\142\000\000\000\000\000\000\001\174\000\000\000\000\000\000\000\030\000\000\006\134\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\"\000\000\006\138\001\178\001\154\000\000\000\000\000\000\001\158\001\162\000\000\000\246\001\166\002\001\000\000\001\170\000\000\006\150\001\006\000\000\000\000\000\241\000\000\000\000\000\000\000\000\000\000\000&\000*\000.\0002\000\000\000\000\001\174\000\000\000\241\006\150\000\000\000\000\0006\000\233\000\241\000\000\000\000\000\000\000\000\000\000\000\000\000\241\000\000\006\142\000\241\000\000\000\000\000\233\006\150\000\241\000\000\000\000\000\237\000\233\000\000\000\000\000\000\000\000\000\000\000\241\000\233\006\154\000\000\000\233\000\000\000\000\000\237\000\000\000\233\000\000\000\241\006\162\000\237\000\241\000\000\000\000\000\000\000\241\000\233\000\237\006\154\000\000\000\237\000\000\000\000\000\000\000\241\000\237\000\000\000\233\006\162\000\000\000\233\000\000\006\150\000\000\000\233\000\237\000\245\006\154\000\000\000\000\000\000\000\000\000\000\000\233\000\000\000\000\000\237\006\162\000\000\000\237\000\245\006\150\000\000\000\237\000\000\000\249\000\245\000\000\000\000\000\000\000\000\000\000\000\237\000\245\000\000\000\000\000\245\000\000\000\000\000\249\006\150\000\245\000\000\000\000\006\186\000\249\000\000\000\000\000\000\000\000\000\000\000\245\000\249\006\154\000\000\000\249\000\000\000\000\003\005\000\000\000\249\000\000\000\245\006\162\006\210\000\245\000\000\000\000\000\000\000\245\000\249\006\218\006\154\000\000\006\250\000\000\000\000\000\000\000\245\006\194\000\000\000\249\006\162\000\000\000\249\000\000\006\150\000\000\000\249\006\202\000\205\006\154\000\000\000\000\000\000\000\000\000\000\000\249\000\000\000\000\006\226\006\162\000\000\006\234\000\205\006\150\000\000\006\242\000\000\000\221\000\205\000\000\000\000\000\000\000\000\000\000\007\002\000\205\000\000\000\000\000\205\000\000\000\000\000\221\006\150\006\194\000\000\000\000\000\213\000\221\000\000\000\000\000\000\000\000\000\000\006\202\000\221\006\154\000\000\000\221\000\000\000\000\000\213\000\000\000\221\000\000\000\205\006\162\000\213\000\205\000\000\000\000\000\000\000\205\000\221\000\213\006\154\000\000\000\213\000\000\000\000\000\000\000\205\000\213\000\000\000\221\006\162\000\000\000\221\000\000\006\150\000\000\000\221\000\213\006\186\006\154\000\000\000\000\000\000\000\000\000\000\000\221\000\000\000\000\000\213\006\162\000\000\000\213\000\197\006\150\000\000\000\213\000\000\000\217\000\197\000\000\000\000\000\000\000\000\000\000\000\213\006\218\000\000\000\000\000\197\000\000\000\000\000\217\006\150\006\194\000\000\000\000\000\225\000\217\000\000\000\000\000\000\000\000\000\000\006\202\000\217\006\154\000\000\000\217\000\000\000\000\000\225\000\000\006\194\000\000\006\226\006\162\000\225\006\234\000\000\000\000\000\000\006\242\006\202\000\225\006\154\000\000\000\225\000\000\000\000\000\000\000\197\006\194\000\000\000\217\006\162\000\000\000\217\000\000\006\150\000\000\000\217\006\202\000\229\006\154\000\000\000\000\000\000\000\000\000\000\000\217\000\000\000\000\000\225\006\162\000\000\000\225\000\229\006\150\000\000\000\225\000\000\000\209\000\229\000\000\000\000\000\000\000\000\000\000\000\225\000\229\000\000\000\000\000\229\000\000\000\000\000\209\006\150\006\194\000\000\000\000\006\186\000\209\000\000\000\000\000\000\000\000\000\000\006\202\000\209\006\154\000\000\000\209\000\000\000\000\000\201\000\000\006\194\000\000\000\229\006\162\000\201\000\229\000\000\000\000\000\000\000\229\006\202\006\218\006\154\000\000\000\201\000\000\000\000\000\000\000\229\006\194\000\000\000\209\006\162\000\000\000\209\000\000\006\150\000\000\000\209\006\202\006\186\006\154\000\000\000\000\000\000\000\000\000\000\000\209\000\000\000\000\006\226\006\162\000\000\006\234\002]\006\150\000\000\006\242\000\000\006\186\006\210\000\000\000\000\000\000\000\000\000\000\000\201\006\218\000\000\000\000\006\250\000\000\000\000\002a\006\150\006\194\000\000\000\000\006\186\006\210\000\000\000\000\000\000\000\000\000\000\006\202\006\218\006\154\000\000\006\250\000\000\000\000\003\001\000\000\006\194\000\000\006\226\006\162\006\210\006\234\000\000\000\000\000\000\006\242\006\202\006\218\006\154\000\000\006\250\000\000\000\000\000\000\007\030\006\194\000\000\006\226\006\162\000\000\006\234\000\000\006\150\000\000\006\242\006\202\006\186\006\154\002e\000\000\000\000\000\000\002e\007:\000\000\000\000\006\226\006\162\000\000\006\234\002U\000\000\000\000\006\242\002!\002e\006\210\000\000\000\000\002e\000\000\000\000\007V\006\218\000\000\000\000\006\250\000\000\000\000\000\000\000\000\006\194\006\150\000\000\000\000\000\000\006\186\000\000\000\000\002e\000\000\006\202\000\000\006\154\000\000\000\000\000\000\000\000\000\000\002e\002Y\000\000\006\226\006\162\000\000\006\234\006\210\000\000\000\000\006\242\000\000\000\000\000\000\006\218\000\000\000\000\006\250\000\000\000\000\000\000\000\000\006\194\001^\000\000\000\000\000\000\002e\002e\002e\002e\006\150\006\202\000\000\006\154\006\186\000\n\000\000\000\000\002e\000R\000\000\000\000\006\226\006\162\000\000\006\234\000\000\000\000\002\249\006\242\000\000\000\000\000\022\000\000\006\210\000\000\000\026\000\000\000\000\000\000\000\000\006\218\000\000\000\000\006\250\000\000\000\000\000\000\000\000\006\194\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\000\000\000\006\202\000\000\006\154\000\000\000\000\000\000\000\000\000\"\000\000\000\000\000\000\006\226\006\162\000\000\006\234\000\000\000\000\000\000\006\242\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000&\000*\000.\0002"))
  
  and lhs =
    (8, "\001\000XWVVUUTTTTTTTTTTTTTTTTTTSSSSSSSSSRRRRRRRRRRRRRRQQQQQQQQQQQQQQQQPOOOONNNNMMMMLLKKJJJJJJJJJJJJJJJJJJJJJJJJJIHGFEDCBA@@@???????>>==<<;;::9988766666665444433221100//..--,,++**))((''&&%%$#\"!!! \031\031\031\031\030\030\029\028\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\026\026\025\025\024\024\023\023\023\023\023\023\022\022\022\022\022\022\021\021\020\020\019\019\018\018\018\018\018\018\018\018\018\017\017\016\015\014\014\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\012\012\011\n\t\b\b\b\007\007\007\006\006\005\004\004\004\004\004\003\002\002")
  
  and goto =
    ((16, "\001F\000\000\000\000\000\000\001\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\029\000\007\000\000\000\000\000\000\000 \000\000\001>\000\000\000\b\000\000\000\140\000\000\000\192\000\000\000\000\000\000\000\000\000\000\000\244\000\000\000\000\000\000\000,\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\172\000\000\000\000\001p\002\222\000\000\000\000\000\027\000\000\004\026\000\000\000\000\000\000\000\000\004|\004\150\004\172\001\214\000\t\000\000\000\000\000\000\004\176\000\000\002\132\000\000\000\000\000\000\000\000\000\000\004\178\000\000\004\204\000\000\004\206\000\000\004\210\000\000\000\000\000{\004\232\000\000\004\236\000\000\004\238\000\000\005\b\000\000\005\n\000\000\005\014\000\000\005$\000\000\005(\000\000\005*\000\000\005D\000\000\005F\000\000\005J\000\000\005`\000\000\005d\000\000\005f\000\000\005\128\000\000\005\130\000\000\005\134\000\000\000\000\000\000\000[\000\000\000\000\005\156\000\000\000\000\001F\000\000\000\000\002\180\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003@\000\000\000\000\000\000\000\000\000\000\001\248\000\000\005\160\000\000\000\000\000\000\001b\000\000\005\162\000\000\000\000\000\000\000\000\005\188\000\000\005\190\000\000\000\000\000\000\000\000\005\194\000\000\000\000\000\000\005\216\000\000\000\000\000\000\005\220\000\000\005\222\000\000\000\000\000\000\000\000\003b\000\000\000\000\000\000\000,\000\000\000\248\000\000\003.\000\000\000\000\003\170\000\000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\003\208\000\000\000\000\000\000\003\224\000\000\000\000\000\000\005\248\000\000\000\000\000\000\005\250\000\000\000\000\000\000\000\000\000\176\000\000\000\000\000\000\000\000\000\000\002\224\000\000\000\000\000\000\000\202\000\000\000\000\000\018\000\000\003\000\000\000\000\000\000\000\000\005\000\000\005\254\000\000\002\030\000\000\000I\000\000\006\020\000\000\002D\000\000\003\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\146\000\004\001\166\000\000\000\000\000\000\000\000\002\"\000\000\000\020\006\024\000\000\000\000\000\000\000\000\000\000\000\000\000\190\000\000\000\000\003\148\000\012\000\000\000\000\000\190\003\162\000\000\000\000\000\000\000\000\003 \000\000\000\000\000\000\000\000\000\022\000\000\0032\000\000\000\t\000\000\003\166\000\000\003\168\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\006\026\000\000\000\000\0064\000\000\000\000\0066\000\000\000\000\006:\000\000\000\000\006P\000\000\000\000\006T\000\000\000\000\006V\000\000\000\000\000\000\003\218\000\228\000\000\000\000\006p\000\000\002n\000\000\000\000\002\218\000\000\000H\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\0002\000\000\000\000\000\000\000\000\000\216\000\000\002.\000\000\003\228\000\000\000\000\000\000\000\170\000\000\000f\001\178\001\214\000\000\004<\006f\006v\006\128\000\000\000\000\006\134\000\000\006\144\000\000\000\000\000\000\000\000\000\000\006\160\000\000\006\174\000\000\006\188\000\000\006\192\000\000\006\202\000\000\006\206\000\000\006\220\000\000\006\234\000\000\006\248\000\000\000\000\000\000\006\252\000\000\000\000\007\006\000\000\000\000\000\000\007\n\000\000\000\000\007\024\000\000\000\000\000\000\007&\000\000\000\000\0074\000\000\000\000\000\000\0078\000\000\000\000\000\000\000\000\000\000\000\000\007R\000\000\000\000\000\000\000\000\007T\000\000\000\000\000\000\000:\000\000\007n\000\000\000\000\002D\000\000\007p\000\000\000\000\002p\000\000\000\000\007r\000\000\000\000\000\000\007t\000\000\000\000\002\170\000\000\007\142\000\000\007\144\000\000\000\000\000\200\000\212\000\000\000\000\007\170\000\000\000\000\000\000\007\172\000\000\000\000\002\234\000\000\007\174\000\000\000\000\002\250\000\000\007\176\000\000\000\000\002\252\000\000\007\202\000\000\007\204\000\000\000\000\002\254\000\000\000\000\007\230\000\210\007\232\000\000\000\000\000\000\000\000\007\234\000\000\000\000\000\000\001\216\000\000\004\022\000\000\004B\000\000\000\000\004V\000\000\001\144\000\000\000\000\000\000\000\000\000\000\000\000\004\\\000\000\000\000\000\000\004j\000\000\000\000\000\000\004\024\001\254\003f\000\000\000\000\003\128\000\000\001*\000\194\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\020\000\000\004\030\002&\000\000\000\000\002\020\004\020\000\000\000\000\001\b\000\000\000\000\004J\0028\000\000\000\000\000\000\000\000\002\018\000\000\000\180\004P\002\128\000\000\000\000\000\224\004v\002\242\000\000\000\000\000\190\004\146\000\000\000\000\000\000\000\000\000\000\000\000\004\156\003^\000\000\000\000\000\000\000\000\000\000\002z\000\000\002\186\000\000\000\000\000\000\002\228\000\000\001 \000\000\000\000\000\000\002\224\000\000\001\140\000\000\000\000\000K\000\000\001L\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"), (16, "\001\132\001.\000\163\000n\001\140\001^\001/\000\020\000\025\000U\002\153\001\132\001.\000\167\000\239\001B\001C\001/\000\166\000n\000\178\000}\000\178\000\030\000\240\000U\001B\001C\001 \000\167\000\230\001=\002\155\001_\000U\001=\002,\000}\001\132\001.\000\232\001K\002<\001>\001/\000\242\001;\001E\000\018\000S\001\143\001L\001K\001B\001C\001<\001\134\000U\002E\000\017\000n\001Q\001L\001K\002W\002_\000U\001\137\000U\001b\000\173\001x\001\136\001L\000\025\001S\000Z\001a\000}\000U\001b\000U\001x\001Q\001y\000\238\000T\000\028\001a\000\027\001K\001b\000U\001x\001\133\001y\000\238\002k\000V\000 \001L\000\029\002o\002p\001\b\002x\000U\002y\000\235\000\238\001Q\002f\000%\001\141\002@\001a\0026\001\017\001b\002k\001x\001\t\001y\000\238\002o\002p\000\025\002x\002a\002y\002\005\001A\000\230\000!\000&\002h\002b\001\218\0026\002E\001<\000#\000\232\001=\001K\002W\002_\000\241\002&\002\128\002O\002k\000n\000\028\001L\001{\002o\002p\000U\002x\000U\002y\001\014\000\023\001Q\002\157\001K\000%\002{\001\148\000}\002z\001b\002k\001x\002|\001L\0026\002o\002p\001\147\002x\000U\002y\002P\000\228\001Q\000\172\000[\000&\002{\000\028\002`\002Q\001b\000\244\001x\002|\001K\0026\001\132\001.\000\000\002\140\000\000\000\028\001/\0027\001L\002a\000\235\000\238\000\028\0028\000U\001B\001C\002b\001Q\0026\001K\000\000\002{\001\222\001\144\002\151\001b\000n\001x\002|\001L\0026\0012\000U\001\146\001\147\000U\000\173\0013\000Y\001Q\000\000\000\028\002.\002{\000}\000\028\001\226\001b\0020\001x\002|\001K\0026\001\139\001.\002\146\000\000\002:\000p\001/\000\000\001L\000\248\000\238\000Z\001\218\000\028\000U\001B\001C\000]\001Q\001\129\001.\0014\002\130\001a\0015\001/\001b\000U\001x\002R\001y\000\238\0018\001\220\001B\001C\000\000\000\180\001-\001.\0017\002S\001\238\000\000\001/\000n\0013\002V\001\141\002R\002\131\000U\001K\001B\001C\000\173\002Q\001\154\002R\001\128\001.\002Y\001L\000}\001\243\001/\001\226\0023\000U\0026\002d\001K\001Q\001\155\001B\001C\000\000\001a\000\000\000\000\001b\001L\001x\0014\001y\000\238\0015\000U\001\226\000U\001K\001Q\000p\001\253\0018\001=\001a\002\136\002\158\001b\001L\001x\002E\001y\000\238\002\137\000U\002m\002W\002_\001Q\001K\000\000\001\131\001.\001a\000p\001\226\001b\001/\001x\001L\001y\000\238\000q\002\015\002\142\000U\001B\001C\001\b\001Q\000n\002\020\002\025\002 \001a\000\000\000U\001b\000S\001x\000s\001y\000\238\000\000\001\b\001\r\000\175\001\226\000}\001\b\001=\000\000\002\143\002\134\000n\001\226\001\226\001\226\002\148\000\230\000U\001\022\002r\001K\000\173\000\000\001&\002\156\000p\000\232\002a\000\000\000}\001L\000\234\000T\000n\000p\002b\000U\0026\000U\000U\001Q\000\185\000\000\001\014\000\\\001a\000\000\000\000\001b\000n\001x\000}\001y\000\238\000n\000U\002H\001N\000\226\001\014\000U\001=\000\000\0013\001\014\000n\001U\000}\000\000\002K\000\000\000U\000}\002~\000n\000s\0013\000\000\000\230\000\000\000U\000n\000\000\000}\000\173\000S\000S\000U\000\232\000\000\001I\000\173\000}\000\237\000\235\000\238\000\000\000\230\000n\000}\0014\002I\000\000\000%\000U\000\230\000U\000\232\000\173\000\000\000\000\002L\000\246\0014\002I\000\232\000}\001Y\001[\000U\000\250\000S\000T\000T\002L\000&\0010\001D\000U\000U\000n\002.\000n\000n\001@\001G\000U\0020\000U\000U\000\173\000\000\001]\001]\000\000\000\000\0029\002]\000}\000\000\000}\000}\000S\002.\000\000\000S\000\235\000\238\000T\0020\001\152\000\000\001z\002.\000U\000\000\002.\000\000\0022\0020\001@\001\147\0020\002.\000\000\000\235\000\238\000S\0025\0020\000S\002>\000\028\000\235\000\238\000\000\000\000\000n\002B\000T\000n\002F\000T\000U\002X\000U\000U\000\173\000U\000S\000\189\002U\000\000\000\000\002[\000}\000\000\000n\000}\0023\002v\0026\000\000\000U\000T\000\000\002c\000T\000S\000\000\000U\002l\000\000\000U\001\174\001\171\002U\000\000\000\000\001@\000\000\0023\000\000\0026\000\000\000\000\000T\000\000\000\000\000n\002q\0023\000U\0026\0023\000U\0026\000\000\002t\000\188\000n\0023\000n\0026\000\000\000T\000U\000}\000U\002}\000\173\000U\000\187\000n\000\000\000n\000n\001@\000}\000U\000}\000U\000U\000\182\000\000\000\177\000v\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\000x\000z\000\000\000|\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\000\128\000\000\000\130\000\132\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\000\134\000\136\000\000\000\138\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\000\140\000\000\000\142\000\144\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\000\146\000\148\000\000\000\150\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\000\152\000\000\000\154\000\156\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\000\158\000\160\000\000\000\162\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\000\169\000\000\000\193\000\199\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\000\204\000\206\000\000\000\211\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\000\215\000\000\000\219\000\221\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\000\254\001\003\000\000\001\028\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\001\"\000\000\001:\001d\000\000\000\000\000n\000n\000}\000n\000}\000}\000U\000U\000\000\000U\001g\001j\000\000\001m\000n\000\000\000n\000n\000}\000}\000U\000}\000U\000U\001p\000n\001s\001v\000\000\000\000\000n\000U\000}\000n\000}\000}\000U\000\000\000n\000U\001~\000n\001\173\001\171\000U\000\000\000n\000U\000}\000\000\001\172\001\171\000U\000\000\000n\001\165\001\171\000\000\001\168\001\171\000U\000n\000\000\001\170\001\171\000\000\000\000\000U\000n\000\000\000n\001\176\001\171\000\000\000U\000n\000U\000n\001\178\001\171\000\000\000U\000\000\000U\000n\001\180\001\171\001\182\001\171\000\000\000U\000n\001\184\001\171\001\186\001\171\000\000\000U\000n\000\000\000n\001\188\001\171\000\000\000U\000n\000U\000n\001\190\001\171\000\000\000U\000\000\000U\000n\001\192\001\171\001\196\001\171\000\000\000U\000n\001\199\001\171\001\203\001\171\000\000\000U\000n\000\000\000n\001\206\001\171\000\000\000U\000\000\000U\000\000\001\210\001\171\000\000\000\000\000\000\000n\000n\001\213\001\171\001\217\001\171\000U\000U\000\000\000\000\001\224\001\229\000\000\000\000\000n\000n\000n\000n\000}\000}\000U\000U\000U\000U\001\235\001\240\001\246\001\250\000\000\000\000\000n\000n\000}\000}\000}\000}\000U\000U\000\000\000\000\001\255\002\001\000\000\000\000\000n\000n\000n\000n\000}\000}\000U\000U\000U\000U\002\b\002\012\002\017\002\022\000\000\000\000\000n\000n\000}\000}\000}\000}\000U\000U\000\000\000\000\002\027\002\029\000\000\000\000\000n\000n\000n\000\000\000}\000}\000U\000U\000U\000\000\002#\002%\002*\000\000\000\000\000\000\000\000\000\000\000}\000}\000}"))
  
  and semantic_action =
    [|
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = id;
          MenhirLib.EngineTypes.startp = _startpos_id_;
          MenhirLib.EngineTypes.endp = _endpos_id_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = ut;
            MenhirLib.EngineTypes.startp = _startpos_ut_;
            MenhirLib.EngineTypes.endp = _endpos_ut_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = od;
              MenhirLib.EngineTypes.startp = _startpos_od_;
              MenhirLib.EngineTypes.endp = _endpos_od_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let id : (Ast.identifier) = Obj.magic id in
        let ut : (Middle.UnsizedType.t) = Obj.magic ut in
        let od : (unit option) = Obj.magic od in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_od_ in
        let _endpos = _endpos_id_ in
        let _v : (Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier) = 
# 298 "src/frontend/parser.mly"
    (  grammar_logger "arg_decl" ;
       match od with None -> (UnsizedType.AutoDiffable, ut, id) | _ -> (DataOnly, ut, id)  )
# 651 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = l;
            MenhirLib.EngineTypes.startp = _startpos_l_;
            MenhirLib.EngineTypes.endp = _endpos_l_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let l : (Ast.untyped_expression list) = Obj.magic l in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression list) = 
# 576 "src/frontend/parser.mly"
                 ( grammar_logger "array dims" ; l  )
# 697 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_dims_ in
        let _endpos = _endpos_ty_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 440 "src/frontend/parser.mly"
  ( grammar_logger "array_type" ;
    let (type_, trans) = ty in
    ((reducearray (type_, dims)), trans)
  )
# 734 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_dims_ in
        let _endpos = _endpos_ty_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 440 "src/frontend/parser.mly"
  ( grammar_logger "array_type" ;
    let (type_, trans) = ty in
    ((reducearray (type_, dims)), trans)
  )
# 771 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_dims_ in
        let _endpos = _endpos_ty_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 440 "src/frontend/parser.mly"
  ( grammar_logger "array_type" ;
    let (type_, trans) = ty in
    ((reducearray (type_, dims)), trans)
  )
# 808 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_dims_ in
        let _endpos = _endpos_ty_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 440 "src/frontend/parser.mly"
  ( grammar_logger "array_type" ;
    let (type_, trans) = ty in
    ((reducearray (type_, dims)), trans)
  )
# 845 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 795 "src/frontend/parser.mly"
    (  grammar_logger "assign_plain" ; Assign )
# 892 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 903 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 797 "src/frontend/parser.mly"
    ( grammar_logger "assign_plus" ; OperatorAssign Plus )
# 954 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 965 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 799 "src/frontend/parser.mly"
    ( grammar_logger "assign_minus" ; OperatorAssign Minus )
# 1016 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 1027 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 801 "src/frontend/parser.mly"
    ( grammar_logger "assign_times"  ; OperatorAssign Times )
# 1078 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 1089 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 803 "src/frontend/parser.mly"
    ( grammar_logger "assign_divide" ; OperatorAssign Divide )
# 1140 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 1151 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 805 "src/frontend/parser.mly"
    ( grammar_logger "assign_elttimes"  ; OperatorAssign EltTimes )
# 1202 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 1213 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = l;
                MenhirLib.EngineTypes.startp = _startpos_l_;
                MenhirLib.EngineTypes.endp = _endpos_l_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let l : (Ast.untyped_expression) = Obj.magic l in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_l_ in
        let _endpos = _endpos__4_ in
        let _v =
          let op = 
# 807 "src/frontend/parser.mly"
    ( grammar_logger "assign_eltdivide" ; OperatorAssign EltDivide  )
# 1264 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_l_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 762 "src/frontend/parser.mly"
    (  grammar_logger "assignment_statement" ;
       Assignment {assign_lhs=try_convert_to_lvalue l _sloc;
                   assign_op=op;
                   assign_rhs=e} )
# 1275 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = xs;
              MenhirLib.EngineTypes.startp = _startpos_xs_;
              MenhirLib.EngineTypes.endp = _endpos_xs_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = id;
                  MenhirLib.EngineTypes.startp = _startpos_id_;
                  MenhirLib.EngineTypes.endp = _endpos_id_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let id : (Ast.identifier) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos__5_ in
        let _v =
          let args = 
# 241 "<standard.mly>"
    ( xs )
# 1333 "src/frontend/parser.ml"
           in
          (
# 767 "src/frontend/parser.mly"
    (  grammar_logger "funapp_statement" ; NRFunApp ((),id, args)  )
# 1338 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _8;
          MenhirLib.EngineTypes.startp = _startpos__8_;
          MenhirLib.EngineTypes.endp = _endpos__8_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = ot;
            MenhirLib.EngineTypes.startp = _startpos_ot_;
            MenhirLib.EngineTypes.endp = _endpos_ot_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _6;
              MenhirLib.EngineTypes.startp = _startpos__6_;
              MenhirLib.EngineTypes.endp = _endpos__6_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = xs;
                MenhirLib.EngineTypes.startp = _startpos_xs_;
                MenhirLib.EngineTypes.endp = _endpos_xs_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _4;
                  MenhirLib.EngineTypes.startp = _startpos__4_;
                  MenhirLib.EngineTypes.endp = _endpos__4_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = id;
                    MenhirLib.EngineTypes.startp = _startpos_id_;
                    MenhirLib.EngineTypes.endp = _endpos_id_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _;
                      MenhirLib.EngineTypes.semv = _2;
                      MenhirLib.EngineTypes.startp = _startpos__2_;
                      MenhirLib.EngineTypes.endp = _endpos__2_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.state = _menhir_s;
                        MenhirLib.EngineTypes.semv = e;
                        MenhirLib.EngineTypes.startp = _startpos_e_;
                        MenhirLib.EngineTypes.endp = _endpos_e_;
                        MenhirLib.EngineTypes.next = _menhir_stack;
                      };
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _8 : unit = Obj.magic _8 in
        let ot : (Ast.untyped_expression Ast.truncation option) = Obj.magic ot in
        let _6 : unit = Obj.magic _6 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _4 : unit = Obj.magic _4 in
        let id : (Ast.identifier) = Obj.magic id in
        let _2 : unit = Obj.magic _2 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos__8_ in
        let _v =
          let es = 
# 241 "<standard.mly>"
    ( xs )
# 1417 "src/frontend/parser.ml"
           in
          (
# 770 "src/frontend/parser.mly"
    (  grammar_logger "tilde_statement" ;
       let t = match ot with Some tt -> tt | None -> NoTruncate in
       Tilde {arg= e; distribution= id; args= es; truncation= t  }
    )
# 1425 "src/frontend/parser.ml"
           : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 775 "src/frontend/parser.mly"
    (   grammar_logger "targetpe_statement" ; TargetPE e )
# 1478 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 777 "src/frontend/parser.mly"
    (  grammar_logger "break_statement" ; Break )
# 1513 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 779 "src/frontend/parser.mly"
    (  grammar_logger "continue_statement" ; Continue )
# 1548 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = l;
              MenhirLib.EngineTypes.startp = _startpos_l_;
              MenhirLib.EngineTypes.endp = _endpos_l_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let l : (Ast.untyped_expression Ast.printable list) = Obj.magic l in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 781 "src/frontend/parser.mly"
    (  grammar_logger "print_statement" ; Print l )
# 1604 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = l;
              MenhirLib.EngineTypes.startp = _startpos_l_;
              MenhirLib.EngineTypes.endp = _endpos_l_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let l : (Ast.untyped_expression Ast.printable list) = Obj.magic l in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 783 "src/frontend/parser.mly"
    (  grammar_logger "reject_statement" ; Reject l  )
# 1660 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = l;
              MenhirLib.EngineTypes.startp = _startpos_l_;
              MenhirLib.EngineTypes.endp = _endpos_l_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let l : (Ast.untyped_expression Ast.printable list) = Obj.magic l in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 785 "src/frontend/parser.mly"
    (  grammar_logger "exit_statement" ; FatalError l  )
# 1716 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 787 "src/frontend/parser.mly"
    (  grammar_logger "return_statement" ; Return e )
# 1758 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__2_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 789 "src/frontend/parser.mly"
    (  grammar_logger "return_nothing_statement" ; ReturnVoid )
# 1793 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 791 "src/frontend/parser.mly"
    (  grammar_logger "skip" ; Skip )
# 1821 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 336 "src/frontend/parser.mly"
    (  grammar_logger "basic_type INT" ; UnsizedType.UInt  )
# 1846 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 338 "src/frontend/parser.mly"
    (  grammar_logger "basic_type REAL"  ; UnsizedType.UReal )
# 1871 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 340 "src/frontend/parser.mly"
    ( grammar_logger "basic_type COMPLEX" ; UnsizedType.UComplex )
# 1896 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 342 "src/frontend/parser.mly"
    (  grammar_logger "basic_type VECTOR" ; UnsizedType.UVector )
# 1921 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 344 "src/frontend/parser.mly"
    (  grammar_logger "basic_type ROWVECTOR" ; UnsizedType.URowVector )
# 1946 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 346 "src/frontend/parser.mly"
    (  grammar_logger "basic_type MATRIX" ; UnsizedType.UMatrix )
# 1971 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 348 "src/frontend/parser.mly"
    (  grammar_logger "basic_type COMPLEXVECTOR" ; UnsizedType.UComplexVector )
# 1996 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 350 "src/frontend/parser.mly"
    (  grammar_logger "basic_type COMPLEXROWVECTOR" ; UnsizedType.UComplexRowVector )
# 2021 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.t) = 
# 352 "src/frontend/parser.mly"
    (  grammar_logger "basic_type COMPLEXMATRIX" ; UnsizedType.UComplexMatrix )
# 2046 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = id;
          MenhirLib.EngineTypes.startp = _startpos_id_;
          MenhirLib.EngineTypes.endp = _endpos_id_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let id : (Ast.identifier) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos_id_ in
        let _v =
          let _endpos = _endpos_id_ in
          let _startpos = _startpos_id_ in
          let _loc = (_startpos, _endpos) in
          (
# 615 "src/frontend/parser.mly"
    ( grammar_logger "identifier_expr" ;
      build_expr (Variable id) _loc )
# 2076 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = i;
          MenhirLib.EngineTypes.startp = _startpos_i_;
          MenhirLib.EngineTypes.endp = _endpos_i_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let i : (
# 90 "src/frontend/parser.mly"
       (string)
# 2098 "src/frontend/parser.ml"
        ) = Obj.magic i in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_i_ in
        let _endpos = _endpos_i_ in
        let _v =
          let _endpos = _endpos_i_ in
          let _startpos = _startpos_i_ in
          let _loc = (_startpos, _endpos) in
          (
# 618 "src/frontend/parser.mly"
    ( grammar_logger ("intnumeral " ^ i) ;
      build_expr (IntNumeral i) _loc )
# 2111 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let r : (
# 91 "src/frontend/parser.mly"
       (string)
# 2133 "src/frontend/parser.ml"
        ) = Obj.magic r in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_r_ in
        let _v =
          let _endpos = _endpos_r_ in
          let _startpos = _startpos_r_ in
          let _loc = (_startpos, _endpos) in
          (
# 622 "src/frontend/parser.mly"
    ( grammar_logger ("realnumeral " ^ r) ;
      build_expr (RealNumeral r) _loc )
# 2146 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let r : (
# 91 "src/frontend/parser.mly"
       (string)
# 2168 "src/frontend/parser.ml"
        ) = Obj.magic r in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_r_ in
        let _v =
          let _endpos = _endpos_r_ in
          let _startpos = _startpos_r_ in
          let _loc = (_startpos, _endpos) in
          (
# 622 "src/frontend/parser.mly"
    ( grammar_logger ("realnumeral " ^ r) ;
      build_expr (RealNumeral r) _loc )
# 2181 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = z;
          MenhirLib.EngineTypes.startp = _startpos_z_;
          MenhirLib.EngineTypes.endp = _endpos_z_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let z : (
# 92 "src/frontend/parser.mly"
       (string)
# 2203 "src/frontend/parser.ml"
        ) = Obj.magic z in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_z_ in
        let _endpos = _endpos_z_ in
        let _v =
          let _endpos = _endpos_z_ in
          let _startpos = _startpos_z_ in
          let _loc = (_startpos, _endpos) in
          (
# 625 "src/frontend/parser.mly"
    ( grammar_logger ("imagnumeral " ^ z) ;
      build_expr (ImagNumeral (String.drop_suffix z 1)) _loc )
# 2216 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = xs;
            MenhirLib.EngineTypes.startp = _startpos_xs_;
            MenhirLib.EngineTypes.endp = _endpos_xs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v =
          let _endpos = _endpos__3_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 628 "src/frontend/parser.mly"
    ( grammar_logger "array_expression" ;
      build_expr (ArrayExpr xs) _loc )
# 2261 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = xs;
            MenhirLib.EngineTypes.startp = _startpos_xs_;
            MenhirLib.EngineTypes.endp = _endpos_xs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v =
          let xs = 
# 241 "<standard.mly>"
    ( xs )
# 2302 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__3_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 631 "src/frontend/parser.mly"
    ( grammar_logger "row_vector_expression" ;
      build_expr (RowVectorExpr xs) _loc )
# 2311 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = xs;
            MenhirLib.EngineTypes.startp = _startpos_xs_;
            MenhirLib.EngineTypes.endp = _endpos_xs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = id;
                MenhirLib.EngineTypes.startp = _startpos_id_;
                MenhirLib.EngineTypes.endp = _endpos_id_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let id : (Ast.identifier) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos__4_ in
        let _v =
          let args = 
# 241 "<standard.mly>"
    ( xs )
# 2359 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _startpos = _startpos_id_ in
          let _loc = (_startpos, _endpos) in
          (
# 634 "src/frontend/parser.mly"
    ( grammar_logger "fun_app" ;
      let app =
       if
         List.length args = 1
         && List.exists ~f:(fun x -> String.is_suffix ~suffix:x id.name) Utils.conditioning_suffices
       then CondDistApp ((), id, args)
       else FunApp ((), id, args)
       in build_expr app _loc )
# 2374 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v =
          let _endpos = _endpos__3_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 643 "src/frontend/parser.mly"
    ( grammar_logger "target_read" ;
      build_expr GetTarget _loc )
# 2419 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = xs;
            MenhirLib.EngineTypes.startp = _startpos_xs_;
            MenhirLib.EngineTypes.endp = _endpos_xs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = e;
                MenhirLib.EngineTypes.startp = _startpos_e_;
                MenhirLib.EngineTypes.endp = _endpos_e_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = id;
                    MenhirLib.EngineTypes.startp = _startpos_id_;
                    MenhirLib.EngineTypes.endp = _endpos_id_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let id : (Ast.identifier) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos__6_ in
        let _v =
          let args = 
# 241 "<standard.mly>"
    ( xs )
# 2481 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__6_ in
          let _startpos = _startpos_id_ in
          let _loc = (_startpos, _endpos) in
          (
# 647 "src/frontend/parser.mly"
    ( grammar_logger "conditional_dist_app" ;
      build_expr (CondDistApp ((), id, e :: args)) _loc )
# 2490 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = xs;
            MenhirLib.EngineTypes.startp = _startpos_xs_;
            MenhirLib.EngineTypes.endp = _endpos_xs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = x_head;
                MenhirLib.EngineTypes.startp = _startpos_x_head_;
                MenhirLib.EngineTypes.endp = _endpos_x_head_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _3 : unit = Obj.magic _3 in
        let x_head : (Ast.untyped_expression) = Obj.magic x_head in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v =
          let _endpos = _endpos__5_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 650 "src/frontend/parser.mly"
    ( grammar_logger "tuple_expression" ;
      build_expr (TupleExpr (x_head::xs)) _loc  )
# 2549 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = ix_str;
          MenhirLib.EngineTypes.startp = _startpos_ix_str_;
          MenhirLib.EngineTypes.endp = _endpos_ix_str_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let ix_str : (
# 91 "src/frontend/parser.mly"
       (string)
# 2577 "src/frontend/parser.ml"
        ) = Obj.magic ix_str in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos_ix_str_ in
        let _v =
          let _endpos = _endpos_ix_str_ in
          let _startpos = _startpos_e_ in
          let _loc = (_startpos, _endpos) in
          (
# 653 "src/frontend/parser.mly"
    ( grammar_logger "common_expression_tuple_index" ;
      build_expr (TupleProjection (e, parse_tuple_slot ix_str _loc)) _loc
    )
# 2592 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = indices;
            MenhirLib.EngineTypes.startp = _startpos_indices_;
            MenhirLib.EngineTypes.endp = _endpos_indices_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = e;
                MenhirLib.EngineTypes.startp = _startpos_e_;
                MenhirLib.EngineTypes.endp = _endpos_e_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let indices : (Ast.untyped_expression Ast.index list) = Obj.magic indices in
        let _2 : unit = Obj.magic _2 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos_e_ in
          let _loc = (_startpos, _endpos) in
          (
# 657 "src/frontend/parser.mly"
    ( grammar_logger "common_expression_indexed";
      build_expr (Indexed (e, indices)) _loc )
# 2644 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v =
          let _endpos = _endpos__3_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 660 "src/frontend/parser.mly"
    ( grammar_logger "extra_paren" ;
      build_expr (Paren e) _loc )
# 2689 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 683 "src/frontend/parser.mly"
    (  grammar_logger "infix_plus" ; Operator.Plus )
# 2730 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 2741 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 685 "src/frontend/parser.mly"
    (   grammar_logger "infix_minus" ;Operator.Minus )
# 2782 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 2793 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 687 "src/frontend/parser.mly"
    (  grammar_logger "infix_times" ; Operator.Times )
# 2834 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 2845 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 689 "src/frontend/parser.mly"
    (  grammar_logger "infix_divide" ; Operator.Divide )
# 2886 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 2897 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 691 "src/frontend/parser.mly"
    (  grammar_logger "infix_intdivide" ; Operator.IntDivide )
# 2938 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 2949 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 693 "src/frontend/parser.mly"
    (  grammar_logger "infix_modulo" ; Operator.Modulo )
# 2990 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 3001 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 695 "src/frontend/parser.mly"
    (  grammar_logger "infix_ldivide" ; Operator.LDivide )
# 3042 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 3053 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 697 "src/frontend/parser.mly"
    (  grammar_logger "infix_elttimes" ; Operator.EltTimes )
# 3094 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 3105 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 699 "src/frontend/parser.mly"
    (   grammar_logger "infix_eltdivide" ; Operator.EltDivide )
# 3146 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 3157 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 701 "src/frontend/parser.mly"
    (  grammar_logger "infix_hat" ; Operator.Pow )
# 3198 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 3209 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op = 
# 703 "src/frontend/parser.mly"
    (  grammar_logger "infix_eltpow" ; Operator.EltPow )
# 3250 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 595 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_arithmetic" ;
      build_expr (BinOp (e1, op, e2)) _loc
    )
# 3261 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v =
          let op = 
# 665 "src/frontend/parser.mly"
    (   grammar_logger "prefix_bang" ; Operator.PNot )
# 3295 "src/frontend/parser.ml"
           in
          let _startpos_op_ = _startpos__1_ in
          let _endpos = _endpos_e_ in
          let _startpos = _startpos_op_ in
          let _loc = (_startpos, _endpos) in
          (
# 600 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_prefixOp" ;
      build_expr (PrefixOp (op, e)) _loc
    )
# 3307 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v =
          let op = 
# 667 "src/frontend/parser.mly"
    (  grammar_logger "prefix_minus" ; Operator.PMinus )
# 3341 "src/frontend/parser.ml"
           in
          let _startpos_op_ = _startpos__1_ in
          let _endpos = _endpos_e_ in
          let _startpos = _startpos_op_ in
          let _loc = (_startpos, _endpos) in
          (
# 600 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_prefixOp" ;
      build_expr (PrefixOp (op, e)) _loc
    )
# 3353 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v =
          let op = 
# 669 "src/frontend/parser.mly"
    (   grammar_logger "prefix_plus" ; Operator.PPlus )
# 3387 "src/frontend/parser.ml"
           in
          let _startpos_op_ = _startpos__1_ in
          let _endpos = _endpos_e_ in
          let _startpos = _startpos_op_ in
          let _loc = (_startpos, _endpos) in
          (
# 600 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_prefixOp" ;
      build_expr (PrefixOp (op, e)) _loc
    )
# 3399 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos__1_ in
        let _v =
          let op = 
# 673 "src/frontend/parser.mly"
    (  grammar_logger "postfix_transpose" ; Operator.Transpose )
# 3433 "src/frontend/parser.ml"
           in
          let _endpos_op_ = _endpos__1_ in
          let _endpos = _endpos_op_ in
          let _startpos = _startpos_e_ in
          let _loc = (_startpos, _endpos) in
          (
# 605 "src/frontend/parser.mly"
    (
      grammar_logger "constr_expression_postfix" ;
      build_expr (PostfixOp (e, op)) _loc
    )
# 3445 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression) = 
# 610 "src/frontend/parser.mly"
    ( grammar_logger "constr_expression_common_expr" ; e )
# 3471 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = tvd;
            MenhirLib.EngineTypes.startp = _startpos_tvd_;
            MenhirLib.EngineTypes.endp = _endpos_tvd_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let tvd : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic tvd in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 184 "src/frontend/parser.mly"
    ( grammar_logger "data_block" ;
      {stmts= tvd; xloc= location_span_of_positions _loc} )
# 3523 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = id;
                MenhirLib.EngineTypes.startp = _startpos_id_;
                MenhirLib.EngineTypes.endp = _endpos_id_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = ty;
                  MenhirLib.EngineTypes.startp = _startpos_ty_;
                  MenhirLib.EngineTypes.endp = _endpos_ty_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _3 : unit = Obj.magic _3 in
        let id : (Ast.identifier) = Obj.magic id in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__5_ in
        let _v =
          let _loc_dims_ = (_startpos_dims_, _endpos_dims_) in
          (
# 394 "src/frontend/parser.mly"
                                                                                                  (
    let (ty, trans) = ty in
    let ty = List.fold_right ~f:(fun e ty -> SizedType.SArray (ty, e)) ~init:ty dims in
    let ty = (ty, trans) in
    raise
    (Errors.SyntaxError
       (Errors.Parsing
          ( Fmt.str
              "\";\" expected after variable declaration.@ It looks like you \
               are trying to use the old array syntax.@ Please use the new \
               syntax:@ @[<h>%a %s;@]@\n"
              Pretty_printing.pp_transformed_type ty id.name
          , location_span_of_positions _loc_dims_ )))
    )
# 3594 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 3647 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 3669 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 3722 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 3744 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 3797 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 3819 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = id;
                MenhirLib.EngineTypes.startp = _startpos_id_;
                MenhirLib.EngineTypes.endp = _endpos_id_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = ty;
                  MenhirLib.EngineTypes.startp = _startpos_ty_;
                  MenhirLib.EngineTypes.endp = _endpos_ty_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _3 : unit = Obj.magic _3 in
        let id : (Ast.identifier) = Obj.magic id in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__5_ in
        let _v =
          let _loc_dims_ = (_startpos_dims_, _endpos_dims_) in
          (
# 394 "src/frontend/parser.mly"
                                                                                                  (
    let (ty, trans) = ty in
    let ty = List.fold_right ~f:(fun e ty -> SizedType.SArray (ty, e)) ~init:ty dims in
    let ty = (ty, trans) in
    raise
    (Errors.SyntaxError
       (Errors.Parsing
          ( Fmt.str
              "\";\" expected after variable declaration.@ It looks like you \
               are trying to use the old array syntax.@ Please use the new \
               syntax:@ @[<h>%a %s;@]@\n"
              Pretty_printing.pp_transformed_type ty id.name
          , location_span_of_positions _loc_dims_ )))
    )
# 3891 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 3944 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 3966 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 4019 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 4041 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 4094 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 4116 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = dims;
            MenhirLib.EngineTypes.startp = _startpos_dims_;
            MenhirLib.EngineTypes.endp = _endpos_dims_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = id;
                MenhirLib.EngineTypes.startp = _startpos_id_;
                MenhirLib.EngineTypes.endp = _endpos_id_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = ty;
                  MenhirLib.EngineTypes.startp = _startpos_ty_;
                  MenhirLib.EngineTypes.endp = _endpos_ty_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let dims : (Ast.untyped_expression list) = Obj.magic dims in
        let _3 : unit = Obj.magic _3 in
        let id : (Ast.identifier) = Obj.magic id in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__5_ in
        let _v =
          let _loc_dims_ = (_startpos_dims_, _endpos_dims_) in
          (
# 394 "src/frontend/parser.mly"
                                                                                                  (
    let (ty, trans) = ty in
    let ty = List.fold_right ~f:(fun e ty -> SizedType.SArray (ty, e)) ~init:ty dims in
    let ty = (ty, trans) in
    raise
    (Errors.SyntaxError
       (Errors.Parsing
          ( Fmt.str
              "\";\" expected after variable declaration.@ It looks like you \
               are trying to use the old array syntax.@ Please use the new \
               syntax:@ @[<h>%a %s;@]@\n"
              Pretty_printing.pp_transformed_type ty id.name
          , location_span_of_positions _loc_dims_ )))
    )
# 4188 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 4241 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 4263 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 4316 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 4338 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vs;
            MenhirLib.EngineTypes.startp = _startpos_vs_;
            MenhirLib.EngineTypes.endp = _endpos_vs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = v;
              MenhirLib.EngineTypes.startp = _startpos_v_;
              MenhirLib.EngineTypes.endp = _endpos_v_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vs : (Ast.untyped_expression Ast.variable list option) = Obj.magic vs in
        let v : (Ast.untyped_expression Ast.variable) = Obj.magic v in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos__4_ in
        let _v =
          let ty = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 4391 "src/frontend/parser.ml"
           in
          let _endpos = _endpos__4_ in
          let _symbolstartpos = _startpos_ty_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 411 "src/frontend/parser.mly"
    ( (fun ~is_global ->
      let vs = v :: Option.value vs ~default:[]
      in
      { stmt=
          VarDecl {
              decl_type= fst ty
            ; transformation= snd ty
            ; variables=vs
            ; is_global
            }
      ; smeta= {
          loc= location_span_of_positions _sloc
        }
      })
    )
# 4413 "src/frontend/parser.ml"
           : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = id;
          MenhirLib.EngineTypes.startp = _startpos_id_;
          MenhirLib.EngineTypes.endp = _endpos_id_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let id : (Ast.identifier) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos_id_ in
        let _v : (Ast.identifier) = 
# 227 "src/frontend/parser.mly"
                  ( id )
# 4441 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = err;
          MenhirLib.EngineTypes.startp = _startpos_err_;
          MenhirLib.EngineTypes.endp = _endpos_err_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let err : (string * (Lexing.position * Lexing.position) * bool) = Obj.magic err in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_err_ in
        let _endpos = _endpos_err_ in
        let _v : (Ast.identifier) = 
# 228 "src/frontend/parser.mly"
                      ( reserved err )
# 4466 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = id;
          MenhirLib.EngineTypes.startp = _startpos_id_;
          MenhirLib.EngineTypes.endp = _endpos_id_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let id : (Ast.identifier) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos_id_ in
        let _v : (Ast.identifier) = 
# 231 "src/frontend/parser.mly"
                  ( id )
# 4491 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = err;
          MenhirLib.EngineTypes.startp = _startpos_err_;
          MenhirLib.EngineTypes.endp = _endpos_err_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let err : (string * (Lexing.position * Lexing.position) * bool) = Obj.magic err in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_err_ in
        let _endpos = _endpos_err_ in
        let _v : (Ast.identifier) = 
# 232 "src/frontend/parser.mly"
                      ( reserved_decl err )
# 4516 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e3;
          MenhirLib.EngineTypes.startp = _startpos_e3_;
          MenhirLib.EngineTypes.endp = _endpos_e3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = e2;
              MenhirLib.EngineTypes.startp = _startpos_e2_;
              MenhirLib.EngineTypes.endp = _endpos_e2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = e1;
                  MenhirLib.EngineTypes.startp = _startpos_e1_;
                  MenhirLib.EngineTypes.endp = _endpos_e1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let e3 : (Ast.untyped_expression) = Obj.magic e3 in
        let _4 : unit = Obj.magic _4 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _2 : unit = Obj.magic _2 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e3_ in
        let _v =
          let _endpos = _endpos_e3_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 581 "src/frontend/parser.mly"
    ( grammar_logger "ifthenelse_expr" ; build_expr (TernaryIf (e1, e2, e3)) _loc )
# 4573 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 683 "src/frontend/parser.mly"
    (  grammar_logger "infix_plus" ; Operator.Plus )
# 4615 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4620 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4629 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 685 "src/frontend/parser.mly"
    (   grammar_logger "infix_minus" ;Operator.Minus )
# 4671 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4676 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4685 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 687 "src/frontend/parser.mly"
    (  grammar_logger "infix_times" ; Operator.Times )
# 4727 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4732 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4741 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 689 "src/frontend/parser.mly"
    (  grammar_logger "infix_divide" ; Operator.Divide )
# 4783 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4788 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4797 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 691 "src/frontend/parser.mly"
    (  grammar_logger "infix_intdivide" ; Operator.IntDivide )
# 4839 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4844 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4853 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 693 "src/frontend/parser.mly"
    (  grammar_logger "infix_modulo" ; Operator.Modulo )
# 4895 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4900 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4909 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 695 "src/frontend/parser.mly"
    (  grammar_logger "infix_ldivide" ; Operator.LDivide )
# 4951 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 4956 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 4965 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 697 "src/frontend/parser.mly"
    (  grammar_logger "infix_elttimes" ; Operator.EltTimes )
# 5007 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 5012 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5021 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 699 "src/frontend/parser.mly"
    (   grammar_logger "infix_eltdivide" ; Operator.EltDivide )
# 5063 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 5068 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5077 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 701 "src/frontend/parser.mly"
    (  grammar_logger "infix_hat" ; Operator.Pow )
# 5119 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 5124 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5133 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let a = 
# 703 "src/frontend/parser.mly"
    (  grammar_logger "infix_eltpow" ; Operator.EltPow )
# 5175 "src/frontend/parser.ml"
             in
            
# 677 "src/frontend/parser.mly"
    (   grammar_logger "infix_arithmetic" ; a )
# 5180 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5189 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 707 "src/frontend/parser.mly"
    (   grammar_logger "infix_or" ; Operator.Or )
# 5231 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5236 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5245 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 709 "src/frontend/parser.mly"
    (   grammar_logger "infix_and" ; Operator.And )
# 5287 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5292 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5301 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 711 "src/frontend/parser.mly"
    (   grammar_logger "infix_equals" ; Operator.Equals )
# 5343 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5348 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5357 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 713 "src/frontend/parser.mly"
    (   grammar_logger "infix_nequals" ; Operator.NEquals)
# 5399 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5404 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5413 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 715 "src/frontend/parser.mly"
    (   grammar_logger "infix_less" ; Operator.Less )
# 5455 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5460 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5469 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 717 "src/frontend/parser.mly"
    (   grammar_logger "infix_leq" ; Operator.Leq )
# 5511 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5516 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5525 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 719 "src/frontend/parser.mly"
    (   grammar_logger "infix_greater" ; Operator.Greater )
# 5567 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5572 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5581 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _1 : unit = Obj.magic _1 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v =
          let op =
            let l = 
# 721 "src/frontend/parser.mly"
    (   grammar_logger "infix_geq" ; Operator.Geq )
# 5623 "src/frontend/parser.ml"
             in
            
# 679 "src/frontend/parser.mly"
    (  grammar_logger "infix_logical" ; l )
# 5628 "src/frontend/parser.ml"
            
          in
          let _endpos = _endpos_e2_ in
          let _startpos = _startpos_e1_ in
          let _loc = (_startpos, _endpos) in
          (
# 583 "src/frontend/parser.mly"
    ( grammar_logger "infix_expr" ; build_expr (BinOp (e1, op, e2)) _loc  )
# 5637 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v =
          let op = 
# 665 "src/frontend/parser.mly"
    (   grammar_logger "prefix_bang" ; Operator.PNot )
# 5671 "src/frontend/parser.ml"
           in
          let _startpos_op_ = _startpos__1_ in
          let _endpos = _endpos_e_ in
          let _startpos = _startpos_op_ in
          let _loc = (_startpos, _endpos) in
          (
# 585 "src/frontend/parser.mly"
    ( grammar_logger "prefix_expr" ; build_expr (PrefixOp (op, e)) _loc )
# 5680 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v =
          let op = 
# 667 "src/frontend/parser.mly"
    (  grammar_logger "prefix_minus" ; Operator.PMinus )
# 5714 "src/frontend/parser.ml"
           in
          let _startpos_op_ = _startpos__1_ in
          let _endpos = _endpos_e_ in
          let _startpos = _startpos_op_ in
          let _loc = (_startpos, _endpos) in
          (
# 585 "src/frontend/parser.mly"
    ( grammar_logger "prefix_expr" ; build_expr (PrefixOp (op, e)) _loc )
# 5723 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v =
          let op = 
# 669 "src/frontend/parser.mly"
    (   grammar_logger "prefix_plus" ; Operator.PPlus )
# 5757 "src/frontend/parser.ml"
           in
          let _startpos_op_ = _startpos__1_ in
          let _endpos = _endpos_e_ in
          let _startpos = _startpos_op_ in
          let _loc = (_startpos, _endpos) in
          (
# 585 "src/frontend/parser.mly"
    ( grammar_logger "prefix_expr" ; build_expr (PrefixOp (op, e)) _loc )
# 5766 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos__1_ in
        let _v =
          let op = 
# 673 "src/frontend/parser.mly"
    (  grammar_logger "postfix_transpose" ; Operator.Transpose )
# 5800 "src/frontend/parser.ml"
           in
          let _endpos_op_ = _endpos__1_ in
          let _endpos = _endpos_op_ in
          let _startpos = _startpos_e_ in
          let _loc = (_startpos, _endpos) in
          (
# 587 "src/frontend/parser.mly"
    ( grammar_logger "postfix_expr" ; build_expr (PostfixOp (e, op)) _loc)
# 5809 "src/frontend/parser.ml"
           : (Ast.untyped_expression))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression) = 
# 589 "src/frontend/parser.mly"
    ( grammar_logger "common_expr" ; e )
# 5835 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = fd;
            MenhirLib.EngineTypes.startp = _startpos_fd_;
            MenhirLib.EngineTypes.endp = _endpos_fd_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let fd : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic fd in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 179 "src/frontend/parser.mly"
    ( grammar_logger "function_block" ;
      {stmts= fd; xloc= location_span_of_positions _loc} )
# 5887 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = b;
          MenhirLib.EngineTypes.startp = _startpos_b_;
          MenhirLib.EngineTypes.endp = _endpos_b_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _5;
            MenhirLib.EngineTypes.startp = _startpos__5_;
            MenhirLib.EngineTypes.endp = _endpos__5_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = xs;
              MenhirLib.EngineTypes.startp = _startpos_xs_;
              MenhirLib.EngineTypes.endp = _endpos_xs_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _3;
                MenhirLib.EngineTypes.startp = _startpos__3_;
                MenhirLib.EngineTypes.endp = _endpos__3_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = name;
                  MenhirLib.EngineTypes.startp = _startpos_name_;
                  MenhirLib.EngineTypes.endp = _endpos_name_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = rt;
                    MenhirLib.EngineTypes.startp = _startpos_rt_;
                    MenhirLib.EngineTypes.endp = _endpos_rt_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let b : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic b in
        let _5 : unit = Obj.magic _5 in
        let xs : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = Obj.magic xs in
        let _3 : unit = Obj.magic _3 in
        let name : (Ast.identifier) = Obj.magic name in
        let rt : (Middle.UnsizedType.returntype) = Obj.magic rt in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_rt_ in
        let _endpos = _endpos_b_ in
        let _v =
          let args = 
# 241 "<standard.mly>"
    ( xs )
# 5952 "src/frontend/parser.ml"
           in
          let _endpos = _endpos_b_ in
          let _startpos = _startpos_rt_ in
          let _loc = (_startpos, _endpos) in
          (
# 282 "src/frontend/parser.mly"
    (
      grammar_logger "function_def" ;
      {stmt=FunDef {returntype = rt; funname = name;
                           arguments = args; body=b;};
       smeta={loc=location_span_of_positions _loc}
      }
    )
# 5966 "src/frontend/parser.ml"
           : (Ast.untyped_statement))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = fd;
            MenhirLib.EngineTypes.startp = _startpos_fd_;
            MenhirLib.EngineTypes.endp = _endpos_fd_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _2 : unit = Obj.magic _2 in
        let fd : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic fd in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_fd_ in
        let _endpos = _endpos__2_ in
        let _v =
          let _endpos = _endpos__2_ in
          let _startpos = _startpos_fd_ in
          let _loc = (_startpos, _endpos) in
          (
# 165 "src/frontend/parser.mly"
    ( grammar_logger "functions_only";
      { functionblock= Some {stmts= fd; xloc= location_span_of_positions _loc}
      ; datablock= None
      ; transformeddatablock= None
      ; parametersblock= None
      ; transformedparametersblock= None
      ; modelblock= None
      ; generatedquantitiesblock= None
      ; comments= [] }
    )
# 6013 "src/frontend/parser.ml"
           : (Ast.untyped_statement Ast.program))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 224 "src/frontend/parser.mly"
             ( build_id "jacobian" _loc, "2.38.0" )
# 6043 "src/frontend/parser.ml"
           : (Ast.identifier * string))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = tvds;
            MenhirLib.EngineTypes.startp = _startpos_tvds_;
            MenhirLib.EngineTypes.endp = _endpos_tvds_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let tvds : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic tvds in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 209 "src/frontend/parser.mly"
    ( grammar_logger "generated_quantities_block" ;
      {stmts= tvds; xloc= location_span_of_positions _loc} )
# 6096 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = initial_value;
          MenhirLib.EngineTypes.startp = _startpos_initial_value_;
          MenhirLib.EngineTypes.endp = _endpos_initial_value_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = identifier;
            MenhirLib.EngineTypes.startp = _startpos_identifier_;
            MenhirLib.EngineTypes.endp = _endpos_identifier_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let initial_value : (Ast.untyped_expression option) = Obj.magic initial_value in
        let identifier : (Ast.identifier) = Obj.magic identifier in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_identifier_ in
        let _endpos = _endpos_initial_value_ in
        let _v : (Ast.untyped_expression Ast.variable) = 
# 372 "src/frontend/parser.mly"
    ( Ast.{identifier; initial_value} )
# 6130 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = initial_value;
          MenhirLib.EngineTypes.startp = _startpos_initial_value_;
          MenhirLib.EngineTypes.endp = _endpos_initial_value_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = identifier;
            MenhirLib.EngineTypes.startp = _startpos_identifier_;
            MenhirLib.EngineTypes.endp = _endpos_identifier_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let initial_value : (Ast.untyped_expression option) = Obj.magic initial_value in
        let identifier : (Ast.identifier) = Obj.magic identifier in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_identifier_ in
        let _endpos = _endpos_initial_value_ in
        let _v : (Ast.untyped_expression Ast.variable) = 
# 372 "src/frontend/parser.mly"
    ( Ast.{identifier; initial_value} )
# 6162 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = initial_value;
          MenhirLib.EngineTypes.startp = _startpos_initial_value_;
          MenhirLib.EngineTypes.endp = _endpos_initial_value_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = identifier;
            MenhirLib.EngineTypes.startp = _startpos_identifier_;
            MenhirLib.EngineTypes.endp = _endpos_identifier_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let initial_value : (Ast.untyped_expression option) = Obj.magic initial_value in
        let identifier : (Ast.identifier) = Obj.magic identifier in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_identifier_ in
        let _endpos = _endpos_initial_value_ in
        let _v : (Ast.untyped_expression Ast.variable) = 
# 372 "src/frontend/parser.mly"
    ( Ast.{identifier; initial_value} )
# 6194 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = initial_value;
          MenhirLib.EngineTypes.startp = _startpos_initial_value_;
          MenhirLib.EngineTypes.endp = _endpos_initial_value_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = identifier;
            MenhirLib.EngineTypes.startp = _startpos_identifier_;
            MenhirLib.EngineTypes.endp = _endpos_identifier_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let initial_value : (Ast.untyped_expression option) = Obj.magic initial_value in
        let identifier : (Ast.identifier) = Obj.magic identifier in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_identifier_ in
        let _endpos = _endpos_initial_value_ in
        let _v : (Ast.untyped_expression Ast.variable) = 
# 372 "src/frontend/parser.mly"
    ( Ast.{identifier; initial_value} )
# 6226 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = id;
          MenhirLib.EngineTypes.startp = _startpos_id_;
          MenhirLib.EngineTypes.endp = _endpos_id_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let id : (
# 94 "src/frontend/parser.mly"
       (string)
# 6247 "src/frontend/parser.ml"
        ) = Obj.magic id in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_ in
        let _endpos = _endpos_id_ in
        let _v =
          let _endpos = _endpos_id_ in
          let _startpos = _startpos_id_ in
          let _loc = (_startpos, _endpos) in
          (
# 214 "src/frontend/parser.mly"
                  ( build_id id _loc )
# 6259 "src/frontend/parser.ml"
           : (Ast.identifier))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 215 "src/frontend/parser.mly"
             ( build_id "T" _loc)
# 6289 "src/frontend/parser.ml"
           : (Ast.identifier))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = id_and_v;
          MenhirLib.EngineTypes.startp = _startpos_id_and_v_;
          MenhirLib.EngineTypes.endp = _endpos_id_and_v_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let id_and_v : (Ast.identifier * string) = Obj.magic id_and_v in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_id_and_v_ in
        let _endpos = _endpos_id_and_v_ in
        let _v =
          let _endpos = _endpos_id_and_v_ in
          let _startpos = _startpos_id_and_v_ in
          let _loc = (_startpos, _endpos) in
          (
# 217 "src/frontend/parser.mly"
    (
      let id, v = id_and_v in
      Input_warnings.future_keyword id.name v _loc;
      id
    )
# 6323 "src/frontend/parser.ml"
           : (Ast.identifier))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 725 "src/frontend/parser.mly"
    (   grammar_logger "index_nothing" ; [All] )
# 6342 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 727 "src/frontend/parser.mly"
    (   grammar_logger "index_all" ; [All] )
# 6367 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 729 "src/frontend/parser.mly"
    (  grammar_logger "index_single" ; [Single e] )
# 6392 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _2;
          MenhirLib.EngineTypes.startp = _startpos__2_;
          MenhirLib.EngineTypes.endp = _endpos__2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let _2 : unit = Obj.magic _2 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos__2_ in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 731 "src/frontend/parser.mly"
    (  grammar_logger "index_upper" ; [Upfrom e] )
# 6424 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 733 "src/frontend/parser.mly"
    (   grammar_logger "index_lower" ; [Downfrom e] )
# 6456 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _2 : unit = Obj.magic _2 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e1_ in
        let _endpos = _endpos_e2_ in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 735 "src/frontend/parser.mly"
    (  grammar_logger "index_twosided" ; [Between (e1, e2)] )
# 6495 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = i2;
          MenhirLib.EngineTypes.startp = _startpos_i2_;
          MenhirLib.EngineTypes.endp = _endpos_i2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = i1;
              MenhirLib.EngineTypes.startp = _startpos_i1_;
              MenhirLib.EngineTypes.endp = _endpos_i1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let i2 : (Ast.untyped_expression Ast.index list) = Obj.magic i2 in
        let _2 : unit = Obj.magic _2 in
        let i1 : (Ast.untyped_expression Ast.index list) = Obj.magic i1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_i1_ in
        let _endpos = _endpos_i2_ in
        let _v : (Ast.untyped_expression Ast.index list) = 
# 737 "src/frontend/parser.mly"
    (  grammar_logger "indexes" ; i1 @ i2 )
# 6534 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (unit list) = 
# 216 "<standard.mly>"
    ( [] )
# 6552 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let xs : (unit list) = Obj.magic xs in
        let x : unit = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : (unit list) = 
# 219 "<standard.mly>"
    ( x :: xs )
# 6584 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 216 "<standard.mly>"
    ( [] )
# 6603 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic xs in
        let x : (Ast.untyped_statement) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 219 "<standard.mly>"
    ( x :: xs )
# 6637 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 216 "<standard.mly>"
    ( [] )
# 6656 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic xs in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 219 "<standard.mly>"
    ( x :: xs )
# 6691 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 216 "<standard.mly>"
    ( [] )
# 6710 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic xs in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 219 "<standard.mly>"
    ( x :: xs )
# 6745 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 216 "<standard.mly>"
    ( [] )
# 6764 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic xs in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = 
# 219 "<standard.mly>"
    ( x :: xs )
# 6799 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = 
# 145 "<standard.mly>"
    ( [] )
# 6818 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = 
# 148 "<standard.mly>"
    ( x )
# 6845 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression list) = 
# 145 "<standard.mly>"
    ( [] )
# 6863 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression list) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression list) = 
# 148 "<standard.mly>"
    ( x )
# 6888 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = vds;
            MenhirLib.EngineTypes.startp = _startpos_vds_;
            MenhirLib.EngineTypes.endp = _endpos_vds_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let vds : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic vds in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 204 "src/frontend/parser.mly"
    ( grammar_logger "model_block" ;
      {stmts= vds; xloc= location_span_of_positions _loc} )
# 6940 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = s2;
          MenhirLib.EngineTypes.startp = _startpos_s2_;
          MenhirLib.EngineTypes.endp = _endpos_s2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _6;
            MenhirLib.EngineTypes.startp = _startpos__6_;
            MenhirLib.EngineTypes.endp = _endpos__6_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = s1;
              MenhirLib.EngineTypes.startp = _startpos_s1_;
              MenhirLib.EngineTypes.endp = _endpos_s1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = e;
                  MenhirLib.EngineTypes.startp = _startpos_e_;
                  MenhirLib.EngineTypes.endp = _endpos_e_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let s2 : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s2 in
        let _6 : unit = Obj.magic _6 in
        let s1 : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s1 in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_s2_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 825 "src/frontend/parser.mly"
    (  grammar_logger "ifelse_statement" ; IfThenElse (e, s1, Some s2) )
# 7014 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = e;
              MenhirLib.EngineTypes.startp = _startpos_e_;
              MenhirLib.EngineTypes.endp = _endpos_e_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let s : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_s_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 827 "src/frontend/parser.mly"
    (  grammar_logger "if_statement" ; IfThenElse (e, s, None) )
# 7071 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _4;
            MenhirLib.EngineTypes.startp = _startpos__4_;
            MenhirLib.EngineTypes.endp = _endpos__4_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = e;
              MenhirLib.EngineTypes.startp = _startpos_e_;
              MenhirLib.EngineTypes.endp = _endpos_e_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let s : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_s_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 829 "src/frontend/parser.mly"
    (  grammar_logger "while_statement" ; While (e, s) )
# 7128 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _8;
            MenhirLib.EngineTypes.startp = _startpos__8_;
            MenhirLib.EngineTypes.endp = _endpos__8_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = e2;
              MenhirLib.EngineTypes.startp = _startpos_e2_;
              MenhirLib.EngineTypes.endp = _endpos_e2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _6;
                MenhirLib.EngineTypes.startp = _startpos__6_;
                MenhirLib.EngineTypes.endp = _endpos__6_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = e1;
                  MenhirLib.EngineTypes.startp = _startpos_e1_;
                  MenhirLib.EngineTypes.endp = _endpos_e1_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _4;
                    MenhirLib.EngineTypes.startp = _startpos__4_;
                    MenhirLib.EngineTypes.endp = _endpos__4_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _;
                      MenhirLib.EngineTypes.semv = id;
                      MenhirLib.EngineTypes.startp = _startpos_id_;
                      MenhirLib.EngineTypes.endp = _endpos_id_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.state = _;
                        MenhirLib.EngineTypes.semv = _2;
                        MenhirLib.EngineTypes.startp = _startpos__2_;
                        MenhirLib.EngineTypes.endp = _endpos__2_;
                        MenhirLib.EngineTypes.next = {
                          MenhirLib.EngineTypes.state = _menhir_s;
                          MenhirLib.EngineTypes.semv = _1;
                          MenhirLib.EngineTypes.startp = _startpos__1_;
                          MenhirLib.EngineTypes.endp = _endpos__1_;
                          MenhirLib.EngineTypes.next = _menhir_stack;
                        };
                      };
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let s : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s in
        let _8 : unit = Obj.magic _8 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _6 : unit = Obj.magic _6 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _4 : unit = Obj.magic _4 in
        let id : (Ast.identifier) = Obj.magic id in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_s_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 832 "src/frontend/parser.mly"
    (
      grammar_logger "for_statement" ;
      For {loop_variable= id;
           lower_bound= e1;
           upper_bound= e2;
           loop_body= s;}
    )
# 7219 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _6;
            MenhirLib.EngineTypes.startp = _startpos__6_;
            MenhirLib.EngineTypes.endp = _endpos__6_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = e;
              MenhirLib.EngineTypes.startp = _startpos_e_;
              MenhirLib.EngineTypes.endp = _endpos_e_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = id;
                  MenhirLib.EngineTypes.startp = _startpos_id_;
                  MenhirLib.EngineTypes.endp = _endpos_id_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let s : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s in
        let _6 : unit = Obj.magic _6 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _4 : unit = Obj.magic _4 in
        let id : (Ast.identifier) = Obj.magic id in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_s_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 840 "src/frontend/parser.mly"
    (  grammar_logger "foreach_statement" ; ForEach (id, e, s) )
# 7290 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _7;
          MenhirLib.EngineTypes.startp = _startpos__7_;
          MenhirLib.EngineTypes.endp = _endpos__7_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = l;
            MenhirLib.EngineTypes.startp = _startpos_l_;
            MenhirLib.EngineTypes.endp = _endpos_l_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = st;
                  MenhirLib.EngineTypes.startp = _startpos_st_;
                  MenhirLib.EngineTypes.endp = _endpos_st_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _7 : unit = Obj.magic _7 in
        let l : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic l in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let st : (string) = Obj.magic st in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__7_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 842 "src/frontend/parser.mly"
    (  grammar_logger "profile_statement" ; Profile (st, l) )
# 7361 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = l;
            MenhirLib.EngineTypes.startp = _startpos_l_;
            MenhirLib.EngineTypes.endp = _endpos_l_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let l : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic l in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = 
# 844 "src/frontend/parser.mly"
    (  grammar_logger "block_statement" ; Block l )
# 7404 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Ast.untyped_expression) = 
# 361 "src/frontend/parser.mly"
    ( (* This code will never be reached *)
       Common.ICE.internal_compiler_error
          [%message "the UNREACHABLE token should never be produced"]
    )
# 7432 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _6;
            MenhirLib.EngineTypes.startp = _startpos__6_;
            MenhirLib.EngineTypes.endp = _endpos__6_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = e1;
                  MenhirLib.EngineTypes.startp = _startpos_e1_;
                  MenhirLib.EngineTypes.endp = _endpos_e1_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _6 : unit = Obj.magic _6 in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e2_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 568 "src/frontend/parser.mly"
    ( grammar_logger "offset_mult" ; Transformation.OffsetMultiplier (e1, e2) )
# 7499 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e1;
          MenhirLib.EngineTypes.startp = _startpos_e1_;
          MenhirLib.EngineTypes.endp = _endpos_e1_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _6;
            MenhirLib.EngineTypes.startp = _startpos__6_;
            MenhirLib.EngineTypes.endp = _endpos__6_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = e2;
                  MenhirLib.EngineTypes.startp = _startpos_e2_;
                  MenhirLib.EngineTypes.endp = _endpos_e2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _6 : unit = Obj.magic _6 in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e1_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 568 "src/frontend/parser.mly"
    ( grammar_logger "offset_mult" ; Transformation.OffsetMultiplier (e1, e2) )
# 7566 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 570 "src/frontend/parser.mly"
    ( grammar_logger "offset" ; Offset e )
# 7605 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 572 "src/frontend/parser.mly"
    ( grammar_logger "multiplier" ; Multiplier e )
# 7644 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (unit option) = 
# 111 "<standard.mly>"
    ( None )
# 7662 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : unit = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (unit option) = 
# 114 "<standard.mly>"
    ( Some x )
# 7687 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 7706 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 7733 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression option) = 
# 111 "<standard.mly>"
    ( None )
# 7751 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression option) = 
# 114 "<standard.mly>"
    ( Some x )
# 7776 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 7795 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 7822 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 7841 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 7868 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 7887 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 7914 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((unit * Ast.untyped_expression) option) = 
# 111 "<standard.mly>"
    ( None )
# 7932 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = y;
          MenhirLib.EngineTypes.startp = _startpos_y_;
          MenhirLib.EngineTypes.endp = _endpos_y_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let y : (Ast.untyped_expression) = Obj.magic y in
        let x : unit = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_y_ in
        let _v =
          let x = 
# 172 "<standard.mly>"
    ( (x, y) )
# 7965 "src/frontend/parser.ml"
           in
          (
# 114 "<standard.mly>"
    ( Some x )
# 7970 "src/frontend/parser.ml"
           : ((unit * Ast.untyped_expression) option))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((unit * Ast.untyped_expression) option) = 
# 111 "<standard.mly>"
    ( None )
# 7989 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = y;
          MenhirLib.EngineTypes.startp = _startpos_y_;
          MenhirLib.EngineTypes.endp = _endpos_y_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let y : (Ast.untyped_expression) = Obj.magic y in
        let x : unit = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_y_ in
        let _v =
          let x = 
# 172 "<standard.mly>"
    ( (x, y) )
# 8022 "src/frontend/parser.ml"
           in
          (
# 114 "<standard.mly>"
    ( Some x )
# 8027 "src/frontend/parser.ml"
           : ((unit * Ast.untyped_expression) option))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((unit * Ast.untyped_expression) option) = 
# 111 "<standard.mly>"
    ( None )
# 8046 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = y;
          MenhirLib.EngineTypes.startp = _startpos_y_;
          MenhirLib.EngineTypes.endp = _endpos_y_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = x;
            MenhirLib.EngineTypes.startp = _startpos_x_;
            MenhirLib.EngineTypes.endp = _endpos_x_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let y : (Ast.untyped_expression) = Obj.magic y in
        let x : unit = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_y_ in
        let _v =
          let x = 
# 172 "<standard.mly>"
    ( (x, y) )
# 8079 "src/frontend/parser.ml"
           in
          (
# 114 "<standard.mly>"
    ( Some x )
# 8084 "src/frontend/parser.ml"
           : ((unit * Ast.untyped_expression) option))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 8104 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 8131 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression Ast.variable list option) = 
# 111 "<standard.mly>"
    ( None )
# 8149 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression Ast.variable list) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression Ast.variable list option) = 
# 114 "<standard.mly>"
    ( Some x )
# 8174 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression Ast.variable list option) = 
# 111 "<standard.mly>"
    ( None )
# 8192 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression Ast.variable list) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression Ast.variable list option) = 
# 114 "<standard.mly>"
    ( Some x )
# 8217 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 8236 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 8263 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 111 "<standard.mly>"
    ( None )
# 8282 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = 
# 114 "<standard.mly>"
    ( Some x )
# 8309 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression Ast.truncation option) = 
# 111 "<standard.mly>"
    ( None )
# 8327 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression Ast.truncation) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression Ast.truncation option) = 
# 114 "<standard.mly>"
    ( Some x )
# 8352 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = rhs_opt;
          MenhirLib.EngineTypes.startp = _startpos_rhs_opt_;
          MenhirLib.EngineTypes.endp = _endpos_rhs_opt_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let rhs_opt : ((unit * Ast.untyped_expression) option) = Obj.magic rhs_opt in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_rhs_opt_ in
        let _endpos = _endpos_rhs_opt_ in
        let _v : (Ast.untyped_expression option) = 
# 368 "src/frontend/parser.mly"
    ( Option.map ~f:snd rhs_opt )
# 8377 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = rhs_opt;
          MenhirLib.EngineTypes.startp = _startpos_rhs_opt_;
          MenhirLib.EngineTypes.endp = _endpos_rhs_opt_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let rhs_opt : ((unit * Ast.untyped_expression) option) = Obj.magic rhs_opt in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_rhs_opt_ in
        let _endpos = _endpos_rhs_opt_ in
        let _v : (Ast.untyped_expression option) = 
# 368 "src/frontend/parser.mly"
    ( Option.map ~f:snd rhs_opt )
# 8402 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = tvd;
            MenhirLib.EngineTypes.startp = _startpos_tvd_;
            MenhirLib.EngineTypes.endp = _endpos_tvd_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let tvd : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic tvd in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 194 "src/frontend/parser.mly"
    ( grammar_logger "parameters_block" ;
      {stmts= tvd; xloc= location_span_of_positions _loc} )
# 8454 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_e_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Ast.printable list) = 
# 741 "src/frontend/parser.mly"
    (  grammar_logger "printable expression" ; [PExpr e] )
# 8481 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let s : (string) = Obj.magic s in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_s_ in
        let _v : (Ast.untyped_expression Ast.printable list) = 
# 743 "src/frontend/parser.mly"
    (  grammar_logger "printable string" ; [PString s] )
# 8506 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = p2;
          MenhirLib.EngineTypes.startp = _startpos_p2_;
          MenhirLib.EngineTypes.endp = _endpos_p2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = p1;
              MenhirLib.EngineTypes.startp = _startpos_p1_;
              MenhirLib.EngineTypes.endp = _endpos_p1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let p2 : (Ast.untyped_expression Ast.printable list) = Obj.magic p2 in
        let _2 : unit = Obj.magic _2 in
        let p1 : (Ast.untyped_expression Ast.printable list) = Obj.magic p1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_p1_ in
        let _endpos = _endpos_p2_ in
        let _v : (Ast.untyped_expression Ast.printable list) = 
# 745 "src/frontend/parser.mly"
    ( grammar_logger "printables" ; p1 @ p2 )
# 8545 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _8;
          MenhirLib.EngineTypes.startp = _startpos__8_;
          MenhirLib.EngineTypes.endp = _endpos__8_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = ogb;
            MenhirLib.EngineTypes.startp = _startpos_ogb_;
            MenhirLib.EngineTypes.endp = _endpos_ogb_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = omb;
              MenhirLib.EngineTypes.startp = _startpos_omb_;
              MenhirLib.EngineTypes.endp = _endpos_omb_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = otpb;
                MenhirLib.EngineTypes.startp = _startpos_otpb_;
                MenhirLib.EngineTypes.endp = _endpos_otpb_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = opb;
                  MenhirLib.EngineTypes.startp = _startpos_opb_;
                  MenhirLib.EngineTypes.endp = _endpos_opb_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = otdb;
                    MenhirLib.EngineTypes.startp = _startpos_otdb_;
                    MenhirLib.EngineTypes.endp = _endpos_otdb_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _;
                      MenhirLib.EngineTypes.semv = odb;
                      MenhirLib.EngineTypes.startp = _startpos_odb_;
                      MenhirLib.EngineTypes.endp = _endpos_odb_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.state = _menhir_s;
                        MenhirLib.EngineTypes.semv = ofb;
                        MenhirLib.EngineTypes.startp = _startpos_ofb_;
                        MenhirLib.EngineTypes.endp = _endpos_ofb_;
                        MenhirLib.EngineTypes.next = _menhir_stack;
                      };
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _8 : unit = Obj.magic _8 in
        let ogb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic ogb in
        let omb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic omb in
        let otpb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic otpb in
        let opb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic opb in
        let otdb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic otdb in
        let odb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic odb in
        let ofb : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block option) = Obj.magic ofb in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ofb_ in
        let _endpos = _endpos__8_ in
        let _v =
          let _startpos = _startpos_ofb_ in
          (
# 144 "src/frontend/parser.mly"
    (
      grammar_logger "program" ;
      (* check for empty programs*)
      let () =
        match (ofb, odb, otdb, opb, otpb, omb, ogb) with
        | None, None, None, None, None, None, None ->
            Input_warnings.empty (location_of_position _startpos).filename
        | _ -> ()
      in
      { functionblock= ofb
      ; datablock= odb
      ; transformeddatablock= otdb
      ; parametersblock= opb
      ; transformedparametersblock= otpb
      ; modelblock= omb
      ; generatedquantitiesblock= ogb
      ; comments= [] }
    )
# 8645 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.program))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e2;
          MenhirLib.EngineTypes.startp = _startpos_e2_;
          MenhirLib.EngineTypes.endp = _endpos_e2_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _6;
            MenhirLib.EngineTypes.startp = _startpos__6_;
            MenhirLib.EngineTypes.endp = _endpos__6_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = e1;
                  MenhirLib.EngineTypes.startp = _startpos_e1_;
                  MenhirLib.EngineTypes.endp = _endpos_e1_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _6 : unit = Obj.magic _6 in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e2_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 559 "src/frontend/parser.mly"
    ( grammar_logger "lower_upper_range" ; Transformation.LowerUpper (e1, e2) )
# 8714 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e1;
          MenhirLib.EngineTypes.startp = _startpos_e1_;
          MenhirLib.EngineTypes.endp = _endpos_e1_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _6;
            MenhirLib.EngineTypes.startp = _startpos__6_;
            MenhirLib.EngineTypes.endp = _endpos__6_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _4;
                MenhirLib.EngineTypes.startp = _startpos__4_;
                MenhirLib.EngineTypes.endp = _endpos__4_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = e2;
                  MenhirLib.EngineTypes.startp = _startpos_e2_;
                  MenhirLib.EngineTypes.endp = _endpos_e2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _2;
                    MenhirLib.EngineTypes.startp = _startpos__2_;
                    MenhirLib.EngineTypes.endp = _endpos__2_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _6 : unit = Obj.magic _6 in
        let _5 : unit = Obj.magic _5 in
        let _4 : unit = Obj.magic _4 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e1_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 559 "src/frontend/parser.mly"
    ( grammar_logger "lower_upper_range" ; Transformation.LowerUpper (e1, e2) )
# 8781 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 561 "src/frontend/parser.mly"
    (  grammar_logger "lower_range" ; Lower e )
# 8820 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = e;
          MenhirLib.EngineTypes.startp = _startpos_e_;
          MenhirLib.EngineTypes.endp = _endpos_e_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_e_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 563 "src/frontend/parser.mly"
    ( grammar_logger "upper_range" ; Upper e )
# 8859 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let _menhir_s = _menhir_env.MenhirLib.EngineTypes.current in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _endpos = _startpos in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 552 "src/frontend/parser.mly"
    ( grammar_logger "empty_constraint" ; Transformation.Identity )
# 8877 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = r;
            MenhirLib.EngineTypes.startp = _startpos_r_;
            MenhirLib.EngineTypes.endp = _endpos_r_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let r : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic r in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 554 "src/frontend/parser.mly"
    (  grammar_logger "range_constraint" ; r )
# 8916 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = decls;
          MenhirLib.EngineTypes.startp = _startpos_decls_;
          MenhirLib.EngineTypes.endp = _endpos_decls_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let decls : (Ast.untyped_expression Ast.variable list) = Obj.magic decls in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_decls_ in
        let _v : (Ast.untyped_expression Ast.variable list) = 
# 376 "src/frontend/parser.mly"
    ( decls )
# 8948 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = decls;
          MenhirLib.EngineTypes.startp = _startpos_decls_;
          MenhirLib.EngineTypes.endp = _endpos_decls_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let decls : (Ast.untyped_expression Ast.variable list) = Obj.magic decls in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_decls_ in
        let _v : (Ast.untyped_expression Ast.variable list) = 
# 376 "src/frontend/parser.mly"
    ( decls )
# 8980 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 237 "src/frontend/parser.mly"
                  ( "functions", _loc, false )
# 9009 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 238 "src/frontend/parser.mly"
              ( "data", _loc, false )
# 9039 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 239 "src/frontend/parser.mly"
                    ( "parameters", _loc, false )
# 9069 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 240 "src/frontend/parser.mly"
               ( "model", _loc, false )
# 9099 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 241 "src/frontend/parser.mly"
           ( "return", _loc, false )
# 9129 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 242 "src/frontend/parser.mly"
       ( "if", _loc, false )
# 9159 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 243 "src/frontend/parser.mly"
         ( "else", _loc, false )
# 9189 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 244 "src/frontend/parser.mly"
          ( "while", _loc, false )
# 9219 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 245 "src/frontend/parser.mly"
        ( "for", _loc, false )
# 9249 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 246 "src/frontend/parser.mly"
       ( "in", _loc, false )
# 9279 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 247 "src/frontend/parser.mly"
          ( "break", _loc, false )
# 9309 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 248 "src/frontend/parser.mly"
             ( "continue", _loc, false )
# 9339 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 249 "src/frontend/parser.mly"
         ( "void", _loc, false )
# 9369 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 250 "src/frontend/parser.mly"
        ( "int", _loc, true )
# 9399 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 251 "src/frontend/parser.mly"
         ( "real", _loc, true )
# 9429 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 252 "src/frontend/parser.mly"
            ( "complex", _loc, true )
# 9459 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 253 "src/frontend/parser.mly"
           ( "vector", _loc, true )
# 9489 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 254 "src/frontend/parser.mly"
              ( "row_vector", _loc, true )
# 9519 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 255 "src/frontend/parser.mly"
           ( "matrix", _loc, true )
# 9549 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 256 "src/frontend/parser.mly"
                  ( "complex_vector", _loc, true )
# 9579 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 257 "src/frontend/parser.mly"
                     ( "complex_row_vector", _loc, true )
# 9609 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 258 "src/frontend/parser.mly"
                  ( "complex_matrix", _loc, true )
# 9639 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 259 "src/frontend/parser.mly"
            ( "ordered", _loc, true )
# 9669 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 260 "src/frontend/parser.mly"
                    ( "positive_ordered", _loc, true )
# 9699 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 261 "src/frontend/parser.mly"
            ( "simplex", _loc, true )
# 9729 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 262 "src/frontend/parser.mly"
               ( "unit_vector", _loc, true )
# 9759 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 263 "src/frontend/parser.mly"
                       ( "cholesky_factor_corr", _loc, true )
# 9789 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 264 "src/frontend/parser.mly"
                      ( "cholesky_factor_cov", _loc, true )
# 9819 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 265 "src/frontend/parser.mly"
               ( "corr_matrix", _loc, true )
# 9849 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 266 "src/frontend/parser.mly"
              ( "cov_matrix", _loc, true  )
# 9879 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 267 "src/frontend/parser.mly"
          ( "print", _loc, false )
# 9909 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 268 "src/frontend/parser.mly"
           ( "reject", _loc, false )
# 9939 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 269 "src/frontend/parser.mly"
                ( "fatal_error", _loc, false )
# 9969 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 270 "src/frontend/parser.mly"
           ( "target", _loc, false )
# 9999 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 271 "src/frontend/parser.mly"
            ( "profile", _loc, false )
# 10029 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 272 "src/frontend/parser.mly"
          ( "tuple", _loc, true )
# 10059 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 273 "src/frontend/parser.mly"
           ( "offset", _loc, false )
# 10089 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 274 "src/frontend/parser.mly"
               ( "multiplier", _loc, false )
# 10119 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 275 "src/frontend/parser.mly"
          ( "lower", _loc, false )
# 10149 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 276 "src/frontend/parser.mly"
          ( "upper", _loc, false )
# 10179 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 277 "src/frontend/parser.mly"
          ( "array", _loc, true )
# 10209 "src/frontend/parser.ml"
           : (string * (Lexing.position * Lexing.position) * bool))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Middle.UnsizedType.returntype) = 
# 292 "src/frontend/parser.mly"
    ( grammar_logger "return_type VOID" ; Void )
# 10235 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ut;
          MenhirLib.EngineTypes.startp = _startpos_ut_;
          MenhirLib.EngineTypes.endp = _endpos_ut_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ut : (Middle.UnsizedType.t) = Obj.magic ut in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ut_ in
        let _endpos = _endpos_ut_ in
        let _v : (Middle.UnsizedType.returntype) = 
# 294 "src/frontend/parser.mly"
    (  grammar_logger "return_type unsized_type" ; UnsizedType.ReturnType ut )
# 10260 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = 
# 250 "<standard.mly>"
    ( [ x ] )
# 10286 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = x;
              MenhirLib.EngineTypes.startp = _startpos_x_;
              MenhirLib.EngineTypes.endp = _endpos_x_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let x : (Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : ((Middle.UnsizedType.autodifftype * Middle.UnsizedType.t * Ast.identifier)
  list) = 
# 253 "<standard.mly>"
    ( x :: xs )
# 10327 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression list) = 
# 250 "<standard.mly>"
    ( [ x ] )
# 10352 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = x;
              MenhirLib.EngineTypes.startp = _startpos_x_;
              MenhirLib.EngineTypes.endp = _endpos_x_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : (Ast.untyped_expression list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let x : (Ast.untyped_expression) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : (Ast.untyped_expression list) = 
# 253 "<standard.mly>"
    ( x :: xs )
# 10391 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10420 "src/frontend/parser.ml"
           in
          (
# 250 "<standard.mly>"
    ( [ x ] )
# 10425 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10457 "src/frontend/parser.ml"
           in
          (
# 250 "<standard.mly>"
    ( [ x ] )
# 10462 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10494 "src/frontend/parser.ml"
           in
          (
# 250 "<standard.mly>"
    ( [ x ] )
# 10499 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = ty;
              MenhirLib.EngineTypes.startp = _startpos_ty_;
              MenhirLib.EngineTypes.endp = _endpos_ty_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_xs_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10547 "src/frontend/parser.ml"
           in
          (
# 253 "<standard.mly>"
    ( x :: xs )
# 10552 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = ty;
              MenhirLib.EngineTypes.startp = _startpos_ty_;
              MenhirLib.EngineTypes.endp = _endpos_ty_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_xs_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10600 "src/frontend/parser.ml"
           in
          (
# 253 "<standard.mly>"
    ( x :: xs )
# 10605 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = ty;
              MenhirLib.EngineTypes.startp = _startpos_ty_;
              MenhirLib.EngineTypes.endp = _endpos_ty_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_xs_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10653 "src/frontend/parser.ml"
           in
          (
# 253 "<standard.mly>"
    ( x :: xs )
# 10658 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10690 "src/frontend/parser.ml"
           in
          (
# 250 "<standard.mly>"
    ( [ x ] )
# 10695 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10727 "src/frontend/parser.ml"
           in
          (
# 250 "<standard.mly>"
    ( [ x ] )
# 10732 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = ty;
          MenhirLib.EngineTypes.startp = _startpos_ty_;
          MenhirLib.EngineTypes.endp = _endpos_ty_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_ty_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10764 "src/frontend/parser.ml"
           in
          (
# 250 "<standard.mly>"
    ( [ x ] )
# 10769 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = ty;
              MenhirLib.EngineTypes.startp = _startpos_ty_;
              MenhirLib.EngineTypes.endp = _endpos_ty_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_xs_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10817 "src/frontend/parser.ml"
           in
          (
# 253 "<standard.mly>"
    ( x :: xs )
# 10822 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = ty;
              MenhirLib.EngineTypes.startp = _startpos_ty_;
              MenhirLib.EngineTypes.endp = _endpos_ty_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_xs_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10870 "src/frontend/parser.ml"
           in
          (
# 253 "<standard.mly>"
    ( x :: xs )
# 10875 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = ty;
              MenhirLib.EngineTypes.startp = _startpos_ty_;
              MenhirLib.EngineTypes.endp = _endpos_ty_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_ty_ in
        let _endpos = _endpos_xs_ in
        let _v =
          let x = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 10923 "src/frontend/parser.ml"
           in
          (
# 253 "<standard.mly>"
    ( x :: xs )
# 10928 "src/frontend/parser.ml"
           : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression Ast.variable) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression Ast.variable list) = 
# 250 "<standard.mly>"
    ( [ x ] )
# 10956 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = x;
              MenhirLib.EngineTypes.startp = _startpos_x_;
              MenhirLib.EngineTypes.endp = _endpos_x_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : (Ast.untyped_expression Ast.variable list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let x : (Ast.untyped_expression Ast.variable) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : (Ast.untyped_expression Ast.variable list) = 
# 253 "<standard.mly>"
    ( x :: xs )
# 10995 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Ast.untyped_expression Ast.variable) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Ast.untyped_expression Ast.variable list) = 
# 250 "<standard.mly>"
    ( [ x ] )
# 11020 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = x;
              MenhirLib.EngineTypes.startp = _startpos_x_;
              MenhirLib.EngineTypes.endp = _endpos_x_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : (Ast.untyped_expression Ast.variable list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let x : (Ast.untyped_expression Ast.variable) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : (Ast.untyped_expression Ast.variable list) = 
# 253 "<standard.mly>"
    ( x :: xs )
# 11059 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = x;
          MenhirLib.EngineTypes.startp = _startpos_x_;
          MenhirLib.EngineTypes.endp = _endpos_x_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let x : (Middle.UnsizedType.t) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_x_ in
        let _v : (Middle.UnsizedType.t list) = 
# 250 "<standard.mly>"
    ( [ x ] )
# 11084 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = xs;
          MenhirLib.EngineTypes.startp = _startpos_xs_;
          MenhirLib.EngineTypes.endp = _endpos_xs_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = _2;
            MenhirLib.EngineTypes.startp = _startpos__2_;
            MenhirLib.EngineTypes.endp = _endpos__2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = x;
              MenhirLib.EngineTypes.startp = _startpos_x_;
              MenhirLib.EngineTypes.endp = _endpos_x_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let xs : (Middle.UnsizedType.t list) = Obj.magic xs in
        let _2 : unit = Obj.magic _2 in
        let x : (Middle.UnsizedType.t) = Obj.magic x in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_x_ in
        let _endpos = _endpos_xs_ in
        let _v : (Middle.UnsizedType.t list) = 
# 253 "<standard.mly>"
    ( x :: xs )
# 11123 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 479 "src/frontend/parser.mly"
    ( grammar_logger "INT_var_type" ; (SizedType.SInt, Identity) )
# 11149 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 481 "src/frontend/parser.mly"
    ( grammar_logger "REAL_var_type" ; (SizedType.SReal, Identity) )
# 11175 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 483 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEX_var_type" ; (SizedType.SComplex, Identity) )
# 11201 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 485 "src/frontend/parser.mly"
    ( grammar_logger "VECTOR_var_type" ; (SizedType.SVector (Mem_pattern.AoS, e), Identity) )
# 11248 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 487 "src/frontend/parser.mly"
    ( grammar_logger "ROWVECTOR_var_type" ; (SizedType.SRowVector (AoS, e) , Identity) )
# 11295 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e2;
            MenhirLib.EngineTypes.startp = _startpos_e2_;
            MenhirLib.EngineTypes.endp = _endpos_e2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = e1;
                MenhirLib.EngineTypes.startp = _startpos_e1_;
                MenhirLib.EngineTypes.endp = _endpos_e1_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _4 : unit = Obj.magic _4 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 489 "src/frontend/parser.mly"
    ( grammar_logger "MATRIX_var_type" ; (SizedType.SMatrix (AoS, e1, e2), Identity) )
# 11356 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 491 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEXVECTOR_var_type" ; (SizedType.SComplexVector e, Identity) )
# 11403 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 493 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEXROWVECTOR_var_type" ; (SizedType.SComplexRowVector e , Identity) )
# 11450 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e2;
            MenhirLib.EngineTypes.startp = _startpos_e2_;
            MenhirLib.EngineTypes.endp = _endpos_e2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = e1;
                MenhirLib.EngineTypes.startp = _startpos_e1_;
                MenhirLib.EngineTypes.endp = _endpos_e1_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _4 : unit = Obj.magic _4 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 495 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEXMATRIX_var_type" ; (SizedType.SComplexMatrix (e1, e2), Transformation.Identity) )
# 11511 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let s : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = Obj.magic s in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_s_ in
        let _v =
          let _endpos = _endpos_s_ in
          let _symbolstartpos = _startpos_s_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 750 "src/frontend/parser.mly"
    (  grammar_logger "atomic_statement" ;
       {stmt= s;
        smeta= { loc=location_span_of_positions _sloc} }
    )
# 11546 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let s : ((Ast.untyped_expression,
   (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
   Ast.statement_with, Ast.untyped_lval, unit)
  Ast.statement) = Obj.magic s in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_s_ in
        let _v =
          let _endpos = _endpos_s_ in
          let _symbolstartpos = _startpos_s_ in
          let _sloc = (_symbolstartpos, _endpos) in
          (
# 755 "src/frontend/parser.mly"
    (  grammar_logger "nested_statement" ;
       {stmt= s;
        smeta={loc = location_span_of_positions _sloc} }
    )
# 11583 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let s : (
# 93 "src/frontend/parser.mly"
       (string)
# 11606 "src/frontend/parser.ml"
        ) = Obj.magic s in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_s_ in
        let _v : (string) = 
# 811 "src/frontend/parser.mly"
    (  grammar_logger ("string_literal " ^ s) ; s )
# 11614 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d_fn;
          MenhirLib.EngineTypes.startp = _startpos_d_fn_;
          MenhirLib.EngineTypes.endp = _endpos_d_fn_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let d_fn : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic d_fn in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_d_fn_ in
        let _endpos = _endpos_d_fn_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 461 "src/frontend/parser.mly"
    ( grammar_logger "top_var_decl" ;
      d_fn ~is_global:true
    )
# 11644 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d_fn;
          MenhirLib.EngineTypes.startp = _startpos_d_fn_;
          MenhirLib.EngineTypes.endp = _endpos_d_fn_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let d_fn : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic d_fn in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_d_fn_ in
        let _endpos = _endpos_d_fn_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 467 "src/frontend/parser.mly"
    ( grammar_logger "top_var_decl_no_assign" ;
      d_fn ~is_global:true
    )
# 11674 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = _1;
          MenhirLib.EngineTypes.startp = _startpos__1_;
          MenhirLib.EngineTypes.endp = _endpos__1_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__1_ in
        let _v =
          let _endpos = _endpos__1_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 471 "src/frontend/parser.mly"
    ( grammar_logger "top_var_decl_no_assign_skip";
      { stmt= Skip
      ; smeta= { loc= location_span_of_positions _loc }
      }
    )
# 11707 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let r : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic r in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_r_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 499 "src/frontend/parser.mly"
    ( grammar_logger "INT_top_var_type" ; (SInt, r) )
# 11742 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = c;
          MenhirLib.EngineTypes.startp = _startpos_c_;
          MenhirLib.EngineTypes.endp = _endpos_c_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_c_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 501 "src/frontend/parser.mly"
    ( grammar_logger "REAL_top_var_type" ; (SReal, c) )
# 11775 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = c;
          MenhirLib.EngineTypes.startp = _startpos_c_;
          MenhirLib.EngineTypes.endp = _endpos_c_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = _1;
            MenhirLib.EngineTypes.startp = _startpos__1_;
            MenhirLib.EngineTypes.endp = _endpos__1_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_c_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 503 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEX_var_type" ; (SComplex, c) )
# 11808 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = c;
                MenhirLib.EngineTypes.startp = _startpos_c_;
                MenhirLib.EngineTypes.endp = _endpos_c_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _3 : unit = Obj.magic _3 in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 505 "src/frontend/parser.mly"
    ( grammar_logger "VECTOR_top_var_type" ; (SVector (AoS, e), c) )
# 11862 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = c;
                MenhirLib.EngineTypes.startp = _startpos_c_;
                MenhirLib.EngineTypes.endp = _endpos_c_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _3 : unit = Obj.magic _3 in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 507 "src/frontend/parser.mly"
    ( grammar_logger "ROWVECTOR_top_var_type" ; (SRowVector (AoS, e), c) )
# 11916 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _7;
          MenhirLib.EngineTypes.startp = _startpos__7_;
          MenhirLib.EngineTypes.endp = _endpos__7_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e2;
            MenhirLib.EngineTypes.startp = _startpos_e2_;
            MenhirLib.EngineTypes.endp = _endpos_e2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = e1;
                MenhirLib.EngineTypes.startp = _startpos_e1_;
                MenhirLib.EngineTypes.endp = _endpos_e1_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _3;
                  MenhirLib.EngineTypes.startp = _startpos__3_;
                  MenhirLib.EngineTypes.endp = _endpos__3_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = c;
                    MenhirLib.EngineTypes.startp = _startpos_c_;
                    MenhirLib.EngineTypes.endp = _endpos_c_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _7 : unit = Obj.magic _7 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _5 : unit = Obj.magic _5 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _3 : unit = Obj.magic _3 in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__7_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 509 "src/frontend/parser.mly"
    ( grammar_logger "MATRIX_top_var_type" ; (SMatrix (AoS, e1, e2), c) )
# 11984 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = c;
                MenhirLib.EngineTypes.startp = _startpos_c_;
                MenhirLib.EngineTypes.endp = _endpos_c_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _3 : unit = Obj.magic _3 in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 511 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEXVECTOR_top_var_type" ; (SComplexVector e, c) )
# 12038 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _3;
              MenhirLib.EngineTypes.startp = _startpos__3_;
              MenhirLib.EngineTypes.endp = _endpos__3_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = c;
                MenhirLib.EngineTypes.startp = _startpos_c_;
                MenhirLib.EngineTypes.endp = _endpos_c_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _3 : unit = Obj.magic _3 in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 513 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEXROWVECTOR_top_var_type" ; (SComplexRowVector e, c) )
# 12092 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _7;
          MenhirLib.EngineTypes.startp = _startpos__7_;
          MenhirLib.EngineTypes.endp = _endpos__7_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e2;
            MenhirLib.EngineTypes.startp = _startpos_e2_;
            MenhirLib.EngineTypes.endp = _endpos_e2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _5;
              MenhirLib.EngineTypes.startp = _startpos__5_;
              MenhirLib.EngineTypes.endp = _endpos__5_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = e1;
                MenhirLib.EngineTypes.startp = _startpos_e1_;
                MenhirLib.EngineTypes.endp = _endpos_e1_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _3;
                  MenhirLib.EngineTypes.startp = _startpos__3_;
                  MenhirLib.EngineTypes.endp = _endpos__3_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = c;
                    MenhirLib.EngineTypes.startp = _startpos_c_;
                    MenhirLib.EngineTypes.endp = _endpos_c_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _menhir_s;
                      MenhirLib.EngineTypes.semv = _1;
                      MenhirLib.EngineTypes.startp = _startpos__1_;
                      MenhirLib.EngineTypes.endp = _endpos__1_;
                      MenhirLib.EngineTypes.next = _menhir_stack;
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _7 : unit = Obj.magic _7 in
        let e2 : (Ast.untyped_expression) = Obj.magic e2 in
        let _5 : unit = Obj.magic _5 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _3 : unit = Obj.magic _3 in
        let c : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic c in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__7_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 515 "src/frontend/parser.mly"
    ( grammar_logger "COMPLEXMATRIX_top_var_type" ; (SComplexMatrix (e1, e2), c) )
# 12160 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 517 "src/frontend/parser.mly"
    ( grammar_logger "ORDERED_top_var_type" ; (SVector (AoS, e), Ordered) )
# 12207 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 519 "src/frontend/parser.mly"
    (
      grammar_logger "POSITIVEORDERED_top_var_type" ;
      (SVector (AoS, e), PositiveOrdered)
    )
# 12257 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 524 "src/frontend/parser.mly"
    ( grammar_logger "SIMPLEX_top_var_type" ; (SVector (AoS, e), Simplex) )
# 12304 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 526 "src/frontend/parser.mly"
    ( grammar_logger "UNITVECTOR_top_var_type" ; (SVector (AoS, e), UnitVector) )
# 12351 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 528 "src/frontend/parser.mly"
    (
      grammar_logger "CHOLESKYFACTORCORR_top_var_type" ;
      (SMatrix (AoS, e, e), CholeskyCorr)
    )
# 12401 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _5;
          MenhirLib.EngineTypes.startp = _startpos__5_;
          MenhirLib.EngineTypes.endp = _endpos__5_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = oe2;
            MenhirLib.EngineTypes.startp = _startpos_oe2_;
            MenhirLib.EngineTypes.endp = _endpos_oe2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = e1;
              MenhirLib.EngineTypes.startp = _startpos_e1_;
              MenhirLib.EngineTypes.endp = _endpos_e1_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = _2;
                MenhirLib.EngineTypes.startp = _startpos__2_;
                MenhirLib.EngineTypes.endp = _endpos__2_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _menhir_s;
                  MenhirLib.EngineTypes.semv = _1;
                  MenhirLib.EngineTypes.startp = _startpos__1_;
                  MenhirLib.EngineTypes.endp = _endpos__1_;
                  MenhirLib.EngineTypes.next = _menhir_stack;
                };
              };
            };
          };
        } = _menhir_stack in
        let _5 : unit = Obj.magic _5 in
        let oe2 : ((unit * Ast.untyped_expression) option) = Obj.magic oe2 in
        let e1 : (Ast.untyped_expression) = Obj.magic e1 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__5_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 534 "src/frontend/parser.mly"
    (
      grammar_logger "CHOLESKYFACTORCOV_top_var_type" ;
      match oe2 with Some (_,e2) -> ( SMatrix (AoS, e1, e2), CholeskyCov)
                   | _           ->  (SMatrix (AoS, e1, e1),  CholeskyCov)
    )
# 12459 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 540 "src/frontend/parser.mly"
    ( grammar_logger "CORRMATRIX_top_var_type" ; (SMatrix (AoS, e, e), Correlation) )
# 12506 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e;
            MenhirLib.EngineTypes.startp = _startpos_e_;
            MenhirLib.EngineTypes.endp = _endpos_e_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let e : (Ast.untyped_expression) = Obj.magic e in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = 
# 542 "src/frontend/parser.mly"
    ( grammar_logger "COVMATRIX_top_var_type" ; (SizedType.SMatrix (AoS, e, e), Transformation.Covariance) )
# 12553 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let s : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_s_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 855 "src/frontend/parser.mly"
    ( grammar_logger "top_vardecl_or_statement_statement" ; s )
# 12580 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = v;
          MenhirLib.EngineTypes.startp = _startpos_v_;
          MenhirLib.EngineTypes.endp = _endpos_v_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic v in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_v_ in
        let _endpos = _endpos_v_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 857 "src/frontend/parser.mly"
    ( grammar_logger "top_vardecl_or_statement_top_vardecl" ; v )
# 12607 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = tvds;
            MenhirLib.EngineTypes.startp = _startpos_tvds_;
            MenhirLib.EngineTypes.endp = _endpos_tvds_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let tvds : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic tvds in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 189 "src/frontend/parser.mly"
    ( grammar_logger "transformed_data_block" ;
      {stmts= tvds; xloc= location_span_of_positions _loc} )
# 12659 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _4;
          MenhirLib.EngineTypes.startp = _startpos__4_;
          MenhirLib.EngineTypes.endp = _endpos__4_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = tvds;
            MenhirLib.EngineTypes.startp = _startpos_tvds_;
            MenhirLib.EngineTypes.endp = _endpos_tvds_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _2;
              MenhirLib.EngineTypes.startp = _startpos__2_;
              MenhirLib.EngineTypes.endp = _endpos__2_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _menhir_s;
                MenhirLib.EngineTypes.semv = _1;
                MenhirLib.EngineTypes.startp = _startpos__1_;
                MenhirLib.EngineTypes.endp = _endpos__1_;
                MenhirLib.EngineTypes.next = _menhir_stack;
              };
            };
          };
        } = _menhir_stack in
        let _4 : unit = Obj.magic _4 in
        let tvds : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with list) = Obj.magic tvds in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__4_ in
        let _v =
          let _endpos = _endpos__4_ in
          let _startpos = _startpos__1_ in
          let _loc = (_startpos, _endpos) in
          (
# 199 "src/frontend/parser.mly"
    ( grammar_logger "transformed_parameters_block" ;
      {stmts= tvds; xloc= location_span_of_positions _loc} )
# 12713 "src/frontend/parser.ml"
           : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.block))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = e2;
            MenhirLib.EngineTypes.startp = _startpos_e2_;
            MenhirLib.EngineTypes.endp = _endpos_e2_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = e1;
                MenhirLib.EngineTypes.startp = _startpos_e1_;
                MenhirLib.EngineTypes.endp = _endpos_e1_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let e2 : (Ast.untyped_expression option) = Obj.magic e2 in
        let _4 : unit = Obj.magic _4 in
        let e1 : (Ast.untyped_expression option) = Obj.magic e1 in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v : (Ast.untyped_expression Ast.truncation) = 
# 816 "src/frontend/parser.mly"
    (  grammar_logger "truncation" ;
       match (e1, e2) with
       | Some tt1, Some tt2 -> TruncateBetween (tt1, tt2)
       | Some tt1, None -> TruncateUpFrom tt1
       | None, Some tt2 -> TruncateDownFrom tt2
       | None, None -> NoTruncate  )
# 12780 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = rest;
            MenhirLib.EngineTypes.startp = _startpos_rest_;
            MenhirLib.EngineTypes.endp = _endpos_rest_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let rest : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic rest in
        let _4 : unit = Obj.magic _4 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let head = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 12846 "src/frontend/parser.ml"
           in
          (
# 447 "src/frontend/parser.mly"
  ( grammar_logger "tuple_type" ;
    let ts = head::rest in
    let types, trans = List.unzip ts in
    (SizedType.STuple types, Transformation.TupleTransformation trans)
  )
# 12855 "src/frontend/parser.ml"
           : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = rest;
            MenhirLib.EngineTypes.startp = _startpos_rest_;
            MenhirLib.EngineTypes.endp = _endpos_rest_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let rest : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic rest in
        let _4 : unit = Obj.magic _4 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let head = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 12923 "src/frontend/parser.ml"
           in
          (
# 447 "src/frontend/parser.mly"
  ( grammar_logger "tuple_type" ;
    let ts = head::rest in
    let types, trans = List.unzip ts in
    (SizedType.STuple types, Transformation.TupleTransformation trans)
  )
# 12932 "src/frontend/parser.ml"
           : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = rest;
            MenhirLib.EngineTypes.startp = _startpos_rest_;
            MenhirLib.EngineTypes.endp = _endpos_rest_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let rest : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic rest in
        let _4 : unit = Obj.magic _4 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let head = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 13000 "src/frontend/parser.ml"
           in
          (
# 447 "src/frontend/parser.mly"
  ( grammar_logger "tuple_type" ;
    let ts = head::rest in
    let types, trans = List.unzip ts in
    (SizedType.STuple types, Transformation.TupleTransformation trans)
  )
# 13009 "src/frontend/parser.ml"
           : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = rest;
            MenhirLib.EngineTypes.startp = _startpos_rest_;
            MenhirLib.EngineTypes.endp = _endpos_rest_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let rest : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic rest in
        let _4 : unit = Obj.magic _4 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let head = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 13077 "src/frontend/parser.ml"
           in
          (
# 447 "src/frontend/parser.mly"
  ( grammar_logger "tuple_type" ;
    let ts = head::rest in
    let types, trans = List.unzip ts in
    (SizedType.STuple types, Transformation.TupleTransformation trans)
  )
# 13086 "src/frontend/parser.ml"
           : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = rest;
            MenhirLib.EngineTypes.startp = _startpos_rest_;
            MenhirLib.EngineTypes.endp = _endpos_rest_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let rest : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic rest in
        let _4 : unit = Obj.magic _4 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let head = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 13154 "src/frontend/parser.ml"
           in
          (
# 447 "src/frontend/parser.mly"
  ( grammar_logger "tuple_type" ;
    let ts = head::rest in
    let types, trans = List.unzip ts in
    (SizedType.STuple types, Transformation.TupleTransformation trans)
  )
# 13163 "src/frontend/parser.ml"
           : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = rest;
            MenhirLib.EngineTypes.startp = _startpos_rest_;
            MenhirLib.EngineTypes.endp = _endpos_rest_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = ty;
                MenhirLib.EngineTypes.startp = _startpos_ty_;
                MenhirLib.EngineTypes.endp = _endpos_ty_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let rest : ((Ast.untyped_expression Middle.SizedType.t *
   Ast.untyped_expression Middle.Transformation.t)
  list) = Obj.magic rest in
        let _4 : unit = Obj.magic _4 in
        let ty : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t) = Obj.magic ty in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let head = 
# 433 "src/frontend/parser.mly"
  ( grammar_logger "higher_type" ;
    ty
  )
# 13231 "src/frontend/parser.ml"
           in
          (
# 447 "src/frontend/parser.mly"
  ( grammar_logger "tuple_type" ;
    let ts = head::rest in
    let types, trans = List.unzip ts in
    (SizedType.STuple types, Transformation.TupleTransformation trans)
  )
# 13240 "src/frontend/parser.ml"
           : (Ast.untyped_expression Middle.SizedType.t *
  Ast.untyped_expression Middle.Transformation.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = r;
          MenhirLib.EngineTypes.startp = _startpos_r_;
          MenhirLib.EngineTypes.endp = _endpos_r_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let r : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic r in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_r_ in
        let _endpos = _endpos_r_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 546 "src/frontend/parser.mly"
    (  grammar_logger "type_constraint_range" ; r )
# 13267 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = l;
            MenhirLib.EngineTypes.startp = _startpos_l_;
            MenhirLib.EngineTypes.endp = _endpos_l_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let l : (Ast.untyped_expression Middle.Transformation.t) = Obj.magic l in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : (Ast.untyped_expression Middle.Transformation.t) = 
# 548 "src/frontend/parser.mly"
    (  grammar_logger "type_constraint_offset_mult" ; l )
# 13306 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _3;
          MenhirLib.EngineTypes.startp = _startpos__3_;
          MenhirLib.EngineTypes.endp = _endpos__3_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = cs;
            MenhirLib.EngineTypes.startp = _startpos_cs_;
            MenhirLib.EngineTypes.endp = _endpos_cs_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let _3 : unit = Obj.magic _3 in
        let cs : (unit list) = Obj.magic cs in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__3_ in
        let _v : (int) = 
# 356 "src/frontend/parser.mly"
    ( grammar_logger "unsized_dims" ; List.length(cs) + 1 )
# 13345 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = t;
          MenhirLib.EngineTypes.startp = _startpos_t_;
          MenhirLib.EngineTypes.endp = _endpos_t_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = n;
            MenhirLib.EngineTypes.startp = _startpos_n_;
            MenhirLib.EngineTypes.endp = _endpos_n_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _menhir_s;
              MenhirLib.EngineTypes.semv = _1;
              MenhirLib.EngineTypes.startp = _startpos__1_;
              MenhirLib.EngineTypes.endp = _endpos__1_;
              MenhirLib.EngineTypes.next = _menhir_stack;
            };
          };
        } = _menhir_stack in
        let t : (Middle.UnsizedType.t) = Obj.magic t in
        let n : (int) = Obj.magic n in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos_t_ in
        let _v : (Middle.UnsizedType.t) = 
# 304 "src/frontend/parser.mly"
    (  grammar_logger "unsized_type";
        nest_unsized_array t n
    )
# 13386 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = ts;
            MenhirLib.EngineTypes.startp = _startpos_ts_;
            MenhirLib.EngineTypes.endp = _endpos_ts_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = hd;
                MenhirLib.EngineTypes.startp = _startpos_hd_;
                MenhirLib.EngineTypes.endp = _endpos_hd_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _;
                    MenhirLib.EngineTypes.semv = _1_inlined1;
                    MenhirLib.EngineTypes.startp = _startpos__1_inlined1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_inlined1_;
                    MenhirLib.EngineTypes.next = {
                      MenhirLib.EngineTypes.state = _;
                      MenhirLib.EngineTypes.semv = n;
                      MenhirLib.EngineTypes.startp = _startpos_n_;
                      MenhirLib.EngineTypes.endp = _endpos_n_;
                      MenhirLib.EngineTypes.next = {
                        MenhirLib.EngineTypes.state = _menhir_s;
                        MenhirLib.EngineTypes.semv = _1;
                        MenhirLib.EngineTypes.startp = _startpos__1_;
                        MenhirLib.EngineTypes.endp = _endpos__1_;
                        MenhirLib.EngineTypes.next = _menhir_stack;
                      };
                    };
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let ts : (Middle.UnsizedType.t list) = Obj.magic ts in
        let _4 : unit = Obj.magic _4 in
        let hd : (Middle.UnsizedType.t) = Obj.magic hd in
        let _2 : unit = Obj.magic _2 in
        let _1_inlined1 : unit = Obj.magic _1_inlined1 in
        let n : (int) = Obj.magic n in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let t = 
# 331 "src/frontend/parser.mly"
    (  UnsizedType.UTuple (hd::ts)
    )
# 13462 "src/frontend/parser.ml"
           in
          (
# 304 "src/frontend/parser.mly"
    (  grammar_logger "unsized_type";
        nest_unsized_array t n
    )
# 13469 "src/frontend/parser.ml"
           : (Middle.UnsizedType.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = dims;
          MenhirLib.EngineTypes.startp = _startpos_dims_;
          MenhirLib.EngineTypes.endp = _endpos_dims_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _menhir_s;
            MenhirLib.EngineTypes.semv = bt;
            MenhirLib.EngineTypes.startp = _startpos_bt_;
            MenhirLib.EngineTypes.endp = _endpos_bt_;
            MenhirLib.EngineTypes.next = _menhir_stack;
          };
        } = _menhir_stack in
        let dims : (int) = Obj.magic dims in
        let bt : (Middle.UnsizedType.t) = Obj.magic bt in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_bt_ in
        let _endpos = _endpos_dims_ in
        let _v =
          let _loc_dims_ = (_startpos_dims_, _endpos_dims_) in
          (
# 310 "src/frontend/parser.mly"
                                    (
    raise
    (Errors.SyntaxError
       (Errors.Parsing
          (Fmt.str
              "An identifier is expected after the type as a function argument \
               name.@ It looks like you are trying to use the old array \
               syntax.@ Please use the new syntax: @ @[<h>array[%s] %a@]@\n"
              (String.make (dims-1) ',')
              UnsizedType.pp bt
          , location_span_of_positions _loc_dims_ )))
  )
# 13515 "src/frontend/parser.ml"
           : (Middle.UnsizedType.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = bt;
          MenhirLib.EngineTypes.startp = _startpos_bt_;
          MenhirLib.EngineTypes.endp = _endpos_bt_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let bt : (Middle.UnsizedType.t) = Obj.magic bt in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_bt_ in
        let _endpos = _endpos_bt_ in
        let _v : (Middle.UnsizedType.t) = 
# 323 "src/frontend/parser.mly"
    (  grammar_logger "unsized_type";
       bt
    )
# 13543 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _;
          MenhirLib.EngineTypes.semv = _6;
          MenhirLib.EngineTypes.startp = _startpos__6_;
          MenhirLib.EngineTypes.endp = _endpos__6_;
          MenhirLib.EngineTypes.next = {
            MenhirLib.EngineTypes.state = _;
            MenhirLib.EngineTypes.semv = ts;
            MenhirLib.EngineTypes.startp = _startpos_ts_;
            MenhirLib.EngineTypes.endp = _endpos_ts_;
            MenhirLib.EngineTypes.next = {
              MenhirLib.EngineTypes.state = _;
              MenhirLib.EngineTypes.semv = _4;
              MenhirLib.EngineTypes.startp = _startpos__4_;
              MenhirLib.EngineTypes.endp = _endpos__4_;
              MenhirLib.EngineTypes.next = {
                MenhirLib.EngineTypes.state = _;
                MenhirLib.EngineTypes.semv = hd;
                MenhirLib.EngineTypes.startp = _startpos_hd_;
                MenhirLib.EngineTypes.endp = _endpos_hd_;
                MenhirLib.EngineTypes.next = {
                  MenhirLib.EngineTypes.state = _;
                  MenhirLib.EngineTypes.semv = _2;
                  MenhirLib.EngineTypes.startp = _startpos__2_;
                  MenhirLib.EngineTypes.endp = _endpos__2_;
                  MenhirLib.EngineTypes.next = {
                    MenhirLib.EngineTypes.state = _menhir_s;
                    MenhirLib.EngineTypes.semv = _1;
                    MenhirLib.EngineTypes.startp = _startpos__1_;
                    MenhirLib.EngineTypes.endp = _endpos__1_;
                    MenhirLib.EngineTypes.next = _menhir_stack;
                  };
                };
              };
            };
          };
        } = _menhir_stack in
        let _6 : unit = Obj.magic _6 in
        let ts : (Middle.UnsizedType.t list) = Obj.magic ts in
        let _4 : unit = Obj.magic _4 in
        let hd : (Middle.UnsizedType.t) = Obj.magic hd in
        let _2 : unit = Obj.magic _2 in
        let _1 : unit = Obj.magic _1 in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos__1_ in
        let _endpos = _endpos__6_ in
        let _v =
          let t = 
# 331 "src/frontend/parser.mly"
    (  UnsizedType.UTuple (hd::ts)
    )
# 13605 "src/frontend/parser.ml"
           in
          (
# 327 "src/frontend/parser.mly"
    ( t )
# 13610 "src/frontend/parser.ml"
           : (Middle.UnsizedType.t))
        in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = d_fn;
          MenhirLib.EngineTypes.startp = _startpos_d_fn_;
          MenhirLib.EngineTypes.endp = _endpos_d_fn_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let d_fn : (is_global:bool ->
  (Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic d_fn in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_d_fn_ in
        let _endpos = _endpos_d_fn_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 455 "src/frontend/parser.mly"
    ( grammar_logger "var_decl" ;
      d_fn ~is_global:false
    )
# 13641 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = s;
          MenhirLib.EngineTypes.startp = _startpos_s_;
          MenhirLib.EngineTypes.endp = _endpos_s_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let s : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic s in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_s_ in
        let _endpos = _endpos_s_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 849 "src/frontend/parser.mly"
    ( grammar_logger "vardecl_or_statement_statement" ; s )
# 13668 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
      (fun _menhir_env ->
        let _menhir_stack = _menhir_env.MenhirLib.EngineTypes.stack in
        let {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = v;
          MenhirLib.EngineTypes.startp = _startpos_v_;
          MenhirLib.EngineTypes.endp = _endpos_v_;
          MenhirLib.EngineTypes.next = _menhir_stack;
        } = _menhir_stack in
        let v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = Obj.magic v in
        let _endpos__0_ = _menhir_stack.MenhirLib.EngineTypes.endp in
        let _startpos = _startpos_v_ in
        let _endpos = _endpos_v_ in
        let _v : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with) = 
# 851 "src/frontend/parser.mly"
    ( grammar_logger "vardecl_or_statement_vardecl" ; v )
# 13695 "src/frontend/parser.ml"
         in
        {
          MenhirLib.EngineTypes.state = _menhir_s;
          MenhirLib.EngineTypes.semv = Obj.repr _v;
          MenhirLib.EngineTypes.startp = _startpos;
          MenhirLib.EngineTypes.endp = _endpos;
          MenhirLib.EngineTypes.next = _menhir_stack;
        });
    |]
  
  and trace =
    None
  
end

module MenhirInterpreter = struct
  
  module ET = MenhirLib.TableInterpreter.MakeEngineTable (Tables)
  
  module TI = MenhirLib.Engine.Make (ET)
  
  include TI
  
end

let program =
  fun lexer lexbuf : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.program) ->
    Obj.magic (MenhirInterpreter.entry `Legacy 404 lexer lexbuf)

and functions_only =
  fun lexer lexbuf : (Ast.untyped_statement Ast.program) ->
    Obj.magic (MenhirInterpreter.entry `Legacy 0 lexer lexbuf)

module Incremental = struct
  
  let program =
    fun initial_position : ((Ast.untyped_expression, Ast.located_meta, Ast.untyped_lval, unit)
  Ast.statement_with Ast.program) MenhirInterpreter.checkpoint ->
      Obj.magic (MenhirInterpreter.start 404 initial_position)
  
  and functions_only =
    fun initial_position : (Ast.untyped_statement Ast.program) MenhirInterpreter.checkpoint ->
      Obj.magic (MenhirInterpreter.start 0 initial_position)
  
end
