/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SingletonSortedNumericDocValues;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public final class DocValues {
    private DocValues() {
    }

    public static final BinaryDocValues emptyBinary() {
        final BytesRef empty = new BytesRef();
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                return empty;
            }
        };
    }

    public static final NumericDocValues emptyNumeric() {
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return 0L;
            }
        };
    }

    public static final SortedDocValues emptySorted() {
        final BytesRef empty = new BytesRef();
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return -1;
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return empty;
            }

            @Override
            public int getValueCount() {
                return 0;
            }
        };
    }

    public static final SortedNumericDocValues emptySortedNumeric(int maxDoc) {
        return DocValues.singleton(DocValues.emptyNumeric(), new Bits.MatchNoBits(maxDoc));
    }

    public static final RandomAccessOrds emptySortedSet() {
        return DocValues.singleton(DocValues.emptySorted());
    }

    public static RandomAccessOrds singleton(SortedDocValues dv) {
        return new SingletonSortedSetDocValues(dv);
    }

    public static SortedDocValues unwrapSingleton(SortedSetDocValues dv) {
        if (dv instanceof SingletonSortedSetDocValues) {
            return ((SingletonSortedSetDocValues)dv).getSortedDocValues();
        }
        return null;
    }

    public static NumericDocValues unwrapSingleton(SortedNumericDocValues dv) {
        if (dv instanceof SingletonSortedNumericDocValues) {
            return ((SingletonSortedNumericDocValues)dv).getNumericDocValues();
        }
        return null;
    }

    public static Bits unwrapSingletonBits(SortedNumericDocValues dv) {
        if (dv instanceof SingletonSortedNumericDocValues) {
            return ((SingletonSortedNumericDocValues)dv).getDocsWithField();
        }
        return null;
    }

    public static SortedNumericDocValues singleton(NumericDocValues dv, Bits docsWithField) {
        return new SingletonSortedNumericDocValues(dv, docsWithField);
    }

    public static Bits docsWithValue(final SortedDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                return dv.getOrd(index) >= 0;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final SortedSetDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                dv.setDocument(index);
                return dv.nextOrd() != -1L;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final SortedNumericDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                dv.setDocument(index);
                return dv.count() != 0;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static NumericDocValues getNumeric(AtomicReader in, String field) throws IOException {
        NumericDocValues dv = in.getNumericDocValues(field);
        if (dv == null) {
            return DocValues.emptyNumeric();
        }
        return dv;
    }

    public static BinaryDocValues getBinary(AtomicReader in, String field) throws IOException {
        BinaryDocValues dv = in.getBinaryDocValues(field);
        if (dv == null && (dv = in.getSortedDocValues(field)) == null) {
            return DocValues.emptyBinary();
        }
        return dv;
    }

    public static SortedDocValues getSorted(AtomicReader in, String field) throws IOException {
        SortedDocValues dv = in.getSortedDocValues(field);
        if (dv == null) {
            return DocValues.emptySorted();
        }
        return dv;
    }

    public static SortedNumericDocValues getSortedNumeric(AtomicReader in, String field) throws IOException {
        SortedNumericDocValues dv = in.getSortedNumericDocValues(field);
        if (dv == null) {
            NumericDocValues single = in.getNumericDocValues(field);
            if (single == null) {
                return DocValues.emptySortedNumeric(in.maxDoc());
            }
            Bits bits = in.getDocsWithField(field);
            return DocValues.singleton(single, bits);
        }
        return dv;
    }

    public static SortedSetDocValues getSortedSet(AtomicReader in, String field) throws IOException {
        SortedSetDocValues dv = in.getSortedSetDocValues(field);
        if (dv == null) {
            SortedDocValues sorted = in.getSortedDocValues(field);
            if (sorted == null) {
                return DocValues.emptySortedSet();
            }
            return DocValues.singleton(sorted);
        }
        return dv;
    }

    public static Bits getDocsWithField(AtomicReader in, String field) throws IOException {
        Bits dv = in.getDocsWithField(field);
        if (dv == null) {
            return new Bits.MatchNoBits(in.maxDoc());
        }
        return dv;
    }
}

