/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify.demo;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class MnistConverter {
    static final Redwood.RedwoodChannels logger = Redwood.channels(MnistConverter.class);

    private MnistConverter() {
    }

    public static void main(String[] args) throws IOException {
        int yNumLabels;
        if (args.length != 4) {
            logger.info("Usage: MnistConverter dataFile labelFile outFile propsFile");
            return;
        }
        DataInputStream xStream = IOUtils.getDataInputStream(args[0]);
        DataInputStream yStream = IOUtils.getDataInputStream(args[1]);
        PrintWriter oStream = new PrintWriter(new FileWriter(args[2]));
        PrintWriter pStream = new PrintWriter(new FileWriter(args[3]));
        int xMagic = xStream.readInt();
        if (xMagic != 2051) {
            throw new RuntimeException("Bad format of xStream");
        }
        int yMagic = yStream.readInt();
        if (yMagic != 2049) {
            throw new RuntimeException("Bad format of yStream");
        }
        int xNumImages = xStream.readInt();
        if (xNumImages != (yNumLabels = yStream.readInt())) {
            throw new RuntimeException("x and y sizes don't match");
        }
        logger.info("Images and label file both contain " + xNumImages + " entries.");
        int xRows = xStream.readInt();
        int xColumns = xStream.readInt();
        for (int i = 0; i < xNumImages; ++i) {
            int label = yStream.readUnsignedByte();
            int[] matrix = new int[xRows * xColumns];
            for (int j = 0; j < xRows * xColumns; ++j) {
                matrix[j] = xStream.readUnsignedByte();
            }
            oStream.print(label);
            for (int k : matrix) {
                oStream.print('\t');
                oStream.print(k);
            }
            oStream.println();
        }
        logger.info("Converted.");
        xStream.close();
        yStream.close();
        oStream.close();
        pStream.println("goldAnswerColumn = 0");
        pStream.println("useClassFeature = true");
        pStream.println("sigma = 10");
        for (int j = 0; j < xRows * xColumns; ++j) {
            pStream.println(j + 1 + ".realValued = true");
        }
        pStream.close();
    }
}

