/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.data;

import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.InputDoc;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.data.SpeakerInfo;
import edu.stanford.nlp.coref.docreader.CoNLLDocumentReader;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Document
implements Serializable {
    private static final long serialVersionUID = -4139866807494603953L;
    public DocType docType;
    public Annotation annotation;
    public CoNLLDocumentReader.CoNLLDocument conllDoc;
    public List<List<Mention>> goldMentions;
    public List<List<Mention>> predictedMentions;
    public Map<Integer, CorefCluster> corefClusters;
    public Map<Integer, CorefCluster> goldCorefClusters = null;
    public Map<Integer, Mention> predictedMentionsByID;
    public Map<Integer, Mention> goldMentionsByID;
    public Set<Mention> roleSet;
    public Map<Mention, IntTuple> positions;
    public Map<Mention, IntTuple> allPositions;
    public final Map<IntTuple, Mention> mentionheadPositions;
    private List<Pair<IntTuple, IntTuple>> goldLinks;
    public Map<Integer, String> speakers;
    public Set<Pair<Integer, Integer>> speakerPairs;
    public boolean speakerInfoGiven;
    public int maxUtter;
    public int numParagraph;
    public int numSentences;
    private final Set<Pair<Integer, Integer>> incompatibles;
    private final Set<Pair<Integer, Integer>> incompatibleClusters;
    public Map<Pair<Integer, Integer>, Boolean> acronymCache;
    public Map<String, SpeakerInfo> speakerInfoMap = Generics.newHashMap();
    public Map<String, String> docInfo;

    public List<List<Mention>> getOrderedMentions() {
        return this.predictedMentions;
    }

    public Document() {
        this.positions = Generics.newHashMap();
        this.mentionheadPositions = Generics.newHashMap();
        this.roleSet = Generics.newHashSet();
        this.corefClusters = Generics.newHashMap();
        this.predictedMentionsByID = Generics.newHashMap();
        this.speakers = Generics.newHashMap();
        this.speakerPairs = Generics.newHashSet();
        this.incompatibles = Generics.newHashSet();
        this.incompatibleClusters = Generics.newHashSet();
        this.acronymCache = Generics.newHashMap();
    }

    public Document(Annotation anno, List<List<Mention>> predictedMentions, List<List<Mention>> goldMentions) {
        this();
        this.annotation = anno;
        this.predictedMentions = predictedMentions;
        this.goldMentions = goldMentions;
    }

    public Document(InputDoc input, List<List<Mention>> mentions) {
        this();
        this.annotation = input.annotation;
        this.predictedMentions = mentions;
        this.goldMentions = input.goldMentions;
        this.docInfo = input.docInfo;
        this.numSentences = ((List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class)).size();
        this.conllDoc = input.conllDoc;
    }

    public boolean isIncompatible(CorefCluster c1, CorefCluster c2) {
        int cid1 = Math.min(c1.clusterID, c2.clusterID);
        int cid2 = Math.max(c1.clusterID, c2.clusterID);
        return this.incompatibleClusters.contains(Pair.makePair(cid1, cid2));
    }

    public void mergeIncompatibles(CorefCluster to, CorefCluster from) {
        ArrayList<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> replacements = new ArrayList<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>>();
        for (Pair<Integer, Integer> pair : this.incompatibleClusters) {
            Integer other = null;
            if ((Integer)pair.first == from.clusterID) {
                other = (Integer)pair.second;
            } else if ((Integer)pair.second == from.clusterID) {
                other = (Integer)pair.first;
            }
            if (other == null || other == to.clusterID) continue;
            int cid1 = Math.min(other, to.clusterID);
            int cid2 = Math.max(other, to.clusterID);
            replacements.add(Pair.makePair(pair, Pair.makePair(cid1, cid2)));
        }
        for (Pair<Integer, Integer> pair : replacements) {
            this.incompatibleClusters.remove(pair.first);
            this.incompatibleClusters.add((Pair)pair.second);
        }
    }

    public void mergeAcronymCache(CorefCluster to, CorefCluster from) {
        Map<Pair<Integer, Integer>, Boolean> replacements = Generics.newHashMap();
        for (Pair<Integer, Integer> p : this.acronymCache.keySet()) {
            if (!this.acronymCache.get(p).booleanValue()) continue;
            Integer other = null;
            if ((Integer)p.first == from.clusterID) {
                other = (Integer)p.second;
            } else if ((Integer)p.second == from.clusterID) {
                other = (Integer)p.first;
            }
            if (other == null || other == to.clusterID) continue;
            int cid1 = Math.min(other, to.clusterID);
            int cid2 = Math.max(other, to.clusterID);
            replacements.put(Pair.makePair(cid1, cid2), true);
        }
        for (Pair<Integer, Integer> p : replacements.keySet()) {
            this.acronymCache.put(p, (Boolean)replacements.get(p));
        }
    }

    public boolean isIncompatible(Mention m1, Mention m2) {
        int mid1 = Math.min(m1.mentionID, m2.mentionID);
        int mid2 = Math.max(m1.mentionID, m2.mentionID);
        return this.incompatibles.contains(Pair.makePair(mid1, mid2));
    }

    public void addIncompatible(Mention m1, Mention m2) {
        int mid1 = Math.min(m1.mentionID, m2.mentionID);
        int mid2 = Math.max(m1.mentionID, m2.mentionID);
        this.incompatibles.add(Pair.makePair(mid1, mid2));
        int cid1 = Math.min(m1.corefClusterID, m2.corefClusterID);
        int cid2 = Math.max(m1.corefClusterID, m2.corefClusterID);
        this.incompatibleClusters.add(Pair.makePair(cid1, cid2));
    }

    public List<Pair<IntTuple, IntTuple>> getGoldLinks() {
        if (this.goldLinks == null) {
            this.extractGoldLinks();
        }
        return this.goldLinks;
    }

    protected void extractGoldLinks() {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        Map<Integer, IntTuple> positions = Generics.newHashMap();
        Map antecedents = Generics.newHashMap();
        for (int i = 0; i < this.goldMentions.size(); ++i) {
            for (int j = 0; j < this.goldMentions.get(i).size(); ++j) {
                Mention m = this.goldMentions.get(i).get(j);
                int id = m.mentionID;
                IntTuple pos = new IntTuple(2);
                pos.set(0, i);
                pos.set(1, j);
                positions.put(id, pos);
                antecedents.put(id, new ArrayList());
            }
        }
        for (List<Mention> mentions : this.goldMentions) {
            for (Mention m : mentions) {
                int id = m.mentionID;
                IntTuple src = (IntTuple)positions.get(id);
                assert (src != null);
                if (m.originalRef < 0) continue;
                IntTuple dst = (IntTuple)positions.get(m.originalRef);
                if (dst == null) {
                    throw new RuntimeException("Cannot find gold mention with ID=" + m.originalRef);
                }
                while (dst.get(0) > src.get(0) || dst.get(0) == src.get(0) && dst.get(1) > src.get(1)) {
                    Mention dstMention = this.goldMentions.get(dst.get(0)).get(dst.get(1));
                    m.originalRef = dstMention.originalRef;
                    dstMention.originalRef = id;
                    if (m.originalRef < 0) break;
                    dst = (IntTuple)positions.get(m.originalRef);
                }
                if (m.originalRef < 0) continue;
                block5: for (int k = dst.get(0); k <= src.get(0); ++k) {
                    for (int l = 0; l < this.goldMentions.get(k).size(); ++l) {
                        if (k == dst.get(0) && l < dst.get(1)) continue;
                        if (k == src.get(0) && l > src.get(1)) continue block5;
                        IntTuple missed = new IntTuple(2);
                        missed.set(0, k);
                        missed.set(1, l);
                        if (!links.contains(new Pair<IntTuple, IntTuple>(missed, dst))) continue;
                        ((List)antecedents.get(id)).add(missed);
                        links.add(new Pair<IntTuple, IntTuple>(src, missed));
                    }
                }
                links.add(new Pair<IntTuple, IntTuple>(src, dst));
                assert (antecedents.get(id) != null);
                ((List)antecedents.get(id)).add(dst);
                List ants = (List)antecedents.get(m.originalRef);
                assert (ants != null);
                for (IntTuple ant : ants) {
                    ((List)antecedents.get(id)).add(ant);
                    links.add(new Pair<IntTuple, IntTuple>(src, ant));
                }
            }
        }
        this.goldLinks = links;
    }

    public SpeakerInfo getSpeakerInfo(String speaker) {
        return this.speakerInfoMap.get(speaker);
    }

    public int numberOfSpeakers() {
        return this.speakerInfoMap.size();
    }

    public boolean isCoref(Mention m1, Mention m2) {
        return this.goldMentionsByID.containsKey(m1.mentionID) && this.goldMentionsByID.containsKey(m2.mentionID) && this.goldMentionsByID.get((Object)Integer.valueOf((int)m1.mentionID)).goldCorefClusterID == this.goldMentionsByID.get((Object)Integer.valueOf((int)m2.mentionID)).goldCorefClusterID;
    }

    public static enum DocType {
        CONVERSATION,
        ARTICLE;

    }
}

