/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.CorefDocumentProcessor;
import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.statistical.StatisticalCorefTrainer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataWriter
implements CorefDocumentProcessor {
    private final Map<Integer, Map<Integer, String>> mentionTypes;
    private final Map<Integer, List<List<Integer>>> goldClusters;
    private final Counter<String> wordCounts;
    private final Map<Integer, Map<Pair<Integer, Integer>, Boolean>> mentionPairs;
    private final boolean countWords;

    public MetadataWriter(boolean countWords) {
        this.countWords = countWords;
        this.mentionTypes = new HashMap<Integer, Map<Integer, String>>();
        this.goldClusters = new HashMap<Integer, List<List<Integer>>>();
        this.wordCounts = new ClassicCounter<String>();
        try {
            this.mentionPairs = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.datasetFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(int id, Document document) {
        this.mentionTypes.put(id, document.predictedMentionsByID.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Mention)e.getValue()).mentionType.toString())));
        ArrayList clusters = new ArrayList();
        for (CorefCluster c : document.goldCorefClusters.values()) {
            ArrayList<Integer> cluster = new ArrayList<Integer>();
            for (Mention m : c.getCorefMentions()) {
                cluster.add(m.mentionID);
            }
            clusters.add(cluster);
        }
        this.goldClusters.put(id, clusters);
        if (this.countWords && this.mentionPairs.containsKey(id)) {
            Set<Pair<Integer, Integer>> pairs = this.mentionPairs.get(id).keySet();
            HashSet<Integer> mentions = new HashSet<Integer>();
            for (Pair pair : pairs) {
                mentions.add((Integer)pair.first);
                mentions.add((Integer)pair.second);
                Mention m1 = document.predictedMentionsByID.get(pair.first);
                Mention m2 = document.predictedMentionsByID.get(pair.second);
                this.wordCounts.incrementCount("h_" + m1.headWord.word().toLowerCase() + "_" + m2.headWord.word().toLowerCase());
            }
            HashMap<Integer, List<CoreLabel>> sentences = new HashMap<Integer, List<CoreLabel>>();
            Iterator iterator = mentions.iterator();
            while (iterator.hasNext()) {
                int mention = (Integer)iterator.next();
                Mention m = document.predictedMentionsByID.get(mention);
                if (sentences.containsKey(m.sentNum)) continue;
                sentences.put(m.sentNum, m.sentenceWords);
            }
            for (List sentence : sentences.values()) {
                for (int i = 0; i < sentence.size(); ++i) {
                    CoreLabel clp;
                    CoreLabel cl = (CoreLabel)sentence.get(i);
                    if (cl == null) continue;
                    String w = cl.word().toLowerCase();
                    this.wordCounts.incrementCount(w);
                    if (i <= 0 || (clp = (CoreLabel)sentence.get(i - 1)) == null) continue;
                    String wp = clp.word().toLowerCase();
                    this.wordCounts.incrementCount(wp + "_" + w);
                }
            }
        }
    }

    @Override
    public void finish() throws Exception {
        IOUtils.writeObjectToFile(this.mentionTypes, StatisticalCorefTrainer.mentionTypesFile);
        IOUtils.writeObjectToFile(this.goldClusters, StatisticalCorefTrainer.goldClustersFile);
        if (this.countWords) {
            IOUtils.writeObjectToFile(this.wordCounts, StatisticalCorefTrainer.wordCountsFile);
        }
    }
}

