/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SpeakerInfo;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.math.NumberMatchingRegex;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class Rules {
    private static final boolean DEBUG = true;
    private static final List<String> entityWordsToExclude = Arrays.asList("the", "this", "mr.", "miss", "mrs.", "dr.", "ms.", "inc.", "ltd.", "corp.", "'s");
    private static final Set<String> locationModifier = Generics.newHashSet(Arrays.asList("east", "west", "north", "south", "eastern", "western", "northern", "southern", "northwestern", "southwestern", "northeastern", "southeastern", "upper", "lower"));
    private static final Set<String> NUMBERS = Generics.newHashSet(Arrays.asList("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "hundred", "thousand", "million", "billion"));
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile(" +");

    public static boolean entityBothHaveProper(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        boolean mentionClusterHaveProper = false;
        boolean potentialAntecedentHaveProper = false;
        for (Mention m : mentionCluster.corefMentions) {
            if (m.mentionType != Dictionaries.MentionType.PROPER) continue;
            mentionClusterHaveProper = true;
            break;
        }
        for (Mention a : potentialAntecedent.corefMentions) {
            if (a.mentionType != Dictionaries.MentionType.PROPER) continue;
            potentialAntecedentHaveProper = true;
            break;
        }
        return mentionClusterHaveProper && potentialAntecedentHaveProper;
    }

    public static boolean entitySameProperHeadLastWord(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention, Mention ant) {
        for (Mention m : mentionCluster.getCorefMentions()) {
            for (Mention a : potentialAntecedent.getCorefMentions()) {
                if (!Rules.entitySameProperHeadLastWord(m, a)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean entityAlias(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Semantics semantics, Dictionaries dict) throws Exception {
        Mention mention = mentionCluster.getRepresentativeMention();
        Mention antecedent = potentialAntecedent.getRepresentativeMention();
        if (mention.mentionType != Dictionaries.MentionType.PROPER || antecedent.mentionType != Dictionaries.MentionType.PROPER) {
            return false;
        }
        Method meth = semantics.wordnet.getClass().getMethod("alias", Mention.class, Mention.class);
        return (Boolean)meth.invoke(semantics.wordnet, mention, antecedent) != false;
    }

    public static boolean entityIWithinI(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict) {
        for (Mention m : mentionCluster.getCorefMentions()) {
            for (Mention a : potentialAntecedent.getCorefMentions()) {
                if (!Rules.entityIWithinI(m, a, dict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean entityPersonDisagree(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict) {
        boolean disagree = false;
        block0: for (Mention m : mentionCluster.getCorefMentions()) {
            for (Mention ant : potentialAntecedent.getCorefMentions()) {
                if (!Rules.entityPersonDisagree(document, m, ant, dict)) continue;
                disagree = true;
                continue block0;
            }
        }
        return disagree;
    }

    public static boolean entityWordsIncluded(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention, Mention ant) {
        Set<String> wordsExceptStopWords = Generics.newHashSet(mentionCluster.words);
        wordsExceptStopWords.removeAll(entityWordsToExclude);
        wordsExceptStopWords.remove(mention.headString.toLowerCase());
        return potentialAntecedent.words.containsAll(wordsExceptStopWords);
    }

    public static boolean entityHaveIncompatibleModifier(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        for (Mention m : mentionCluster.corefMentions) {
            for (Mention ant : potentialAntecedent.corefMentions) {
                if (!Rules.entityHaveIncompatibleModifier(m, ant)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean entityIsRoleAppositive(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m1, Mention m2, Dictionaries dict) {
        if (!Rules.entityAttributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        return m1.isRoleAppositive(m2, dict) || m2.isRoleAppositive(m1, dict);
    }

    public static boolean entityIsRelativePronoun(Mention m1, Mention m2) {
        return m1.isRelativePronoun(m2) || m2.isRelativePronoun(m1);
    }

    public static boolean entityIsAcronym(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        int minId = Math.min(mentionCluster.clusterID, potentialAntecedent.clusterID);
        int maxId = Math.max(mentionCluster.clusterID, potentialAntecedent.clusterID);
        if (!document.acronymCache.contains(minId, maxId)) {
            boolean isAcronym = false;
            for (Mention m : mentionCluster.corefMentions) {
                if (m.isPronominal()) continue;
                for (Mention ant : potentialAntecedent.corefMentions) {
                    if (!Rules.isAcronym(m.originalSpan, ant.originalSpan)) continue;
                    isAcronym = true;
                }
            }
            document.acronymCache.put(minId, maxId, isAcronym);
        }
        return document.acronymCache.get(minId, maxId);
    }

    public static boolean isAcronym(List<CoreLabel> first, List<CoreLabel> second) {
        int acronymPos;
        List<CoreLabel> shorter;
        List<CoreLabel> longer;
        if (first.size() > 1 && second.size() > 1) {
            return false;
        }
        if (first.size() == 0 && second.size() == 0) {
            return false;
        }
        if (first.size() == second.size()) {
            String firstWord = (String)first.get(0).get(CoreAnnotations.TextAnnotation.class);
            String secondWord = (String)second.get(0).get(CoreAnnotations.TextAnnotation.class);
            longer = firstWord.length() > secondWord.length() ? first : second;
            shorter = firstWord.length() > secondWord.length() ? second : first;
        } else {
            longer = first.size() > 0 && first.size() > second.size() ? first : second;
            shorter = second.size() > 0 && first.size() > second.size() ? second : first;
        }
        String acronym = shorter.size() > 0 ? (String)shorter.get(0).get(CoreAnnotations.TextAnnotation.class) : "<UNK>";
        for (acronymPos = 0; acronymPos < acronym.length(); ++acronymPos) {
            if (acronym.charAt(acronymPos) >= 'A' && acronym.charAt(acronymPos) <= 'Z') continue;
            return false;
        }
        acronymPos = 0;
        for (CoreLabel aLonger1 : longer) {
            String word = (String)aLonger1.get(CoreAnnotations.TextAnnotation.class);
            for (int charNum = 0; charNum < word.length(); ++charNum) {
                if (word.charAt(charNum) < 'A' || word.charAt(charNum) > 'Z') continue;
                if (acronymPos >= acronym.length()) {
                    return false;
                }
                if (acronym.charAt(acronymPos) != word.charAt(charNum)) {
                    return false;
                }
                ++acronymPos;
            }
        }
        if (acronymPos != acronym.length()) {
            return false;
        }
        for (CoreLabel aLonger : longer) {
            if (!((String)aLonger.get(CoreAnnotations.TextAnnotation.class)).contains(acronym)) continue;
            return false;
        }
        return true;
    }

    public static boolean entityIsPredicateNominatives(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m1, Mention m2) {
        if (!Rules.entityAttributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (m1.startIndex <= m2.startIndex && m1.endIndex >= m2.endIndex || m1.startIndex >= m2.startIndex && m1.endIndex <= m2.endIndex) {
            return false;
        }
        return m1.isPredicateNominatives(m2) || m2.isPredicateNominatives(m1);
    }

    public static boolean entityIsApposition(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m1, Mention m2) {
        if (!Rules.entityAttributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (m1.mentionType == Dictionaries.MentionType.PROPER && m2.mentionType == Dictionaries.MentionType.PROPER) {
            return false;
        }
        if (m1.nerString.equals("LOCATION")) {
            return false;
        }
        return m1.isApposition(m2) || m2.isApposition(m1);
    }

    public static boolean entityAttributesAgree(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        return Rules.entityAttributesAgree(mentionCluster, potentialAntecedent, false);
    }

    public static boolean entityAttributesAgree(CorefCluster mentionCluster, CorefCluster potentialAntecedent, boolean ignoreGender) {
        boolean hasExtraAnt = false;
        boolean hasExtraThis = false;
        if (!mentionCluster.numbers.contains((Object)Dictionaries.Number.UNKNOWN)) {
            for (Dictionaries.Number n : potentialAntecedent.numbers) {
                if (n == Dictionaries.Number.UNKNOWN || mentionCluster.numbers.contains((Object)n)) continue;
                hasExtraAnt = true;
                break;
            }
        }
        if (!potentialAntecedent.numbers.contains((Object)Dictionaries.Number.UNKNOWN)) {
            for (Dictionaries.Number n : mentionCluster.numbers) {
                if (n == Dictionaries.Number.UNKNOWN || potentialAntecedent.numbers.contains((Object)n)) continue;
                hasExtraThis = true;
                break;
            }
        }
        if (hasExtraAnt && hasExtraThis) {
            return false;
        }
        hasExtraAnt = false;
        hasExtraThis = false;
        if (!ignoreGender) {
            if (!mentionCluster.genders.contains((Object)Dictionaries.Gender.UNKNOWN)) {
                for (Dictionaries.Gender g : potentialAntecedent.genders) {
                    if (g == Dictionaries.Gender.UNKNOWN || mentionCluster.genders.contains((Object)g)) continue;
                    hasExtraAnt = true;
                    break;
                }
            }
            if (!potentialAntecedent.genders.contains((Object)Dictionaries.Gender.UNKNOWN)) {
                for (Dictionaries.Gender g : mentionCluster.genders) {
                    if (g == Dictionaries.Gender.UNKNOWN || potentialAntecedent.genders.contains((Object)g)) continue;
                    hasExtraThis = true;
                    break;
                }
            }
        }
        if (hasExtraAnt && hasExtraThis) {
            return false;
        }
        hasExtraAnt = false;
        hasExtraThis = false;
        if (!mentionCluster.animacies.contains((Object)Dictionaries.Animacy.UNKNOWN)) {
            for (Dictionaries.Animacy a : potentialAntecedent.animacies) {
                if (a == Dictionaries.Animacy.UNKNOWN || mentionCluster.animacies.contains((Object)a)) continue;
                hasExtraAnt = true;
                break;
            }
        }
        if (!potentialAntecedent.animacies.contains((Object)Dictionaries.Animacy.UNKNOWN)) {
            for (Dictionaries.Animacy a : mentionCluster.animacies) {
                if (a == Dictionaries.Animacy.UNKNOWN || potentialAntecedent.animacies.contains((Object)a)) continue;
                hasExtraThis = true;
                break;
            }
        }
        if (hasExtraAnt && hasExtraThis) {
            return false;
        }
        hasExtraAnt = false;
        hasExtraThis = false;
        if (!mentionCluster.nerStrings.contains("O") && !mentionCluster.nerStrings.contains("MISC")) {
            for (String ne : potentialAntecedent.nerStrings) {
                if (ne.equals("O") || ne.equals("MISC") || mentionCluster.nerStrings.contains(ne)) continue;
                hasExtraAnt = true;
                break;
            }
        }
        if (!potentialAntecedent.nerStrings.contains("O") && !potentialAntecedent.nerStrings.contains("MISC")) {
            for (String ne : mentionCluster.nerStrings) {
                if (ne.equals("O") || ne.equals("MISC") || potentialAntecedent.nerStrings.contains(ne)) continue;
                hasExtraThis = true;
                break;
            }
        }
        return !hasExtraAnt || !hasExtraThis;
    }

    public static boolean entityRelaxedHeadsAgreeBetweenMentions(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m, Mention ant) {
        if (m.isPronominal() || ant.isPronominal()) {
            return false;
        }
        return m.headsAgree(ant);
    }

    public static boolean entityHeadsAgree(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m, Mention ant, Dictionaries dict) {
        boolean headAgree = false;
        if (m.isPronominal() || ant.isPronominal() || dict.allPronouns.contains(m.lowercaseNormalizedSpanString()) || dict.allPronouns.contains(ant.lowercaseNormalizedSpanString())) {
            return false;
        }
        for (Mention a : potentialAntecedent.corefMentions) {
            if (!a.headString.equals(m.headString)) continue;
            headAgree = true;
        }
        return headAgree;
    }

    public static boolean entityExactStringMatch(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict, Set<Mention> roleSet) {
        boolean matched = false;
        for (Mention m : mentionCluster.corefMentions) {
            String mSpan;
            if (roleSet.contains(m)) {
                return false;
            }
            if (m.isPronominal() || dict.allPronouns.contains(mSpan = m.lowercaseNormalizedSpanString())) continue;
            for (Mention ant : potentialAntecedent.corefMentions) {
                String antSpan;
                if (ant.isPronominal() || dict.allPronouns.contains(antSpan = ant.lowercaseNormalizedSpanString())) continue;
                if (mSpan.equals(antSpan)) {
                    matched = true;
                }
                if (!mSpan.equals(antSpan + " 's") && !antSpan.equals(mSpan + " 's")) continue;
                matched = true;
            }
        }
        return matched;
    }

    public static boolean entityRelaxedExactStringMatch(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention, Mention ant, Dictionaries dict, Set<Mention> roleSet) {
        if (roleSet.contains(mention)) {
            return false;
        }
        if (mention.mentionType == Dictionaries.MentionType.LIST || ant.mentionType == Dictionaries.MentionType.LIST) {
            return false;
        }
        if (mention.isPronominal() || ant.isPronominal() || dict.allPronouns.contains(mention.lowercaseNormalizedSpanString()) || dict.allPronouns.contains(ant.lowercaseNormalizedSpanString())) {
            return false;
        }
        String mentionSpan = mention.removePhraseAfterHead();
        String antSpan = ant.removePhraseAfterHead();
        if (mentionSpan.equals("") || antSpan.equals("")) {
            return false;
        }
        return mentionSpan.equals(antSpan) || mentionSpan.equals(antSpan + " 's") || antSpan.equals(mentionSpan + " 's");
    }

    public static boolean entityIWithinI(Mention m1, Mention m2, Dictionaries dict) {
        return !m1.isApposition(m2) && !m2.isApposition(m1) && !m1.isRelativePronoun(m2) && !m2.isRelativePronoun(m1) && !m1.isRoleAppositive(m2, dict) && !m2.isRoleAppositive(m1, dict) && (m1.includedIn(m2) || m2.includedIn(m1));
    }

    public static boolean entityHaveIncompatibleModifier(Mention m, Mention ant) {
        if (!ant.headString.equalsIgnoreCase(m.headString)) {
            return false;
        }
        boolean thisHasExtra = false;
        int lengthThis = m.originalSpan.size();
        int lengthM = ant.originalSpan.size();
        Set<String> thisWordSet = Generics.newHashSet();
        Set<String> antWordSet = Generics.newHashSet();
        Set<String> locationModifier = Generics.newHashSet(Arrays.asList("east", "west", "north", "south", "eastern", "western", "northern", "southern", "upper", "lower"));
        for (int i = 0; i < lengthThis; ++i) {
            String w1 = ((String)m.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
            String pos1 = (String)m.originalSpan.get(i).get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (!pos1.startsWith("N") && !pos1.startsWith("JJ") && !pos1.equals("CD") && !pos1.startsWith("V") || w1.equalsIgnoreCase(m.headString)) continue;
            thisWordSet.add(w1);
        }
        for (int j = 0; j < lengthM; ++j) {
            String w2 = ((String)ant.originalSpan.get(j).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
            antWordSet.add(w2);
        }
        for (String w : thisWordSet) {
            if (antWordSet.contains(w)) continue;
            thisHasExtra = true;
            break;
        }
        boolean hasLocationModifier = false;
        for (String l : locationModifier) {
            if (!antWordSet.contains(l) || thisWordSet.contains(l)) continue;
            hasLocationModifier = true;
            break;
        }
        return thisHasExtra || hasLocationModifier;
    }

    public static boolean entityHaveDifferentLocation(Mention m, Mention a, Dictionaries dict) {
        String loc;
        String lowercased;
        String text;
        if ((dict.statesAbbreviation.containsKey(a.spanToString()) || dict.statesAbbreviation.containsValue(a.spanToString())) && (m.headString.equalsIgnoreCase("country") || m.headString.equalsIgnoreCase("nation"))) {
            return true;
        }
        Set<String> locationM = Generics.newHashSet();
        Set<String> locationA = Generics.newHashSet();
        String mString = m.lowercaseNormalizedSpanString();
        String aString = a.lowercaseNormalizedSpanString();
        for (CoreLabel w : m.originalSpan) {
            text = (String)w.get(CoreAnnotations.TextAnnotation.class);
            lowercased = text.toLowerCase();
            if (locationModifier.contains(lowercased)) {
                return true;
            }
            if (!((String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("LOCATION")) continue;
            loc = text;
            if (dict.statesAbbreviation.containsKey(loc)) {
                loc = dict.statesAbbreviation.get(loc);
            }
            locationM.add(lowercased);
        }
        for (CoreLabel w : a.originalSpan) {
            text = (String)w.get(CoreAnnotations.TextAnnotation.class);
            lowercased = text.toLowerCase();
            if (locationModifier.contains(lowercased)) {
                return true;
            }
            if (!((String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("LOCATION")) continue;
            loc = text;
            if (dict.statesAbbreviation.containsKey(loc)) {
                loc = dict.statesAbbreviation.get(loc);
            }
            locationA.add(lowercased);
        }
        boolean mHasExtra = false;
        boolean aHasExtra = false;
        for (String s : locationM) {
            if (aString.contains(s)) continue;
            mHasExtra = true;
            break;
        }
        for (String s : locationA) {
            if (mString.contains(s)) continue;
            aHasExtra = true;
            break;
        }
        return mHasExtra && aHasExtra;
    }

    public static boolean entitySameProperHeadLastWord(Mention m, Mention a) {
        if (!(m.headString.equalsIgnoreCase(a.headString) && ((String)m.sentenceWords.get(m.headIndex).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") && ((String)a.sentenceWords.get(a.headIndex).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP"))) {
            return false;
        }
        if (!m.removePhraseAfterHead().toLowerCase().endsWith(m.headString) || !a.removePhraseAfterHead().toLowerCase().endsWith(a.headString)) {
            return false;
        }
        Set<String> mProperNouns = Generics.newHashSet();
        Set<String> aProperNouns = Generics.newHashSet();
        for (CoreLabel w : m.sentenceWords.subList(m.startIndex, m.headIndex)) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            mProperNouns.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        for (CoreLabel w : a.sentenceWords.subList(a.startIndex, a.headIndex)) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            aProperNouns.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        boolean mHasExtra = false;
        boolean aHasExtra = false;
        for (String s : mProperNouns) {
            if (aProperNouns.contains(s)) continue;
            mHasExtra = true;
            break;
        }
        for (String s : aProperNouns) {
            if (mProperNouns.contains(s)) continue;
            aHasExtra = true;
            break;
        }
        return !mHasExtra || !aHasExtra;
    }

    public static boolean entityNumberInLaterMention(Mention mention, Mention ant) {
        Set<String> antecedentWords = Generics.newHashSet();
        for (CoreLabel w : ant.originalSpan) {
            antecedentWords.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        for (CoreLabel w : mention.originalSpan) {
            String word = (String)w.get(CoreAnnotations.TextAnnotation.class);
            if (!(NumberMatchingRegex.isDouble(word) ? !antecedentWords.contains(word) : NUMBERS.contains(word.toLowerCase()) && !antecedentWords.contains(word))) continue;
            return true;
        }
        return false;
    }

    public static boolean entityHaveExtraProperNoun(Mention m, Mention a, Set<String> exceptWords) {
        Set<String> mProper = Generics.newHashSet();
        Set<String> aProper = Generics.newHashSet();
        String mString = m.spanToString();
        String aString = a.spanToString();
        for (CoreLabel w : m.originalSpan) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            mProper.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        for (CoreLabel w : a.originalSpan) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            aProper.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        boolean mHasExtra = false;
        boolean aHasExtra = false;
        for (String s : mProper) {
            if (aString.contains(s) || exceptWords.contains(s.toLowerCase())) continue;
            mHasExtra = true;
            break;
        }
        for (String s : aProper) {
            if (mString.contains(s) || exceptWords.contains(s.toLowerCase())) continue;
            aHasExtra = true;
            break;
        }
        return mHasExtra && aHasExtra;
    }

    public static boolean antecedentIsMentionSpeaker(Document document, Mention mention, Mention ant, Dictionaries dict) {
        if (document.speakerPairs.contains(new Pair<Integer, Integer>(mention.mentionID, ant.mentionID))) {
            return true;
        }
        return Rules.antecedentMatchesMentionSpeakerAnnotation(mention, ant, document);
    }

    public static boolean antecedentMatchesMentionSpeakerAnnotation(Mention mention, Mention ant) {
        return Rules.antecedentMatchesMentionSpeakerAnnotation(mention, ant, null);
    }

    public static boolean antecedentMatchesMentionSpeakerAnnotation(Mention mention, Mention ant, Document document) {
        SpeakerInfo speakerInfo;
        if (mention.headWord == null) {
            return false;
        }
        String speaker = (String)mention.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
        if (speaker == null) {
            return false;
        }
        SpeakerInfo speakerInfo2 = speakerInfo = document != null ? document.getSpeakerInfo(speaker) : null;
        if (speakerInfo != null) {
            return Rules.mentionMatchesSpeaker(ant, speakerInfo, false);
        }
        if (speaker.indexOf(" ") >= 0) {
            for (String s : WHITESPACE_PATTERN.split(speaker)) {
                if (!ant.headString.equalsIgnoreCase(s)) continue;
                return true;
            }
        } else if (ant.headString.equalsIgnoreCase(speaker)) {
            return true;
        }
        return false;
    }

    public static boolean mentionMatchesSpeaker(Mention mention, SpeakerInfo speakerInfo, boolean strictMatch) {
        if (mention.speakerInfo != null && mention.speakerInfo == speakerInfo) {
            return true;
        }
        if (speakerInfo.containsMention(mention)) {
            return true;
        }
        if (strictMatch) {
            String mstr;
            String spkstr = SpeakerInfo.WHITESPACE_PATTERN.matcher(speakerInfo.getSpeakerName()).replaceAll("");
            if (spkstr.equalsIgnoreCase(mstr = SpeakerInfo.WHITESPACE_PATTERN.matcher(mention.spanToString()).replaceAll(""))) {
                speakerInfo.addMention(mention);
                return true;
            }
        } else {
            String mstr;
            String spkDescStr;
            for (String s : speakerInfo.getSpeakerNameStrings()) {
                if (!mention.headString.equalsIgnoreCase(s)) continue;
                speakerInfo.addMention(mention);
                return true;
            }
            if (speakerInfo.getSpeakerDesc() != null && (spkDescStr = SpeakerInfo.WHITESPACE_PATTERN.matcher(speakerInfo.getSpeakerDesc()).replaceAll("")).equalsIgnoreCase(mstr = SpeakerInfo.WHITESPACE_PATTERN.matcher(mention.spanToString()).replaceAll(""))) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityPersonDisagree(Document document, Mention m, Mention ant, Dictionaries dict) {
        boolean sameSpeaker = Rules.entitySameSpeaker(document, m, ant);
        if (sameSpeaker && m.person != ant.person) {
            if (m.person == Dictionaries.Person.IT && ant.person == Dictionaries.Person.THEY || m.person == Dictionaries.Person.THEY && ant.person == Dictionaries.Person.IT || m.person == Dictionaries.Person.THEY && ant.person == Dictionaries.Person.THEY) {
                return false;
            }
            if (m.person != Dictionaries.Person.UNKNOWN && ant.person != Dictionaries.Person.UNKNOWN) {
                return true;
            }
        }
        if (sameSpeaker && (!ant.isPronominal() ? m.person == Dictionaries.Person.I || m.person == Dictionaries.Person.WE || m.person == Dictionaries.Person.YOU : !m.isPronominal() && (ant.person == Dictionaries.Person.I || ant.person == Dictionaries.Person.WE || ant.person == Dictionaries.Person.YOU))) {
            return true;
        }
        if (m.person == Dictionaries.Person.YOU && m != ant && ant.appearEarlierThan(m)) {
            assert (!m.appearEarlierThan(ant));
            int mUtter = (Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
            if (!document.speakers.containsKey(mUtter - 1)) return true;
            String previousSpeaker = document.speakers.get(mUtter - 1);
            int previousSpeakerCorefClusterID = Rules.getSpeakerClusterId(document, previousSpeaker);
            if (previousSpeakerCorefClusterID < 0) {
                return true;
            }
            if (ant.corefClusterID == previousSpeakerCorefClusterID || ant.person == Dictionaries.Person.I) return false;
            return true;
        }
        if (ant.person != Dictionaries.Person.YOU || m == ant || !m.appearEarlierThan(ant)) return false;
        assert (!ant.appearEarlierThan(m));
        int aUtter = (Integer)ant.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
        if (!document.speakers.containsKey(aUtter - 1)) return true;
        String previousSpeaker = document.speakers.get(aUtter - 1);
        int previousSpeakerCorefClusterID = Rules.getSpeakerClusterId(document, previousSpeaker);
        if (previousSpeakerCorefClusterID < 0) {
            return true;
        }
        if (m.corefClusterID == previousSpeakerCorefClusterID || m.person == Dictionaries.Person.I) return false;
        return true;
    }

    public static boolean entitySameSpeaker(Document document, Mention m, Mention ant) {
        String mSpeakerStr = (String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
        if (mSpeakerStr == null) {
            return false;
        }
        String antSpeakerStr = (String)ant.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
        if (antSpeakerStr == null) {
            return false;
        }
        if (mSpeakerStr.equals(antSpeakerStr)) {
            return true;
        }
        int mSpeakerClusterID = Rules.getSpeakerClusterId(document, mSpeakerStr);
        int antSpeakerClusterID = Rules.getSpeakerClusterId(document, antSpeakerStr);
        if (mSpeakerClusterID >= 0 && antSpeakerClusterID >= 0) {
            return mSpeakerClusterID == antSpeakerClusterID;
        }
        return false;
    }

    public static int getSpeakerClusterId(Document document, String speakerString) {
        int speakerClusterId = -1;
        SpeakerInfo speakerInfo = null;
        if (speakerString != null && (speakerInfo = document.getSpeakerInfo(speakerString)) != null) {
            speakerClusterId = speakerInfo.getCorefClusterId();
        }
        if (speakerClusterId < 0 && speakerString != null && NumberMatchingRegex.isDecimalInteger(speakerString)) {
            try {
                int speakerMentionId = Integer.parseInt(speakerString);
                Mention mention = document.allPredictedMentions.get(speakerMentionId);
                if (mention != null) {
                    speakerClusterId = mention.corefClusterID;
                    if (speakerInfo != null) {
                        speakerInfo.addMention(mention);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return speakerClusterId;
    }

    public static boolean entitySubjectObject(Mention m1, Mention m2) {
        if (m1.sentNum != m2.sentNum) {
            return false;
        }
        if (m1.dependingVerb == null || m2.dependingVerb == null) {
            return false;
        }
        return m1.dependingVerb == m2.dependingVerb && (m1.isSubject && (m2.isDirectObject || m2.isIndirectObject || m2.isPrepositionObject) || m2.isSubject && (m1.isDirectObject || m1.isIndirectObject || m1.isPrepositionObject));
    }

    public static boolean entityTokenDistance(Mention m1, Mention m2) {
        return m2.sentNum == m1.sentNum && m1.startIndex - m2.startIndex < 6;
    }

    public static boolean entityClusterAllCorefDictionary(CorefCluster menCluster, CorefCluster antCluster, Dictionaries dict, int dictColumn, int freq) {
        boolean ret = false;
        for (Mention men : menCluster.getCorefMentions()) {
            if (men.isPronominal()) continue;
            for (Mention ant : antCluster.getCorefMentions()) {
                if (ant.isPronominal() || men.headWord.lemma().equals(ant.headWord.lemma())) continue;
                if (Rules.entityCorefDictionary(men, ant, dict, dictColumn, freq)) {
                    ret = true;
                    continue;
                }
                return false;
            }
        }
        return ret;
    }

    public static boolean entityCorefDictionary(Mention men, Mention ant, Dictionaries dict, int dictVersion, int freq) {
        Pair<String, String> mention_pair = new Pair<String, String>(men.getSplitPattern()[dictVersion - 1].toLowerCase(), ant.getSplitPattern()[dictVersion - 1].toLowerCase());
        int high_freq = -1;
        if (dictVersion == 1) {
            high_freq = 75;
        } else if (dictVersion == 2) {
            high_freq = 16;
        } else if (dictVersion == 3) {
            high_freq = 16;
        } else if (dictVersion == 4) {
            high_freq = 16;
        }
        if (dict.corefDict.get(dictVersion - 1).getCount(mention_pair) > (double)high_freq) {
            return true;
        }
        if (dict.corefDict.get(dictVersion - 1).getCount(mention_pair) > (double)freq) {
            if (dict.corefDictPMI.getCount(mention_pair) > 0.18) {
                return true;
            }
            if (!dict.corefDictPMI.containsKey(mention_pair)) {
                return true;
            }
        }
        return false;
    }

    public static boolean contextIncompatible(Mention men, Mention ant, Dictionaries dict) {
        String antHead = ant.headWord.word();
        if (ant.mentionType == Dictionaries.MentionType.PROPER && ant.sentNum != men.sentNum && !Rules.isContextOverlapping(ant, men) && dict.NE_signatures.containsKey(antHead)) {
            IntCounter<String> ranks = Counters.toRankCounter(dict.NE_signatures.get(antHead));
            List<String> context = !men.getPremodifierContext().isEmpty() ? men.getPremodifierContext() : men.getContext();
            if (!context.isEmpty()) {
                int highestRank = 100000;
                for (String w : context) {
                    IntCounter<String> reverseRanks;
                    if (ranks.containsKey(w) && ranks.getIntCount(w) < highestRank) {
                        highestRank = ranks.getIntCount(w);
                    }
                    if (!dict.NE_signatures.containsKey(w) || !(reverseRanks = Counters.toRankCounter(dict.NE_signatures.get(w))).containsKey(antHead) || reverseRanks.getIntCount(antHead) >= highestRank) continue;
                    highestRank = reverseRanks.getIntCount(antHead);
                }
                if (highestRank > 10) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean sentenceContextIncompatible(Mention men, Mention ant, Dictionaries dict) {
        if (ant.mentionType != Dictionaries.MentionType.PROPER && ant.sentNum != men.sentNum && men.mentionType != Dictionaries.MentionType.PROPER && !Rules.isContextOverlapping(ant, men)) {
            List<String> context2;
            List<String> context1 = !ant.getPremodifierContext().isEmpty() ? ant.getPremodifierContext() : ant.getContext();
            List<String> list = context2 = !men.getPremodifierContext().isEmpty() ? men.getPremodifierContext() : men.getContext();
            if (!context1.isEmpty() && !context2.isEmpty()) {
                int highestRank = 100000;
                for (String w1 : context1) {
                    for (String w2 : context2) {
                        IntCounter<String> reverseRanks;
                        IntCounter<String> ranks;
                        if (dict.NE_signatures.containsKey(w1) && (ranks = Counters.toRankCounter(dict.NE_signatures.get(w1))).containsKey(w2) && ranks.getIntCount(w2) < highestRank) {
                            highestRank = ranks.getIntCount(w2);
                        }
                        if (!dict.NE_signatures.containsKey(w2) || !(reverseRanks = Counters.toRankCounter(dict.NE_signatures.get(w2))).containsKey(w1) || reverseRanks.getIntCount(w1) >= highestRank) continue;
                        highestRank = reverseRanks.getIntCount(w1);
                    }
                }
                if (highestRank > 10) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isContextOverlapping(Mention m1, Mention m2) {
        Set<String> context1 = Generics.newHashSet();
        Set<String> context2 = Generics.newHashSet();
        context1.addAll(m1.getContext());
        context2.addAll(m2.getContext());
        return Sets.intersects(context1, context2);
    }
}

