/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.ChineseQuantifiableEntityNormalizer;
import edu.stanford.nlp.ie.ClassifierCombiner;
import edu.stanford.nlp.ie.QuantifiableEntityNormalizer;
import edu.stanford.nlp.ie.regexp.ChineseNumberSequenceClassifier;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class NERClassifierCombiner
extends ClassifierCombiner<CoreLabel> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NERClassifierCombiner.class);
    private final boolean applyNumericClassifiers;
    public static final boolean APPLY_NUMERIC_CLASSIFIERS_DEFAULT = true;
    public static final String APPLY_NUMERIC_CLASSIFIERS_PROPERTY = "ner.applyNumericClassifiers";
    private static final String APPLY_NUMERIC_CLASSIFIERS_PROPERTY_BASE = "applyNumericClassifiers";
    private final Language nerLanguage;
    public static final Language NER_LANGUAGE_DEFAULT = Language.ENGLISH;
    public static final String NER_LANGUAGE_PROPERTY = "ner.language";
    public static final String NER_LANGUAGE_PROPERTY_BASE = "language";
    public static final String USE_PRESET_NER_PROPERTY = "ner.usePresetNERTags";
    private final boolean useSUTime;
    private final AbstractSequenceClassifier<CoreLabel> nsc;
    public static final Set<String> DEFAULT_PASS_DOWN_PROPERTIES = CollectionUtils.asSet("encoding", "inputEncoding", "outputEncoding", "maxAdditionalKnownLCWords", "map", "ner.combinationMode", "ner.usePresetNERTags");

    public NERClassifierCombiner(Properties props) throws IOException {
        super(props);
        this.applyNumericClassifiers = PropertiesUtils.getBool(props, APPLY_NUMERIC_CLASSIFIERS_PROPERTY, true);
        this.nerLanguage = Language.fromString(PropertiesUtils.getString(props, NER_LANGUAGE_PROPERTY, null), NER_LANGUAGE_DEFAULT);
        this.useSUTime = PropertiesUtils.getBool(props, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
        this.nsc = new NumberSequenceClassifier(new Properties(), this.useSUTime, props);
    }

    public NERClassifierCombiner(String ... loadPaths) throws IOException {
        this(true, NumberSequenceClassifier.USE_SUTIME_DEFAULT, loadPaths);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, boolean useSUTime, String ... loadPaths) throws IOException {
        super(loadPaths);
        this.applyNumericClassifiers = applyNumericClassifiers;
        this.nerLanguage = NER_LANGUAGE_DEFAULT;
        this.useSUTime = useSUTime;
        this.nsc = new NumberSequenceClassifier(useSUTime);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, Language nerLanguage, boolean useSUTime, Properties nscProps, String ... loadPaths) throws IOException {
        super(nscProps, ClassifierCombiner.extractCombinationModeSafe(nscProps), loadPaths);
        this.applyNumericClassifiers = applyNumericClassifiers;
        this.nerLanguage = nerLanguage;
        this.useSUTime = useSUTime;
        this.nsc = nerLanguage == Language.CHINESE ? new ChineseNumberSequenceClassifier(new Properties(), useSUTime, nscProps) : new NumberSequenceClassifier(new Properties(), useSUTime, nscProps);
    }

    @SafeVarargs
    public NERClassifierCombiner(AbstractSequenceClassifier<CoreLabel> ... classifiers) throws IOException {
        this(true, NumberSequenceClassifier.USE_SUTIME_DEFAULT, classifiers);
    }

    @SafeVarargs
    public NERClassifierCombiner(boolean applyNumericClassifiers, boolean useSUTime, AbstractSequenceClassifier<CoreLabel> ... classifiers) throws IOException {
        super(classifiers);
        this.applyNumericClassifiers = applyNumericClassifiers;
        this.nerLanguage = NER_LANGUAGE_DEFAULT;
        this.useSUTime = useSUTime;
        this.nsc = new NumberSequenceClassifier(useSUTime);
    }

    public NERClassifierCombiner(ObjectInputStream ois, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        super(ois, props);
        Boolean diskUseSUTime = ois.readBoolean();
        this.useSUTime = props.getProperty("ner.useSUTime") != null ? Boolean.parseBoolean(props.getProperty("ner.useSUTime")) : diskUseSUTime;
        Boolean diskApplyNumericClassifiers = ois.readBoolean();
        this.applyNumericClassifiers = props.getProperty(APPLY_NUMERIC_CLASSIFIERS_PROPERTY) != null ? Boolean.parseBoolean(props.getProperty(APPLY_NUMERIC_CLASSIFIERS_PROPERTY)) : diskApplyNumericClassifiers;
        this.nerLanguage = NER_LANGUAGE_DEFAULT;
        this.nsc = new NumberSequenceClassifier(new Properties(), this.useSUTime, props);
    }

    public static NERClassifierCombiner createNERClassifierCombiner(String name, Properties properties) {
        return NERClassifierCombiner.createNERClassifierCombiner(name, DEFAULT_PASS_DOWN_PROPERTIES, properties);
    }

    public static NERClassifierCombiner createNERClassifierCombiner(String name, Set<String> passDownProperties, Properties properties) {
        NERClassifierCombiner nerCombiner;
        String[] models;
        String prefix = name == null ? "ner." : (name.isEmpty() ? "" : name + '.');
        String modelNames = properties.getProperty(prefix + "model");
        if (modelNames == null) {
            modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
        }
        if (!modelNames.isEmpty()) {
            models = modelNames.split(",");
        } else {
            log.info("WARNING: no NER models specified");
            models = StringUtils.EMPTY_STRING_ARRAY;
        }
        try {
            Properties combinerProperties;
            boolean applyNumericClassifiers = PropertiesUtils.getBool(properties, prefix + APPLY_NUMERIC_CLASSIFIERS_PROPERTY_BASE, true);
            boolean useSUTime = PropertiesUtils.getBool(properties, prefix + "useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
            if (passDownProperties != null) {
                combinerProperties = PropertiesUtils.extractSelectedProperties(properties, passDownProperties);
                if (useSUTime) {
                    Properties sutimeProps = PropertiesUtils.extractPrefixedProperties(properties, "sutime.", true);
                    PropertiesUtils.overWriteProperties(combinerProperties, sutimeProps);
                }
            } else {
                combinerProperties = properties;
            }
            Language nerLanguage = Language.fromString(properties.getProperty(prefix + NER_LANGUAGE_PROPERTY_BASE), Language.ENGLISH);
            nerCombiner = new NERClassifierCombiner(applyNumericClassifiers, nerLanguage, useSUTime, combinerProperties, models);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return nerCombiner;
    }

    public boolean appliesNumericClassifiers() {
        return this.applyNumericClassifiers;
    }

    public boolean usesSUTime() {
        return this.useSUTime && this.applyNumericClassifiers;
    }

    private static <INN extends CoreMap> void copyAnswerFieldsToNERField(List<INN> l) {
        for (CoreMap m : l) {
            m.set(CoreAnnotations.NamedEntityTagAnnotation.class, (String)m.get(CoreAnnotations.AnswerAnnotation.class));
            Map<String, Double> labelToProb = Collections.singletonMap((String)m.get(CoreAnnotations.NamedEntityTagAnnotation.class), (Double)m.get(CoreAnnotations.AnswerProbAnnotation.class));
            m.set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, labelToProb);
        }
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> tokens) {
        return this.classifyWithGlobalInformation(tokens, (CoreMap)null, (CoreMap)null);
    }

    @Override
    public List<CoreLabel> classifyWithGlobalInformation(List<CoreLabel> tokens, CoreMap document, CoreMap sentence) {
        List<CoreLabel> output;
        block9: {
            output = super.classify(tokens);
            if (this.applyNumericClassifiers) {
                try {
                    this.recognizeNumberSequences(output, document, sentence);
                }
                catch (RuntimeInterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.info("Ignored an exception in NumberSequenceClassifier: (result is that some numbers were not classified)");
                    log.info("Tokens: " + StringUtils.joinWords(tokens, " "));
                    e.printStackTrace(System.err);
                }
                NERClassifierCombiner.copyAnswerFieldsToNERField(output);
                try {
                    if (this.nerLanguage == Language.CHINESE) {
                        ChineseQuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(output, document, sentence);
                        break block9;
                    }
                    QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(output, false, this.useSUTime);
                }
                catch (Exception e) {
                    log.info("Ignored an exception in QuantifiableEntityNormalizer: (result is that entities were not normalized)");
                    log.info("Tokens: " + StringUtils.joinWords(tokens, " "));
                    e.printStackTrace(System.err);
                }
                catch (AssertionError e) {
                    log.info("Ignored an assertion in QuantifiableEntityNormalizer: (result is that entities were not normalized)");
                    log.info("Tokens: " + StringUtils.joinWords(tokens, " "));
                    ((Throwable)((Object)e)).printStackTrace(System.err);
                }
            } else {
                NERClassifierCombiner.copyAnswerFieldsToNERField(output);
            }
        }
        return output;
    }

    private void recognizeNumberSequences(List<CoreLabel> words, CoreMap document, CoreMap sentence) {
        List<CoreLabel> newWords = NumberSequenceClassifier.copyTokens(words, sentence);
        this.nsc.classifyWithGlobalInformation(newWords, document, sentence);
        int sz = words.size();
        for (int i = 0; i < sz; ++i) {
            CoreLabel origWord = words.get(i);
            CoreLabel newWord = newWords.get(i);
            String before = (String)origWord.get(CoreAnnotations.AnswerAnnotation.class);
            String newGuess = (String)newWord.get(CoreAnnotations.AnswerAnnotation.class);
            if ((before == null || before.equals(this.nsc.flags.backgroundSymbol) || before.equals("MISC")) && !newGuess.equals(this.nsc.flags.backgroundSymbol)) {
                origWord.set(CoreAnnotations.AnswerAnnotation.class, newGuess);
            }
            NumberSequenceClassifier.transferAnnotations(newWord, origWord);
        }
    }

    public void finalizeAnnotation(Annotation annotation) {
        this.nsc.finalizeClassification(annotation);
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
        try {
            super.serializeClassifier(oos);
            oos.writeBoolean(this.useSUTime);
            oos.writeBoolean(this.applyNumericClassifiers);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static NERClassifierCombiner getClassifier(String loadPath, Properties props) throws IOException, ClassNotFoundException, ClassCastException {
        ObjectInputStream ois = IOUtils.readStreamFromString(loadPath);
        NERClassifierCombiner returnNCC = NERClassifierCombiner.getClassifier(ois, props);
        IOUtils.closeIgnoringExceptions(ois);
        return returnNCC;
    }

    public static NERClassifierCombiner getClassifier(ObjectInputStream ois, Properties props) throws IOException, ClassNotFoundException, ClassCastException {
        return new NERClassifierCombiner(ois, props);
    }

    public static void showNCCInfo(NERClassifierCombiner ncc) {
        log.info("");
        log.info("info for this NERClassifierCombiner: ");
        ClassifierCombiner.showCCInfo(ncc);
        log.info("useSUTime: " + ncc.useSUTime);
        log.info("applyNumericClassifier: " + ncc.applyNumericClassifiers);
        log.info("");
    }

    private static Map<String, String> readRegexnerGazette(String mappingFile) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        try (BufferedReader reader = IOUtils.readerFromString(mappingFile.trim());){
            for (String line : IOUtils.slurpReader(reader).split("\n")) {
                String[] fields = line.split("\t");
                String key = fields[0];
                String target = fields[1];
                mapping.put(key, target);
            }
        }
        catch (IOException e) {
            log.warn("Could not read Regex mapping: " + mappingFile);
        }
        return Collections.unmodifiableMap(mapping);
    }

    public static void main(String[] args) throws Exception {
        String showNCCInfo;
        String textFiles;
        String textFile;
        StringUtils.logInvocationString(log, args);
        Properties props = StringUtils.argsToProperties(args);
        SeqClassifierFlags flags = new SeqClassifierFlags(props, false);
        String loadPath = props.getProperty("loadClassifier");
        NERClassifierCombiner ncc = loadPath != null ? NERClassifierCombiner.getClassifier(loadPath, props) : NERClassifierCombiner.createNERClassifierCombiner("ner", null, props);
        String serializeTo = props.getProperty("serializeTo");
        if (serializeTo != null) {
            ncc.serializeClassifier(serializeTo);
        }
        if ((textFile = props.getProperty("textFile")) != null) {
            ncc.classifyAndWriteAnswers(textFile);
        }
        if ((textFiles = props.getProperty("textFiles")) != null) {
            ArrayList<File> files = new ArrayList<File>();
            for (String filename : textFiles.split(",")) {
                files.add(new File(filename));
            }
            ncc.classifyFilesAndWriteAnswers(files);
        }
        String testFile = props.getProperty("testFile");
        String testFiles = props.getProperty("testFiles");
        String crfToExamine = props.getProperty("crfToExamine");
        DocumentReaderAndWriter<CoreLabel> readerAndWriter = ncc.defaultReaderAndWriter();
        if (testFile != null || testFiles != null) {
            if (crfToExamine == null) {
                if (testFile != null) {
                    ncc.classifyAndWriteAnswers(testFile, readerAndWriter, true);
                } else {
                    List<File> files = Arrays.stream(testFiles.split(",")).map(File::new).collect(Collectors.toList());
                    ncc.classifyFilesAndWriteAnswers(files, ncc.defaultReaderAndWriter(), true);
                }
            } else {
                ClassifierCombiner.examineCRF(ncc, crfToExamine, flags, testFile, testFiles, readerAndWriter);
            }
        }
        if ((showNCCInfo = props.getProperty("showNCCInfo")) != null) {
            NERClassifierCombiner.showNCCInfo(ncc);
        }
        if (flags.readStdin) {
            ncc.classifyStdin();
        }
    }

    public static enum Language {
        ENGLISH("English"),
        CHINESE("Chinese");

        public String languageName;

        private Language(String name) {
            this.languageName = name;
        }

        public static Language fromString(String name, Language defaultValue) {
            if (name != null) {
                for (Language l : Language.values()) {
                    if (!name.equalsIgnoreCase(l.languageName)) continue;
                    return l;
                }
            }
            return defaultValue;
        }
    }
}

