/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.pascal.ISODateInstance;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.EditDistance;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuantifiableEntityNormalizer {
    private static final Redwood.RedwoodChannels log = Redwood.channels(QuantifiableEntityNormalizer.class);
    private static final boolean DEBUG = false;
    private static final boolean DEBUG2 = false;
    public static String BACKGROUND_SYMBOL = "O";
    private static final Pattern timePattern = Pattern.compile("([0-2]?[0-9])((?::[0-5][0-9]){0,2})([PpAa]\\.?[Mm]\\.?)?");
    private static final Pattern moneyPattern = Pattern.compile("([$\u00a3\u00a5\u20ac#]?)(-?[0-9,]*)(\\.[0-9]*)?+");
    private static final Pattern scorePattern = Pattern.compile(" *([0-9]+) *- *([0-9]+) *");
    private static final Set<String> quantifiable = Generics.newHashSet();
    private static final Set<String> collapseBeforeParsing;
    private static final Set<String> timeUnitWords;
    private static final Map<String, Double> moneyMultipliers;
    private static final Map<String, Integer> moneyMultipliers2;
    private static final Map<String, Character> currencyWords;
    public static final ClassicCounter<String> wordsToValues;
    public static final ClassicCounter<String> ordinalsToValues;
    private static final String dateRangeAfterOneWord = "after|since";
    private static final String dateRangeBeforeOneWord = "before|until";
    private static final List<Pair<String, String>> dateRangeBeforePairedOneWord;
    private static final String datePrepositionAfterWord = "in|of";
    private static final Pattern allSpaces;
    private static final Pattern numberPattern;
    private static final String lessEqualThreeWords = "no (?:more|greater|higher) than|as (?:many|much) as";
    private static final String greaterEqualThreeWords = "no (?:less|fewer) than|as few as";
    private static final String greaterThanTwoWords = "(?:more|greater|larger|higher) than";
    private static final String lessThanTwoWords = "(?:less|fewer|smaller) than|at most";
    private static final String lessEqualTwoWords = "no (?:more|greater)_than|or less|up to";
    private static final String greaterEqualTwoWords = "no (?:less|fewer)_than|or more|at least";
    private static final String approxTwoWords = "just (?:over|under)|or so";
    private static final String greaterThanOneWord = "(?:above|over|more_than|greater_than)";
    private static final String lessThanOneWord = "(?:below|under|less_than)";
    private static final String lessEqualOneWord = "(?:up_to|within)";
    private static final String approxOneWord = "(?:approximately|estimated|nearly|around|about|almost|just_over|just_under)";
    private static final String other = "other";
    private static final String earlyOneWord = "early";
    private static final String earlyTwoWords = "(?:dawn|eve|beginning) of";
    private static final String earlyThreeWords = "early in the";
    private static final String lateOneWord = "late";
    private static final String lateTwoWords = "late at|end of";
    private static final String lateThreeWords = "end of the";
    private static final String middleTwoWords = "(?:middle|midst) of";
    private static final String middleThreeWords = "(?:middle|midst) of the";
    private static final String amOneWord = "[Aa]\\.?[Mm]\\.?";
    private static final String pmOneWord = "[Pp]\\.?[Mm]\\.?";
    private static final String amThreeWords = "in the morning";
    private static final String pmTwoWords = "at night";
    private static final String pmThreeWords = "in the (?:afternoon|evening)";

    private QuantifiableEntityNormalizer() {
    }

    private static String getOneSubstitutionMatch(String word, Set<String> set) {
        EditDistance ed = new EditDistance();
        for (String cur : set) {
            if (!QuantifiableEntityNormalizer.isOneSubstitutionMatch(word, cur, ed)) continue;
            return cur;
        }
        return null;
    }

    private static boolean isOneSubstitutionMatch(String word, String match, EditDistance ed) {
        if (word.equalsIgnoreCase(match)) {
            return true;
        }
        return match.length() > 3 && ed.score(word, match) <= 1.0;
    }

    private static <E extends CoreMap> String singleEntityToString(List<E> l) {
        String entityType = (String)((CoreMap)l.get(0)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
        StringBuilder sb = new StringBuilder();
        for (CoreMap w : l) {
            assert (((String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals(entityType));
            sb.append((String)w.get(CoreAnnotations.TextAnnotation.class));
            sb.append(' ');
        }
        return sb.toString();
    }

    public static List<CoreLabel> collapseNERLabels(List<CoreLabel> l) {
        ArrayList<CoreLabel> s = new ArrayList<CoreLabel>();
        String lastEntity = BACKGROUND_SYMBOL;
        StringBuilder entityStringCollector = null;
        for (CoreLabel w : l) {
            String entityType = (String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (entityStringCollector != null && !entityType.equals(lastEntity)) {
                CoreLabel nextWord = new CoreLabel();
                nextWord.setWord(entityStringCollector.toString());
                nextWord.set(CoreAnnotations.PartOfSpeechAnnotation.class, "NNP");
                nextWord.set(CoreAnnotations.NamedEntityTagAnnotation.class, lastEntity);
                s.add(nextWord);
                entityStringCollector = null;
            }
            if (!collapseBeforeParsing.contains(entityType)) {
                s.add(w);
            } else if (entityType.equals(lastEntity)) {
                assert (entityStringCollector != null);
                entityStringCollector.append('_');
                entityStringCollector.append((String)w.get(CoreAnnotations.TextAnnotation.class));
            } else {
                entityStringCollector = new StringBuilder();
                entityStringCollector.append((String)w.get(CoreAnnotations.TextAnnotation.class));
            }
            lastEntity = entityType;
        }
        if (entityStringCollector != null) {
            CoreLabel nextWord = new CoreLabel();
            nextWord.setWord(entityStringCollector.toString());
            nextWord.set(CoreAnnotations.PartOfSpeechAnnotation.class, "NNP");
            nextWord.set(CoreAnnotations.NamedEntityTagAnnotation.class, lastEntity);
            s.add(nextWord);
        }
        for (CoreLabel w : s) {
            log.info("<<" + (String)w.get(CoreAnnotations.TextAnnotation.class) + "::" + (String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class) + "::" + (String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class) + ">>");
        }
        return s;
    }

    static String normalizedDateString(String s, Timex timexFromSUTime) {
        return QuantifiableEntityNormalizer.normalizedDateString(s, "", timexFromSUTime);
    }

    private static String normalizedDateString(String s, String openRangeMarker, Timex timexFromSUTime) {
        if (timexFromSUTime != null) {
            if (timexFromSUTime.value() != null) {
                return timexFromSUTime.value();
            }
            return timexFromSUTime.altVal();
        }
        ISODateInstance d = new ISODateInstance(s, openRangeMarker);
        return d.getDateString();
    }

    private static String normalizedDurationString(String s, Timex timexFromSUTime) {
        if (timexFromSUTime != null) {
            if (timexFromSUTime.value() != null) {
                return timexFromSUTime.value();
            }
            return timexFromSUTime.altVal();
        }
        return null;
    }

    private static boolean isYear(CoreMap word) {
        String wordString = (String)word.get(CoreAnnotations.TextAnnotation.class);
        if (word.get(CoreAnnotations.PartOfSpeechAnnotation.class) == null || ((String)word.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CD")) {
            if (wordString.length() == 3 && wordString.startsWith("'")) {
                wordString = wordString.substring(1);
                try {
                    Integer.parseInt(wordString);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (wordString.length() == 4) {
                try {
                    int num = Integer.parseInt(wordString);
                    if (num < 3000) {
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    private static <E extends CoreMap> String detectDateRangeModifier(List<E> date, List<E> list, int beforeIndex, int afterIndex) {
        CoreMap next3;
        CoreMap prev = beforeIndex >= 0 ? (CoreMap)list.get(beforeIndex) : null;
        int sz = list.size();
        CoreMap next = afterIndex < sz ? (CoreMap)list.get(afterIndex) : null;
        CoreMap next2 = afterIndex + 1 < sz ? (CoreMap)list.get(afterIndex + 1) : null;
        CoreMap coreMap = next3 = afterIndex + 2 < sz ? (CoreMap)list.get(afterIndex + 2) : null;
        if (next != null && QuantifiableEntityNormalizer.isYear(next)) {
            date.add(next);
            next.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DATE");
            ++afterIndex;
        }
        if (next2 != null && QuantifiableEntityNormalizer.isYear(next2)) {
            date.add(next);
            assert (next != null);
            next.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DATE");
            date.add(next2);
            next2.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DATE");
            afterIndex += 2;
        }
        if (next != null && ((String)next.get(CoreAnnotations.TextAnnotation.class)).matches(datePrepositionAfterWord) && next2 != null && QuantifiableEntityNormalizer.isYear(next2)) {
            date.add(next);
            date.add(next2);
            afterIndex += 2;
        }
        if (prev != null) {
            String prevWord = ((String)prev.get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
            if (prevWord.matches(dateRangeBeforeOneWord)) {
                prev.set(CoreAnnotations.PartOfSpeechAnnotation.class, "DATE_MOD");
                return "B";
            }
            if (prevWord.matches(dateRangeAfterOneWord)) {
                prev.set(CoreAnnotations.PartOfSpeechAnnotation.class, "DATE_MOD");
                return "A";
            }
        }
        return "";
    }

    private static <E extends CoreMap> String detectDateRangeModifier(E prev) {
        if (prev != null) {
            String prevWord = ((String)prev.get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
            if (prevWord.matches(dateRangeBeforeOneWord)) {
                return "B";
            }
            if (prevWord.matches(dateRangeAfterOneWord)) {
                return "A";
            }
        }
        return "";
    }

    private static <E extends CoreMap> List<E> detectTwoSidedRangeModifier(E firstDate, List<E> list, int beforeIndex, int afterIndex, boolean concatenate) {
        String curNER;
        CoreMap prev = beforeIndex >= 0 ? (CoreMap)list.get(beforeIndex) : null;
        int sz = list.size();
        CoreMap next = afterIndex < sz ? (CoreMap)list.get(afterIndex) : null;
        CoreMap next2 = afterIndex + 1 < sz ? (CoreMap)list.get(afterIndex + 1) : null;
        ArrayList toRemove = new ArrayList();
        String string = curNER = firstDate == null ? "" : (String)firstDate.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        if (curNER == null) {
            curNER = "";
        }
        if (firstDate == null || firstDate.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class) == null) {
            return toRemove;
        }
        if (prev != null) {
            for (Pair<String, String> ranges : dateRangeBeforePairedOneWord) {
                String rangeString;
                if (!((String)prev.get(CoreAnnotations.TextAnnotation.class)).matches(ranges.first()) || next == null || next2 == null) continue;
                String nerNext2 = (String)next2.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                if (!((String)next.get(CoreAnnotations.TextAnnotation.class)).matches(ranges.second()) || nerNext2 == null || !nerNext2.equals(curNER)) continue;
                prev.set(CoreAnnotations.PartOfSpeechAnnotation.class, "QUANT_MOD");
                if (curNER.equals("DATE")) {
                    ISODateInstance c = new ISODateInstance(new ISODateInstance((String)firstDate.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class)), new ISODateInstance((String)next2.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class)));
                    rangeString = c.getDateString();
                } else {
                    rangeString = (String)firstDate.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class) + '-' + (String)next2.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                }
                firstDate.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, (String)rangeString);
                next2.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, rangeString);
                next.set(CoreAnnotations.NamedEntityTagAnnotation.class, nerNext2);
                next.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, rangeString);
                if (!concatenate) continue;
                ArrayList<CoreMap> numberWords = new ArrayList<CoreMap>();
                numberWords.add(firstDate);
                numberWords.add(next);
                numberWords.add(next2);
                QuantifiableEntityNormalizer.concatenateNumericString(numberWords, toRemove);
            }
        }
        return toRemove;
    }

    private static <E extends CoreMap> void concatenateNumericString(List<E> words, List<E> toRemove) {
        if (words.size() <= 1) {
            return;
        }
        boolean first = true;
        StringBuilder newText = new StringBuilder();
        CoreMap foundEntity = null;
        for (CoreMap word : words) {
            if (foundEntity == null && (((String)word.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CD") || ((String)word.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("NNP"))) {
                foundEntity = word;
            }
            if (first) {
                first = false;
            } else {
                newText.append('_');
            }
            newText.append((String)word.get(CoreAnnotations.TextAnnotation.class));
        }
        if (foundEntity == null) {
            foundEntity = (CoreMap)words.get(0);
        }
        toRemove.addAll(words);
        toRemove.remove(foundEntity);
        foundEntity.set(CoreAnnotations.PartOfSpeechAnnotation.class, "CD");
        String collapsed = newText.toString();
        foundEntity.set(CoreAnnotations.TextAnnotation.class, collapsed);
        foundEntity.set(CoreAnnotations.OriginalTextAnnotation.class, collapsed);
    }

    public static String normalizedTimeString(String s, Timex timexFromSUTime) {
        return QuantifiableEntityNormalizer.normalizedTimeString(s, null, timexFromSUTime);
    }

    private static String normalizedTimeString(String s, String ampm, Timex timexFromSUTime) {
        if (timexFromSUTime != null) {
            if (timexFromSUTime.value() != null) {
                return timexFromSUTime.value();
            }
            return timexFromSUTime.altVal();
        }
        s = s.replaceAll("[ \t\n\u0000\f\r]", "");
        Matcher m = timePattern.matcher(s);
        if (s.equalsIgnoreCase("noon")) {
            return "12:00pm";
        }
        if (s.equalsIgnoreCase("midnight")) {
            return "00:00am";
        }
        if (s.equalsIgnoreCase("morning")) {
            return "M";
        }
        if (s.equalsIgnoreCase("afternoon")) {
            return "A";
        }
        if (s.equalsIgnoreCase("evening")) {
            return "EN";
        }
        if (s.equalsIgnoreCase("night")) {
            return "N";
        }
        if (s.equalsIgnoreCase("day")) {
            return "D";
        }
        if (s.equalsIgnoreCase("suppertime")) {
            return "EN";
        }
        if (s.equalsIgnoreCase("lunchtime")) {
            return "MD";
        }
        if (s.equalsIgnoreCase("midday")) {
            return "MD";
        }
        if (s.equalsIgnoreCase("teatime")) {
            return "A";
        }
        if (s.equalsIgnoreCase("dinnertime")) {
            return "EN";
        }
        if (s.equalsIgnoreCase("dawn")) {
            return "EM";
        }
        if (s.equalsIgnoreCase("dusk")) {
            return "EN";
        }
        if (s.equalsIgnoreCase("sundown")) {
            return "EN";
        }
        if (s.equalsIgnoreCase("sunup")) {
            return "EM";
        }
        if (s.equalsIgnoreCase("daybreak")) {
            return "EM";
        }
        if (m.matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(m.group(1));
            if (m.group(2) == null || "".equals(m.group(2))) {
                sb.append(":00");
            } else {
                sb.append(m.group(2));
            }
            if (m.group(3) != null) {
                String suffix = m.group(3);
                suffix = suffix.replaceAll("\\.", "");
                suffix = suffix.toLowerCase();
                sb.append(suffix);
            } else if (ampm != null) {
                sb.append(ampm);
            }
            return sb.toString();
        }
        return null;
    }

    private static String convertToAmerican(String s) {
        if (s.contains(",")) {
            while (s.indexOf(44) != s.lastIndexOf(44)) {
                s = s.replaceFirst(",", "");
            }
            int place = s.lastIndexOf(44);
            s = place >= s.length() - 3 && place != s.length() - 1 ? s.substring(0, place) + '.' + s.substring(place + 1) : s.replace(",", "");
        }
        return s;
    }

    static String normalizedMoneyString(String s, Number numberFromSUTime) {
        s = QuantifiableEntityNormalizer.convertToAmerican(s);
        s = s.replaceAll("[ \t\n\u0000\f\r,]", "");
        s = s.toLowerCase();
        double multiplier = 1.0;
        char currencySign = '$';
        for (Map.Entry<String, Character> stringCharacterEntry : currencyWords.entrySet()) {
            String key = stringCharacterEntry.getKey();
            if (!StringUtils.find(s, key)) continue;
            if (key.equals("pence|penny") || key.equals("cents?") || key.equals("\u00a2")) {
                multiplier *= 0.01;
            }
            s = s.replaceAll(key, "");
            currencySign = stringCharacterEntry.getValue().charValue();
        }
        String value = QuantifiableEntityNormalizer.normalizedNumberStringQuiet(s, multiplier, "", numberFromSUTime);
        if (value == null) {
            return null;
        }
        return currencySign + value;
    }

    public static String normalizedNumberString(String s, String nextWord, Number numberFromSUTime) {
        return QuantifiableEntityNormalizer.normalizedNumberStringQuiet(s, 1.0, nextWord, numberFromSUTime);
    }

    public static String normalizedNumberStringQuiet(String s, double multiplier, String nextWord, Number numberFromSUTime) {
        Matcher m;
        boolean bl;
        if (numberFromSUTime != null) {
            double v = Double.valueOf(numberFromSUTime.toString());
            return Double.toString(v * multiplier);
        }
        String origSClean = s.replaceAll("[\t\n\u0000\f\r]", "");
        if (allSpaces.matcher(origSClean).matches()) {
            return s;
        }
        String[] origSSplit = origSClean.split(" ");
        s = s.replaceAll("[ \t\n\u0000\f\r]", "");
        if ((s = QuantifiableEntityNormalizer.convertToAmerican(s)).startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        s = s.toLowerCase();
        boolean foundMultiplier = false;
        for (Map.Entry<String, Double> entry : moneyMultipliers.entrySet()) {
            String string = entry.getKey();
            if (!s.contains(string) || string.equals("m") && (nextWord.equals("high") || nextWord.equals("long"))) continue;
            s = s.replaceAll(string, "");
            multiplier *= entry.getValue().doubleValue();
            foundMultiplier = true;
        }
        for (Map.Entry<String, Number> entry : moneyMultipliers2.entrySet()) {
            String string = entry.getKey();
            Matcher m2 = Pattern.compile(string).matcher(s);
            if (!m2.find()) continue;
            multiplier *= (double)((Integer)entry.getValue()).intValue();
            foundMultiplier = true;
            int start = m2.start(1);
            int end = m2.end(1);
            s = s.substring(0, start) + s.substring(end);
        }
        if (!foundMultiplier) {
            EditDistance ed = new EditDistance();
            for (Map.Entry<String, Double> entry : moneyMultipliers.entrySet()) {
                String moneyTag2 = entry.getKey();
                if (!QuantifiableEntityNormalizer.isOneSubstitutionMatch(origSSplit[origSSplit.length - 1], moneyTag2, ed)) continue;
                s = s.replaceAll(moneyTag2, "");
                multiplier *= entry.getValue().doubleValue();
            }
        }
        String[] parts = s.split("[ -]");
        boolean bl2 = false;
        double d = 0.0;
        for (String part : parts) {
            if (wordsToValues.containsKey(part)) {
                d += wordsToValues.getCount(part);
                bl = true;
                continue;
            }
            String partMatch = QuantifiableEntityNormalizer.getOneSubstitutionMatch(part, wordsToValues.keySet());
            if (partMatch == null) continue;
            d += wordsToValues.getCount(partMatch);
            bl = true;
        }
        if (bl) {
            return Double.toString(d *= multiplier);
        }
        Matcher m2 = scorePattern.matcher(s = s.replaceAll("[A-Za-z]", ""));
        if (m2.matches()) {
            double d1 = Double.parseDouble(m2.group(1));
            double d2 = Double.parseDouble(m2.group(2));
            return Double.toString(d1) + " - " + Double.toString(d2);
        }
        if (s.endsWith("-")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((m = moneyPattern.matcher(s)).matches()) {
            try {
                double d2 = 0.0;
                if (m.group(2) != null && !m.group(2).isEmpty()) {
                    d2 = Double.parseDouble(m.group(2));
                }
                if (m.group(3) != null && !m.group(3).isEmpty()) {
                    d2 += Double.parseDouble(m.group(3));
                }
                if (d2 == 0.0 && multiplier != 1.0) {
                    d2 = 1.0;
                }
                return Double.toString(d2 *= multiplier);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (multiplier != 1.0) {
            return Double.toString(multiplier);
        }
        return null;
    }

    public static String normalizedOrdinalString(String s, Number numberFromSUTime) {
        return QuantifiableEntityNormalizer.normalizedOrdinalStringQuiet(s, numberFromSUTime);
    }

    private static String normalizedOrdinalStringQuiet(String s, Number numberFromSUTime) {
        if ((s = s.replaceAll("[ \t\n\u0000\f\r,]", "")).startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        if (Character.isDigit((s = s.toLowerCase()).charAt(0))) {
            Matcher matcher = numberPattern.matcher(s);
            matcher.find();
            return QuantifiableEntityNormalizer.normalizedNumberStringQuiet(matcher.group(), 1.0, "", numberFromSUTime);
        }
        if (ordinalsToValues.containsKey(s)) {
            return Double.toString(ordinalsToValues.getCount(s));
        }
        String val = QuantifiableEntityNormalizer.getOneSubstitutionMatch(s, ordinalsToValues.keySet());
        if (val != null) {
            return Double.toString(ordinalsToValues.getCount(val));
        }
        return null;
    }

    public static String normalizedPercentString(String s, Number numberFromSUTime) {
        String norm;
        s = s.replaceAll("\\s", "");
        if ((s = s.toLowerCase()).contains("%") || s.contains("percent")) {
            s = s.replaceAll("percent|%", "");
        }
        if ((norm = QuantifiableEntityNormalizer.normalizedNumberStringQuiet(s, 1.0, "", numberFromSUTime)) == null) {
            return null;
        }
        return '%' + norm;
    }

    private static <E extends CoreMap> Number fetchNumberFromSUTime(List<E> l) {
        for (CoreMap e : l) {
            if (!e.containsKey(CoreAnnotations.NumericCompositeValueAnnotation.class)) continue;
            return (Number)e.get(CoreAnnotations.NumericCompositeValueAnnotation.class);
        }
        return null;
    }

    private static <E extends CoreMap> Timex fetchTimexFromSUTime(List<E> l) {
        for (CoreMap e : l) {
            if (!e.containsKey(TimeAnnotations.TimexAnnotation.class)) continue;
            return (Timex)e.get(TimeAnnotations.TimexAnnotation.class);
        }
        return null;
    }

    private static <E extends CoreMap> List<E> processEntity(List<E> l, String entityType, String compModifier, String nextWord) {
        assert (quantifiable.contains(entityType));
        String s = entityType.equals("TIME") ? QuantifiableEntityNormalizer.timeEntityToString(l) : QuantifiableEntityNormalizer.singleEntityToString(l);
        Number numberFromSUTime = QuantifiableEntityNormalizer.fetchNumberFromSUTime(l);
        Timex timexFromSUTime = QuantifiableEntityNormalizer.fetchTimexFromSUTime(l);
        String p = null;
        switch (entityType) {
            case "NUMBER": {
                String q;
                p = "";
                if (compModifier != null) {
                    p = compModifier;
                }
                if ((q = QuantifiableEntityNormalizer.normalizedNumberString(s, nextWord, numberFromSUTime)) != null) {
                    p = p.concat(q);
                    break;
                }
                p = null;
                break;
            }
            case "ORDINAL": {
                p = QuantifiableEntityNormalizer.normalizedOrdinalString(s, numberFromSUTime);
                break;
            }
            case "DURATION": {
                p = QuantifiableEntityNormalizer.normalizedDurationString(s, timexFromSUTime);
                break;
            }
            case "MONEY": {
                String q;
                p = "";
                if (compModifier != null) {
                    p = compModifier;
                }
                if ((q = QuantifiableEntityNormalizer.normalizedMoneyString(s, numberFromSUTime)) != null) {
                    p = p.concat(q);
                    break;
                }
                p = null;
                break;
            }
            case "DATE": {
                p = QuantifiableEntityNormalizer.normalizedDateString(s, timexFromSUTime);
                break;
            }
            case "TIME": {
                String q;
                p = "";
                if (compModifier != null && !compModifier.matches("am|pm")) {
                    p = compModifier;
                }
                if ((q = QuantifiableEntityNormalizer.normalizedTimeString(s, compModifier != null ? compModifier : "", timexFromSUTime)) != null && q.length() == 1 && !q.equals("D")) {
                    p = p.concat(q);
                    break;
                }
                p = q;
                break;
            }
            case "PERCENT": {
                String q;
                p = "";
                if (compModifier != null) {
                    p = compModifier;
                }
                if ((q = QuantifiableEntityNormalizer.normalizedPercentString(s, numberFromSUTime)) != null) {
                    p = p.concat(q);
                    break;
                }
                p = null;
                break;
            }
        }
        int i = 0;
        for (CoreMap wi : l) {
            if (p != null) {
                wi.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, p);
            }
            ++i;
        }
        return l;
    }

    private static <E extends CoreMap> String timeEntityToString(List<E> l) {
        String entityType = (String)((CoreMap)l.get(0)).get(CoreAnnotations.AnswerAnnotation.class);
        int size = l.size();
        for (CoreMap w : l) {
            assert (w.get(CoreAnnotations.AnswerAnnotation.class) == null || ((String)w.get(CoreAnnotations.AnswerAnnotation.class)).equals(entityType));
            Matcher m = timePattern.matcher((CharSequence)w.get(CoreAnnotations.TextAnnotation.class));
            if (!m.matches()) continue;
            return (String)w.get(CoreAnnotations.TextAnnotation.class);
        }
        return (String)((CoreMap)l.get(size - 1)).get(CoreAnnotations.TextAnnotation.class);
    }

    public static List<List<CoreLabel>> normalizeClassifierOutput(List<List<CoreLabel>> l) {
        for (List<CoreLabel> doc : l) {
            QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(doc);
        }
        return l;
    }

    private static <E extends CoreMap> String detectQuantityModifier(List<E> list, int beforeIndex, int afterIndex) {
        String prev = beforeIndex >= 0 ? ((String)((CoreMap)list.get(beforeIndex)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String prev2 = beforeIndex - 1 >= 0 ? ((String)((CoreMap)list.get(beforeIndex - 1)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String prev3 = beforeIndex - 2 >= 0 ? ((String)((CoreMap)list.get(beforeIndex - 2)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        int sz = list.size();
        String next = afterIndex < sz ? ((String)((CoreMap)list.get(afterIndex)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String next2 = afterIndex + 1 < sz ? ((String)((CoreMap)list.get(afterIndex + 1)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String next3 = afterIndex + 2 < sz ? ((String)((CoreMap)list.get(afterIndex + 2)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String longPrev = prev3 + ' ' + prev2 + ' ' + prev;
        if (longPrev.matches(lessEqualThreeWords)) {
            return "<=";
        }
        if (longPrev.matches(greaterEqualThreeWords)) {
            return ">=";
        }
        longPrev = prev2 + ' ' + prev;
        if (longPrev.matches(greaterThanTwoWords)) {
            return ">";
        }
        if (longPrev.matches(lessEqualTwoWords)) {
            return "<=";
        }
        if (longPrev.matches(greaterEqualTwoWords)) {
            return ">=";
        }
        if (longPrev.matches(lessThanTwoWords)) {
            return "<";
        }
        if (longPrev.matches(approxTwoWords)) {
            return "~";
        }
        String longNext = next + ' ' + next2;
        if (longNext.matches(greaterEqualTwoWords)) {
            return ">=";
        }
        if (longNext.matches(lessEqualTwoWords)) {
            return "<=";
        }
        if (prev.matches(greaterThanOneWord)) {
            return ">";
        }
        if (prev.matches(lessThanOneWord)) {
            return "<";
        }
        if (prev.matches(lessEqualOneWord)) {
            return "<=";
        }
        if (prev.matches(approxOneWord)) {
            return "~";
        }
        if (next.matches(other)) {
            return ">=";
        }
        return null;
    }

    private static <E extends CoreMap> String detectTimeOfDayModifier(List<E> list, int beforeIndex, int afterIndex) {
        String prev = beforeIndex >= 0 ? ((String)((CoreMap)list.get(beforeIndex)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String prev2 = beforeIndex - 1 >= 0 ? ((String)((CoreMap)list.get(beforeIndex - 1)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String prev3 = beforeIndex - 2 >= 0 ? ((String)((CoreMap)list.get(beforeIndex - 2)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        int sz = list.size();
        String next = afterIndex < sz ? ((String)((CoreMap)list.get(afterIndex)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String next2 = afterIndex + 1 < sz ? ((String)((CoreMap)list.get(afterIndex + 1)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String next3 = afterIndex + 2 < sz ? ((String)((CoreMap)list.get(afterIndex + 2)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase() : "";
        String longPrev = prev3 + ' ' + prev2 + ' ' + prev;
        if (longPrev.matches(earlyThreeWords)) {
            return "E";
        }
        if (longPrev.matches(lateThreeWords)) {
            return "L";
        }
        if (longPrev.matches(middleThreeWords)) {
            return "M";
        }
        longPrev = prev2 + ' ' + prev;
        if (longPrev.matches(earlyTwoWords)) {
            return "E";
        }
        if (longPrev.matches(lateTwoWords)) {
            return "L";
        }
        if (longPrev.matches(middleTwoWords)) {
            return "M";
        }
        if (prev.matches(earlyOneWord) || prev2.matches(earlyOneWord)) {
            return "E";
        }
        if (prev.matches(lateOneWord) || prev2.matches(lateOneWord)) {
            return "L";
        }
        String longNext = next3 + ' ' + next2 + ' ' + next;
        if (longNext.matches(pmThreeWords)) {
            return "pm";
        }
        if (longNext.matches(amThreeWords)) {
            return "am";
        }
        longNext = next2 + ' ' + next;
        if (longNext.matches(pmTwoWords)) {
            return "pm";
        }
        if (next.matches(amOneWord) || next2.matches("morning") || next3.matches("morning")) {
            return "am";
        }
        if (next.matches(pmOneWord) || next2.matches("afternoon") || next3.matches("afternoon") || next2.matches("night") || next3.matches("night") || next2.matches("evening") || next3.matches("evening")) {
            return "pm";
        }
        return "";
    }

    public static <E extends CoreMap> void addNormalizedQuantitiesToEntities(List<E> l) {
        QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(l, false, false);
    }

    public static <E extends CoreMap> void addNormalizedQuantitiesToEntities(List<E> l, boolean concatenate) {
        QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(l, concatenate, false);
    }

    public static <E extends CoreMap> boolean isCompatible(String tag, E prev, E cur) {
        Timex timex2;
        String tid2;
        Timex timex1;
        String tid1;
        boolean compatible;
        if ("NUMBER".equals(tag) || "ORDINAL".equals(tag) || "PERCENT".equals(tag)) {
            Number n1 = (Number)cur.get(CoreAnnotations.NumericCompositeValueAnnotation.class);
            Number n2 = (Number)prev.get(CoreAnnotations.NumericCompositeValueAnnotation.class);
            if ("PERCENT".equals(tag) && n1 == null) {
                return true;
            }
            boolean compatible2 = Objects.equals(n1, n2);
            if (!compatible2) {
                return false;
            }
        }
        return !"TIME".equals(tag) && !"SET".equals(tag) && !"DATE".equals(tag) && !"DURATION".equals(tag) || (compatible = Objects.equals(tid1 = (timex1 = (Timex)cur.get(TimeAnnotations.TimexAnnotation.class)) != null ? timex1.tid() : null, tid2 = (timex2 = (Timex)prev.get(TimeAnnotations.TimexAnnotation.class)) != null ? timex2.tid() : null));
    }

    public static <E extends CoreMap> void addNormalizedQuantitiesToEntities(List<E> list, boolean concatenate, boolean usesSUTime) {
        ArrayList toRemove = new ArrayList();
        QuantifiableEntityNormalizer.fixupNerBeforeNormalization(list);
        String prevNerTag = BACKGROUND_SYMBOL;
        String timeModifier = "";
        int beforeIndex = -1;
        ArrayList<CoreMap> collector = new ArrayList<CoreMap>();
        int sz = list.size();
        for (int i = 0; i <= sz; ++i) {
            CoreMap wprev;
            CoreMap wi = null;
            String currNerTag = null;
            String nextWord = "";
            if (i < list.size()) {
                wi = (CoreMap)list.get(i);
                if (i + 1 < sz && (nextWord = (String)((CoreMap)list.get(i + 1)).get(CoreAnnotations.TextAnnotation.class)) == null) {
                    nextWord = "";
                }
                if ("TIME".equals(currNerTag = (String)wi.get(CoreAnnotations.NamedEntityTagAnnotation.class)) && timeModifier.isEmpty()) {
                    timeModifier = QuantifiableEntityNormalizer.detectTimeOfDayModifier(list, i - 1, i + 1);
                }
            }
            CoreMap coreMap = wprev = i > 0 ? (CoreMap)list.get(i - 1) : null;
            if (!(currNerTag != null && currNerTag.equals(prevNerTag) && QuantifiableEntityNormalizer.isCompatible(prevNerTag, wprev, wi) || !quantifiable.contains(prevNerTag))) {
                String compModifier = null;
                switch (prevNerTag) {
                    case "TIME": {
                        QuantifiableEntityNormalizer.processEntity(collector, prevNerTag, timeModifier, nextWord);
                        break;
                    }
                    case "DATE": {
                        CoreMap prev = beforeIndex >= 0 ? (CoreMap)list.get(beforeIndex) : null;
                        compModifier = usesSUTime ? QuantifiableEntityNormalizer.detectDateRangeModifier(prev) : QuantifiableEntityNormalizer.detectDateRangeModifier(collector, list, beforeIndex, i);
                        if (!compModifier.equals("C")) {
                            QuantifiableEntityNormalizer.processEntity(collector, prevNerTag, compModifier, nextWord);
                        }
                        if (!concatenate) break;
                        QuantifiableEntityNormalizer.concatenateNumericString(collector, toRemove);
                        break;
                    }
                    default: {
                        if (prevNerTag.equals("MONEY") || prevNerTag.equals("NUMBER") || prevNerTag.equals("PERCENT")) {
                            compModifier = QuantifiableEntityNormalizer.detectQuantityModifier(list, beforeIndex, i);
                        }
                        QuantifiableEntityNormalizer.processEntity(collector, prevNerTag, compModifier, nextWord);
                        if (!concatenate) break;
                        QuantifiableEntityNormalizer.concatenateNumericString(collector, toRemove);
                    }
                }
                collector = new ArrayList();
                timeModifier = "";
            }
            if (quantifiable.contains(currNerTag)) {
                if (collector.isEmpty()) {
                    beforeIndex = i - 1;
                }
                collector.add(wi);
            }
            prevNerTag = currNerTag;
        }
        if (concatenate) {
            list.removeAll(toRemove);
        }
        ArrayList<CoreMap> moreRemoves = new ArrayList<CoreMap>();
        int sz2 = list.size();
        for (int i = 0; i < sz2; ++i) {
            CoreMap wi = (CoreMap)list.get(i);
            moreRemoves.addAll(QuantifiableEntityNormalizer.detectTwoSidedRangeModifier(wi, list, i - 1, i + 1, concatenate));
        }
        if (concatenate) {
            list.removeAll(moreRemoves);
        }
    }

    private static <E extends CoreMap> void fixupNerBeforeNormalization(List<E> list) {
        String prevNerTag = BACKGROUND_SYMBOL;
        String prevNumericType = null;
        Timex prevTimex = null;
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            CoreMap wi = (CoreMap)list.get(i);
            Timex timex = (Timex)wi.get(TimeAnnotations.TimexAnnotation.class);
            String numericType = (String)wi.get(CoreAnnotations.NumericCompositeTypeAnnotation.class);
            String curWord = wi.get(CoreAnnotations.TextAnnotation.class) != null ? (String)wi.get(CoreAnnotations.TextAnnotation.class) : "";
            String currNerTag = (String)wi.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (timex == null && numericType == null) {
                String[] sides;
                CoreMap nextToken;
                String nextNER;
                if (i + 1 < sz && ",".equals(wi.get(CoreAnnotations.TextAnnotation.class)) && "DATE".equals(prevNerTag) && prevTimex == null && prevNumericType == null && (nextNER = (String)(nextToken = (CoreMap)list.get(i + 1)).get(CoreAnnotations.NamedEntityTagAnnotation.class)) != null && nextNER.equals("DATE")) {
                    wi.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DATE");
                }
                if (!curWord.isEmpty() && (moneyMultipliers.containsKey(curWord) || QuantifiableEntityNormalizer.getOneSubstitutionMatch(curWord, moneyMultipliers.keySet()) != null) && prevNerTag != null && (prevNerTag.equals("MONEY") || prevNerTag.equals("NUMBER"))) {
                    wi.set(CoreAnnotations.NamedEntityTagAnnotation.class, prevNerTag);
                }
                if (curWord.contains("-") && (sides = curWord.split("-")).length == 2) {
                    try {
                        int first = Integer.parseInt(sides[0]);
                        int second = Integer.parseInt(sides[1]);
                        if (1000 <= first && first <= 3000 && 1000 <= second && second <= 3000) {
                            wi.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DATE");
                            String dateStr = new ISODateInstance(new ISODateInstance(sides[0]), new ISODateInstance(sides[1])).getDateString();
                            wi.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, dateStr);
                            continue;
                        }
                    }
                    catch (Exception first) {
                        // empty catch block
                    }
                }
                if (timeUnitWords.contains(curWord) && (currNerTag == null || !"DURATION".equals(currNerTag)) && "NUMBER".equals(prevNerTag)) {
                    wi.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DURATION");
                    for (int j = i - 1; j > 0; --j) {
                        CoreMap prev = (CoreMap)list.get(j);
                        if (!"NUMBER".equals(prev.get(CoreAnnotations.NamedEntityTagAnnotation.class))) continue;
                        prev.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DURATION");
                    }
                }
            } else if ("DURATION".equals(currNerTag) && ordinalsToValues.containsKey(curWord) && curWord.endsWith("second") && timex.text().equals(curWord)) {
                wi.set(CoreAnnotations.NamedEntityTagAnnotation.class, "ORDINAL");
            }
            prevNerTag = currNerTag;
            prevNumericType = numericType;
            prevTimex = timex;
        }
    }

    public static <E extends CoreLabel> List<E> applySpecializedNER(List<E> l) {
        int sz = l.size();
        List copyL = new ArrayList<CoreLabel>(sz);
        for (int i = 0; i < sz; ++i) {
            copyL.add(new CoreLabel((CoreLabel)l.get(i)));
        }
        NumberSequenceClassifier nsc = new NumberSequenceClassifier();
        copyL = ((AbstractSequenceClassifier)nsc).classify(copyL);
        for (int i = 0; i < sz; ++i) {
            CoreLabel before = (CoreLabel)l.get(i);
            CoreLabel nscAnswer = (CoreLabel)copyL.get(i);
            if (before.get(CoreAnnotations.NamedEntityTagAnnotation.class) != null || !((String)before.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals(BACKGROUND_SYMBOL) || nscAnswer.get(CoreAnnotations.AnswerAnnotation.class) == null || ((String)nscAnswer.get(CoreAnnotations.AnswerAnnotation.class)).equals(BACKGROUND_SYMBOL)) continue;
            log.info("Quantifiable: updating class for " + (String)before.get(CoreAnnotations.TextAnnotation.class) + '/' + (String)before.get(CoreAnnotations.NamedEntityTagAnnotation.class) + " to " + (String)nscAnswer.get(CoreAnnotations.AnswerAnnotation.class));
            before.set(CoreAnnotations.NamedEntityTagAnnotation.class, (String)nscAnswer.get(CoreAnnotations.AnswerAnnotation.class));
        }
        QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(l);
        return l;
    }

    static {
        quantifiable.add("MONEY");
        quantifiable.add("TIME");
        quantifiable.add("DATE");
        quantifiable.add("PERCENT");
        quantifiable.add("NUMBER");
        quantifiable.add("ORDINAL");
        quantifiable.add("DURATION");
        collapseBeforeParsing = Generics.newHashSet();
        collapseBeforeParsing.add("PERSON");
        collapseBeforeParsing.add("ORGANIZATION");
        collapseBeforeParsing.add("LOCATION");
        timeUnitWords = Generics.newHashSet();
        timeUnitWords.add("second");
        timeUnitWords.add("seconds");
        timeUnitWords.add("minute");
        timeUnitWords.add("minutes");
        timeUnitWords.add("hour");
        timeUnitWords.add("hours");
        timeUnitWords.add("day");
        timeUnitWords.add("days");
        timeUnitWords.add("week");
        timeUnitWords.add("weeks");
        timeUnitWords.add("month");
        timeUnitWords.add("months");
        timeUnitWords.add("year");
        timeUnitWords.add("years");
        currencyWords = Generics.newHashMap();
        currencyWords.put("dollars?", Character.valueOf('$'));
        currencyWords.put("cents?", Character.valueOf('$'));
        currencyWords.put("pounds?", Character.valueOf('\u00a3'));
        currencyWords.put("pence|penny", Character.valueOf('\u00a3'));
        currencyWords.put("yen", Character.valueOf('\u00a5'));
        currencyWords.put("euros?", Character.valueOf('\u20ac'));
        currencyWords.put("won", Character.valueOf('\u20a9'));
        currencyWords.put("\\$", Character.valueOf('$'));
        currencyWords.put("\u00a2", Character.valueOf('$'));
        currencyWords.put("\u00a3", Character.valueOf('\u00a3'));
        currencyWords.put("#", Character.valueOf('\u00a3'));
        currencyWords.put("\u00a5", Character.valueOf('\u00a5'));
        currencyWords.put("\u20ac", Character.valueOf('\u20ac'));
        currencyWords.put("\u20a9", Character.valueOf('\u20a9'));
        currencyWords.put("yuan", Character.valueOf('\u5143'));
        moneyMultipliers = Generics.newHashMap();
        moneyMultipliers.put("trillion", 1.0E12);
        moneyMultipliers.put("billion", 1.0E9);
        moneyMultipliers.put("bn", 1.0E9);
        moneyMultipliers.put("million", 1000000.0);
        moneyMultipliers.put("thousand", 1000.0);
        moneyMultipliers.put("hundred", 100.0);
        moneyMultipliers.put("b.", 1.0E9);
        moneyMultipliers.put("m.", 1000000.0);
        moneyMultipliers.put(" m ", 1000000.0);
        moneyMultipliers.put(" k ", 1000.0);
        moneyMultipliers2 = Generics.newHashMap();
        moneyMultipliers2.put("[0-9](m)(?:[^a-zA-Z]|$)", 1000000);
        moneyMultipliers2.put("[0-9](b)(?:[^a-zA-Z]|$)", 1000000000);
        wordsToValues = new ClassicCounter();
        wordsToValues.setCount("zero", 0.0);
        wordsToValues.setCount("one", 1.0);
        wordsToValues.setCount("two", 2.0);
        wordsToValues.setCount("three", 3.0);
        wordsToValues.setCount("four", 4.0);
        wordsToValues.setCount("five", 5.0);
        wordsToValues.setCount("six", 6.0);
        wordsToValues.setCount("seven", 7.0);
        wordsToValues.setCount("eight", 8.0);
        wordsToValues.setCount("nine", 9.0);
        wordsToValues.setCount("ten", 10.0);
        wordsToValues.setCount("eleven", 11.0);
        wordsToValues.setCount("twelve", 12.0);
        wordsToValues.setCount("thirteen", 13.0);
        wordsToValues.setCount("fourteen", 14.0);
        wordsToValues.setCount("fifteen", 15.0);
        wordsToValues.setCount("sixteen", 16.0);
        wordsToValues.setCount("seventeen", 17.0);
        wordsToValues.setCount("eighteen", 18.0);
        wordsToValues.setCount("nineteen", 19.0);
        wordsToValues.setCount("twenty", 20.0);
        wordsToValues.setCount("thirty", 30.0);
        wordsToValues.setCount("forty", 40.0);
        wordsToValues.setCount("fifty", 50.0);
        wordsToValues.setCount("sixty", 60.0);
        wordsToValues.setCount("seventy", 70.0);
        wordsToValues.setCount("eighty", 80.0);
        wordsToValues.setCount("ninety", 90.0);
        wordsToValues.setCount("hundred", 100.0);
        wordsToValues.setCount("thousand", 1000.0);
        wordsToValues.setCount("million", 1000000.0);
        wordsToValues.setCount("billion", 1.0E9);
        wordsToValues.setCount("bn", 1.0E9);
        wordsToValues.setCount("trillion", 1.0E12);
        wordsToValues.setCount("dozen", 12.0);
        ordinalsToValues = new ClassicCounter();
        ordinalsToValues.setCount("zeroth", 0.0);
        ordinalsToValues.setCount("first", 1.0);
        ordinalsToValues.setCount("second", 2.0);
        ordinalsToValues.setCount("third", 3.0);
        ordinalsToValues.setCount("fourth", 4.0);
        ordinalsToValues.setCount("fifth", 5.0);
        ordinalsToValues.setCount("sixth", 6.0);
        ordinalsToValues.setCount("seventh", 7.0);
        ordinalsToValues.setCount("eighth", 8.0);
        ordinalsToValues.setCount("ninth", 9.0);
        ordinalsToValues.setCount("tenth", 10.0);
        ordinalsToValues.setCount("eleventh", 11.0);
        ordinalsToValues.setCount("twelfth", 12.0);
        ordinalsToValues.setCount("thirteenth", 13.0);
        ordinalsToValues.setCount("fourteenth", 14.0);
        ordinalsToValues.setCount("fifteenth", 15.0);
        ordinalsToValues.setCount("sixteenth", 16.0);
        ordinalsToValues.setCount("seventeenth", 17.0);
        ordinalsToValues.setCount("eighteenth", 18.0);
        ordinalsToValues.setCount("nineteenth", 19.0);
        ordinalsToValues.setCount("twentieth", 20.0);
        ordinalsToValues.setCount("twenty-first", 21.0);
        ordinalsToValues.setCount("twenty-second", 22.0);
        ordinalsToValues.setCount("twenty-third", 23.0);
        ordinalsToValues.setCount("twenty-fourth", 24.0);
        ordinalsToValues.setCount("twenty-fifth", 25.0);
        ordinalsToValues.setCount("twenty-sixth", 26.0);
        ordinalsToValues.setCount("twenty-seventh", 27.0);
        ordinalsToValues.setCount("twenty-eighth", 28.0);
        ordinalsToValues.setCount("twenty-ninth", 29.0);
        ordinalsToValues.setCount("thirtieth", 30.0);
        ordinalsToValues.setCount("thirty-first", 31.0);
        ordinalsToValues.setCount("fortieth", 40.0);
        ordinalsToValues.setCount("fiftieth", 50.0);
        ordinalsToValues.setCount("sixtieth", 60.0);
        ordinalsToValues.setCount("seventieth", 70.0);
        ordinalsToValues.setCount("eightieth", 80.0);
        ordinalsToValues.setCount("ninetieth", 90.0);
        ordinalsToValues.setCount("hundredth", 100.0);
        ordinalsToValues.setCount("thousandth", 1000.0);
        ordinalsToValues.setCount("millionth", 1000000.0);
        ordinalsToValues.setCount("billionth", 1.0E9);
        ordinalsToValues.setCount("trillionth", 1.0E12);
        dateRangeBeforePairedOneWord = new ArrayList<Pair<String, String>>();
        dateRangeBeforePairedOneWord.add(new Pair<String, String>("between", "and"));
        dateRangeBeforePairedOneWord.add(new Pair<String, String>("from", "to"));
        dateRangeBeforePairedOneWord.add(new Pair<String, String>("from", "-"));
        allSpaces = Pattern.compile(" *");
        numberPattern = Pattern.compile("([0-9.]+)");
    }
}

