/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import edu.stanford.nlp.ie.pascal.CliqueTemplates;
import edu.stanford.nlp.ie.pascal.DateTemplate;
import edu.stanford.nlp.ie.pascal.InfoTemplate;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PascalTemplate {
    private static Redwood.RedwoodChannels log = Redwood.channels(PascalTemplate.class);
    public static final String[] fields = new String[]{"workshoppapersubmissiondate", "workshopnotificationofacceptancedate", "workshopcamerareadycopydate", "workshopdate", "workshoplocation", "workshopacronym", "workshophomepage", "workshopname", "conferenceacronym", "conferencehomepage", "conferencename", "0"};
    public static final String BACKGROUND_SYMBOL = "0";
    private static final Index<String> fieldIndices = new HashIndex<String>();
    private final String[] values = new String[fields.length];
    private static Pattern acronymPattern;

    public PascalTemplate() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    public PascalTemplate(PascalTemplate pt) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = pt.values[i] == null ? null : pt.values[i];
        }
    }

    public static boolean acronymMatch(String s1, String s2, HashMap stemmedAcronymIndex) {
        log.info("Testing match:" + s1 + " : " + s2);
        String stem1 = (String)stemmedAcronymIndex.get(s1);
        String stem2 = (String)stemmedAcronymIndex.get(s2);
        log.info("Got stems:" + s1 + " : " + s2);
        return stem1.equals(stem2);
    }

    public static String stemAcronym(String s, CliqueTemplates ct) {
        if (ct.stemmedAcronymIndex.containsKey(s)) {
            return (String)ct.stemmedAcronymIndex.get(s);
        }
        Matcher matcher = acronymPattern.matcher(s);
        if (!matcher.matches() || s.equalsIgnoreCase("www")) {
            log.info("Not a valid acronym: " + s);
            return "null";
        }
        String stemmed = matcher.group(1).toLowerCase();
        if (stemmed.endsWith("-")) {
            stemmed = stemmed.substring(0, stemmed.length() - 1);
        }
        ct.stemmedAcronymIndex.put(s, stemmed);
        log.info("Stemmed: " + s + " to: " + stemmed);
        if (ct.inverseAcronymMap.containsKey(stemmed)) {
            HashSet set = (HashSet)ct.inverseAcronymMap.get(stemmed);
            set.add(s);
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(s);
            ct.inverseAcronymMap.put(stemmed, set);
        }
        return stemmed;
    }

    public static PascalTemplate mergeCliqueTemplates(DateTemplate dt, String location, InfoTemplate wi) {
        PascalTemplate pt = new PascalTemplate();
        pt.setValue("workshopnotificationofacceptancedate", dt.noadate);
        pt.setValue("workshopcamerareadycopydate", dt.crcdate);
        pt.setValue("workshopdate", dt.workdate);
        pt.setValue("workshoppapersubmissiondate", dt.subdate);
        pt.setValue("workshoplocation", location);
        pt.setValue("workshopacronym", wi.wacronym);
        pt.setValue("workshophomepage", wi.whomepage);
        pt.setValue("workshopname", wi.wname);
        pt.setValue("conferenceacronym", wi.cacronym);
        pt.setValue("conferencehomepage", wi.chomepage);
        pt.setValue("conferencename", wi.cname);
        return pt;
    }

    public void setValue(String fieldName, String value) {
        int index = PascalTemplate.getFieldIndex(fieldName);
        assert (index != -1);
        this.values[index] = value;
    }

    public void setValue(int index, String value) {
        if (index != this.values.length - 1) {
            this.values[index] = value;
        }
    }

    public String getValue(String fieldName) {
        int i = PascalTemplate.getFieldIndex(fieldName);
        if (i == -1 || i == this.values.length - 1) {
            return null;
        }
        return this.values[i];
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PascalTemplate)) {
            return false;
        }
        PascalTemplate pt = (PascalTemplate)obj;
        String[] values2 = pt.values;
        if (this.values.length != values2.length) {
            return false;
        }
        for (int i = 0; i < this.values.length - 1; ++i) {
            if (this.values[i] == null) {
                if (values2[i] == null) continue;
                return false;
            }
            if (values2[i] == null) {
                return false;
            }
            if (values2[i].equals(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int tally = 37;
        for (int i = 0; i < this.values.length - 1; ++i) {
            int n = this.values[i] == null ? 11 : this.values[i].hashCode();
            tally = 17 * tally + n;
        }
        return tally;
    }

    public static int getFieldIndex(String tag) {
        return fieldIndices.indexOf(tag);
    }

    public void writeToFieldValueCounter(Counter<String>[] fieldValueCounter, double score) {
        for (int i = 0; i < fields.length; ++i) {
            if (this.values[i] == null || this.values[i].equals("NULL")) continue;
            fieldValueCounter[i].incrementCount(this.values[i], score);
        }
    }

    public void unpackToCliqueTemplates(CliqueTemplates ct, double score) {
        ct.dateCliqueCounter.incrementCount(new DateTemplate(this.values[0], this.values[1], this.values[2], this.values[3]), score);
        if (this.values[4] != null) {
            ct.locationCliqueCounter.incrementCount(this.values[4], score);
        }
        ct.workshopInfoCliqueCounter.incrementCount(new InfoTemplate(this.values[6], this.values[5], this.values[7], this.values[9], this.values[8], this.values[10], ct), score);
    }

    public void print() {
        log.info("PascalTemplate: ");
        log.info(this.toString());
    }

    public String toString() {
        String str = "\n====================\n";
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null || this.values[i].equalsIgnoreCase("NULL")) continue;
            str = str.concat(fields[i] + " : " + this.values[i] + "\n");
        }
        return str;
    }

    static {
        for (String field : fields) {
            fieldIndices.add(field);
        }
        acronymPattern = Pattern.compile("([ \r-/a-zA-Z]+?)(?:[ -'*\t\r\n\f0-9]*)", 32);
    }
}

