/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french;

import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class FrenchTokenizerAnnotatorITest
extends TestCase {
    private static List<String> frenchSentences = Arrays.asList("Je sens qu'entre \u00e7a et les films de m\u00e9decins et scientifiques fous que nous avons d\u00e9j\u00e0 vus, nous pourrions emprunter un autre chemin pour l'origine.", "On pourra toujours parler \u00e0 propos d'Averro\u00e8s de \"d\u00e9centrement du Sujet\".", "Consacrant, lui, l'essentiel de son temps et de son \u00e9n\u00e9rgie exclusivement aux grands chantiers \u00e9conomiques destin\u00e9s \u00e0 procurer du travail aux jeunes g\u00e9n\u00e9rations.", "Plus, l'AQMI tente de nouer des rapports avec les mouvements subversifs dans le delta du Nig\u00e9ria, autant qu'avec des sectes d'inspiration religieuse au nord du pays.", "Apr\u00e8s avoir examin\u00e9 l'\u00e9tat des relations bilat\u00e9rales, les deux chefs d'Etat ont r\u00e9it\u00e9r\u00e9 leur volont\u00e9 d'\u0153uvrer \u00e0 leur renforcement et \u00e0 leur diversification.");
    private static List<List<String>> frenchSentenceTokenLists = Arrays.asList(Arrays.asList("Je", "sens", "qu'", "entre", "\u00e7a", "et", "les", "films", "de", "m\u00e9decins", "et", "scientifiques", "fous", "que", "nous", "avons", "d\u00e9j\u00e0", "vus", ",", "nous", "pourrions", "emprunter", "un", "autre", "chemin", "pour", "l'", "origine", "."), Arrays.asList("On", "pourra", "toujours", "parler", "\u00e0", "propos", "d'", "Averro\u00e8s", "de", "\"", "d\u00e9centrement", "de", "le", "Sujet", "\"", "."), Arrays.asList("Consacrant", ",", "lui", ",", "l'", "essentiel", "de", "son", "temps", "et", "de", "son", "\u00e9n\u00e9rgie", "exclusivement", "\u00e0", "les", "grands", "chantiers", "\u00e9conomiques", "destin\u00e9s", "\u00e0", "procurer", "de", "le", "travail", "\u00e0", "les", "jeunes", "g\u00e9n\u00e9rations", "."), Arrays.asList("Plus", ",", "l'", "AQMI", "tente", "de", "nouer", "des", "rapports", "avec", "les", "mouvements", "subversifs", "dans", "le", "delta", "de", "le", "Nig\u00e9ria", ",", "autant", "qu'", "avec", "des", "sectes", "d'", "inspiration", "religieuse", "\u00e0", "le", "nord", "de", "le", "pays", "."), Arrays.asList("Apr\u00e8s", "avoir", "examin\u00e9", "l'", "\u00e9tat", "des", "relations", "bilat\u00e9rales", ",", "les", "deux", "chefs", "d'", "Etat", "ont", "r\u00e9it\u00e9r\u00e9", "leur", "volont\u00e9", "d'", "\u0153uvrer", "\u00e0", "leur", "renforcement", "et", "\u00e0", "leur", "diversification", "."));

    public void testFrench() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize");
        props.setProperty("ssplit.eolonly", "true");
        props.setProperty("tokenize.language", "fr");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        int sentNum = 0;
        for (String exampleSentence : frenchSentences) {
            List<String> exampleSentenceTokens = frenchSentenceTokenLists.get(sentNum);
            CoreDocument exampleSentenceCoreDocument = new CoreDocument(exampleSentence);
            pipeline.annotate(exampleSentenceCoreDocument);
            for (int i = 0; i < exampleSentenceTokens.size(); ++i) {
                FrenchTokenizerAnnotatorITest.assertEquals((String)exampleSentenceTokens.get(i), (String)exampleSentenceCoreDocument.tokens().get(i).word());
            }
            ++sentNum;
        }
    }
}

