/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAggregator;
import edu.stanford.nlp.util.Comparators;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.IntervalTree;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class MatchedExpression {
    protected String text;
    protected Interval<Integer> charOffsets;
    protected Interval<Integer> tokenOffsets;
    protected Interval<Integer> chunkOffsets;
    protected CoreMap annotation;
    protected Object context;
    protected SingleAnnotationExtractor extractFunc;
    public Value value;
    double priority;
    double weight;
    int order;
    public static final Function<CoreMap, Interval<Integer>> COREMAP_TO_TOKEN_OFFSETS_INTERVAL_FUNC = in -> Interval.toInterval((Integer)in.get(CoreAnnotations.TokenBeginAnnotation.class), (Integer)in.get(CoreAnnotations.TokenEndAnnotation.class));
    public static final Function<CoreMap, Interval<Integer>> COREMAP_TO_CHAR_OFFSETS_INTERVAL_FUNC = in -> Interval.toInterval((Integer)in.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)in.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
    public static final Function<MatchedExpression, Interval<Integer>> EXPR_TO_TOKEN_OFFSETS_INTERVAL_FUNC = in -> in.tokenOffsets;
    public static final Comparator<MatchedExpression> EXPR_PRIORITY_COMPARATOR = (e1, e2) -> {
        double s2;
        double s1 = e1.getPriority();
        if (s1 == (s2 = e2.getPriority())) {
            return 0;
        }
        return s1 > s2 ? -1 : 1;
    };
    public static final Comparator<MatchedExpression> EXPR_ORDER_COMPARATOR = (e1, e2) -> {
        int s2;
        int s1 = e1.getOrder();
        if (s1 == (s2 = e2.getOrder())) {
            return 0;
        }
        return s1 < s2 ? -1 : 1;
    };
    public static final Comparator<MatchedExpression> EXPR_LENGTH_COMPARATOR = (e1, e2) -> {
        int len2;
        if (e1.getValue() == null && e2.getValue() != null) {
            return 1;
        }
        if (e1.getValue() != null && e2.getValue() == null) {
            return -1;
        }
        int len1 = e1.tokenOffsets.getEnd() - e1.tokenOffsets.getBegin();
        if (len1 == (len2 = e2.tokenOffsets.getEnd() - e2.tokenOffsets.getBegin())) {
            return 0;
        }
        return len1 > len2 ? -1 : 1;
    };
    public static final Comparator<MatchedExpression> EXPR_TOKEN_OFFSET_COMPARATOR = (e1, e2) -> e1.tokenOffsets.compareTo(e2.tokenOffsets);
    public static final Comparator<MatchedExpression> EXPR_TOKEN_OFFSETS_NESTED_FIRST_COMPARATOR = (e1, e2) -> {
        Interval.RelType rel = e1.tokenOffsets.getRelation(e2.tokenOffsets);
        if (rel.equals((Object)Interval.RelType.CONTAIN)) {
            return 1;
        }
        if (rel.equals((Object)Interval.RelType.INSIDE)) {
            return -1;
        }
        return e1.tokenOffsets.compareTo(e2.tokenOffsets);
    };
    public static final Comparator<MatchedExpression> EXPR_PRIORITY_LENGTH_COMPARATOR = Comparators.chain(EXPR_PRIORITY_COMPARATOR, EXPR_LENGTH_COMPARATOR, EXPR_ORDER_COMPARATOR, EXPR_TOKEN_OFFSET_COMPARATOR);
    public static final Comparator<MatchedExpression> EXPR_LENGTH_PRIORITY_COMPARATOR = Comparators.chain(EXPR_LENGTH_COMPARATOR, EXPR_PRIORITY_COMPARATOR, EXPR_ORDER_COMPARATOR, EXPR_TOKEN_OFFSET_COMPARATOR);
    public static final ToDoubleFunction<MatchedExpression> EXPR_WEIGHT_SCORER = in -> in.weight;

    public MatchedExpression(MatchedExpression me) {
        this.annotation = me.annotation;
        this.extractFunc = me.extractFunc;
        this.text = me.text;
        this.value = me.value;
        this.priority = me.priority;
        this.weight = me.weight;
        this.order = me.order;
        this.charOffsets = me.charOffsets;
        this.tokenOffsets = me.tokenOffsets;
        this.chunkOffsets = me.tokenOffsets;
    }

    public MatchedExpression(Interval<Integer> charOffsets, Interval<Integer> tokenOffsets, SingleAnnotationExtractor extractFunc, double priority, double weight) {
        this.charOffsets = charOffsets;
        this.tokenOffsets = tokenOffsets;
        this.chunkOffsets = tokenOffsets;
        this.extractFunc = extractFunc;
        this.priority = priority;
        this.weight = weight;
    }

    public boolean extractAnnotation(Env env, CoreMap sourceAnnotation) {
        return this.extractAnnotation(sourceAnnotation, this.extractFunc.tokensAggregator);
    }

    private boolean extractAnnotation(CoreMap sourceAnnotation, CoreMapAggregator aggregator) {
        Class tokensAnnotationKey = this.extractFunc.tokensAnnotationField;
        if (this.chunkOffsets != null) {
            this.annotation = aggregator.merge((List<? extends CoreMap>)((List)sourceAnnotation.get(tokensAnnotationKey)), this.chunkOffsets.getBegin(), this.chunkOffsets.getEnd());
            if (sourceAnnotation.containsKey(CoreAnnotations.TextAnnotation.class)) {
                ChunkAnnotationUtils.annotateChunkText(this.annotation, sourceAnnotation);
            }
            if (this.tokenOffsets != null) {
                if (this.annotation.get(CoreAnnotations.TokenBeginAnnotation.class) == null) {
                    this.annotation.set(CoreAnnotations.TokenBeginAnnotation.class, this.tokenOffsets.getBegin());
                }
                if (this.annotation.get(CoreAnnotations.TokenEndAnnotation.class) == null) {
                    this.annotation.set(CoreAnnotations.TokenEndAnnotation.class, this.tokenOffsets.getEnd());
                }
            }
            this.charOffsets = Interval.toInterval((Integer)this.annotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)this.annotation.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
            this.tokenOffsets = Interval.toInterval((Integer)this.annotation.get(CoreAnnotations.TokenBeginAnnotation.class), (Integer)this.annotation.get(CoreAnnotations.TokenEndAnnotation.class), 2);
        } else {
            Integer baseCharOffset = (Integer)sourceAnnotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            if (baseCharOffset == null) {
                baseCharOffset = 0;
            }
            this.chunkOffsets = ChunkAnnotationUtils.getChunkOffsetsUsingCharOffsets((List)sourceAnnotation.get(tokensAnnotationKey), this.charOffsets.getBegin() + baseCharOffset, this.charOffsets.getEnd() + baseCharOffset);
            CoreMap annotation2 = aggregator.merge((List<? extends CoreMap>)((List)sourceAnnotation.get(tokensAnnotationKey)), this.chunkOffsets.getBegin(), this.chunkOffsets.getEnd());
            this.annotation = ChunkAnnotationUtils.getAnnotatedChunkUsingCharOffsets(sourceAnnotation, this.charOffsets.getBegin(), this.charOffsets.getEnd());
            this.tokenOffsets = Interval.toInterval((Integer)this.annotation.get(CoreAnnotations.TokenBeginAnnotation.class), (Integer)this.annotation.get(CoreAnnotations.TokenEndAnnotation.class), 2);
            this.annotation.set(tokensAnnotationKey, (List)annotation2.get(tokensAnnotationKey));
        }
        this.text = (String)this.annotation.get(CoreAnnotations.TextAnnotation.class);
        this.extractFunc.annotate(this, (List)this.annotation.get(tokensAnnotationKey));
        return true;
    }

    public boolean extractAnnotation(Env env, List<? extends CoreMap> source) {
        return this.extractAnnotation(source, CoreMapAggregator.getDefaultAggregator());
    }

    protected boolean extractAnnotation(List<? extends CoreMap> source, CoreMapAggregator aggregator) {
        this.annotation = aggregator.merge(source, this.chunkOffsets.getBegin(), this.chunkOffsets.getEnd());
        this.charOffsets = Interval.toInterval((Integer)this.annotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)this.annotation.get(CoreAnnotations.CharacterOffsetEndAnnotation.class), 2);
        this.tokenOffsets = Interval.toInterval((Integer)this.annotation.get(CoreAnnotations.TokenBeginAnnotation.class), (Integer)this.annotation.get(CoreAnnotations.TokenEndAnnotation.class), 2);
        this.text = (String)this.annotation.get(CoreAnnotations.TextAnnotation.class);
        this.extractFunc.annotate(this, source.subList(this.chunkOffsets.getBegin(), this.chunkOffsets.getEnd()));
        return true;
    }

    public Interval<Integer> getCharOffsets() {
        return this.charOffsets;
    }

    public Interval<Integer> getTokenOffsets() {
        return this.tokenOffsets;
    }

    public Interval<Integer> getChunkOffsets() {
        return this.chunkOffsets;
    }

    public double getPriority() {
        return this.priority;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isIncludeNested() {
        return this.extractFunc.includeNested;
    }

    public void setIncludeNested(boolean includeNested) {
        this.extractFunc.includeNested = includeNested;
    }

    public String getText() {
        return this.text;
    }

    public CoreMap getAnnotation() {
        return this.annotation;
    }

    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return this.text;
    }

    public static List<? extends CoreMap> replaceMerged(List<? extends CoreMap> list, List<? extends MatchedExpression> matchedExprs) {
        if (matchedExprs == null) {
            return list;
        }
        matchedExprs.sort(EXPR_TOKEN_OFFSET_COMPARATOR);
        ArrayList<CoreMap> merged = new ArrayList<CoreMap>(list.size());
        int last = 0;
        for (MatchedExpression matchedExpression : matchedExprs) {
            int start = (Integer)matchedExpression.chunkOffsets.first();
            int end = (Integer)matchedExpression.chunkOffsets.second();
            if (start < last) continue;
            merged.addAll(list.subList(last, start));
            CoreMap m = matchedExpression.getAnnotation();
            merged.add(m);
            last = end;
        }
        if (last < list.size()) {
            merged.addAll(list.subList(last, list.size()));
        }
        return merged;
    }

    public static List<? extends CoreMap> replaceMergedUsingTokenOffsets(List<? extends CoreMap> list, List<? extends MatchedExpression> matchedExprs) {
        if (matchedExprs == null) {
            return list;
        }
        HashMap<Integer, Integer> tokenBeginToListIndexMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> tokenEndToListIndexMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            CoreMap cm = list.get(i);
            if (cm.containsKey(CoreAnnotations.TokenBeginAnnotation.class) && cm.containsKey(CoreAnnotations.TokenEndAnnotation.class)) {
                tokenBeginToListIndexMap.put((Integer)cm.get(CoreAnnotations.TokenBeginAnnotation.class), i);
                tokenEndToListIndexMap.put((Integer)cm.get(CoreAnnotations.TokenEndAnnotation.class), i + 1);
                continue;
            }
            tokenBeginToListIndexMap.put(i, i);
            tokenEndToListIndexMap.put(i + 1, i + 1);
        }
        matchedExprs.sort(EXPR_TOKEN_OFFSET_COMPARATOR);
        ArrayList<CoreMap> merged = new ArrayList<CoreMap>(list.size());
        int last = 0;
        for (MatchedExpression matchedExpression : matchedExprs) {
            int start = (Integer)matchedExpression.tokenOffsets.first();
            int end = (Integer)matchedExpression.tokenOffsets.second();
            Integer istart = (Integer)tokenBeginToListIndexMap.get(start);
            Integer iend = (Integer)tokenEndToListIndexMap.get(end);
            if (istart == null || iend == null || istart < last) continue;
            merged.addAll(list.subList(last, istart));
            CoreMap m = matchedExpression.getAnnotation();
            merged.add(m);
            last = iend;
        }
        if (last < list.size()) {
            merged.addAll(list.subList(last, list.size()));
        }
        return merged;
    }

    public static <T extends MatchedExpression> List<T> removeNullValues(List<T> chunks) {
        ArrayList<MatchedExpression> okayChunks = new ArrayList<MatchedExpression>(chunks.size());
        for (MatchedExpression chunk : chunks) {
            Value v = chunk.value;
            if (v == null || v.get() == null) continue;
            okayChunks.add(chunk);
        }
        return okayChunks;
    }

    public static <T extends MatchedExpression> List<T> removeNested(List<T> chunks) {
        if (chunks.size() > 1) {
            int sz = chunks.size();
            for (int i = 0; i < sz; ++i) {
                ((MatchedExpression)chunks.get((int)i)).order = i;
            }
            return IntervalTree.getNonNested(chunks, EXPR_TO_TOKEN_OFFSETS_INTERVAL_FUNC, EXPR_LENGTH_PRIORITY_COMPARATOR);
        }
        return chunks;
    }

    public static <T extends MatchedExpression> List<T> removeOverlapping(List<T> chunks) {
        if (chunks.size() > 1) {
            int sz = chunks.size();
            for (int i = 0; i < sz; ++i) {
                ((MatchedExpression)chunks.get((int)i)).order = i;
            }
            return IntervalTree.getNonOverlapping(chunks, EXPR_TO_TOKEN_OFFSETS_INTERVAL_FUNC, EXPR_PRIORITY_LENGTH_COMPARATOR);
        }
        return chunks;
    }

    public static <T extends MatchedExpression> T getBestMatched(List<T> matches, ToDoubleFunction<MatchedExpression> scorer) {
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        MatchedExpression best = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (MatchedExpression m : matches) {
            double s = scorer.applyAsDouble(m);
            if (best != null && !(s > bestScore)) continue;
            best = m;
            bestScore = s;
        }
        return (T)best;
    }

    public static class SingleAnnotationExtractor
    implements Function<CoreMap, Value> {
        public String name;
        public double priority;
        public double weight;
        public Class tokensAnnotationField = CoreAnnotations.TokensAnnotation.class;
        public List<Class> tokensResultAnnotationField;
        public List<Class> resultAnnotationField;
        public Class resultNestedAnnotationField;
        public boolean includeNested = false;
        public Function<CoreMap, Value> valueExtractor;
        public Function<MatchedExpression, Value> expressionToValue;
        public Function<MatchedExpression, ?> resultAnnotationExtractor;
        public CoreMapAggregator tokensAggregator;

        @Override
        public Value apply(CoreMap in) {
            return this.valueExtractor.apply(in);
        }

        private static void setAnnotations(CoreMap cm, List<Class> annotationKeys, Object obj) {
            if (annotationKeys.size() > 1 && obj instanceof List) {
                List list = (List)obj;
                int n = Math.min(list.size(), annotationKeys.size());
                for (int i = 0; i < n; ++i) {
                    Object v = list.get(i);
                    Class key = annotationKeys.get(i);
                    if (key == null) {
                        throw new RuntimeException("Invalid null annotation key");
                    }
                    if (v instanceof Value) {
                        cm.set(key, ((Value)v).get());
                        continue;
                    }
                    cm.set(key, v);
                }
            } else {
                for (Class key : annotationKeys) {
                    if (key == null) {
                        throw new RuntimeException("Invalid null annotation key");
                    }
                    cm.set(key, obj);
                }
            }
        }

        public void annotate(MatchedExpression matchedExpression, List<? extends CoreMap> nested) {
            if (this.resultNestedAnnotationField != null) {
                matchedExpression.annotation.set(this.resultNestedAnnotationField, nested);
            }
            this.annotate(matchedExpression);
        }

        public void annotate(MatchedExpression matchedExpression) {
            block8: {
                Value ev = null;
                if (this.expressionToValue != null) {
                    ev = this.expressionToValue.apply(matchedExpression);
                }
                Value value = matchedExpression.value = ev != null ? ev : this.valueExtractor.apply(matchedExpression.annotation);
                if (this.resultAnnotationField != null) {
                    if (this.resultAnnotationExtractor != null) {
                        Object result = this.resultAnnotationExtractor.apply(matchedExpression);
                        SingleAnnotationExtractor.setAnnotations(matchedExpression.annotation, this.resultAnnotationField, result);
                    } else {
                        Value v = matchedExpression.getValue();
                        SingleAnnotationExtractor.setAnnotations(matchedExpression.annotation, this.resultAnnotationField, v != null ? v.get() : null);
                    }
                }
                if (this.tokensResultAnnotationField == null) break block8;
                List tokens = (List)matchedExpression.annotation.get(this.tokensAnnotationField);
                if (this.resultAnnotationExtractor != null) {
                    Object result = this.resultAnnotationExtractor.apply(matchedExpression);
                    for (CoreMap cm : tokens) {
                        SingleAnnotationExtractor.setAnnotations(cm, this.tokensResultAnnotationField, result);
                    }
                } else {
                    Value v = matchedExpression.getValue();
                    for (CoreMap cm : tokens) {
                        SingleAnnotationExtractor.setAnnotations(cm, this.tokensResultAnnotationField, v != null ? v.get() : null);
                    }
                }
            }
        }

        public MatchedExpression createMatchedExpression(Interval<Integer> charOffsets, Interval<Integer> tokenOffsets) {
            return new MatchedExpression(charOffsets, tokenOffsets, this, this.priority, this.weight);
        }
    }
}

