/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.PriorityQueue;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToDoubleFunction;

public class BoundedCostOrderedMap<K, V>
extends AbstractMap<K, V> {
    private final int maxSize;
    private final double maxCost;
    private PriorityQueue<K> priorityQueue = new BinaryHeapPriorityQueue<K>();
    private Map<K, V> valueMap = new HashMap();
    private ToDoubleFunction<V> costFunction;

    public BoundedCostOrderedMap(ToDoubleFunction<V> costFunction, int maxSize, double maxCost) {
        this.costFunction = costFunction;
        this.maxSize = maxSize;
        this.maxCost = maxCost;
    }

    @Override
    public int size() {
        return this.valueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.valueMap.get(key);
    }

    public double getCost(V value) {
        return this.costFunction.applyAsDouble(value);
    }

    @Override
    public V put(K key, V value) {
        double cost = this.getCost(value);
        if (cost >= this.maxCost) {
            return null;
        }
        V v = this.valueMap.get(key);
        if (v != null && this.getCost(v) < cost) {
            return null;
        }
        if (this.maxSize > 0 && this.priorityQueue.size() >= this.maxSize) {
            if (this.priorityQueue.getPriority() > cost) {
                K k = this.priorityQueue.removeFirst();
                this.valueMap.remove(k);
                this.priorityQueue.changePriority(key, cost);
                return this.valueMap.put(key, value);
            }
        } else {
            this.priorityQueue.changePriority(key, cost);
            return this.valueMap.put(key, value);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.priorityQueue.remove(key);
        return this.valueMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.valueMap.clear();
        this.priorityQueue.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.valueMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.valueMap.values();
    }

    public List<V> valuesList() {
        ArrayList<V> list = new ArrayList<V>();
        for (K k : this.priorityQueue.toSortedList()) {
            list.add(this.valueMap.get(k));
        }
        Collections.reverse(list);
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.valueMap.entrySet();
    }

    public double topCost() {
        return this.priorityQueue.getPriority();
    }

    public K topKey() {
        return this.priorityQueue.getFirst();
    }
}

