/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.parser;

import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionNodePattern;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.CoreMapSequenceMatchAction;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MultiCoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.MultiNodePattern;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchAction;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchRules;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.ling.tokensregex.parser.ParseException;
import edu.stanford.nlp.ling.tokensregex.parser.SimpleCharStream;
import edu.stanford.nlp.ling.tokensregex.parser.Token;
import edu.stanford.nlp.ling.tokensregex.parser.TokenMgrError;
import edu.stanford.nlp.ling.tokensregex.parser.TokenSequenceParseException;
import edu.stanford.nlp.ling.tokensregex.parser.TokenSequenceParserConstants;
import edu.stanford.nlp.ling.tokensregex.parser.TokenSequenceParserTokenManager;
import edu.stanford.nlp.ling.tokensregex.types.AssignableExpression;
import edu.stanford.nlp.ling.tokensregex.types.Expression;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.util.ArrayMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TokenSequenceParser
implements SequencePattern.Parser<CoreMap>,
TokenSequenceParserConstants {
    public TokenSequenceParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[71];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[35];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public TokenSequenceParser() {
    }

    public CoreMapExpressionExtractor getExpressionExtractor(Env env, Reader r) throws ParseException, TokenSequenceParseException {
        try {
            TokenSequenceParser p = new TokenSequenceParser(r);
            List<SequenceMatchRules.Rule> rules = p.RuleList(env);
            return new CoreMapExpressionExtractor(env, rules);
        }
        catch (TokenMgrError error) {
            throw new TokenSequenceParseException("Parsing failed. Error: " + error);
        }
    }

    public void updateExpressionExtractor(CoreMapExpressionExtractor extractor, Reader r) throws ParseException, TokenSequenceParseException {
        try {
            TokenSequenceParser p = new TokenSequenceParser(r);
            List<SequenceMatchRules.Rule> rules = p.RuleList(extractor.getEnv());
            extractor.appendRules(rules);
        }
        catch (TokenMgrError error) {
            throw new TokenSequenceParseException("Parsing failed. Error: " + error);
        }
    }

    @Override
    public SequencePattern.PatternExpr parseSequence(Env env, String s) throws ParseException, TokenSequenceParseException {
        try {
            TokenSequenceParser p = new TokenSequenceParser(new StringReader(s));
            return p.SeqRegex(env);
        }
        catch (TokenMgrError error) {
            throw new TokenSequenceParseException("Parsing failed. Error: " + error);
        }
    }

    @Override
    public Pair<SequencePattern.PatternExpr, SequenceMatchAction<CoreMap>> parseSequenceWithAction(Env env, String s) throws ParseException, TokenSequenceParseException {
        try {
            TokenSequenceParser p = new TokenSequenceParser(new StringReader(s));
            return p.SeqRegexWithAction(env);
        }
        catch (TokenMgrError error) {
            throw new TokenSequenceParseException("Parsing failed. Error: " + error);
        }
    }

    @Override
    public SequencePattern.PatternExpr parseNode(Env env, String s) throws ParseException, TokenSequenceParseException {
        try {
            TokenSequenceParser p = new TokenSequenceParser(new StringReader(s));
            NodePattern n = p.Node(env);
            return new SequencePattern.NodePatternExpr(n);
        }
        catch (TokenMgrError error) {
            throw new TokenSequenceParseException("Parsing failed. Error: " + error);
        }
    }

    private static Integer parseInteger(String str) {
        if (str.startsWith("+")) {
            return Integer.valueOf(str.substring(1));
        }
        return Integer.valueOf(str);
    }

    private static Long parseLongInteger(String str) {
        if (str.endsWith("L")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.startsWith("+")) {
            return Long.valueOf(str.substring(1));
        }
        return Long.valueOf(str);
    }

    private String parseQuotedString(String str) {
        return str.substring(1, str.length() - 1).replaceAll("\\\\\"", "\"");
    }

    private void appendSpecialTokens(StringBuilder sb, Token st) {
        if (st != null) {
            this.appendSpecialTokens(sb, st.specialToken);
            sb.append(st.image);
        }
    }

    private String getStringFromTokens(Token head, Token tail, boolean includeSpecial) {
        StringBuilder sb = new StringBuilder();
        Token p = head;
        while (p != tail) {
            if (includeSpecial) {
                this.appendSpecialTokens(sb, p.specialToken);
            }
            sb.append(p.image);
            p = p.next;
        }
        return sb.toString();
    }

    public final List<SequenceMatchRules.Rule> RuleList(Env env) throws ParseException {
        ArrayList<SequenceMatchRules.Rule> rules = new ArrayList<SequenceMatchRules.Rule>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            SequenceMatchRules.Rule rule = this.Rule(env);
            rules.add(rule);
        }
        return rules;
    }

    public final SequenceMatchRules.Rule Rule(Env env) throws ParseException {
        SequenceMatchRules.Rule rule;
        if (this.jj_2_1(3)) {
            rule = this.ExpressionExtractorRule(env);
        } else if (this.jj_2_2(3)) {
            rule = this.AssignmentRule(env);
        } else if (this.jj_2_3(3)) {
            Expressions.CompositeValue cv = this.CompositeFieldValue(env);
            rule = SequenceMatchRules.createRule(env, cv);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return rule;
    }

    public final SequenceMatchRules.Rule ExpressionExtractorRule(Env env) throws ParseException {
        if (this.jj_2_4(2)) {
            this.jj_consume_token(22);
            String stringRegex = this.StringRegex(env);
            this.jj_consume_token(23);
            Expression result = this.Expression(env);
            this.jj_consume_token(24);
            return SequenceMatchRules.createExtractionRule(env, null, stringRegex, result);
        }
        if (this.jj_2_5(2)) {
            this.jj_consume_token(22);
            this.jj_consume_token(25);
            SequencePattern.PatternExpr expr = this.SeqRegex(env);
            this.jj_consume_token(26);
            this.jj_consume_token(23);
            Expression result = this.Expression(env);
            this.jj_consume_token(24);
            return SequenceMatchRules.createExtractionRule(env, null, TokenSequencePattern.compile(expr), result);
        }
        if (this.jj_2_6(2)) {
            this.jj_consume_token(22);
            this.jj_consume_token(27);
            this.jj_consume_token(25);
            SequencePattern.PatternExpr expr = this.SeqRegex(env);
            this.jj_consume_token(26);
            this.jj_consume_token(23);
            Expression result = this.Expression(env);
            this.jj_consume_token(24);
            return SequenceMatchRules.createTokenPatternRule(env, expr, result);
        }
        if (this.jj_2_7(2)) {
            this.jj_consume_token(22);
            this.jj_consume_token(28);
            String stringRegex = this.StringRegex(env);
            this.jj_consume_token(23);
            Expression result = this.Expression(env);
            this.jj_consume_token(24);
            return SequenceMatchRules.createTextPatternRule(env, stringRegex, result);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SequenceMatchRules.Rule AssignmentRule(Env env) throws ParseException {
        AssignableExpression var = this.AssignableExpression(env);
        this.jj_consume_token(29);
        Expression result = this.Expression(env);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return SequenceMatchRules.createAssignmentRule(env, var, result);
    }

    public final AssignableExpression AssignableExpression(Env env) throws ParseException {
        AssignableExpression expr = this.AssignableNestedVarExpression(env);
        return expr;
    }

    public final Expression Expression(Env env) throws ParseException {
        Expression expr;
        if (this.jj_2_8(5)) {
            expr = this.NestedFunctionCallExpression(env);
        } else if (this.jj_2_9(5)) {
            expr = this.NestedVarExpression(env);
        } else if (this.jj_2_10(5)) {
            expr = this.ValueExpression(env);
        } else if (this.jj_2_11(5)) {
            expr = this.ListExpression(env);
        } else if (this.jj_2_12(5)) {
            expr = this.ListExpression2(env);
        } else if (this.jj_2_13(5)) {
            expr = this.CaseExpression(env);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final int Index() throws ParseException {
        this.jj_consume_token(31);
        Token t = this.IntegerToken();
        this.jj_consume_token(32);
        return Integer.parseInt(t.image);
    }

    public final Expression FunctionCallExpression(Env env) throws ParseException {
        ArrayList<Expression> params = new ArrayList<Expression>();
        Token typeToken = this.jj_consume_token(7);
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 38: {
                Expression param = this.Expression(env);
                params.add(param);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(33);
                    param = this.Expression(env);
                    params.add(param);
                }
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        return new Expressions.FunctionCallExpression(typeToken.image, params, new String[0]);
    }

    public final Value ValueExpression(Env env) throws ParseException {
        Value expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: {
                expr = this.BasicValue(env);
                break;
            }
            case 22: {
                expr = this.CompositeFieldValue(env);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final Expressions.CompositeValue CompositeFieldValue(Env env) throws ParseException {
        ArrayMap<String, Expression> attributes = new ArrayMap<String, Expression>();
        this.jj_consume_token(22);
        this.FieldValue(env, attributes);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: 
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    break;
                }
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.FieldValue(env, attributes);
        }
        this.jj_consume_token(24);
        return new Expressions.CompositeValue(attributes, false, new String[0]);
    }

    public final Map<String, Expression> FieldValue(Env env, Map<String, Expression> attributes) throws ParseException {
        String fieldname = null;
        Expression expr = null;
        fieldname = this.RelaxedString();
        this.jj_consume_token(34);
        expr = this.Expression(env);
        if (fieldname != null && expr != null) {
            if (attributes.containsKey(fieldname)) {
                throw new Error("Field already defined: " + fieldname);
            }
            attributes.put(fieldname, expr);
        }
        return attributes;
    }

    public final Value BasicValue(Env env) throws ParseException {
        Token tok = null;
        Token head = null;
        Token tail = null;
        SequencePattern.PatternExpr seqRegex = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                tok = this.jj_consume_token(17);
                return new Expressions.RegexValue(tok.image.substring(1, tok.image.length() - 1), new String[0]);
            }
            case 18: {
                tok = this.jj_consume_token(18);
                return new Expressions.PrimitiveValue<String>("STRING", this.parseQuotedString(tok.image), new String[0]);
            }
            case 13: 
            case 14: {
                tok = this.IntegerToken();
                return new Expressions.PrimitiveValue<Integer>("INTEGER", TokenSequenceParser.parseInteger(tok.image), new String[0]);
            }
            case 15: {
                tok = this.jj_consume_token(15);
                return new Expressions.PrimitiveValue<Long>("INTEGER", TokenSequenceParser.parseLongInteger(tok.image), new String[0]);
            }
            case 16: {
                tok = this.jj_consume_token(16);
                return new Expressions.PrimitiveValue<Double>("REAL", Double.valueOf(tok.image), new String[0]);
            }
            case 25: {
                head = this.jj_consume_token(25);
                seqRegex = this.SeqRegex(env);
                tail = this.jj_consume_token(26);
                String str = this.getStringFromTokens(head, tail, true);
                TokenSequencePattern seqPattern = new TokenSequencePattern(str, seqRegex);
                return new Expressions.PrimitiveValue<TokenSequencePattern>("TOKEN_REGEX", seqPattern, new String[0]);
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AssignableExpression AssignableVar(Env env) throws ParseException {
        Token tok = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                tok = this.jj_consume_token(7);
                return new Expressions.VarExpression(tok.image, new String[0]);
            }
            case 8: {
                tok = this.jj_consume_token(8);
                return new Expressions.RegexMatchVarExpression(tok.image, new String[0]);
            }
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expression VarOrRegexVar(Env env) throws ParseException {
        Token tok = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                tok = this.jj_consume_token(7);
                return new Expressions.VarExpression(tok.image, new String[0]);
            }
            case 8: {
                tok = this.jj_consume_token(8);
                return new Expressions.RegexMatchVarExpression(tok.image, new String[0]);
            }
            case 9: {
                tok = this.jj_consume_token(9);
                return new Expressions.RegexMatchVarExpression(Integer.valueOf(tok.image.substring(1)), new String[0]);
            }
            case 10: {
                tok = this.jj_consume_token(10);
                return new Expressions.RegexMatchResultVarExpression(tok.image.substring(1), new String[0]);
            }
            case 11: {
                tok = this.jj_consume_token(11);
                return new Expressions.RegexMatchResultVarExpression(Integer.valueOf(tok.image.substring(2)), new String[0]);
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expression MethodCallExpression(Env env, Expression parent) throws ParseException {
        ArrayList<Expression> params = new ArrayList<Expression>();
        Token typeToken = this.jj_consume_token(7);
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 38: {
                Expression param = this.Expression(env);
                params.add(param);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(33);
                    param = this.Expression(env);
                    params.add(param);
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        return new Expressions.MethodCallExpression(typeToken.image, parent, params, new String[0]);
    }

    public final AssignableExpression AssignableNestedVarExpression(Env env) throws ParseException {
        AssignableExpression expr;
        block6: {
            expr = this.AssignableVar(env);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: 
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block6;
                    }
                }
                if (this.jj_2_14(2)) {
                    int i = this.Index();
                    expr = new Expressions.IndexedExpression(expr, i);
                    continue;
                }
                if (this.jj_2_15(2)) {
                    this.jj_consume_token(31);
                    Expression fieldExpr = this.Expression(env);
                    expr = new Expressions.FieldExpression((Expression)expr, fieldExpr);
                    this.jj_consume_token(32);
                    continue;
                }
                if (!this.jj_2_16(2)) break;
                this.jj_consume_token(35);
                String s = this.RelaxedString();
                expr = new Expressions.FieldExpression((Expression)expr, s);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final Expression NestedVarExpression(Env env) throws ParseException {
        Expression expr;
        block7: {
            expr = this.VarOrRegexVar(env);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: 
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block7;
                    }
                }
                if (this.jj_2_17(3)) {
                    int i = this.Index();
                    expr = new Expressions.IndexedExpression(expr, i);
                    continue;
                }
                if (this.jj_2_18(3)) {
                    this.jj_consume_token(31);
                    Expression fieldExpr = this.Expression(env);
                    expr = new Expressions.FieldExpression(expr, fieldExpr);
                    this.jj_consume_token(32);
                    continue;
                }
                if (this.jj_2_19(3)) {
                    this.jj_consume_token(35);
                    expr = this.MethodCallExpression(env, expr);
                    continue;
                }
                if (!this.jj_2_20(3)) break;
                this.jj_consume_token(35);
                String s = this.RelaxedString();
                expr = new Expressions.FieldExpression(expr, s);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final Expression NestedFunctionCallExpression(Env env) throws ParseException {
        Expression expr;
        block7: {
            expr = this.FunctionCallExpression(env);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: 
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block7;
                    }
                }
                if (this.jj_2_21(3)) {
                    int i = this.Index();
                    expr = new Expressions.IndexedExpression(expr, i);
                    continue;
                }
                if (this.jj_2_22(3)) {
                    this.jj_consume_token(31);
                    Expression fieldExpr = this.Expression(env);
                    expr = new Expressions.FieldExpression(expr, fieldExpr);
                    this.jj_consume_token(32);
                    continue;
                }
                if (this.jj_2_23(3)) {
                    this.jj_consume_token(35);
                    expr = this.MethodCallExpression(env, expr);
                    continue;
                }
                if (!this.jj_2_24(3)) break;
                this.jj_consume_token(35);
                String s = this.RelaxedString();
                expr = new Expressions.FieldExpression(expr, s);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    public final Expression ListExpression(Env env) throws ParseException {
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        this.jj_consume_token(25);
        Expression expr = this.Expression(env);
        exprs.add(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(33);
            expr = this.Expression(env);
            exprs.add(expr);
        }
        this.jj_consume_token(26);
        return new Expressions.ListExpression("LIST", exprs, new String[0]);
    }

    public final Expression ListExpression2(Env env) throws ParseException {
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        this.jj_consume_token(31);
        Expression expr = this.Expression(env);
        exprs.add(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(33);
            expr = this.Expression(env);
            exprs.add(expr);
        }
        this.jj_consume_token(32);
        return new Expressions.ListExpression("LIST", exprs, new String[0]);
    }

    public final Expression BasicCondExpression(Env env) throws ParseException {
        Expression expr1 = null;
        Expression expr2 = null;
        Token op = null;
        if (this.jj_2_25(3)) {
            expr1 = this.NestedVarExpression(env);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: {
                    op = this.CmpToken();
                    expr2 = this.Expression(env);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                }
            }
            if (op == null) {
                return new Expressions.ConditionalExpression(expr1);
            }
            return new Expressions.ConditionalExpression(op.image, expr1, expr2);
        }
        if (this.jj_2_26(3)) {
            expr1 = this.NestedFunctionCallExpression(env);
            return new Expressions.ConditionalExpression(expr1);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expression CondGroup(Env env) throws ParseException {
        Expression expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                expr = this.BasicCondExpression(env);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                expr = this.CondExpression(env);
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final Expression CondExpression(Env env) throws ParseException {
        ArrayList<Expression> disjChildren = new ArrayList<Expression>();
        ArrayList<Expression> conjChildren = new ArrayList<Expression>();
        Expression child = this.CondGroup(env);
        conjChildren.add(child);
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    op = this.jj_consume_token(36);
                    break;
                }
                case 37: {
                    op = this.jj_consume_token(37);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            child = this.CondGroup(env);
            if ("&&".equals(op.image)) {
                conjChildren.add(child);
                continue;
            }
            if (!"||".equals(op.image)) continue;
            if (conjChildren.size() > 1) {
                disjChildren.add(new Expressions.AndExpression(conjChildren));
            } else {
                disjChildren.add((Expression)conjChildren.get(0));
            }
            conjChildren = new ArrayList();
            conjChildren.add(child);
        }
        if (conjChildren.size() > 1) {
            disjChildren.add(new Expressions.AndExpression(conjChildren));
        } else {
            disjChildren.add((Expression)conjChildren.get(0));
        }
        if (disjChildren.size() == 1) {
            return (Expression)disjChildren.get(0);
        }
        return new Expressions.OrExpression(disjChildren);
    }

    public final Expression CaseExpression(Env env) throws ParseException {
        Expression cond = null;
        Expression expr = null;
        ArrayList<Pair<Expression, Expression>> cases = new ArrayList<Pair<Expression, Expression>>();
        Expression elseExpr = null;
        this.jj_consume_token(38);
        this.jj_consume_token(22);
        block10: while (true) {
            cond = this.CondExpression(env);
            this.jj_consume_token(23);
            expr = this.Expression(env);
            cases.add(new Pair<Expression, Expression>(cond, expr));
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    break;
                }
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 25: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[22] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                this.jj_consume_token(23);
                elseExpr = this.Expression(env);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(24);
        return new Expressions.CaseExpression(cases, elseExpr);
    }

    public final String StringRegex(Env env) throws ParseException {
        Token tok = this.jj_consume_token(17);
        return tok.image.substring(1, tok.image.length() - 1);
    }

    public final SequencePattern.PatternExpr SeqRegex(Env env) throws ParseException {
        boolean hasStart = false;
        boolean hasEnd = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                hasStart = true;
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        SequencePattern.PatternExpr expr = this.SeqRegexDisjConj(env);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                hasEnd = true;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        if (hasStart) {
            expr = new SequencePattern.SequencePatternExpr(SequencePattern.SEQ_BEGIN_PATTERN_EXPR, expr);
        }
        if (hasEnd) {
            expr = new SequencePattern.SequencePatternExpr(expr, SequencePattern.SEQ_END_PATTERN_EXPR);
        }
        return expr;
    }

    public final Object StringNumberValue(Env env) throws ParseException {
        Token tok = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                tok = this.jj_consume_token(18);
                return this.parseQuotedString(tok.image);
            }
            case 13: 
            case 14: {
                tok = this.IntegerToken();
                return TokenSequenceParser.parseInteger(tok.image);
            }
            case 15: {
                tok = this.jj_consume_token(15);
                return TokenSequenceParser.parseLongInteger(tok.image);
            }
            case 16: {
                tok = this.jj_consume_token(16);
                return Double.valueOf(tok.image);
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SequencePattern.PatternExpr SeqRegexBasic(Env env) throws ParseException {
        SequencePattern.PatternExpr expr;
        ArrayList<SequencePattern.PatternExpr> children = new ArrayList<SequencePattern.PatternExpr>();
        Expression value = null;
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    NodePattern node = this.BracketedNode(env);
                    expr = new SequencePattern.NodePatternExpr(node);
                    break;
                }
                case 7: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 21: {
                    NodePattern node = this.CoreMapWordPattern(env);
                    expr = new SequencePattern.NodePatternExpr(node);
                    break;
                }
                case 52: {
                    MultiNodePattern multiNode = this.MultiNodePattern(env);
                    expr = new SequencePattern.MultiNodePatternExpr(multiNode);
                    break;
                }
                case 25: {
                    expr = this.SeqRegexGroup(env);
                    break;
                }
                case 8: {
                    expr = this.SeqVar(env);
                    break;
                }
                case 12: {
                    expr = this.SeqBackRef(env);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 42: 
                case 43: 
                case 44: {
                    expr = this.SeqRegexRepeatTimes(env, expr);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            children.add(expr);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 25: 
                case 31: 
                case 52: {
                    continue block17;
                }
            }
            break;
        }
        this.jj_la1[29] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                value = this.Expression(env);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        if (children.size() != 1) {
            expr = new SequencePattern.SequencePatternExpr(children);
        }
        if (value != null) {
            expr = new SequencePattern.ValuePatternExpr(expr, value);
        }
        return expr;
    }

    public final SequencePattern.PatternExpr SeqRegexRepeatTimes(Env env, SequencePattern.PatternExpr expr) throws ParseException {
        int min = -1;
        int max = -1;
        boolean greedy = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                Token value = this.jj_consume_token(42);
                min = 0;
                max = -1;
                break;
            }
            case 43: {
                Token value = this.jj_consume_token(43);
                min = 0;
                max = 1;
                break;
            }
            case 44: {
                Token value = this.jj_consume_token(44);
                min = 1;
                max = -1;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                if (this.jj_2_27(3)) {
                    this.jj_consume_token(22);
                    Token value = this.jj_consume_token(13);
                    this.jj_consume_token(24);
                    max = min = Integer.parseInt(value.image);
                    break;
                }
                if (this.jj_2_28(4)) {
                    this.jj_consume_token(22);
                    Token value = this.jj_consume_token(13);
                    this.jj_consume_token(33);
                    this.jj_consume_token(24);
                    min = Integer.parseInt(value.image);
                    max = -1;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        Token value = this.jj_consume_token(13);
                        this.jj_consume_token(33);
                        Token v2 = this.jj_consume_token(13);
                        this.jj_consume_token(24);
                        min = Integer.parseInt(value.image);
                        max = Integer.parseInt(v2.image);
                        break block0;
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                greedy = false;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        return new SequencePattern.RepeatPatternExpr(expr, min, max, greedy);
    }

    public final SequencePattern.PatternExpr SeqRegexDisj(Env env) throws ParseException {
        ArrayList<SequencePattern.PatternExpr> children = new ArrayList<SequencePattern.PatternExpr>();
        SequencePattern.PatternExpr expr = this.SeqRegexBasic(env);
        children.add(expr);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 45: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    this.jj_consume_token(45);
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            expr = this.SeqRegexBasic(env);
            children.add(expr);
        }
        if (children.size() == 1) {
            return (SequencePattern.PatternExpr)children.get(0);
        }
        return new SequencePattern.OrPatternExpr(children);
    }

    public final SequencePattern.PatternExpr SeqRegexDisjConj(Env env) throws ParseException {
        ArrayList<SequencePattern.PatternExpr> disjChildren = new ArrayList<SequencePattern.PatternExpr>();
        ArrayList<SequencePattern.PatternExpr> conjChildren = new ArrayList<SequencePattern.PatternExpr>();
        SequencePattern.PatternExpr child = this.SeqRegexBasic(env);
        conjChildren.add(child);
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    op = this.jj_consume_token(46);
                    break;
                }
                case 45: {
                    op = this.jj_consume_token(45);
                    break;
                }
                case 36: {
                    op = this.jj_consume_token(36);
                    break;
                }
                case 37: {
                    op = this.jj_consume_token(37);
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            child = this.SeqRegexBasic(env);
            if ("&".equals(op.image) || "&&".equals(op.image)) {
                conjChildren.add(child);
                continue;
            }
            if (!"|".equals(op.image) && !"||".equals(op.image)) continue;
            if (conjChildren.size() > 1) {
                disjChildren.add(new SequencePattern.AndPatternExpr(conjChildren));
            } else {
                disjChildren.add((SequencePattern.PatternExpr)conjChildren.get(0));
            }
            conjChildren = new ArrayList();
            conjChildren.add(child);
        }
        if (conjChildren.size() > 1) {
            disjChildren.add(new SequencePattern.AndPatternExpr(conjChildren));
        } else {
            disjChildren.add((SequencePattern.PatternExpr)conjChildren.get(0));
        }
        if (disjChildren.size() == 1) {
            return (SequencePattern.PatternExpr)disjChildren.get(0);
        }
        return new SequencePattern.OrPatternExpr(disjChildren);
    }

    public final SequencePattern.PatternExpr SeqRegexGroup(Env env) throws ParseException {
        boolean capturing = true;
        String varname = null;
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: 
            case 47: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        this.jj_consume_token(47);
                        capturing = false;
                        break block0;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        Token var = this.jj_consume_token(8);
                        varname = var.image;
                        break block0;
                    }
                }
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        SequencePattern.PatternExpr expr = this.SeqRegex(env);
        this.jj_consume_token(26);
        if (varname != null) {
            return new SequencePattern.GroupPatternExpr(expr, varname);
        }
        return new SequencePattern.GroupPatternExpr(expr, capturing);
    }

    public final NodePattern BracketedNode(Env env) throws ParseException {
        NodePattern node;
        if (this.jj_2_29(2)) {
            this.jj_consume_token(31);
            this.jj_consume_token(32);
            node = NodePattern.ANY_NODE;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    this.jj_consume_token(31);
                    node = this.NodeDisjConj(env);
                    this.jj_consume_token(32);
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return node;
    }

    public final SequencePattern.PatternExpr SeqVar(Env env) throws ParseException {
        Token name = this.jj_consume_token(8);
        SequencePattern.PatternExpr expr = env.getSequencePatternExpr(name.image, true);
        if (expr == null) {
            throw new Error("Unknown sequence pattern variable " + name.image);
        }
        return expr;
    }

    public final SequencePattern.PatternExpr SeqBackRef(Env env) throws ParseException {
        Token name = this.jj_consume_token(12);
        int v = Integer.parseInt(name.image.substring(1));
        return new SequencePattern.BackRefPatternExpr(CoreMapNodePattern.TEXT_ATTR_EQUAL_CHECKER, v);
    }

    public final NodePattern Node(Env env) throws ParseException {
        NodePattern node;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                node = this.BracketedNode(env);
                break;
            }
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 48: 
            case 49: {
                node = this.NodeGroup(env);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final NodePattern NodeDisj(Env env) throws ParseException {
        ArrayList children = new ArrayList();
        NodePattern child = this.NodeGroup(env);
        children.add(child);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 45: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    this.jj_consume_token(45);
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            child = this.NodeGroup(env);
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new NodePattern.DisjNodePattern(children);
    }

    public final NodePattern NodeConj(Env env) throws ParseException {
        ArrayList children = new ArrayList();
        NodePattern child = this.NodeGroup(env);
        children.add(child);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    this.jj_consume_token(46);
                    break;
                }
                case 36: {
                    this.jj_consume_token(36);
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            child = this.NodeGroup(env);
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new NodePattern.ConjNodePattern(children);
    }

    public final NodePattern NodeDisjConj(Env env) throws ParseException {
        ArrayList disjChildren = new ArrayList();
        ArrayList<NodePattern<Object>> conjChildren = new ArrayList();
        NodePattern child = this.NodeGroup(env);
        conjChildren.add(child);
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    op = this.jj_consume_token(46);
                    break;
                }
                case 45: {
                    op = this.jj_consume_token(45);
                    break;
                }
                case 36: {
                    op = this.jj_consume_token(36);
                    break;
                }
                case 37: {
                    op = this.jj_consume_token(37);
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            child = this.NodeGroup(env);
            if ("&".equals(op.image) || "&&".equals(op.image)) {
                conjChildren.add(child);
                continue;
            }
            if (!"|".equals(op.image) && !"||".equals(op.image)) continue;
            if (conjChildren.size() > 1) {
                disjChildren.add(new NodePattern.ConjNodePattern(conjChildren));
            } else {
                disjChildren.add((NodePattern)conjChildren.get(0));
            }
            conjChildren = new ArrayList();
            conjChildren.add(child);
        }
        if (conjChildren.size() > 1) {
            disjChildren.add(new NodePattern.ConjNodePattern(conjChildren));
        } else {
            disjChildren.add((NodePattern)conjChildren.get(0));
        }
        if (disjChildren.size() == 1) {
            return (NodePattern)disjChildren.get(0);
        }
        return new NodePattern.DisjNodePattern(disjChildren);
    }

    public final NodePattern NodeGroup(Env env) throws ParseException {
        NodePattern.NegateNodePattern node;
        if (this.jj_2_30(2)) {
            node = this.NodeBasic(env);
        } else if (this.jj_2_31(2)) {
            this.jj_consume_token(25);
            node = this.NodeDisjConj(env);
            this.jj_consume_token(26);
        } else if (this.jj_2_32(2)) {
            this.jj_consume_token(48);
            this.jj_consume_token(25);
            node = this.NodeDisjConj(env);
            this.jj_consume_token(26);
            node = new NodePattern.NegateNodePattern(node);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return node;
    }

    public final NodePattern NodeBasic(Env env) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                NodePattern child = this.CoreMapNode(env);
                return new NodePattern.NegateNodePattern(child);
            }
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 22: 
            case 49: {
                NodePattern child = this.CoreMapNode(env);
                return child;
            }
        }
        this.jj_la1[48] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NodePattern CoreMapNode(Env env) throws ParseException {
        ArrayMap<String, String> attributes = new ArrayMap<String, String>();
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 17: 
            case 18: 
            case 22: {
                block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        this.AttrValue(env, attributes);
                        block22: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: 
                                case 33: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[49] = this.jj_gen;
                                    break block22;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 33: {
                                    this.jj_consume_token(33);
                                    break;
                                }
                                case 30: {
                                    this.jj_consume_token(30);
                                    break;
                                }
                                default: {
                                    this.jj_la1[50] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.AttrValue(env, attributes);
                        }
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        if (this.jj_2_33(2)) {
                            this.AttrValue(env, attributes);
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: 
                            case 17: 
                            case 18: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: 
                                    case 18: {
                                        value = this.RelaxedStringToken();
                                        break;
                                    }
                                    case 17: {
                                        value = this.jj_consume_token(17);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[51] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                attributes.put("word", value.image);
                                break block5;
                            }
                        }
                        this.jj_la1[53] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                CoreMapNodePattern pat = CoreMapNodePattern.valueOf(env, attributes);
                return pat;
            }
            case 8: {
                NodePattern pat = this.CoreMapVarNodePattern(env);
                return pat;
            }
            case 49: {
                this.jj_consume_token(49);
                NodePattern pat = this.CoreMapExprNodePattern(env);
                this.jj_consume_token(50);
                return pat;
            }
        }
        this.jj_la1[54] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Map<String, String> AttrValue(Env env, Map<String, String> attributes) throws ParseException {
        Token attr = null;
        Token value = null;
        Token tok = null;
        String str = null;
        attr = this.jj_consume_token(7);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        value = this.jj_consume_token(18);
                        break block0;
                    }
                    case 17: {
                        value = this.jj_consume_token(17);
                        break block0;
                    }
                    case 7: {
                        value = this.jj_consume_token(7);
                        break block0;
                    }
                    case 8: {
                        str = this.CoreMapVarValue(env);
                        break block0;
                    }
                }
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 51: {
                tok = this.jj_consume_token(51);
                value = this.jj_consume_token(7);
                break;
            }
            case 19: {
                tok = this.jj_consume_token(19);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 16: {
                        value = this.NumberToken();
                        break block0;
                    }
                    case 8: {
                        str = this.CoreMapVarValue(env);
                        break block0;
                    }
                }
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (value != null) {
            str = value.image;
        }
        if (tok != null) {
            str = tok.image + str;
        }
        if (attr != null && str != null) {
            if (attributes.containsKey(attr.image)) {
                throw new Error("Attribute match already defined: " + attr.image);
            }
            attributes.put(attr.image, str);
        }
        return attributes;
    }

    public final NodePattern CoreMapWordPattern(Env env) throws ParseException {
        ArrayMap<String, String> attributes = new ArrayMap<String, String>();
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                value = this.jj_consume_token(18);
                break;
            }
            case 17: {
                value = this.jj_consume_token(17);
                break;
            }
            case 7: {
                value = this.jj_consume_token(7);
                break;
            }
            case 13: {
                value = this.jj_consume_token(13);
                break;
            }
            case 14: {
                value = this.jj_consume_token(14);
                break;
            }
            case 15: {
                value = this.jj_consume_token(15);
                break;
            }
            case 16: {
                value = this.jj_consume_token(16);
                break;
            }
            case 21: {
                value = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        attributes.put("word", value.image);
        CoreMapNodePattern pat = CoreMapNodePattern.valueOf(env, attributes);
        return pat;
    }

    public final MultiNodePattern MultiNodePattern(Env env) throws ParseException {
        int min = 1;
        int max = -1;
        boolean greedy = true;
        this.jj_consume_token(52);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                if (this.jj_2_34(3)) {
                    this.jj_consume_token(22);
                    Token v1 = this.jj_consume_token(13);
                    this.jj_consume_token(24);
                    min = Integer.parseInt(v1.image);
                    max = Integer.parseInt(v1.image);
                    break;
                }
                if (this.jj_2_35(4)) {
                    this.jj_consume_token(22);
                    Token v1 = this.jj_consume_token(13);
                    this.jj_consume_token(33);
                    this.jj_consume_token(24);
                    min = Integer.parseInt(v1.image);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        Token v1 = this.jj_consume_token(13);
                        this.jj_consume_token(33);
                        Token v2 = this.jj_consume_token(13);
                        this.jj_consume_token(24);
                        min = Integer.parseInt(v1.image);
                        max = Integer.parseInt(v2.image);
                        break block0;
                    }
                }
                this.jj_la1[59] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                greedy = false;
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        NodePattern pat = this.CoreMapWordPattern(env);
        MultiCoreMapNodePattern mp = new MultiCoreMapNodePattern(pat);
        mp.setMinNodes(min);
        mp.setMaxNodes(max);
        mp.setGreedyMatch(greedy);
        return mp;
    }

    public final String CoreMapVarValue(Env env) throws ParseException {
        Token value = null;
        value = this.jj_consume_token(8);
        return (String)env.get(value.image);
    }

    public final NodePattern CoreMapVarNodePattern(Env env) throws ParseException {
        Token value = null;
        value = this.jj_consume_token(8);
        return env.getNodePattern(value.image);
    }

    public final NodePattern CoreMapExprNodePattern(Env env) throws ParseException {
        Expression expr = null;
        expr = this.CondExpression(env);
        return new CoreMapExpressionNodePattern(env, expr);
    }

    public final Pair<SequencePattern.PatternExpr, SequenceMatchAction<CoreMap>> SeqRegexWithAction(Env env) throws ParseException {
        SequenceMatchAction<CoreMap> action = null;
        SequencePattern.PatternExpr expr = this.SeqRegex(env);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                action = this.Action(env);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        return new Pair<SequencePattern.PatternExpr, SequenceMatchAction<CoreMap>>(expr, action);
    }

    public final SequenceMatchAction<CoreMap> Action(Env env) throws ParseException {
        this.jj_consume_token(53);
        SequenceMatchAction<CoreMap> action = this.AnnotateAction(env);
        return action;
    }

    public final SequenceMatchAction<CoreMap> AnnotateAction(Env env) throws ParseException {
        this.jj_consume_token(54);
        this.jj_consume_token(25);
        Map<String, String> attributes = this.SetAttrValues(env);
        this.jj_consume_token(26);
        return new CoreMapSequenceMatchAction.AnnotateAction<CoreMap>(attributes);
    }

    public final Map<String, String> SetAttrValues(Env env) throws ParseException {
        ArrayMap<String, String> attributes = new ArrayMap<String, String>();
        this.jj_consume_token(22);
        this.SetAttrValue(env, attributes);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: 
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    break;
                }
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.SetAttrValue(env, attributes);
        }
        this.jj_consume_token(24);
        return attributes;
    }

    public final Map<String, String> SetAttrValue(Env env, Map<String, String> attributes) throws ParseException {
        Token attr = null;
        Token value = null;
        String str = null;
        attr = this.jj_consume_token(7);
        this.jj_consume_token(29);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 18: {
                value = this.RelaxedStringToken();
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                value = this.NumberToken();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (value != null) {
            str = value.image;
        }
        if (attr != null && str != null) {
            if (attributes.containsKey(attr.image)) {
                throw new Error("Attribute already defined: " + attr.image);
            }
            attributes.put(attr.image, str);
        }
        return attributes;
    }

    public final Token NumberToken() throws ParseException {
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                value = this.jj_consume_token(13);
                break;
            }
            case 14: {
                value = this.jj_consume_token(14);
                break;
            }
            case 16: {
                value = this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final Token IntegerToken() throws ParseException {
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                value = this.jj_consume_token(13);
                break;
            }
            case 14: {
                value = this.jj_consume_token(14);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final Token CmpToken() throws ParseException {
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                value = this.jj_consume_token(20);
                break;
            }
            case 19: {
                value = this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final Token RelaxedStringToken() throws ParseException {
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                value = this.jj_consume_token(18);
                break;
            }
            case 7: {
                value = this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String RelaxedString() throws ParseException {
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                value = this.jj_consume_token(18);
                return this.parseQuotedString(value.image);
            }
            case 7: {
                value = this.jj_consume_token(7);
                return value.image;
            }
        }
        this.jj_la1[70] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String RelaxedStringNoIdentifier() throws ParseException {
        Token value = null;
        value = this.jj_consume_token(18);
        return this.parseQuotedString(value.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    private boolean jj_3_14() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_16()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_129() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_51()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_60() {
        Token xsp;
        if (this.jj_3R_72()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_73());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_128() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_128()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_129()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_112() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_121()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_59()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(7)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_90() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_33() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(13)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(14)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(13)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(14)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(16)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_65()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_66()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_62() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(46)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(45)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(36)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(37)) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_87();
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_88()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_89()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_88() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_71() {
        Token xsp;
        if (this.jj_3R_87()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_107());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_80() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_3R_59()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_79() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_78() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_77() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_76() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_75()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_76()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_77()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_78()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_79()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_80()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_75() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_126() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(33)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(30)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_39() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3_28() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_124() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3_27() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_122() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_124()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_27()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_28()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_125()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_22() {
        Token xsp;
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_81());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_96() {
        return this.jj_3R_68();
    }

    private boolean jj_3R_115() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_95() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_117() {
        return this.jj_3R_118();
    }

    private boolean jj_3R_134() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_45() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_131() {
        return this.jj_3R_134();
    }

    private boolean jj_3R_106() {
        return this.jj_3R_114();
    }

    private boolean jj_3R_44() {
        return this.jj_3R_67();
    }

    private boolean jj_3R_105() {
        return this.jj_3R_113();
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_104() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_103() {
        return this.jj_3R_111();
    }

    private boolean jj_3R_74() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_102() {
        return this.jj_3R_110();
    }

    private boolean jj_3R_101() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_61() {
        Token xsp;
        if (this.jj_3R_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_74());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_101()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_102()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_103()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_104()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_105()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_106()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_117()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_120() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_87() {
        Token xsp;
        if (this.jj_3R_97()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_97());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_40() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_127() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3_35() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_133() {
        return this.jj_3R_134();
    }

    private boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_127()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_34() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_111() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_120()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_110();
    }

    private boolean jj_3_13() {
        return this.jj_3R_29();
    }

    private boolean jj_3_12() {
        return this.jj_3R_28();
    }

    private boolean jj_3_11() {
        return this.jj_3R_27();
    }

    private boolean jj_3_10() {
        return this.jj_3R_26();
    }

    private boolean jj_3_9() {
        return this.jj_3R_25();
    }

    private boolean jj_3_8() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_110() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(7)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(13)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(14)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(15)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(16)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(21)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_98() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_10()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_11()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_12()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_13()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_70() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_132() {
        return this.jj_3R_135();
    }

    private boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_71()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_98()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_38() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_58() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_133()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_57() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_56() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(7)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_131()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_21() {
        if (this.jj_3R_38()) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_48() {
        if (this.jj_3R_68()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_37() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_58()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_29() {
        Token xsp;
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_3R_48()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_48());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_59();
    }

    private boolean jj_3R_100() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_6()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_7()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_94() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_33() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_86() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_3R_96()) {
            return true;
        }
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_85() {
        return this.jj_3R_95();
    }

    private boolean jj_3_3() {
        return this.jj_3R_22();
    }

    private boolean jj_3_2() {
        return this.jj_3R_21();
    }

    private boolean jj_3_1() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_93() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(36)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(37)) {
                return true;
            }
        }
        return this.jj_3R_82();
    }

    private boolean jj_3R_69() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_84()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_85()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_86()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_94()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        Token xsp;
        if (this.jj_3R_82()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_83());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_54() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_3R_69();
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_92() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_3R_68()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_91() {
        return this.jj_3R_99();
    }

    private boolean jj_3R_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_91()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_92()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_32() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_36();
    }

    private boolean jj_3_26() {
        return this.jj_3R_24();
    }

    private boolean jj_3_31() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_30() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_34() {
        if (this.jj_3R_52()) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_31()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_32()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_25() {
        if (this.jj_3R_25()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_34()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_26()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_47() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(46)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(45)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(36)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(37)) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_55();
    }

    private boolean jj_3R_28() {
        Token xsp;
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_3R_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_47());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_36() {
        Token xsp;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_130());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_46() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_27() {
        Token xsp;
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_3R_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_46());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(26);
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3_23() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_23()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_24()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_21() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_24() {
        Token xsp;
        if (this.jj_3R_40()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_41());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3R_114() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_20()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_113() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_25() {
        Token xsp;
        if (this.jj_3R_42()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_43());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_116() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_116()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4194688, 0x40000000, 0, -2109214848, 38264832, 0x40000000, 0x40000000, 34070528, 384, 3968, 0, -2109214848, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0x180000, 33558400, 0, 0, 0x40000000, 33558400, 0, 0, 0, 385024, -2111311488, 0x400000, -2111311488, 0x800000, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, -2109341312, 0, 0, 0, 0, 0, 0, 4587904, 0x40000000, 0x40000000, 393344, 0x400000, 393344, 4587904, 393600, 90368, 524288, 2613376, 0x400000, 0x400000, 0, 0, 0x40000000, 0x40000000, 352384, 90112, 24576, 0x180000, 262272, 262272};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 2, 64, 0, 2, 2, 0, 0, 0, 2, 64, 8, 8, 8, 2, 2, 0, 0, 48, 48, 2, 0, 128, 256, 512, 0, 0x100000, 7168, 0x100000, 0, 7168, 0, 2048, 8224, 8224, 24624, 24624, 34816, 34816, 0, 196608, 8224, 8224, 16400, 16400, 24624, 24624, 196608, 2, 2, 0, 0, 0, 131072, 0, 0, 524292, 0, 0, 0, 2048, 0x200000, 2, 2, 0, 0, 0, 0, 0, 0};
    }

    public TokenSequenceParser(InputStream stream) {
        this(stream, null);
    }

    public TokenSequenceParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TokenSequenceParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TokenSequenceParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TokenSequenceParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TokenSequenceParser(TokenSequenceParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(TokenSequenceParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                JJCalls[] jJCallsArray = this.jj_2_rtns;
                int n = jJCallsArray.length;
                for (int i = 0; i < n; ++i) {
                    JJCalls jj_2_rtn;
                    JJCalls c = jj_2_rtn = jJCallsArray[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] jj_expentry1 : this.jj_expentries) {
                int[] oldentry = jj_expentry1;
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[55];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 71; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 55; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 35; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        TokenSequenceParser.jj_la1_init_0();
        TokenSequenceParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

