/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import java.util.Iterator;

public class NDArray<T>
implements Iterable<int[]> {
    private int[] dimensions;
    private T[] values;

    public NDArray(int[] dimensions) {
        for (int size : dimensions) {
            assert (size > 0);
        }
        this.dimensions = dimensions;
        this.values = new Object[this.combinatorialNeighborStatesCount()];
    }

    public void setAssignmentValue(int[] assignment, T value) {
        this.values[this.getTableAccessOffset((int[])assignment)] = value;
    }

    public T getAssignmentValue(int[] assignment) {
        return this.values[this.getTableAccessOffset(assignment)];
    }

    public int[] getDimensions() {
        return (int[])this.dimensions.clone();
    }

    @Override
    public Iterator<int[]> iterator() {
        return new Iterator<int[]>(){
            Iterator<int[]> unsafe;
            {
                this.unsafe = NDArray.this.fastPassByReferenceIterator();
            }

            @Override
            public boolean hasNext() {
                return this.unsafe.hasNext();
            }

            @Override
            public int[] next() {
                return (int[])this.unsafe.next().clone();
            }
        };
    }

    public Iterator<int[]> fastPassByReferenceIterator() {
        final int[] assignments = new int[this.dimensions.length];
        if (this.dimensions.length > 0) {
            assignments[0] = -1;
        }
        return new Iterator<int[]>(){

            @Override
            public boolean hasNext() {
                for (int i = 0; i < assignments.length; ++i) {
                    if (assignments[i] >= NDArray.this.dimensions[i] - 1) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int[] next() {
                assignments[0] = assignments[0] + 1;
                for (int i = 0; i < assignments.length && assignments[i] >= NDArray.this.dimensions[i]; ++i) {
                    assignments[i] = 0;
                    if (i >= assignments.length - 1) continue;
                    int n = i + 1;
                    assignments[n] = assignments[n] + 1;
                }
                return assignments;
            }
        };
    }

    public int combinatorialNeighborStatesCount() {
        int c = 1;
        for (int n : this.dimensions) {
            c *= n;
        }
        return c;
    }

    public NDArray<T> cloneArray() {
        NDArray<T> copy = new NDArray<T>((int[])this.dimensions.clone());
        copy.values = (Object[])this.values.clone();
        return copy;
    }

    private int getTableAccessOffset(int[] assignment) {
        assert (assignment.length == this.dimensions.length);
        int offset = 0;
        for (int i = 0; i < assignment.length; ++i) {
            assert (assignment[i] < this.dimensions[i]);
            offset = offset * this.dimensions[i] + assignment[i];
        }
        return offset;
    }
}

