/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.naturalli.NaturalLogicRelation;
import org.junit.Assert;
import org.junit.Test;

public class NaturalLogicRelationTest {
    @Test
    public void fixedIndex() {
        for (NaturalLogicRelation rel : NaturalLogicRelation.values()) {
            Assert.assertEquals((Object)((Object)rel), (Object)((Object)NaturalLogicRelation.byFixedIndex(rel.fixedIndex)));
        }
    }

    @Test
    public void spotTestJoinTable() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.COVER), (Object)((Object)NaturalLogicRelation.NEGATION.join(NaturalLogicRelation.FORWARD_ENTAILMENT)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)NaturalLogicRelation.ALTERNATION.join(NaturalLogicRelation.NEGATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)NaturalLogicRelation.COVER.join(NaturalLogicRelation.ALTERNATION)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.EQUIVALENT), (Object)((Object)NaturalLogicRelation.NEGATION.join(NaturalLogicRelation.NEGATION)));
        for (NaturalLogicRelation rel : NaturalLogicRelation.values()) {
            Assert.assertEquals((Object)((Object)rel), (Object)((Object)NaturalLogicRelation.EQUIVALENT.join(rel)));
            Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)NaturalLogicRelation.INDEPENDENCE.join(rel)));
            Assert.assertEquals((Object)((Object)NaturalLogicRelation.INDEPENDENCE), (Object)((Object)rel.join(NaturalLogicRelation.INDEPENDENCE)));
        }
    }

    @Test
    public void entailmentState() {
        Assert.assertTrue((boolean)NaturalLogicRelation.EQUIVALENT.maintainsTruth);
        Assert.assertTrue((boolean)NaturalLogicRelation.FORWARD_ENTAILMENT.maintainsTruth);
        Assert.assertTrue((boolean)NaturalLogicRelation.NEGATION.negatesTruth);
        Assert.assertTrue((boolean)NaturalLogicRelation.ALTERNATION.negatesTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.EQUIVALENT.negatesTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.FORWARD_ENTAILMENT.negatesTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.NEGATION.maintainsTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.ALTERNATION.maintainsTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.COVER.maintainsTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.COVER.negatesTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.INDEPENDENCE.maintainsTruth);
        Assert.assertFalse((boolean)NaturalLogicRelation.INDEPENDENCE.negatesTruth);
    }

    @Test
    public void someInsertionRelations() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyInsertion("quantmod")));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyInsertion("amod")));
    }

    @Test
    public void conjOrPeculiarities() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyInsertion("conj:or")));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyInsertion("conj:or", true)));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyInsertion("conj:or", false)));
    }

    @Test
    public void someDeletionRelations() {
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.REVERSE_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyDeletion("quantmod")));
        Assert.assertEquals((Object)((Object)NaturalLogicRelation.FORWARD_ENTAILMENT), (Object)((Object)NaturalLogicRelation.forDependencyDeletion("amod")));
    }
}

