/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.NaturalLogicWeights;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class NaturalLogicWeightsITest {
    private static Supplier<NaturalLogicWeights> weights = new Supplier<NaturalLogicWeights>(){
        NaturalLogicWeights weights = null;

        @Override
        public NaturalLogicWeights get() {
            if (this.weights == null) {
                try {
                    this.weights = new NaturalLogicWeights("edu/stanford/nlp/naturalli/", 0.3333333333333333);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return this.weights;
        }
    };

    private CoreLabel mockWord(String text) {
        CoreLabel word = new CoreLabel();
        word.setOriginalText(text);
        word.setWord(text);
        return word;
    }

    private Pair<SemanticGraphEdge, List<SemanticGraphEdge>> mkSegment(String root, Pair<String, String> ... outEdges) {
        IndexedWord rootVertex = new IndexedWord(this.mockWord(root));
        List edges = Arrays.asList(outEdges).stream().map(pair -> new SemanticGraphEdge(rootVertex, new IndexedWord(this.mockWord((String)pair.second)), GrammaticalRelation.valueOf(Language.English, (String)pair.first), Double.NEGATIVE_INFINITY, false)).collect(Collectors.toList());
        return Pair.makePair((SemanticGraphEdge)edges.get(0), edges);
    }

    @Test
    public void testLoadWeightsDoesntCrash() throws IOException {
        Assert.assertNotNull((Object)weights.get());
    }

    @Test
    public void testSomeSanityChecks() throws IOException {
        Pair<SemanticGraphEdge, List<SemanticGraphEdge>> spec = this.mkSegment("signed", Pair.makePair("prep_into", "law"), Pair.makePair("nsubj", "Obama"));
        Assert.assertTrue((0.5 > weights.get().deletionProbability((SemanticGraphEdge)spec.first, (Iterable)spec.second) ? 1 : 0) != 0);
        spec = this.mkSegment("threw", Pair.makePair("prep_at", "her"), Pair.makePair("nsubj", "he"), Pair.makePair("dobj", "ball"));
        Assert.assertTrue((0.5 < weights.get().deletionProbability((SemanticGraphEdge)spec.first, (Iterable)spec.second) ? 1 : 0) != 0);
    }
}

