/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class OpenIEITest {
    protected static StanfordCoreNLP pipeline = new StanfordCoreNLP(new Properties(){
        {
            this.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse,natlog,openie");
            this.setProperty("openie.splitter.threshold", "0.25");
            this.setProperty("openie.ignoreaffinity", "false");
            this.setProperty("openie.max_entailments_per_clause", "1000");
            this.setProperty("openie.triple.strict", "true");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
            this.setProperty("enforceRequirements", "true");
        }
    });

    public CoreMap annotate(String text) {
        Annotation ann = new Annotation(text);
        pipeline.annotate(ann);
        return (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
    }

    public void assertExtracted(String expected, String text) {
        boolean found = false;
        Collection extractions = (Collection)this.annotate(text).get(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
        for (RelationTriple extraction : extractions) {
            if (!extraction.toString().equals("1.0\t" + expected)) continue;
            found = true;
        }
        Assert.assertTrue((String)("The extraction (" + expected.replace("\t", "; ") + ") was not found in '" + text + "'"), (boolean)found);
    }

    public void assertExtracted(Set<String> expectedSet, String text) {
        Collection extractions = (Collection)this.annotate(text).get(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
        String actual = StringUtils.join(extractions.stream().map(x -> x.toString().substring(x.toString().indexOf("\t") + 1).toLowerCase()).sorted(), "\n");
        String expected = StringUtils.join(expectedSet.stream().map(String::toLowerCase).sorted(), "\n");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEntailed(String expected, String text) {
        boolean found = false;
        Collection extractions = (Collection)this.annotate(text).get(NaturalLogicAnnotations.EntailedSentencesAnnotation.class);
        for (SentenceFragment extraction : extractions) {
            if (!extraction.toString().equals(expected)) continue;
            found = true;
        }
        Assert.assertTrue((String)("The sentence '" + expected + "' was not entailed from '" + text + "'"), (boolean)found);
    }

    @Test
    public void testAnnotatorRuns() {
        this.annotate("all cats have tails");
    }

    @Test
    public void testBasicEntailments() {
        this.assertEntailed("some cats have tails", "some blue cats have tails");
        this.assertEntailed("blue cats have tails", "some blue cats have tails");
        this.assertEntailed("cats have tails", "some blue cats have tails");
    }

    @Test
    public void testBasicExtractions() {
        this.assertExtracted("cats\thave\ttails", "some cats have tails");
    }

    @Test
    public void testPaperExamples() {
        this.assertExtracted("cats\tis with\ttails", "There are cats with tails.");
        this.assertExtracted("IBM\thas\tresearch group", "IBM's research group.");
        this.assertExtracted("rabbits\teat\tvegetables", "All rabbits eat vegetables.");
    }

    @Test
    public void testOtherExamples() {
    }

    @Test
    public void testExtractionsGeorgeBoyd() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("George Boyd\tjoined on\t21 february 2013");
                this.add("George Boyd\tjoined for\tremainder");
                this.add("George Boyd\tjoined for\tremainder of season");
                this.add("George Boyd\tjoined on\tloan");
                this.add("George Boyd\tjoined from\tpeterborough united");
            }
        }, "On 21 February 2013 George Boyd joined on loan from Peterborough United for the remainder of the season.");
    }

    @Test
    public void testExtractionsObamaWikiOne() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("Barack Hussein Obama II\tis 44th and current President of\tUnited States");
                this.add("Barack Hussein Obama II\tis 44th President of\tUnited States");
                this.add("Barack Hussein Obama II\tis President of\tUnited States");
                this.add("Barack Hussein Obama II\tis\tPresident");
                this.add("Barack Hussein Obama II\tis\t44th President");
            }
        }, "Barack Hussein Obama II is the 44th and current President of the United States, and the first African American to hold the office.");
    }

    @Test
    @Ignore
    public void testExtractionsObamaWikiTwo() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("Obama\tis graduate of\tColumbia University");
                this.add("Obama\tborn in\tHawaii");
                this.add("Obama\tborn in\tHonolulu");
                this.add("he\tserved as\tpresident of Harvard Law Review");
                this.add("he\tserved as\tpresident");
                this.add("he\tpresident of\tHarvard Law Review");
                this.add("Obama\tis\tgraduate");
            }
        }, "Born in Honolulu, Hawaii, Obama is a graduate of Columbia University and Harvard Law School, where he served as president of the Harvard Law Review.");
    }

    @Test
    @Ignore
    public void testExtractionsObamaWikiThree() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("He\twas\tcommunity organizer in Chicago");
                this.add("He\twas\tcommunity organizer");
                this.add("He\tearning\this law degree");
                this.add("community organizer\tis in\tChicago");
            }
        }, "He was a community organizer in Chicago before earning his law degree.");
    }

    @Test
    public void testExtractionsObamaWikiFour() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("He\tworked as\tcivil rights attorney");
                this.add("He\tworked as\trights attorney");
                this.add("He\ttaught\tconstitutional law");
                this.add("He\ttaught\tlaw");
                this.add("He\ttaught law at\tUniversity of Chicago");
                this.add("He\ttaught law at_time\tLaw School");
                this.add("He\ttaught law at\tUniversity");
                this.add("He\ttaught law from\t1992 to 2004");
            }
        }, "He worked as a civil rights attorney and taught constitutional law at the University of Chicago Law School from 1992 to 2004.");
    }

    @Test
    public void testExtractionsObamaWikiFive() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("He\tserved\tthree terms");
                this.add("13th district\tis in\tIllinois Senate");
                this.add("He\trunning unsuccessfully for\tUnited States House of Representatives");
                this.add("He\trunning unsuccessfully for\tUnited States House");
                this.add("He\trunning for\tUnited States House of Representatives");
                this.add("He\trunning for\tUnited States House");
                this.add("He\trunning in\t2000");
                this.add("He\trunning unsuccessfully in\t2000");
            }
        }, "He served three terms representing the 13th District in the Illinois Senate from 1997 to 2004, running unsuccessfully for the United States House of Representatives in 2000.");
    }

    @Test
    public void testExtractionsObamaWikiSix() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("He\tdefeated\tRepublican nominee John McCain");
                this.add("He\tdefeated\tnominee John McCain");
                this.add("He\tdefeated nominee John McCain in\telection");
                this.add("He\tdefeated nominee John McCain in\tgeneral election");
                this.add("He\twas\tinaugurated as president on January 20 2009");
                this.add("He\twas inaugurated as\tpresident");
                this.add("He\twas\tinaugurated");
                this.add("He\twas inaugurated on\tJanuary 20 2009");
            }
        }, "He then defeated Republican nominee John McCain in the general election, and was inaugurated as president on January 20, 2009.");
    }

    @Test
    public void testThereIsNoDoubt() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("I\tam\tgreat");
            }
        }, "There is no doubt that I am great.");
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("cats\thave\ttails");
            }
        }, "There is no doubt that cats have tails.");
        this.assertExtracted((Set<String>)new HashSet<String>(){}, "There is doubt that cats have tails.");
    }

    @Test
    public void testChessIsNotAPhysicalSport() {
        this.assertExtracted((Set<String>)new HashSet<String>(){
            {
                this.add("Chess\tis\tphysical");
                this.add("Chess\tis\tphysical sport");
                this.add("Chess\tis\tsport");
            }
        }, "Chess is a physical sport");
        this.assertExtracted((Set<String>)new HashSet<String>(){}, "Chess is not a physical sport");
    }

    @Test
    public void dummyTest() {
        Assert.assertTrue((boolean)true);
    }
}

