/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class VerbTense
extends Enum<VerbTense> {
    public static final /* enum */ VerbTense INFINITIVE = new VerbTense(0);
    public static final /* enum */ VerbTense SINGULAR_PRESENT_FIRST_PERSON = new VerbTense(1);
    public static final /* enum */ VerbTense SINGULAR_PRESENT_SECOND_PERSON = new VerbTense(2);
    public static final /* enum */ VerbTense SINGULAR_PRESENT_THIRD_PERSON = new VerbTense(3);
    public static final /* enum */ VerbTense PRESENT_PLURAL = new VerbTense(4);
    public static final /* enum */ VerbTense PRESENT_PARTICIPLE = new VerbTense(5);
    public static final /* enum */ VerbTense SINGULAR_PAST_FIRST_PERSON = new VerbTense(6);
    public static final /* enum */ VerbTense SINGULAR_PAST_SECOND_PERSON = new VerbTense(7);
    public static final /* enum */ VerbTense SINGULAR_PAST_THIRD_PERSON = new VerbTense(8);
    public static final /* enum */ VerbTense PAST_PLURAL = new VerbTense(9);
    public static final /* enum */ VerbTense PAST = new VerbTense(10);
    public static final /* enum */ VerbTense PAST_PARTICIPLE = new VerbTense(11);
    private static final Lazy<Map<String, String[]>> ENGLISH_TENSES;
    private final int column;
    private static final /* synthetic */ VerbTense[] $VALUES;

    public static VerbTense[] values() {
        return (VerbTense[])$VALUES.clone();
    }

    public static VerbTense valueOf(String name) {
        return Enum.valueOf(VerbTense.class, name);
    }

    private VerbTense(int column) {
        this.column = column;
    }

    public static VerbTense of(boolean past, boolean plural, boolean participle, int person) {
        if (past) {
            if (plural) {
                return PAST_PLURAL;
            }
            if (participle) {
                return PAST_PARTICIPLE;
            }
            switch (person) {
                case 1: {
                    return SINGULAR_PAST_FIRST_PERSON;
                }
                case 2: {
                    return SINGULAR_PAST_SECOND_PERSON;
                }
            }
            return SINGULAR_PAST_THIRD_PERSON;
        }
        if (plural) {
            return PRESENT_PLURAL;
        }
        if (participle) {
            return PRESENT_PARTICIPLE;
        }
        switch (person) {
            case 1: {
                return SINGULAR_PRESENT_FIRST_PERSON;
            }
            case 2: {
                return SINGULAR_PRESENT_SECOND_PERSON;
            }
        }
        return SINGULAR_PRESENT_THIRD_PERSON;
    }

    public String conjugateEnglish(String lemma, boolean negated) {
        String[] data = ENGLISH_TENSES.get().get(lemma);
        if (data != null) {
            String conjugated = data[negated ? this.column + 12 : this.column];
            if (!"".equals(conjugated)) {
                return conjugated;
            }
            if (negated && !"".equals(conjugated = data[this.column])) {
                return conjugated;
            }
            conjugated = this.column >= 0 && this.column < 6 ? data[VerbTense.INFINITIVE.column] : data[VerbTense.PAST.column];
            if (!"".equals(conjugated)) {
                return conjugated;
            }
            return lemma;
        }
        return lemma;
    }

    public String conjugateEnglish(String lemma) {
        return this.conjugateEnglish(lemma, false);
    }

    public String conjugateEnglish(CoreLabel token, boolean negated) {
        return this.conjugateEnglish(Optional.ofNullable(token.lemma()).orElse(token.word()), negated);
    }

    public String conjugateEnglish(CoreLabel token) {
        return this.conjugateEnglish(Optional.ofNullable(token.lemma()).orElse(token.word()), false);
    }

    static {
        $VALUES = new VerbTense[]{INFINITIVE, SINGULAR_PRESENT_FIRST_PERSON, SINGULAR_PRESENT_SECOND_PERSON, SINGULAR_PRESENT_THIRD_PERSON, PRESENT_PLURAL, PRESENT_PARTICIPLE, SINGULAR_PAST_FIRST_PERSON, SINGULAR_PAST_SECOND_PERSON, SINGULAR_PAST_THIRD_PERSON, PAST_PLURAL, PAST, PAST_PARTICIPLE};
        ENGLISH_TENSES = Lazy.of(() -> {
            HashMap<String, String[]> tenseMap = new HashMap<String, String[]>();
            try (BufferedReader reader = IOUtils.readerFromString("edu/stanford/nlp/models/naturalli/conjugations_english.tab");){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] fields = StringUtils.splitOnChar(line, '\t');
                    assert (fields.length == 24);
                    tenseMap.put(fields[0], fields);
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            return Collections.unmodifiableMap(tenseMap);
        });
    }
}

