/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.DelimitRegExIterator;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DelimitRegExIteratorTest {
    private static final String[] testCases = new String[]{"@@123\nthis\nis\na\nsentence\n\n@@124\nThis\nis\nanother\n.\n\n@125\nThis\nis\nthe\nlast\n", "@@123\nthis\nis\na\nsentence\n\n@@124\nThis\nis\nanother\n.\n\n@125\nThis\nis\nthe\nlast\n"};
    private static final String[] delimiterCases = new String[]{"\n\n", "a|e"};
    private static final List[] answerCases = new List[]{Arrays.asList("@@123\nthis\nis\na\nsentence", "@@124\nThis\nis\nanother\n.", "@125\nThis\nis\nthe\nlast\n"), Arrays.asList("@@123\nthis\nis\n", "\ns", "nt", "nc", "\n\n@@124\nThis\nis\n", "noth", "r\n.\n\n@125\nThis\nis\nth", "\nl", "st\n")};

    @Test
    public void testFunctionality() {
        Assert.assertEquals((long)testCases.length, (long)delimiterCases.length);
        Assert.assertEquals((long)testCases.length, (long)answerCases.length);
        for (int i = 0; i < testCases.length; ++i) {
            String s = testCases[i];
            DelimitRegExIterator<String> di = DelimitRegExIterator.defaultDelimitRegExIterator(new StringReader(s), delimiterCases[i]);
            ArrayList<String> answer = new ArrayList<String>();
            while (di.hasNext()) {
                answer.add(di.next());
            }
            Assert.assertEquals((Object)answerCases[i], answer);
        }
    }
}

