/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.ScaledSGDMinimizer;
import edu.stanford.nlp.optimization.StochasticCalculateMethods;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.Objects;

public class SGDToQNMinimizer
implements Minimizer<DiffFunction>,
Serializable {
    private static Redwood.RedwoodChannels log = Redwood.channels(SGDToQNMinimizer.class);
    private static final long serialVersionUID = -7551807670291500396L;
    private final int bSize;
    private boolean quiet = false;
    public boolean outputIterationsToFile = false;
    public double gain = 0.1;
    public int SGDPasses = -1;
    public int QNPasses = -1;
    private final int hessSampleSize;
    private final int QNMem;

    public SGDToQNMinimizer(double SGDGain, int batchSize, int SGDPasses, int QNPasses) {
        this(SGDGain, batchSize, SGDPasses, QNPasses, 50, 10);
    }

    public SGDToQNMinimizer(double SGDGain, int batchSize, int sgdPasses, int qnPasses, int hessSamples, int QNMem) {
        this(SGDGain, batchSize, sgdPasses, qnPasses, hessSamples, QNMem, false);
    }

    public SGDToQNMinimizer(double SGDGain, int batchSize, int sgdPasses, int qnPasses, int hessSamples, int QNMem, boolean outputToFile) {
        this.gain = SGDGain;
        this.bSize = batchSize;
        this.SGDPasses = sgdPasses;
        this.QNPasses = qnPasses;
        this.hessSampleSize = hessSamples;
        this.QNMem = QNMem;
        this.outputIterationsToFile = outputToFile;
    }

    public void shutUp() {
        this.quiet = true;
    }

    protected String getName() {
        int g = (int)(this.gain * 1000.0);
        return "SGD2QN" + this.bSize + "_g" + g;
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial, int maxIterations) {
        this.sayln("SGDToQNMinimizer called on function of " + function.domainDimension() + " variables;");
        if (!(function instanceof AbstractStochasticCachingDiffFunction)) {
            throw new UnsupportedOperationException();
        }
        AbstractStochasticCachingDiffFunction dfunction = (AbstractStochasticCachingDiffFunction)function;
        dfunction.method = StochasticCalculateMethods.GradientOnly;
        ScaledSGDMinimizer sgd = new ScaledSGDMinimizer(this.gain, this.bSize, this.SGDPasses, 1, this.outputIterationsToFile);
        QNMinimizer qn = new QNMinimizer(this.QNMem, true);
        double[] x = sgd.minimize(dfunction, functionTolerance, initial, this.SGDPasses);
        QNMinimizer qNMinimizer = qn;
        Objects.requireNonNull(qNMinimizer);
        QNMinimizer.QNInfo qnInfo = qNMinimizer.new QNMinimizer.QNInfo(sgd.sList, sgd.yList);
        qnInfo.d = sgd.diag;
        qn.minimize(dfunction, functionTolerance, x, this.QNPasses, qnInfo);
        log.info("");
        log.info("Minimization complete.");
        log.info("");
        log.info("Exiting for Debug");
        return x;
    }

    private void sayln(String s) {
        if (!this.quiet) {
            log.info(s);
        }
    }

    private void say(String s) {
        if (!this.quiet) {
            log.info(s);
        }
    }
}

