/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.TestCase;

public class LexicalizedParserCharacterEncodingITest
extends TestCase {
    private static final String input = "caf\u00e9";
    private static final byte[] utf8Bytes = new byte[]{40, 82, 79, 79, 84, 10, 32, 32, 40, 78, 80, 32, 40, 78, 78, 80, 32, 99, 97, 102, -61, -87, 41, 41, 41, 10};
    private static final byte[] iso8859Bytes = new byte[]{40, 82, 79, 79, 84, 10, 32, 32, 40, 78, 80, 32, 40, 78, 78, 80, 32, 99, 97, 102, -23, 41, 41, 41, 10};
    private static final byte[] gb18030Bytes = new byte[]{40, 82, 79, 79, 84, 10, 32, 32, 40, 78, 80, 32, 40, 78, 78, 80, 32, 99, 97, 102, -88, -90, 41, 41, 41, 10};

    public void testCharEncodingUtf8() throws IOException {
        LexicalizedParserCharacterEncodingITest.tryCharEncoding("utf-8", utf8Bytes);
    }

    public void testCharEncodingIso8859() throws IOException {
        LexicalizedParserCharacterEncodingITest.tryCharEncoding("iso-8859-1", iso8859Bytes);
    }

    public void testCharEncodingGB18030() throws IOException {
        LexicalizedParserCharacterEncodingITest.tryCharEncoding("gb18030", gb18030Bytes);
    }

    private static void tryCharEncoding(String encoding, byte[] expected) throws IOException {
        int numRead;
        byte[] contents = new byte[128];
        File tmpInput = File.createTempFile("parser", null);
        PrintWriter pw = IOUtils.getPrintWriter(tmpInput, encoding);
        pw.println(input);
        pw.close();
        File tmpFile = File.createTempFile("parser", null);
        System.err.println("Sending output to " + tmpFile.getCanonicalPath());
        PrintStream ps = new PrintStream(tmpFile);
        System.setOut(ps);
        LexicalizedParser.main(new String[]{"-encoding", encoding, "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz", tmpInput.getCanonicalPath()});
        ps.close();
        FileInputStream is = new FileInputStream(tmpFile);
        int offset = 0;
        do {
            int length = contents.length - offset;
            numRead = ((InputStream)is).read(contents, offset, length);
            offset += numRead;
        } while (numRead > 0);
        ((InputStream)is).close();
        for (int i = 0; i < Math.min(expected.length, offset); ++i) {
            LexicalizedParserCharacterEncodingITest.assertEquals((String)("Byte " + i + " should be " + expected[i] + " but was " + contents[i] + "."), (byte)expected[i], (byte)contents[i]);
        }
        if (expected.length > offset) {
            System.err.println("First non-received byte was " + expected[offset]);
        }
        if (expected.length < offset) {
            System.err.println("First wrongly received byte was " + contents[expected.length]);
        }
        LexicalizedParserCharacterEncodingITest.assertEquals((String)("Was expecting " + expected.length + " bytes but got " + offset + " bytes."), (int)expected.length, (int)offset);
    }
}

