/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep.demo;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.List;
import java.util.Properties;

public class DependencyParserCoreNLPDemo {
    private static final Redwood.RedwoodChannels log = Redwood.channels(DependencyParserCoreNLPDemo.class);

    private DependencyParserCoreNLPDemo() {
    }

    public static void main(String[] args) {
        String text = args.length > 0 ? IOUtils.slurpFileNoExceptions(args[0], "utf-8") : "I can almost always tell when movies use fake dinosaurs.";
        Annotation ann = new Annotation(text);
        Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,depparse", "depparse.model", "edu/stanford/nlp/models/parser/nndep/english_UD.gz");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        ((AnnotationPipeline)pipeline).annotate(ann);
        for (CoreMap sent : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
            SemanticGraph sg = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            log.info(IOUtils.eolChar + sg.toString(SemanticGraph.OutputFormat.LIST));
        }
    }
}

