/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.CreateTransitionSequence;
import edu.stanford.nlp.parser.shiftreduce.FinalizeTransition;
import edu.stanford.nlp.parser.shiftreduce.ReorderingOracle;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class ReorderingOracleTest
extends TestCase {
    FinalizeTransition finalize = new FinalizeTransition(Collections.singleton("ROOT"));
    ShiftTransition shift = new ShiftTransition();
    BinaryTransition rightNP = new BinaryTransition("NP", BinaryTransition.Side.RIGHT);
    BinaryTransition tempRightNP = new BinaryTransition("@NP", BinaryTransition.Side.RIGHT);
    BinaryTransition leftNP = new BinaryTransition("NP", BinaryTransition.Side.LEFT);
    BinaryTransition tempLeftNP = new BinaryTransition("@NP", BinaryTransition.Side.LEFT);
    BinaryTransition rightVP = new BinaryTransition("VP", BinaryTransition.Side.RIGHT);
    BinaryTransition tempRightVP = new BinaryTransition("@VP", BinaryTransition.Side.RIGHT);
    BinaryTransition leftVP = new BinaryTransition("VP", BinaryTransition.Side.LEFT);
    BinaryTransition tempLeftVP = new BinaryTransition("@VP", BinaryTransition.Side.LEFT);
    BinaryTransition rightS = new BinaryTransition("S", BinaryTransition.Side.RIGHT);
    BinaryTransition tempRightS = new BinaryTransition("@S", BinaryTransition.Side.RIGHT);
    BinaryTransition leftS = new BinaryTransition("S", BinaryTransition.Side.LEFT);
    BinaryTransition tempLeftS = new BinaryTransition("@S", BinaryTransition.Side.LEFT);
    UnaryTransition unaryADVP = new UnaryTransition("ADVP", false);
    String[] WORDS = new String[]{"My", "dog", "also", "likes", "eating", "sausage"};
    String[] TAGS = new String[]{"PRP$", "NN", "RB", "VBZ", "VBZ", "NN"};
    List<TaggedWord> sentence = SentenceUtils.toTaggedList(Arrays.asList(this.WORDS), Arrays.asList(this.TAGS));
    Tree[] correctTrees = new Tree[]{Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))"), Tree.valueOf("(NP (NP (NN A) (NN B)) (NN C))"), Tree.valueOf("(ROOT (S (NP (PRP$ My) (JJ small) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))")};
    List<Tree> binarizedTrees;
    Tree[] incorrectShiftTrees = new Tree[]{Tree.valueOf("(ROOT (S (PRP$ My) (NN dog) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))"), Tree.valueOf("(NP (NN A) (NN B) (NN C))"), Tree.valueOf("(ROOT (S (PRP$ My) (JJ small) (NN dog) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))")};
    Debinarizer debinarizer = new Debinarizer(false);

    public void setUp() {
        Options op = new Options();
        MemoryTreebank treebank = op.tlpParams.memoryTreebank();
        treebank.addAll(Arrays.asList(this.correctTrees));
        this.binarizedTrees = ShiftReduceParser.binarizeTreebank(treebank, op);
    }

    public List<Transition> buildTransitionList(Transition ... transitions) {
        return Generics.newLinkedList(Arrays.asList(transitions));
    }

    public void testReorderIncorrectBinaryTransition() {
        List<Transition> transitions = this.buildTransitionList(this.shift, this.rightNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectBinaryTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.shift, this.unaryADVP, this.rightNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectBinaryTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.shift, this.rightNP, this.unaryADVP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectBinaryTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.rightVP, this.finalize), transitions);
    }

    public void testReorderIncorrectShiftResultingTree() {
        for (int testcase = 0; testcase < this.correctTrees.length; ++testcase) {
            int tnum;
            State state = ShiftReduceParser.initialStateFromGoldTagTree(this.correctTrees[testcase]);
            List<Transition> gold = CreateTransitionSequence.createTransitionSequence(this.binarizedTrees.get(testcase));
            for (tnum = 0; tnum < gold.size() && !(gold.get(tnum) instanceof BinaryTransition); ++tnum) {
                state = gold.get(tnum).apply(state);
            }
            state = this.shift.apply(state);
            LinkedList<Transition> reordered = Generics.newLinkedList(gold.subList(tnum, gold.size()));
            ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(reordered));
            for (Transition transition : reordered) {
                state = transition.apply(state);
            }
            Tree debinarized = this.debinarizer.transformTree(state.stack.peek());
            ReorderingOracleTest.assertEquals((String)this.incorrectShiftTrees[testcase].toString(), (String)debinarized.toString());
        }
    }

    public void testReorderIncorrectShift() {
        List<Transition> transitions = this.buildTransitionList(this.rightNP, this.shift, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.tempRightVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.rightNP, this.shift, this.shift, this.leftNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.leftNP, this.tempRightVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.rightNP, this.shift, this.unaryADVP, this.shift, this.leftNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.unaryADVP, this.shift, this.leftNP, this.tempRightVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.rightNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempRightVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.leftNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempRightVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.leftNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.leftVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempLeftVP, this.leftVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.rightNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.leftVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempLeftVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.leftNP, this.leftNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.rightVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempRightVP, this.tempRightVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.leftNP, this.rightNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.leftVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempLeftVP, this.tempLeftVP, this.rightVP, this.finalize), transitions);
        transitions = this.buildTransitionList(this.leftNP, this.leftNP, this.shift, this.shift, this.unaryADVP, this.leftNP, this.leftVP, this.finalize);
        ReorderingOracleTest.assertTrue((boolean)ReorderingOracle.reorderIncorrectShiftTransition(transitions));
        ReorderingOracleTest.assertEquals(this.buildTransitionList(this.shift, this.unaryADVP, this.leftNP, this.tempLeftVP, this.tempLeftVP, this.leftVP, this.finalize), transitions);
    }
}

