/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RegExFileFilter;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.ScorePatterns;
import edu.stanford.nlp.patterns.ScorePatternsFreqBased;
import edu.stanford.nlp.patterns.ScorePatternsRatioModifiedFreq;
import edu.stanford.nlp.patterns.ScorePhrases;
import edu.stanford.nlp.patterns.ScorePhrasesAverageFeatures;
import edu.stanford.nlp.patterns.SentenceIndex;
import edu.stanford.nlp.patterns.dep.DataInstanceDep;
import edu.stanford.nlp.patterns.surface.AnnotatedTextReader;
import edu.stanford.nlp.patterns.surface.CreatePatterns;
import edu.stanford.nlp.patterns.surface.LearnImportantFeatures;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.patterns.surface.ScorePatternsF1;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.sequences.IOBUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.EditDistance;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class GetPatternsFromDataMultiClass<E extends Pattern>
implements Serializable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(GetPatternsFromDataMultiClass.class);
    private static final long serialVersionUID = 1L;
    private PatternsForEachToken<E> patsForEachToken = null;
    public Map<String, Set<String>> wordsForOtherClass = null;
    private Map<String, Boolean> writtenPatInJustification = new HashMap<String, Boolean>();
    private Map<String, Counter<E>> learnedPatterns = new HashMap<String, Counter<E>>();
    private Map<String, Map<Integer, Counter<E>>> learnedPatternsEachIter = new HashMap<String, Map<Integer, Counter<E>>>();
    Map<String, Counter<CandidatePhrase>> matchedSeedWords = new HashMap<String, Counter<CandidatePhrase>>();
    public Map<String, TwoDimensionalCounter<CandidatePhrase, E>> wordsPatExtracted = new HashMap<String, TwoDimensionalCounter<CandidatePhrase, E>>();
    Properties props;
    public ScorePhrases scorePhrases;
    public ConstantsAndVariables constVars;
    public CreatePatterns createPats;
    private final DecimalFormat df = new DecimalFormat("#.##");
    private boolean notComputedAllPatternsYet = true;
    static StanfordCoreNLP pipeline = null;
    private static Function<CoreLabel, String> stringTransformationFunction = new Function<CoreLabel, String>(){

        @Override
        public String apply(CoreLabel l) {
            String s;
            if (PatternFactory.useLemmaContextTokens) {
                s = l.lemma();
                assert (s != null) : "Lemma is null and useLemmaContextTokens is true";
            } else {
                s = l.word();
            }
            if (ConstantsAndVariables.matchLowerCaseContext) {
                s = s.toLowerCase();
            }
            assert (s != null);
            return s;
        }
    };
    public Map<String, TwoDimensionalCounter<E, CandidatePhrase>> patternsandWords = null;
    public Map<String, Counter<E>> currentPatternWeights = null;
    private static AtomicInteger numCallsToCalStats = new AtomicInteger();
    public TwoDimensionalCounter<String, ConstantsAndVariables.ScorePhraseMeasures> phInPatScoresCache = new TwoDimensionalCounter();
    static Class[] printOptionClass = new Class[]{String.class, Boolean.class, Integer.class, Long.class, Double.class, Float.class};
    static int numIterationsLoadedModel = 0;

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Set<CandidatePhrase> seedSet, boolean labelUsingSeedSets, String answerLabel) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this(props, sents, seedSet, labelUsingSeedSets, PatternsAnnotations.PatternLabel1.class, answerLabel);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Set<CandidatePhrase> seedSet, boolean labelUsingSeedSets, Class answerClass, String answerLabel) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this.props = props;
        HashMap<String, Class<? extends TypesafeMap.Key<String>>> ansCl = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        ansCl.put(answerLabel, answerClass);
        HashMap<String, Class> generalizeClasses = new HashMap<String, Class>();
        HashMap<String, Map<Class, Object>> ignoreClasses = new HashMap<String, Map<Class, Object>>();
        ignoreClasses.put(answerLabel, new HashMap());
        HashMap<String, Set<CandidatePhrase>> seedSets = new HashMap<String, Set<CandidatePhrase>>();
        seedSets.put(answerLabel, seedSet);
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, ansCl, generalizeClasses, ignoreClasses);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Set<CandidatePhrase> seedSet, boolean labelUsingSeedSets, String answerLabel, Map<String, Class> generalizeClasses, Map<Class, Object> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this(props, sents, seedSet, labelUsingSeedSets, PatternsAnnotations.PatternLabel1.class, answerLabel, generalizeClasses, ignoreClasses);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Set<CandidatePhrase> seedSet, boolean labelUsingSeedSets, Class answerClass, String answerLabel, Map<String, Class> generalizeClasses, Map<Class, Object> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this.props = props;
        HashMap<String, Class<? extends TypesafeMap.Key<String>>> ansCl = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        ansCl.put(answerLabel, answerClass);
        HashMap<String, Map<Class, Object>> iC = new HashMap<String, Map<Class, Object>>();
        iC.put(answerLabel, ignoreClasses);
        HashMap<String, Set<CandidatePhrase>> seedSets = new HashMap<String, Set<CandidatePhrase>>();
        seedSets.put(answerLabel, seedSet);
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, ansCl, generalizeClasses, iC);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Map<String, Set<CandidatePhrase>> seedSets, boolean labelUsingSeedSets) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, InterruptedException, ExecutionException {
        this.props = props;
        HashMap<String, Class<? extends TypesafeMap.Key<String>>> ansCl = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        HashMap<String, Class> gC = new HashMap<String, Class>();
        HashMap<String, Map<Class, Object>> iC = new HashMap<String, Map<Class, Object>>();
        int i = 1;
        for (String label : seedSets.keySet()) {
            String ansclstr = "edu.stanford.nlp.patterns.PatternsAnnotations$PatternLabel" + i;
            ansCl.put(label, Class.forName(ansclstr));
            iC.put(label, new HashMap());
            ++i;
        }
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, ansCl, gC, iC);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Map<String, Set<CandidatePhrase>> seedSets, boolean labelUsingSeedSets, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this(props, sents, seedSets, labelUsingSeedSets, answerClass, new HashMap<String, Class>(), new HashMap<String, Map<Class, Object>>());
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, DataInstance> sents, Map<String, Set<CandidatePhrase>> seedSets, boolean labelUsingSeedSets, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this.props = props;
        if (ignoreClasses.isEmpty()) {
            for (String label : seedSets.keySet()) {
                ignoreClasses.put(label, new HashMap());
            }
        }
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, answerClass, generalizeClasses, ignoreClasses);
    }

    private void setUpConstructor(Map<String, DataInstance> sents, Map<String, Set<CandidatePhrase>> seedSets, boolean labelUsingSeedSets, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        Data.sents = sents;
        ArgumentParser.fillOptions(Data.class, this.props);
        ArgumentParser.fillOptions(ConstantsAndVariables.class, this.props);
        PatternFactory.setUp(this.props, PatternFactory.PatternType.valueOf(this.props.getProperty(Flags.patternType)), seedSets.keySet());
        this.constVars = new ConstantsAndVariables(this.props, seedSets, answerClass, generalizeClasses, ignoreClasses);
        if (this.constVars.writeMatchedTokensFiles && this.constVars.batchProcessSents) {
            throw new RuntimeException("writeMatchedTokensFiles and batchProcessSents cannot be true at the same time (not implemented; also doesn't make sense to save a large sentences json file)");
        }
        if (this.constVars.debug < 1) {
            Redwood.hideChannelsEverywhere(ConstantsAndVariables.minimaldebug);
        }
        if (this.constVars.debug < 2) {
            Redwood.hideChannelsEverywhere(new Object[]{Redwood.DBG});
        }
        this.constVars.justify = true;
        if (this.constVars.debug < 3) {
            this.constVars.justify = false;
        }
        if (this.constVars.debug < 4) {
            Redwood.hideChannelsEverywhere(ConstantsAndVariables.extremedebug);
        }
        Redwood.log(new Object[]{Redwood.DBG, "Running with debug output"});
        Redwood.log(ConstantsAndVariables.extremedebug, "Running with extreme debug output");
        this.wordsPatExtracted = new HashMap<String, TwoDimensionalCounter<CandidatePhrase, E>>();
        for (String label : answerClass.keySet()) {
            this.wordsPatExtracted.put(label, new TwoDimensionalCounter());
        }
        this.scorePhrases = new ScorePhrases(this.props, this.constVars);
        this.createPats = new CreatePatterns(this.props, this.constVars);
        assert (!this.constVars.doNotApplyPatterns || !PatternFactory.useStopWordsBeforeTerm && PatternFactory.numWordsCompoundMax <= 1) : " Cannot have both doNotApplyPatterns and (useStopWordsBeforeTerm true or numWordsCompound > 1)!";
        if (this.constVars.invertedIndexDirectory == null) {
            File f = File.createTempFile("inv", "index");
            f.deleteOnExit();
            f.mkdir();
            this.constVars.invertedIndexDirectory = f.getAbsolutePath();
        }
        Set<String> extremelySmallStopWordsList = CollectionUtils.asSet(".", ",", "in", "on", "of", "a", "the", "an");
        Function<CoreLabel, Map<String, String>> transformCoreLabelToString = l -> {
            HashMap<String, String> add = new HashMap<String, String>();
            GetPatternsFromDataMultiClass getPatternsFromDataMultiClass = this;
            for (Class gn : getPatternsFromDataMultiClass.constVars.getGeneralizeClasses().values()) {
                Object b = l.get(gn);
                if (b == null) continue;
                if (b.toString().equals(ConstantsAndVariables.backgroundSymbol)) continue;
                add.put(Token.getKeyForClass(gn), b.toString());
            }
            return add;
        };
        boolean createIndex = false;
        if (this.constVars.loadInvertedIndex) {
            this.constVars.invertedIndex = SentenceIndex.loadIndex(this.constVars.invertedIndexClass, this.props, extremelySmallStopWordsList, this.constVars.invertedIndexDirectory, transformCoreLabelToString);
        } else {
            this.constVars.invertedIndex = SentenceIndex.createIndex(this.constVars.invertedIndexClass, null, this.props, extremelySmallStopWordsList, this.constVars.invertedIndexDirectory, transformCoreLabelToString);
            createIndex = true;
        }
        int totalNumSents = 0;
        boolean computeDataFreq = false;
        if (Data.rawFreq == null) {
            Data.rawFreq = new ClassicCounter<CandidatePhrase>();
            computeDataFreq = true;
        }
        ConstantsAndVariables.DataSentsIterator iter = new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents);
        while (iter.hasNext()) {
            Object sentsIter = iter.next();
            Map sentsf = (Map)((Pair)sentsIter).first();
            if (this.constVars.batchProcessSents) {
                for (Map.Entry en : sentsf.entrySet()) {
                    Data.sentId2File.put((String)en.getKey(), (File)((Pair)sentsIter).second());
                }
            }
            totalNumSents += sentsf.size();
            if (computeDataFreq) {
                Data.computeRawFreqIfNull(sentsf, PatternFactory.numWordsCompoundMax);
            }
            Redwood.log(new Object[]{Redwood.DBG, "Initializing sents size " + sentsf.size() + " sentences, either by labeling with the seed set or just setting the right classes"});
            for (String l2 : this.constVars.getAnswerClass().keySet()) {
                HashSet<CandidatePhrase> seed;
                Redwood.log(new Object[]{Redwood.DBG, "labelUsingSeedSets is " + labelUsingSeedSets + " and seed set size for " + l2 + " is " + (seedSets == null ? "null" : Integer.valueOf(seedSets.get(l2).size()))});
                Set<CandidatePhrase> set = seedSets == null || !labelUsingSeedSets ? new HashSet<CandidatePhrase>() : (seed = seedSets.containsKey(l2) ? seedSets.get(l2) : new HashSet<CandidatePhrase>());
                if (!this.matchedSeedWords.containsKey(l2)) {
                    this.matchedSeedWords.put(l2, new ClassicCounter());
                }
                Counter<CandidatePhrase> matched = GetPatternsFromDataMultiClass.runLabelSeedWords(sentsf, this.constVars.getAnswerClass().get(l2), l2, seed, this.constVars, labelUsingSeedSets);
                System.out.println("matched phrases for " + l2 + " is " + matched);
                this.matchedSeedWords.get(l2).addAll(matched);
                if (!this.constVars.addIndvWordsFromPhrasesExceptLastAsNeg) continue;
                Redwood.log(ConstantsAndVariables.minimaldebug, "adding indv words from phrases except last as neg");
                HashSet<CandidatePhrase> otherseed = new HashSet<CandidatePhrase>();
                if (labelUsingSeedSets) {
                    for (CandidatePhrase candidatePhrase : seed) {
                        String[] t = candidatePhrase.getPhrase().split("\\s+");
                        for (int i = 0; i < t.length - 1; ++i) {
                            if (seed.contains(t[i])) continue;
                            otherseed.add(CandidatePhrase.createOrGet(t[i]));
                        }
                    }
                }
                GetPatternsFromDataMultiClass.runLabelSeedWords(sentsf, PatternsAnnotations.OtherSemanticLabel.class, "OTHERSEM", otherseed, this.constVars, labelUsingSeedSets);
            }
            if (labelUsingSeedSets && this.constVars.getOtherSemanticClassesWords() != null) {
                String l3 = "OTHERSEM";
                if (!this.matchedSeedWords.containsKey(l3)) {
                    this.matchedSeedWords.put(l3, new ClassicCounter());
                }
                this.matchedSeedWords.get(l3).addAll(GetPatternsFromDataMultiClass.runLabelSeedWords(sentsf, PatternsAnnotations.OtherSemanticLabel.class, l3, this.constVars.getOtherSemanticClassesWords(), this.constVars, labelUsingSeedSets));
            }
            if (this.constVars.removeOverLappingLabelsFromSeed) {
                this.removeOverLappingLabels(sentsf);
            }
            if (createIndex) {
                this.constVars.invertedIndex.add(sentsf, true);
            }
            if (!((File)((Pair)sentsIter).second()).exists()) continue;
            Redwood.log(new Object[]{Redwood.DBG, "Saving the labeled seed sents (if given the option) to the same file " + ((Pair)sentsIter).second()});
            IOUtils.writeObjectToFile((Object)sentsf, (File)((Pair)sentsIter).second());
        }
        Redwood.log(new Object[]{Redwood.DBG, "Done loading/creating inverted index of tokens and labeling data with total of " + this.constVars.invertedIndex.size() + " sentences"});
        if (this.scorePhrases.phraseScorerClass.equals(ScorePhrasesAverageFeatures.class) && (this.constVars.usePatternEvalWordClass || this.constVars.usePhraseEvalWordClass)) {
            if (this.constVars.externalFeatureWeightsDir == null) {
                File f = File.createTempFile("tempfeat", ".txt");
                f.delete();
                f.deleteOnExit();
                this.constVars.externalFeatureWeightsDir = f.getAbsolutePath();
            }
            IOUtils.ensureDir(new File(this.constVars.externalFeatureWeightsDir));
            for (String label : seedSets.keySet()) {
                String externalFeatureWeightsFileLabel = this.constVars.externalFeatureWeightsDir + "/" + label;
                File f = new File(externalFeatureWeightsFileLabel);
                if (!f.exists()) {
                    Redwood.log(new Object[]{Redwood.DBG, "externalweightsfile for the label " + label + " does not exist: learning weights!"});
                    LearnImportantFeatures lmf = new LearnImportantFeatures();
                    ArgumentParser.fillOptions((Object)lmf, this.props);
                    lmf.answerClass = answerClass.get(label);
                    lmf.answerLabel = label;
                    lmf.setUp();
                    lmf.getTopFeatures(new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents), this.constVars.perSelectRand, this.constVars.perSelectNeg, externalFeatureWeightsFileLabel);
                }
                ClassicCounter distSimWeightsLabel = new ClassicCounter();
                for (String line : IOUtils.readLines(externalFeatureWeightsFileLabel)) {
                    String[] t = line.split(":");
                    if (!t[0].startsWith("Cluster")) continue;
                    String string = t[0].replace("Cluster-", "");
                    Integer clusterNum = Integer.parseInt(string);
                    distSimWeightsLabel.setCount(clusterNum, Double.parseDouble(t[1]));
                }
                this.constVars.distSimWeights.put(label, distSimWeightsLabel);
            }
        }
        if (this.constVars.usePatternEvalSemanticOdds || this.constVars.usePhraseEvalSemanticOdds) {
            Counter dictOddsWeightsLabel = new ClassicCounter();
            Counter<CandidatePhrase> otherSemanticClassFreq = new ClassicCounter();
            for (CandidatePhrase s : this.constVars.getOtherSemanticClassesWords()) {
                for (String s1 : StringUtils.getNgrams(Arrays.asList(s.getPhrase().split("\\s+")), 1, PatternFactory.numWordsCompoundMax)) {
                    otherSemanticClassFreq.incrementCount(CandidatePhrase.createOrGet(s1));
                }
            }
            otherSemanticClassFreq = Counters.add(otherSemanticClassFreq, 1.0);
            HashMap labelDictNgram = new HashMap();
            for (String label : seedSets.keySet()) {
                Counter<CandidatePhrase> classFreq = new ClassicCounter();
                for (CandidatePhrase s : seedSets.get(label)) {
                    for (String s1 : StringUtils.getNgrams(Arrays.asList(s.getPhrase().split("\\s+")), 1, PatternFactory.numWordsCompoundMax)) {
                        classFreq.incrementCount(CandidatePhrase.createOrGet(s1));
                    }
                }
                classFreq = Counters.add(classFreq, 1.0);
                labelDictNgram.put(label, classFreq);
            }
            for (String label : seedSets.keySet()) {
                ClassicCounter<CandidatePhrase> otherLabelFreq = new ClassicCounter<CandidatePhrase>();
                for (String label2 : seedSets.keySet()) {
                    if (label.equals(label2)) continue;
                    otherLabelFreq.addAll((Counter)labelDictNgram.get(label2));
                }
                otherLabelFreq.addAll(otherSemanticClassFreq);
                dictOddsWeightsLabel = Counters.divisionNonNaN((Counter)labelDictNgram.get(label), otherLabelFreq);
                this.constVars.dictOddsWeights.put(label, dictOddsWeightsLabel);
            }
        }
    }

    public PatternsForEachToken getPatsForEachToken() {
        return this.patsForEachToken;
    }

    private void removeOverLappingLabels(Map<String, DataInstance> sents) {
        for (Map.Entry<String, DataInstance> sentEn : sents.entrySet()) {
            for (CoreLabel l : sentEn.getValue().getTokens()) {
                Map longestMatchingMap = (Map)l.get(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class);
                String longestMatchingString = "";
                String longestMatchingLabel = null;
                for (Map.Entry entry : longestMatchingMap.entrySet()) {
                    if (((CandidatePhrase)entry.getValue()).getPhrase().length() <= longestMatchingString.length()) continue;
                    longestMatchingLabel = (String)entry.getKey();
                    longestMatchingString = ((CandidatePhrase)entry.getValue()).getPhrase();
                }
                if (longestMatchingLabel == null) continue;
                if (!"OTHERSEM".equals(longestMatchingLabel)) {
                    l.set(PatternsAnnotations.OtherSemanticLabel.class, ConstantsAndVariables.backgroundSymbol);
                }
                for (Map.Entry<Object, Object> entry : this.constVars.getAnswerClass().entrySet()) {
                    if (!((String)entry.getKey()).equals(longestMatchingLabel)) {
                        l.set((Class)entry.getValue(), ConstantsAndVariables.backgroundSymbol);
                        continue;
                    }
                    l.set((Class)entry.getValue(), (String)entry.getKey());
                }
            }
        }
    }

    public static Map<String, DataInstance> runPOSNERParseOnTokens(Map<String, DataInstance> sents, Properties propsoriginal) {
        PatternFactory.PatternType type = PatternFactory.PatternType.valueOf(propsoriginal.getProperty(Flags.patternType));
        Properties props = new Properties();
        ArrayList<String> anns = new ArrayList<String>();
        anns.add("pos");
        anns.add("lemma");
        boolean useTargetParserParentRestriction = Boolean.parseBoolean(propsoriginal.getProperty(Flags.useTargetParserParentRestriction));
        boolean useTargetNERRestriction = Boolean.parseBoolean(propsoriginal.getProperty(Flags.useTargetNERRestriction));
        String posModelPath = props.getProperty(Flags.posModelPath);
        String numThreads = propsoriginal.getProperty(Flags.numThreads);
        if (useTargetParserParentRestriction) {
            anns.add("parse");
        } else if (type.equals((Object)PatternFactory.PatternType.DEP)) {
            anns.add("depparse");
        }
        if (useTargetNERRestriction) {
            anns.add("ner");
        }
        props.setProperty("annotators", StringUtils.join(anns, ","));
        props.setProperty("parse.maxlen", "80");
        props.setProperty("nthreads", numThreads);
        props.setProperty("threads", numThreads);
        if (posModelPath != null) {
            props.setProperty("pos.model", posModelPath);
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props, false);
        Redwood.log(new Object[]{Redwood.DBG, "Annotating text"});
        for (Map.Entry<String, DataInstance> en : sents.entrySet()) {
            ArrayList<CoreMap> temp = new ArrayList<CoreMap>();
            ArrayCoreMap s = new ArrayCoreMap();
            s.set(CoreAnnotations.TokensAnnotation.class, en.getValue().getTokens());
            temp.add(s);
            Annotation doc = new Annotation(temp);
            try {
                pipeline.annotate(doc);
                if (!useTargetParserParentRestriction) continue;
                GetPatternsFromDataMultiClass.inferParentParseTag((Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class));
            }
            catch (Exception e) {
                log.warn("Ignoring error: for sentence  " + StringUtils.joinWords(en.getValue().getTokens(), " "));
                log.warn(e);
            }
        }
        Redwood.log(new Object[]{Redwood.DBG, "Done annotating text"});
        return sents;
    }

    public static Map<String, DataInstance> runPOSNEROnTokens(List<CoreMap> sentsCM, String posModelPath, boolean useTargetNERRestriction, String prefix, boolean useTargetParserParentRestriction, String numThreads, PatternFactory.PatternType type) {
        Annotation doc = new Annotation(sentsCM);
        Properties props = new Properties();
        ArrayList<String> anns = new ArrayList<String>();
        anns.add("pos");
        anns.add("lemma");
        if (useTargetParserParentRestriction) {
            anns.add("parse");
        } else if (type.equals((Object)PatternFactory.PatternType.DEP)) {
            anns.add("depparse");
        }
        if (useTargetNERRestriction) {
            anns.add("ner");
        }
        props.setProperty("annotators", StringUtils.join(anns, ","));
        props.setProperty("parse.maxlen", "80");
        props.setProperty("nthreads", numThreads);
        props.setProperty("threads", numThreads);
        if (posModelPath != null) {
            props.setProperty("pos.model", posModelPath);
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props, false);
        Redwood.log(new Object[]{Redwood.DBG, "Annotating text"});
        pipeline.annotate(doc);
        Redwood.log(new Object[]{Redwood.DBG, "Done annotating text"});
        HashMap<String, DataInstance> sents = new HashMap<String, DataInstance>();
        for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            if (useTargetParserParentRestriction) {
                GetPatternsFromDataMultiClass.inferParentParseTag((Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class));
            }
            DataInstance d = DataInstance.getNewInstance(type, s);
            sents.put(prefix + (String)s.get(CoreAnnotations.DocIDAnnotation.class), d);
        }
        return sents;
    }

    public static int tokenize(Iterator<String> textReader, String posModelPath, boolean lowercase, boolean useTargetNERRestriction, String sentIDPrefix, boolean useTargetParserParentRestriction, String numThreads, boolean batchProcessSents, int numMaxSentencesPerBatchFile, File saveSentencesSerDirFile, Map<String, DataInstance> sents, int numFilesTillNow, PatternFactory.PatternType type) throws InterruptedException, ExecutionException, IOException {
        if (pipeline == null) {
            Properties props = new Properties();
            ArrayList<String> anns = new ArrayList<String>();
            anns.add("tokenize");
            anns.add("ssplit");
            anns.add("pos");
            anns.add("lemma");
            if (useTargetParserParentRestriction) {
                anns.add("parse");
            }
            if (type.equals((Object)PatternFactory.PatternType.DEP)) {
                anns.add("depparse");
            }
            if (useTargetNERRestriction) {
                anns.add("ner");
            }
            props.setProperty("annotators", StringUtils.join(anns, ","));
            props.setProperty("parse.maxlen", "80");
            if (numThreads != null) {
                props.setProperty("threads", numThreads);
            }
            props.setProperty("tokenize.options", "ptb3Escaping=false,normalizeParentheses=false,escapeForwardSlashAsterisk=false");
            if (posModelPath != null) {
                props.setProperty("pos.model", posModelPath);
            }
            pipeline = new StanfordCoreNLP(props);
        }
        String text = "";
        int numLines = 0;
        while (textReader.hasNext()) {
            String line = textReader.next();
            if (batchProcessSents && ++numLines > numMaxSentencesPerBatchFile) break;
            if (lowercase) {
                line = line.toLowerCase();
            }
            text = text + line + "\n";
        }
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        int i = -1;
        for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            ++i;
            if (useTargetParserParentRestriction) {
                GetPatternsFromDataMultiClass.inferParentParseTag((Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class));
            }
            DataInstance d = DataInstance.getNewInstance(type, s);
            sents.put(sentIDPrefix + i, d);
        }
        Redwood.log(new Object[]{Redwood.DBG, "Done annotating text with " + i + " sentences"});
        if (sents.size() > 0 && batchProcessSents) {
            File file = new File(saveSentencesSerDirFile + "/sents_" + ++numFilesTillNow);
            IOUtils.writeObjectToFile(sents, file);
            Data.sentsFiles.add(file);
            for (String sentid : sents.keySet()) {
                assert (!Data.sentId2File.containsKey(sentid)) : "Data.sentId2File already contains " + sentid + ". Make sure sentIds are unique!";
                Data.sentId2File.put(sentid, file);
            }
            sents.clear();
        }
        if (batchProcessSents) {
            sents = null;
        }
        return numFilesTillNow;
    }

    private static void inferParentParseTag(Tree tree) {
        String grandstr = tree.value();
        for (Tree child : tree.children()) {
            for (Tree grand : child.children()) {
                if (!grand.isLeaf()) continue;
                ((CoreLabel)grand.label()).set(CoreAnnotations.GrandparentAnnotation.class, grandstr);
            }
            GetPatternsFromDataMultiClass.inferParentParseTag(child);
        }
    }

    public static List<Integer> getSubListIndex(String[] l1, String[] l2, String[] subl2, Set<String> doNotLabelTheseWords, HashSet<String> seenFuzzyMatches, int minLen4Fuzzy, boolean fuzzyMatch, boolean ignoreCaseSeedMatch) {
        if (l1.length > l2.length) {
            return null;
        }
        EditDistance editDistance = new EditDistance(true);
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        boolean matched = false;
        int index = -1;
        int lastUnmatchedIndex = 0;
        int i = 0;
        while (i < l2.length) {
            int j = 0;
            while (j < l1.length) {
                boolean d1 = false;
                boolean d2 = false;
                boolean compareFuzzy = true;
                if (!fuzzyMatch || doNotLabelTheseWords.contains(l2[i]) || doNotLabelTheseWords.contains(subl2[i]) || l2[i].length() <= minLen4Fuzzy || subl2[i].length() <= minLen4Fuzzy) {
                    compareFuzzy = false;
                }
                if (!compareFuzzy || l1[j].length() <= minLen4Fuzzy) {
                    boolean bl = d1 = ignoreCaseSeedMatch && l1[j].equalsIgnoreCase(l2[i]) || l1[j].equals(l2[i]);
                    if (!d1 && fuzzyMatch) {
                        d2 = ignoreCaseSeedMatch && subl2[i].equalsIgnoreCase(l1[j]) || subl2[i].equals(l1[j]);
                    }
                } else {
                    String combo = l1[j] + "#" + l2[i];
                    if (ignoreCaseSeedMatch && l1[j].equalsIgnoreCase(l2[i]) || l1[j].equals(l2[i]) || seenFuzzyMatches.contains(combo)) {
                        d1 = true;
                    } else {
                        boolean bl = d1 = editDistance.score(l1[j], l2[i]) <= 1.0;
                        if (!d1) {
                            String combo2 = l1[j] + "#" + subl2[i];
                            if (ignoreCaseSeedMatch && l1[j].equalsIgnoreCase(subl2[i]) || l1[j].equals(subl2[i]) || seenFuzzyMatches.contains(combo2)) {
                                d2 = true;
                            } else {
                                boolean bl2 = d2 = editDistance.score(l1[j], subl2[i]) <= 1.0;
                                if (d2) {
                                    seenFuzzyMatches.add(combo2);
                                }
                            }
                        } else if (d1) {
                            seenFuzzyMatches.add(combo);
                        }
                    }
                }
                if (d1 || d2) {
                    index = i++;
                    if (++j == l1.length) {
                        matched = true;
                        break;
                    }
                } else {
                    j = 0;
                    lastUnmatchedIndex = i = lastUnmatchedIndex + 1;
                    index = -1;
                    if (lastUnmatchedIndex == l2.length) break;
                }
                if (i < l2.length) continue;
                index = -1;
                break;
            }
            if (i != l2.length && !matched) continue;
            if (index >= 0) {
                allIndices.add(index - l1.length + 1);
            }
            matched = false;
            lastUnmatchedIndex = index;
        }
        return allIndices;
    }

    public static <E> List<List<E>> getThreadBatches(List<E> keyset, int numThreads) {
        int num = numThreads == 1 ? keyset.size() : keyset.size() / (numThreads - 1);
        Redwood.log(ConstantsAndVariables.extremedebug, "keyset size is " + keyset.size());
        ArrayList<List<List<E>>> threadedSentIds = new ArrayList<List<List<E>>>();
        for (int i = 0; i < numThreads; ++i) {
            List<E> keys = keyset.subList(i * num, Math.min(keyset.size(), (i + 1) * num));
            threadedSentIds.add(keys);
            Redwood.log(ConstantsAndVariables.extremedebug, "assigning from " + i * num + " till " + Math.min(keyset.size(), (i + 1) * num));
        }
        return threadedSentIds;
    }

    public static Counter<CandidatePhrase> runLabelSeedWords(Map<String, DataInstance> sents, Class answerclass, String label, Collection<CandidatePhrase> seedWords, ConstantsAndVariables constVars, boolean overwriteExistingLabels) throws InterruptedException, ExecutionException, IOException {
        Redwood.log(new Object[]{Redwood.DBG, "ignoreCaseSeedMatch is " + constVars.ignoreCaseSeedMatch});
        List<List<String>> threadedSentIds = GetPatternsFromDataMultiClass.getThreadBatches(new ArrayList<String>(sents.keySet()), constVars.numThreads);
        ExecutorService executor = Executors.newFixedThreadPool(constVars.numThreads);
        ArrayList list = new ArrayList();
        ClassicCounter<CandidatePhrase> matchedPhrasesCounter = new ClassicCounter<CandidatePhrase>();
        for (List<String> keys : threadedSentIds) {
            LabelWithSeedWords task = new LabelWithSeedWords(seedWords, sents, keys, answerclass, label, constVars.fuzzyMatch, constVars.minLen4FuzzyForPattern, ConstantsAndVariables.backgroundSymbol, constVars.getEnglishWords(), stringTransformationFunction, constVars.writeMatchedTokensIdsForEachPhrase, overwriteExistingLabels, constVars.patternType, constVars.ignoreCaseSeedMatch);
            Pair<Map<String, DataInstance>, Counter<CandidatePhrase>> sentsi = executor.submit(task).get();
            sents.putAll(sentsi.first());
            matchedPhrasesCounter.addAll(sentsi.second());
        }
        executor.shutdown();
        Redwood.log("extremedebug", "Matched phrases freq is " + matchedPhrasesCounter);
        return matchedPhrasesCounter;
    }

    public static void getFeatures(SemanticGraph graph, IndexedWord vertex, boolean isHead, Collection<String> features, GrammaticalRelation reln) {
        if (isHead) {
            List<Pair<GrammaticalRelation, IndexedWord>> pt = graph.parentPairs(vertex);
            for (Pair<GrammaticalRelation, IndexedWord> en : pt) {
                features.add("PARENTREL-" + en.first());
            }
        } else {
            List<SemanticGraphEdge> parents;
            if (reln == null && (parents = graph.getOutEdgesSorted(vertex)).size() > 0) {
                reln = parents.get(0).getRelation();
            }
            if (reln != null) {
                features.add("REL-" + reln.getShortName());
            }
        }
    }

    private static void addToMatchedTokensByPhrase(String ph, String sentid, int index, int length) {
        Map<String, List<Integer>> matcheds;
        if (!Data.matchedTokensForEachPhrase.containsKey(ph)) {
            Data.matchedTokensForEachPhrase.put(ph, new HashMap());
        }
        if (!(matcheds = Data.matchedTokensForEachPhrase.get(ph)).containsKey(sentid)) {
            matcheds.put(sentid, new ArrayList());
        }
        for (int i = 0; i < length; ++i) {
            matcheds.get(sentid).add(index + i);
        }
    }

    public void processSents(Map<String, DataInstance> sents, Boolean deleteExistingIndex) throws IOException, ClassNotFoundException {
        if (this.constVars.computeAllPatterns) {
            this.props.setProperty("createTable", deleteExistingIndex.toString());
            this.props.setProperty("deleteExisting", deleteExistingIndex.toString());
            this.props.setProperty("createPatLuceneIndex", deleteExistingIndex.toString());
            Redwood.log(new Object[]{Redwood.DBG, "Computing all patterns"});
            this.createPats.getAllPatterns(sents, this.props, this.constVars.storePatsForEachToken);
        } else {
            Redwood.log(new Object[]{Redwood.DBG, "Reading patterns from existing dir"});
        }
        this.props.setProperty("createTable", "false");
        this.props.setProperty("deleteExisting", "false");
        this.props.setProperty("createPatLuceneIndex", "false");
    }

    private void readSavedPatternsAndIndex() throws IOException, ClassNotFoundException {
        if (!this.constVars.computeAllPatterns) {
            assert (this.constVars.allPatternsDir != null) : "allPatternsDir flag cannot be empty if computeAllPatterns is false!";
            if (this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                this.patsForEachToken.load(this.constVars.allPatternsDir);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Counter<E> getPatterns(String label, Set<E> alreadyIdentifiedPatterns, E p0, Counter<CandidatePhrase> p0Set, Set<E> ignorePatterns) throws IOException, ClassNotFoundException {
        ScorePatterns scorePatterns;
        TwoDimensionalCounter patternsandWords4Label = new TwoDimensionalCounter();
        TwoDimensionalCounter negPatternsandWords4Label = new TwoDimensionalCounter();
        TwoDimensionalCounter unLabeledPatternsandWords4Label = new TwoDimensionalCounter();
        HashSet<String> allCandidatePhrases = new HashSet<String>();
        ConstantsAndVariables.DataSentsIterator sentsIter = new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents);
        boolean firstCallToProcessSents = true;
        while (sentsIter.hasNext()) {
            Object sentsPair = sentsIter.next();
            if (this.notComputedAllPatternsYet) {
                this.processSents((Map)((Pair)sentsPair).first(), firstCallToProcessSents);
                firstCallToProcessSents = false;
                if (this.patsForEachToken == null) {
                    this.patsForEachToken = PatternsForEachToken.getPatternsInstance(this.props, this.constVars.storePatsForEachToken);
                    this.readSavedPatternsAndIndex();
                }
            }
            this.calculateSufficientStats((Map)((Pair)sentsPair).first(), this.patsForEachToken, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, allCandidatePhrases);
        }
        this.notComputedAllPatternsYet = false;
        if (this.constVars.computeAllPatterns) {
            if (this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.DB)) {
                this.patsForEachToken.createIndexIfUsingDBAndNotExists();
            }
            if (this.constVars.allPatternsDir != null) {
                IOUtils.ensureDir(new File(this.constVars.allPatternsDir));
                this.patsForEachToken.save(this.constVars.allPatternsDir);
            }
        }
        this.patsForEachToken.close();
        this.constVars.computeAllPatterns = false;
        if (this.patternsandWords == null) {
            this.patternsandWords = new HashMap<String, TwoDimensionalCounter<E, CandidatePhrase>>();
        }
        if (this.currentPatternWeights == null) {
            this.currentPatternWeights = new HashMap<String, Counter<E>>();
        }
        Counter currentPatternWeights4Label = new ClassicCounter();
        Set removePats = this.enforceMinSupportRequirements(patternsandWords4Label, unLabeledPatternsandWords4Label);
        Counters.removeKeys(patternsandWords4Label, removePats);
        Counters.removeKeys(unLabeledPatternsandWords4Label, removePats);
        Counters.removeKeys(negPatternsandWords4Label, removePats);
        Class patternscoringclass = GetPatternsFromDataMultiClass.getPatternScoringClass(this.constVars.patternScoring);
        if (patternscoringclass != null && patternscoringclass.equals(ScorePatternsF1.class)) {
            ScorePatternsF1 scorePatterns2 = new ScorePatternsF1(this.constVars, this.constVars.patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, this.props, p0Set, p0);
            Counter finalPat = ((ScorePatterns)scorePatterns2).score();
            Counters.removeKeys(finalPat, alreadyIdentifiedPatterns);
            Counters.retainNonZeros(finalPat);
            Counters.retainTop(finalPat, this.constVars.numPatterns);
            if (Double.isNaN(Counters.max(finalPat))) {
                throw new RuntimeException("how is the value NaN");
            }
            Redwood.log(ConstantsAndVariables.minimaldebug, "Selected Patterns: " + finalPat);
            return finalPat;
        }
        if (patternscoringclass != null && patternscoringclass.equals(ScorePatternsRatioModifiedFreq.class)) {
            scorePatterns = new ScorePatternsRatioModifiedFreq(this.constVars, this.constVars.patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, this.phInPatScoresCache, this.scorePhrases, this.props);
        } else if (patternscoringclass != null && patternscoringclass.equals(ScorePatternsFreqBased.class)) {
            scorePatterns = new ScorePatternsFreqBased(this.constVars, this.constVars.patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, this.props);
        } else if (this.constVars.patternScoring.equals((Object)PatternScoring.kNN)) {
            try {
                Class<?> clazz = Class.forName("edu.stanford.nlp.patterns.ScorePatternsKNN");
                Constructor<?> ctor = clazz.getConstructor(ConstantsAndVariables.class, PatternScoring.class, String.class, Set.class, TwoDimensionalCounter.class, TwoDimensionalCounter.class, TwoDimensionalCounter.class, ScorePhrases.class, Properties.class);
                scorePatterns = (ScorePatterns)ctor.newInstance(new Object[]{this.constVars, this.constVars.patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, this.scorePhrases, this.props});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("kNN pattern scoring is not released yet. Stay tuned.");
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("newinstance of kNN not created", e);
            }
        } else {
            throw new RuntimeException((Object)((Object)this.constVars.patternScoring) + " is not implemented (check spelling?). ");
        }
        scorePatterns.setUp(this.props);
        currentPatternWeights4Label = scorePatterns.score();
        Redwood.log(ConstantsAndVariables.extremedebug, "patterns counter size is " + currentPatternWeights4Label.size());
        if (ignorePatterns != null && !ignorePatterns.isEmpty()) {
            Counters.removeKeys(currentPatternWeights4Label, ignorePatterns);
            Redwood.log(ConstantsAndVariables.extremedebug, "Removing patterns from ignorePatterns of size  " + ignorePatterns.size() + ". New patterns size " + currentPatternWeights4Label.size());
        }
        if (alreadyIdentifiedPatterns != null && !alreadyIdentifiedPatterns.isEmpty()) {
            Redwood.log(ConstantsAndVariables.extremedebug, "Patterns size is " + currentPatternWeights4Label.size());
            Counters.removeKeys(currentPatternWeights4Label, alreadyIdentifiedPatterns);
            Redwood.log(ConstantsAndVariables.extremedebug, "Removing already identified patterns of size  " + alreadyIdentifiedPatterns.size() + ". New patterns size " + currentPatternWeights4Label.size());
        }
        PriorityQueue q = Counters.toPriorityQueue(currentPatternWeights4Label);
        int num = 0;
        ClassicCounter<Pattern> chosenPat = new ClassicCounter<Pattern>();
        HashSet removePatterns = new HashSet();
        HashSet<Pattern> removeIdentifiedPatterns = null;
        while (num < this.constVars.numPatterns && !q.isEmpty()) {
            void var23_29;
            int n;
            Pattern pat = (Pattern)q.removeFirst();
            if (currentPatternWeights4Label.getCount(pat) < this.constVars.thresholdSelectPattern) {
                Redwood.log(new Object[]{Redwood.DBG, "The max weight of candidate patterns is " + this.df.format(currentPatternWeights4Label.getCount(pat)) + " so not adding anymore patterns"});
                break;
            }
            boolean notchoose = false;
            if (!unLabeledPatternsandWords4Label.containsFirstKey(pat) || ((ClassicCounter)unLabeledPatternsandWords4Label.getCounter(pat)).isEmpty()) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Removing pattern " + pat + " because it has no unlab support; pos words: " + patternsandWords4Label.getCounter(pat));
                notchoose = true;
                continue;
            }
            Object var23_30 = null;
            if (!notchoose && alreadyIdentifiedPatterns != null) {
                for (Pattern pattern : alreadyIdentifiedPatterns) {
                    if (Pattern.subsumes(this.constVars.patternType, pat, pattern)) {
                        Redwood.log(ConstantsAndVariables.extremedebug, "Not choosing pattern " + pat + " because it is contained in or contains the already chosen pattern " + pattern);
                        notchoose = true;
                        break;
                    }
                    n = pat.equalContext(pattern);
                    if (n == Integer.MAX_VALUE) continue;
                    if (n < 0) {
                        if (removeIdentifiedPatterns == null) {
                            removeIdentifiedPatterns = new HashSet<Pattern>();
                        }
                        removeIdentifiedPatterns.add(pattern);
                        continue;
                    }
                    notchoose = true;
                    break;
                }
            }
            if (!notchoose) {
                for (Pattern pattern : chosenPat.keySet()) {
                    n = 0;
                    if (!Pattern.sameGenre(this.constVars.patternType, pat, pattern)) continue;
                    if (Pattern.subsumes(this.constVars.patternType, pat, pattern)) {
                        Redwood.log(ConstantsAndVariables.extremedebug, "Not choosing pattern " + pat + " because it is contained in or contains the already chosen pattern " + pattern);
                        notchoose = true;
                        break;
                    }
                    if (Pattern.subsumes(this.constVars.patternType, pattern, pat)) {
                        int rest = pat.equalContext(pattern);
                        if (rest == Integer.MAX_VALUE) {
                            Redwood.log(ConstantsAndVariables.extremedebug, "Not choosing pattern " + pattern + " because it is contained in or contains another chosen pattern in this iteration " + pat);
                            n = 1;
                        } else if (rest < 0) {
                            n = 1;
                        } else {
                            notchoose = true;
                            break;
                        }
                    }
                    if (n == 0) continue;
                    if (var23_29 == null) {
                        HashSet hashSet = new HashSet();
                    }
                    var23_29.add(pat);
                    --num;
                }
            }
            if (notchoose) {
                Redwood.log(new Object[]{Redwood.DBG, "Not choosing " + pat + " for whatever reason!"});
                continue;
            }
            if (var23_29 != null) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Removing already chosen patterns in this iteration " + var23_29 + " in favor of " + pat);
                Counters.removeKeys(chosenPat, var23_29);
            }
            if (removeIdentifiedPatterns != null) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Removing already identified patterns " + removeIdentifiedPatterns + " in favor of " + pat);
                removePatterns.addAll(removeIdentifiedPatterns);
            }
            chosenPat.setCount(pat, currentPatternWeights4Label.getCount(pat));
            ++num;
        }
        this.removeLearnedPatterns(label, removePatterns);
        Redwood.log(new Object[]{Redwood.DBG, "final size of the patterns is " + chosenPat.size()});
        Redwood.log(ConstantsAndVariables.minimaldebug, "\n\n## Selected Patterns for " + label + "##\n");
        List chosenPatSorted = Counters.toSortedListWithCounts(chosenPat);
        for (Pair pair : chosenPatSorted) {
            Redwood.log(ConstantsAndVariables.minimaldebug, pair.first() + ":" + this.df.format(pair.second) + "\n");
        }
        if (this.constVars.outDir != null && !this.constVars.outDir.isEmpty()) {
            CollectionValuedMap posWords = new CollectionValuedMap();
            for (Map.Entry entry : patternsandWords4Label.entrySet()) {
                posWords.addAll((Pattern)entry.getKey(), entry.getValue().keySet());
            }
            CollectionValuedMap collectionValuedMap = new CollectionValuedMap();
            for (Map.Entry entry : negPatternsandWords4Label.entrySet()) {
                collectionValuedMap.addAll((Pattern)entry.getKey(), entry.getValue().keySet());
            }
            CollectionValuedMap collectionValuedMap2 = new CollectionValuedMap();
            for (Map.Entry entry : unLabeledPatternsandWords4Label.entrySet()) {
                collectionValuedMap2.addAll((Pattern)entry.getKey(), entry.getValue().keySet());
            }
            if (this.constVars.outDir != null) {
                String string = this.constVars.outDir + "/" + this.constVars.identifier + "/" + label;
                Redwood.log(ConstantsAndVariables.minimaldebug, "Saving output in " + string);
                IOUtils.ensureDir(new File(string));
                String string2 = string + "/patterns.json";
                JsonArrayBuilder obj = Json.createArrayBuilder();
                if (this.writtenPatInJustification.containsKey(label) && this.writtenPatInJustification.get(label).booleanValue()) {
                    JsonReader jsonReader = Json.createReader((InputStream)new BufferedInputStream(new FileInputStream(string2)));
                    JsonArray objarr = jsonReader.readArray();
                    jsonReader.close();
                    for (JsonObjectBuilder o : objarr) {
                        obj.add((JsonValue)o);
                    }
                } else {
                    obj = Json.createArrayBuilder();
                }
                JsonObjectBuilder objThisIter = Json.createObjectBuilder();
                for (Pair pat : chosenPatSorted) {
                    CandidatePhrase w;
                    JsonObjectBuilder o;
                    o = Json.createObjectBuilder();
                    JsonArrayBuilder pos = Json.createArrayBuilder();
                    JsonArrayBuilder neg = Json.createArrayBuilder();
                    JsonArrayBuilder unlab = Json.createArrayBuilder();
                    Iterator iterator = posWords.get(pat.first()).iterator();
                    while (iterator.hasNext()) {
                        w = (CandidatePhrase)iterator.next();
                        pos.add(w.getPhrase());
                    }
                    iterator = collectionValuedMap.get(pat.first()).iterator();
                    while (iterator.hasNext()) {
                        w = (CandidatePhrase)iterator.next();
                        neg.add(w.getPhrase());
                    }
                    iterator = collectionValuedMap2.get(pat.first()).iterator();
                    while (iterator.hasNext()) {
                        w = (CandidatePhrase)iterator.next();
                        unlab.add(w.getPhrase());
                    }
                    o.add("Positive", pos);
                    o.add("Negative", neg);
                    o.add("Unlabeled", unlab);
                    o.add("Score", pat.second().doubleValue());
                    objThisIter.add(((Pattern)pat.first()).toStringSimple(), o);
                }
                obj.add((JsonValue)objThisIter.build());
                IOUtils.ensureDir(new File(string2).getParentFile());
                IOUtils.writeStringToFile(StringUtils.normalize(StringUtils.toAscii(obj.build().toString())), string2, "ASCII");
                this.writtenPatInJustification.put(label, true);
            }
        }
        if (this.constVars.justify) {
            Redwood.log(new Object[]{Redwood.DBG, "Justification for Patterns:"});
            for (Pattern pattern : chosenPat.keySet()) {
                Redwood.log(new Object[]{Redwood.DBG, "\nPattern: " + pattern});
                Redwood.log(new Object[]{Redwood.DBG, "Positive Words:" + Counters.toSortedString(patternsandWords4Label.getCounter(pattern), ((ClassicCounter)patternsandWords4Label.getCounter(pattern)).size(), "%1$s:%2$f", ";")});
                Redwood.log(new Object[]{Redwood.DBG, "Negative Words:" + Counters.toSortedString(negPatternsandWords4Label.getCounter(pattern), ((ClassicCounter)negPatternsandWords4Label.getCounter(pattern)).size(), "%1$s:%2$f", ";")});
                Redwood.log(new Object[]{Redwood.DBG, "Unlabeled Words:" + Counters.toSortedString(unLabeledPatternsandWords4Label.getCounter(pattern), ((ClassicCounter)unLabeledPatternsandWords4Label.getCounter(pattern)).size(), "%1$s:%2$f", ";")});
            }
        }
        this.patternsandWords.put(label, patternsandWords4Label);
        this.currentPatternWeights.put(label, currentPatternWeights4Label);
        return chosenPat;
    }

    public static Class getPatternScoringClass(PatternScoring patternScoring) {
        if (patternScoring.equals((Object)PatternScoring.F1SeedPattern)) {
            return ScorePatternsF1.class;
        }
        if (patternScoring.equals((Object)PatternScoring.PosNegUnlabOdds) || patternScoring.equals((Object)PatternScoring.PosNegOdds) || patternScoring.equals((Object)PatternScoring.RatioAll) || patternScoring.equals((Object)PatternScoring.PhEvalInPat) || patternScoring.equals((Object)PatternScoring.PhEvalInPatLogP) || patternScoring.equals((Object)PatternScoring.LOGREG) || patternScoring.equals((Object)PatternScoring.LOGREGlogP) || patternScoring.equals((Object)PatternScoring.SqrtAllRatio)) {
            return ScorePatternsRatioModifiedFreq.class;
        }
        if (patternScoring.equals((Object)PatternScoring.RlogF) || patternScoring.equals((Object)PatternScoring.RlogFPosNeg) || patternScoring.equals((Object)PatternScoring.RlogFUnlabNeg) || patternScoring.equals((Object)PatternScoring.RlogFNeg) || patternScoring.equals((Object)PatternScoring.YanGarber02) || patternScoring.equals((Object)PatternScoring.LinICML03)) {
            return ScorePatternsFreqBased.class;
        }
        return null;
    }

    private static <E> List<List<E>> splitIntoNumThreadsWithSampling(List<E> c, int n, int numThreads) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0: " + n);
        }
        if (n > c.size()) {
            throw new IllegalArgumentException("n > size of collection: " + n + ", " + c.size());
        }
        ArrayList resultAll = new ArrayList(numThreads);
        int num = numThreads == 1 ? n : n / (numThreads - 1);
        System.out.println("shuffled " + c.size() + " sentences and selecting " + num + " sentences per thread");
        ArrayList<E> result = new ArrayList<E>(num);
        int totalitems = 0;
        int nitem = 0;
        Random r = new Random(numCallsToCalStats.incrementAndGet());
        boolean[] added = new boolean[c.size()];
        while (totalitems < n) {
            int index;
            while (added[index = r.nextInt(c.size())]) {
            }
            added[index] = true;
            E c1 = c.get(index);
            if (nitem == num) {
                resultAll.add(result);
                result = new ArrayList(num);
                nitem = 0;
            }
            result.add(c1);
            ++totalitems;
            ++nitem;
        }
        if (!result.isEmpty()) {
            resultAll.add(result);
        }
        return resultAll;
    }

    private void calculateSufficientStats(Map<String, DataInstance> sents, PatternsForEachToken patternsForEachToken, String label, TwoDimensionalCounter<E, CandidatePhrase> patternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> negPatternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> unLabeledPatternsandWords4Label, Set<String> allCandidatePhrases) {
        Redwood.log(new Object[]{Redwood.DBG, "calculating sufficient stats"});
        patternsForEachToken.setupSearch();
        Class<? extends TypesafeMap.Key<String>> answerClass4Label = this.constVars.getAnswerClass().get(label);
        int sampleSize = this.constVars.sampleSentencesForSufficientStats == 1.0 ? sents.size() : (int)Math.round(this.constVars.sampleSentencesForSufficientStats * (double)sents.size());
        List<List<String>> sampledSentIds = GetPatternsFromDataMultiClass.splitIntoNumThreadsWithSampling(CollectionUtils.toList(sents.keySet()), sampleSize, this.constVars.numThreads);
        Redwood.log(new Object[]{Redwood.DBG, "sampled " + sampleSize + " sentences (" + this.constVars.sampleSentencesForSufficientStats * 100.0 + "%)"});
        ExecutorService executor = Executors.newFixedThreadPool(this.constVars.numThreads);
        ArrayList list = new ArrayList();
        for (List<String> list2 : sampledSentIds) {
            CalculateSufficientStatsThreads task = new CalculateSufficientStatsThreads(patternsForEachToken, list2, sents, label, answerClass4Label);
            Future submit = executor.submit(task);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                Triple stats = (Triple)future.get();
                this.addStats(patternsandWords4Label, (List)stats.first());
                this.addStats(negPatternsandWords4Label, (List)stats.second());
                this.addStats(unLabeledPatternsandWords4Label, (List)stats.third());
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
    }

    private void addStats(TwoDimensionalCounter<E, CandidatePhrase> pw, List<Pair<E, CandidatePhrase>> v) {
        for (Pair<E, CandidatePhrase> w : v) {
            pw.incrementCount((Pattern)w.first(), w.second());
        }
    }

    private Set<E> enforceMinSupportRequirements(TwoDimensionalCounter<E, CandidatePhrase> patternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> unLabeledPatternsandWords4Label) {
        HashSet<Pattern> remove = new HashSet<Pattern>();
        for (Map.Entry<E, ClassicCounter<CandidatePhrase>> en : patternsandWords4Label.entrySet()) {
            if (en.getValue().size() >= this.constVars.minPosPhraseSupportForPat) continue;
            remove.add((Pattern)en.getKey());
        }
        int numRemoved = remove.size();
        Redwood.log(new Object[]{Redwood.DBG, "Removing " + numRemoved + " patterns that do not meet minPosPhraseSupportForPat requirement of >= " + this.constVars.minPosPhraseSupportForPat});
        for (Map.Entry<E, ClassicCounter<CandidatePhrase>> en : unLabeledPatternsandWords4Label.entrySet()) {
            if (en.getValue().size() >= this.constVars.minUnlabPhraseSupportForPat) continue;
            remove.add((Pattern)en.getKey());
        }
        Redwood.log(new Object[]{Redwood.DBG, "Removing " + (remove.size() - numRemoved) + " patterns that do not meet minUnlabPhraseSupportForPat requirement of >= " + this.constVars.minUnlabPhraseSupportForPat});
        return remove;
    }

    private void removeLearnedPatterns(String label, Collection<E> pats) {
        Counters.removeKeys(this.learnedPatterns.get(label), pats);
        for (Map.Entry<Integer, Counter<E>> entry : this.learnedPatternsEachIter.get(label).entrySet()) {
            Counters.removeKeys(entry.getValue(), pats);
        }
        if (this.wordsPatExtracted.containsKey(label)) {
            for (Map.Entry<Comparable<Integer>, Counter<E>> entry : this.wordsPatExtracted.get(label).entrySet()) {
                Counters.removeKeys(entry.getValue(), pats);
            }
        }
    }

    public static <E> Counter<E> normalizeSoftMaxMinMaxScores(Counter<E> scores, boolean minMaxNorm, boolean softmax, boolean oneMinusSoftMax) {
        double minScore = Double.MAX_VALUE;
        double maxScore = Double.MIN_VALUE;
        ClassicCounter<E> newscores = new ClassicCounter<E>();
        if (softmax) {
            for (Map.Entry<E, Double> en : scores.entrySet()) {
                Double score = null;
                score = oneMinusSoftMax ? Double.valueOf(1.0 / (1.0 + Math.exp(Math.min(7.0, en.getValue())))) : Double.valueOf(1.0 / (1.0 + Math.exp(-1.0 * Math.min(7.0, en.getValue()))));
                if (score < minScore) {
                    minScore = score;
                }
                if (score > maxScore) {
                    maxScore = score;
                }
                newscores.setCount(en.getKey(), score);
            }
        } else {
            newscores.addAll(scores);
            minScore = Counters.min(newscores);
            maxScore = Counters.max(newscores);
        }
        if (minMaxNorm) {
            for (Map.Entry<E, Double> en : newscores.entrySet()) {
                double score = minScore == maxScore ? minScore : (en.getValue() - minScore + 1.0E-10) / (maxScore - minScore);
                newscores.setCount(en.getKey(), score);
            }
        }
        return newscores;
    }

    public void labelWords(String label, Map<String, DataInstance> sents, Collection<CandidatePhrase> identifiedWords) throws IOException {
        CollectionValuedMap matchedTokensByPat = new CollectionValuedMap();
        this.labelWords(label, sents, identifiedWords, null, matchedTokensByPat);
    }

    /*
     * Could not resolve type clashes
     */
    public void labelWords(String label, Map<String, DataInstance> sents, Collection<CandidatePhrase> identifiedWords, String outFile, CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat) throws IOException {
        Date startTime = new Date();
        Redwood.log(new Object[]{Redwood.DBG, "Labeling " + sents.size() + " sentences with " + identifiedWords.size() + " phrases for label " + label});
        int numTokensLabeled = 0;
        CollectionValuedMap<String, Integer> tokensMatchedPatterns = null;
        if (this.constVars.restrictToMatched) {
            tokensMatchedPatterns = new CollectionValuedMap<String, Integer>();
            for (Object en : matchedTokensByPat.entrySet()) {
                for (Triple en2 : (Collection)en.getValue()) {
                    for (int i = ((Integer)en2.second()).intValue(); i <= (Integer)en2.third(); ++i) {
                        tokensMatchedPatterns.add((String)en2.first(), i);
                    }
                }
            }
        }
        HashMap tempPatsForSents = new HashMap();
        for (Map.Entry<String, DataInstance> sentEn : sents.entrySet()) {
            List<CoreLabel> tokens = sentEn.getValue().getTokens();
            boolean sentenceChanged = false;
            HashMap<CandidatePhrase, String[]> identifiedWordsTokens = new HashMap<CandidatePhrase, String[]>();
            for (CandidatePhrase s : identifiedWords) {
                String[] toks = s.getPhrase().split("\\s+");
                identifiedWordsTokens.put(s, toks);
            }
            Object[] sent = new String[tokens.size()];
            int i = 0;
            HashSet<Integer> contextWordsRecalculatePats = new HashSet<Integer>();
            for (CoreLabel l : tokens) {
                sent[i] = l.word();
                ++i;
            }
            for (Map.Entry phEn : identifiedWordsTokens.entrySet()) {
                Object[] ph = (String[])phEn.getValue();
                List<Integer> ints = ArrayUtils.getSubListIndex(ph, sent, o -> ConstantsAndVariables.matchLowerCaseContext ? ((String)o.first()).equalsIgnoreCase((String)o.second()) : o.first().equals(o.second()));
                if (ints == null) continue;
                for (Integer idx : ints) {
                    boolean donotuse = false;
                    if (this.constVars.restrictToMatched) {
                        for (int j = 0; j < ph.length; ++j) {
                            if (tokensMatchedPatterns.get(sentEn.getKey()).contains(idx + j)) continue;
                            Redwood.log(ConstantsAndVariables.extremedebug, "not labeling " + tokens.get(idx + j).word());
                            donotuse = true;
                            break;
                        }
                    }
                    if (donotuse) continue;
                    String phStr = StringUtils.join((String[])ph, " ");
                    if (this.constVars.writeMatchedTokensIdsForEachPhrase) {
                        GetPatternsFromDataMultiClass.addToMatchedTokensByPhrase(phStr, sentEn.getKey(), idx, ph.length);
                    }
                    Redwood.log(ConstantsAndVariables.extremedebug, "Labeling because of phrase " + phStr);
                    for (int j = 0; j < ph.length; ++j) {
                        int index = idx + j;
                        CoreLabel l = tokens.get(index);
                        if (!this.constVars.usePatternResultAsLabel) continue;
                        sentenceChanged = true;
                        l.set(this.constVars.getAnswerClass().get(label), label);
                        ++numTokensLabeled;
                        CollectionValuedMap<String, CandidatePhrase> matched = new CollectionValuedMap<String, CandidatePhrase>();
                        matched.add(label, (CandidatePhrase)phEn.getKey());
                        if (!l.containsKey(PatternsAnnotations.MatchedPhrases.class)) {
                            l.set(PatternsAnnotations.MatchedPhrases.class, matched);
                        } else {
                            ((CollectionValuedMap)l.get(PatternsAnnotations.MatchedPhrases.class)).addAll(matched);
                        }
                        CandidatePhrase longest = (CandidatePhrase)((Map)l.get(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class)).get(label);
                        longest = longest != null && longest.getPhrase().length() > ((CandidatePhrase)phEn.getKey()).getPhrase().length() ? longest : (CandidatePhrase)phEn.getKey();
                        ((Map)l.get(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class)).put(label, longest);
                        for (int k = Math.max(0, index - PatternFactory.numWordsCompoundMapped.get(label)); k < tokens.size() && k <= index + PatternFactory.numWordsCompoundMapped.get(label) + 1; ++k) {
                            contextWordsRecalculatePats.add(k);
                        }
                    }
                }
            }
            if (this.patsForEachToken != null) {
                Iterator<Object> iterator = contextWordsRecalculatePats.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    if (!tempPatsForSents.containsKey(sentEn.getKey())) {
                        tempPatsForSents.put(sentEn.getKey(), new HashMap());
                    }
                    ((Map)tempPatsForSents.get(sentEn.getKey())).put(index, Pattern.getContext(this.constVars.patternType, sentEn.getValue(), index, ConstantsAndVariables.getStopWords()));
                }
            }
            if (!sentenceChanged) continue;
            this.constVars.invertedIndex.update(sentEn.getValue().getTokens(), sentEn.getKey());
        }
        if (this.patsForEachToken != null) {
            this.patsForEachToken.updatePatterns(tempPatsForSents);
        }
        this.constVars.invertedIndex.finishUpdating();
        if (outFile != null) {
            Redwood.log(ConstantsAndVariables.minimaldebug, "Writing results to " + outFile);
            IOUtils.writeObjectToFile(sents, outFile);
        }
        Date endTime = new Date();
        Redwood.log(new Object[]{Redwood.DBG, "Done labeling provided sents in " + GetPatternsFromDataMultiClass.elapsedTime(startTime, endTime) + ". Total # of tokens labeled: " + numTokensLabeled});
    }

    public void iterateExtractApply() throws IOException, ClassNotFoundException {
        this.iterateExtractApply(null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void iterateExtractApply(Map<String, E> p0, Map<String, Counter<CandidatePhrase>> p0Set, Map<String, Set<E>> ignorePatterns) throws IOException, ClassNotFoundException {
        HashMap matchedTokensByPatAllLabels = new HashMap();
        HashMap termsAllLabels = new HashMap();
        HashMap<String, Object> ignoreWordsAll = new HashMap<String, Object>();
        for (String label : this.constVars.getSeedLabelDictionary().keySet()) {
            matchedTokensByPatAllLabels.put(label, new CollectionValuedMap());
            termsAllLabels.put(label, new TwoDimensionalCounter());
            if (!this.constVars.useOtherLabelsWordsasNegative) continue;
            HashSet w = new HashSet();
            for (Map.Entry<String, Set<CandidatePhrase>> en : this.constVars.getSeedLabelDictionary().entrySet()) {
                if (en.getKey().equals(label)) continue;
                w.addAll(en.getValue());
            }
            ignoreWordsAll.put(label, w);
        }
        Redwood.log(ConstantsAndVariables.minimaldebug, "Iterating " + this.constVars.numIterationsForPatterns + " times.");
        HashMap<String, BufferedWriter> wordsOutput = new HashMap<String, BufferedWriter>();
        HashMap<String, BufferedWriter> patternsOutput = new HashMap<String, BufferedWriter>();
        for (String label : this.constVars.getLabels()) {
            if (this.constVars.outDir != null) {
                IOUtils.ensureDir(new File(this.constVars.outDir + "/" + this.constVars.identifier + "/" + label));
                String wordsOutputFileLabel = this.constVars.outDir + "/" + this.constVars.identifier + "/" + label + "/learnedwords.txt";
                wordsOutput.put(label, new BufferedWriter(new FileWriter(wordsOutputFileLabel)));
                Redwood.log(ConstantsAndVariables.minimaldebug, "Saving the learned words for label " + label + " in " + wordsOutputFileLabel);
            }
            if (this.constVars.outDir == null) continue;
            String patternsOutputFileLabel = this.constVars.outDir + "/" + this.constVars.identifier + "/" + label + "/learnedpatterns.txt";
            patternsOutput.put(label, new BufferedWriter(new FileWriter(patternsOutputFileLabel)));
            Redwood.log(ConstantsAndVariables.minimaldebug, "Saving the learned patterns for label " + label + " in " + patternsOutputFileLabel);
        }
        for (int i = 0; i < this.constVars.numIterationsForPatterns; ++i) {
            Redwood.log(ConstantsAndVariables.minimaldebug, "\n\n################################ Iteration " + (i + 1) + " ##############################");
            boolean keepRunning = false;
            HashMap<String, Counter<CandidatePhrase>> learnedWordsThisIter = new HashMap<String, Counter<CandidatePhrase>>();
            for (String label : this.constVars.getLabels()) {
                Redwood.log(ConstantsAndVariables.minimaldebug, "\n###Learning for label " + label + " ######");
                String sentout = this.constVars.sentsOutFile == null ? null : this.constVars.sentsOutFile + "_" + label;
                Pair<Counter<Pattern>, Counter<CandidatePhrase>> learnedPatWords4label = this.iterateExtractApply4Label(label, p0 != null ? (Pattern)p0.get(label) : null, p0Set != null ? p0Set.get(label) : null, (BufferedWriter)wordsOutput.get(label), sentout, (BufferedWriter)patternsOutput.get(label), ignorePatterns != null ? ignorePatterns.get(label) : null, (Set)ignoreWordsAll.get(label), (CollectionValuedMap)matchedTokensByPatAllLabels.get(label), (TwoDimensionalCounter)termsAllLabels.get(label), i + numIterationsLoadedModel);
                learnedWordsThisIter.put(label, learnedPatWords4label.second());
                if (learnedPatWords4label.first().size() <= 0 || this.constVars.getLearnedWords(label).size() >= this.constVars.maxExtractNumWords) continue;
                keepRunning = true;
            }
            if (this.constVars.useOtherLabelsWordsasNegative) {
                for (String label : this.constVars.getLabels()) {
                    for (Map.Entry en : learnedWordsThisIter.entrySet()) {
                        if (((String)en.getKey()).equals(label)) continue;
                        ((Set)ignoreWordsAll.get(label)).addAll(((Counter)en.getValue()).keySet());
                    }
                }
            }
            if (keepRunning) continue;
            if (!this.constVars.tuneThresholdKeepRunning) {
                Redwood.log(ConstantsAndVariables.minimaldebug, "No patterns learned for all labels. Ending iterations.");
                break;
            }
            this.constVars.thresholdSelectPattern = 0.8 * this.constVars.thresholdSelectPattern;
            Redwood.log(ConstantsAndVariables.minimaldebug, "\n\nTuning thresholds to keep running. New Pattern threshold is  " + this.constVars.thresholdSelectPattern);
        }
        if (this.constVars.outDir != null && !this.constVars.outDir.isEmpty()) {
            Redwood.log(ConstantsAndVariables.minimaldebug, "Writing justification files");
            for (String label : this.constVars.getLabels()) {
                IOUtils.ensureDir(new File(this.constVars.outDir + "/" + this.constVars.identifier + "/" + label));
                if (!this.constVars.writeMatchedTokensFiles) continue;
                ConstantsAndVariables.DataSentsIterator iter = new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents);
                boolean bl = false;
                String suffix = "";
                while (iter.hasNext()) {
                    void var12_24;
                    ++var12_24;
                    if (this.constVars.batchProcessSents) {
                        suffix = "_" + (int)var12_24;
                    }
                    this.writeMatchedTokensAndSents(label, (Map)((Pair)iter.next()).first(), suffix, (CollectionValuedMap)matchedTokensByPatAllLabels.get(label));
                }
            }
            if (this.constVars.writeMatchedTokensIdsForEachPhrase && this.constVars.outDir != null) {
                String matchedtokensfilename = this.constVars.outDir + "/" + this.constVars.identifier + "/tokenids4matchedphrases.json";
                IOUtils.writeStringToFile(GetPatternsFromDataMultiClass.matchedTokensByPhraseJsonString(), matchedtokensfilename, "utf8");
            }
        }
        System.out.println("\n\nAll patterns learned:");
        for (Map.Entry<String, Map<Integer, Counter<E>>> en2 : this.learnedPatternsEachIter.entrySet()) {
            System.out.println(en2.getKey() + ":");
            for (Map.Entry<Integer, Counter<E>> entry : en2.getValue().entrySet()) {
                System.out.println("Iteration " + entry.getKey());
                System.out.println(StringUtils.join(entry.getValue().keySet(), "\n"));
            }
        }
        System.out.println("\n\nAll words learned:");
        for (String label : this.constVars.getLabels()) {
            System.out.println("\nLabel " + label + "\n");
            for (Map.Entry<Integer, Counter<Object>> entry : this.constVars.getLearnedWordsEachIter(label).entrySet()) {
                System.out.println("Iteration " + entry.getKey() + ":\t\t" + entry.getValue().keySet());
            }
        }
        for (String label : this.constVars.getLabels()) {
            if (wordsOutput.containsKey(label) && wordsOutput.get(label) != null) {
                ((BufferedWriter)wordsOutput.get(label)).close();
            }
            if (!patternsOutput.containsKey(label) || patternsOutput.get(label) == null) continue;
            ((BufferedWriter)patternsOutput.get(label)).close();
        }
    }

    private void writeMatchedTokensAndSents(String label, Map<String, DataInstance> sents, String suffix, CollectionValuedMap<E, Triple<String, Integer, Integer>> tokensMatchedPat) throws IOException {
        if (this.constVars.outDir != null) {
            HashSet<String> allMatchedSents = new HashSet<String>();
            String matchedtokensfilename = this.constVars.outDir + "/" + this.constVars.identifier + "/" + label + "/tokensmatchedpatterns" + suffix + ".json";
            JsonObjectBuilder pats = Json.createObjectBuilder();
            for (Map.Entry<E, Collection<Triple<String, Integer, Integer>>> entry : tokensMatchedPat.entrySet()) {
                CollectionValuedMap<String, Pair<Integer, Integer>> matchedStrs = new CollectionValuedMap<String, Pair<Integer, Integer>>();
                for (Triple<String, Integer, Integer> en2 : entry.getValue()) {
                    allMatchedSents.add(en2.first());
                    matchedStrs.add(en2.first(), new Pair<Integer, Integer>(en2.second(), en2.third()));
                }
                JsonObjectBuilder senttokens = Json.createObjectBuilder();
                for (Map.Entry sen : matchedStrs.entrySet()) {
                    JsonArrayBuilder obj = Json.createArrayBuilder();
                    for (Pair sen2 : sen.getValue()) {
                        JsonArrayBuilder startend = Json.createArrayBuilder();
                        startend.add(((Integer)sen2.first()).intValue());
                        startend.add(((Integer)sen2.second()).intValue());
                        obj.add(startend);
                    }
                    senttokens.add((String)sen.getKey(), obj);
                }
                pats.add(((Pattern)entry.getKey()).toStringSimple(), senttokens);
            }
            IOUtils.writeStringToFile(pats.build().toString(), matchedtokensfilename, "utf8");
            JsonObjectBuilder senttokens = Json.createObjectBuilder();
            for (String sentId : allMatchedSents) {
                JsonArrayBuilder sent = Json.createArrayBuilder();
                for (CoreLabel l : sents.get(sentId).getTokens()) {
                    sent.add(l.word());
                }
                senttokens.add(sentId, sent);
            }
            String string = this.constVars.outDir + "/" + this.constVars.identifier + "/sentences" + suffix + ".json";
            IOUtils.writeStringToFile(senttokens.build().toString(), string, "utf8");
        }
    }

    public static String matchedTokensByPhraseJsonString(String phrase) {
        if (!Data.matchedTokensForEachPhrase.containsKey(phrase)) {
            return "";
        }
        JsonArrayBuilder arrobj = GetPatternsFromDataMultiClass.jsonArrayBuilderFromMapCounter(Data.matchedTokensForEachPhrase.get(phrase));
        return arrobj.build().toString();
    }

    public static String matchedTokensByPhraseJsonString() {
        JsonObjectBuilder pats = Json.createObjectBuilder();
        for (Map.Entry<String, Map<String, List<Integer>>> en : Data.matchedTokensForEachPhrase.entrySet()) {
            JsonArrayBuilder arrobj = GetPatternsFromDataMultiClass.jsonArrayBuilderFromMapCounter(en.getValue());
            pats.add(en.getKey(), arrobj);
        }
        return pats.build().toString();
    }

    private static JsonArrayBuilder jsonArrayBuilderFromMapCounter(Map<String, List<Integer>> mapCounter) {
        JsonArrayBuilder arrobj = Json.createArrayBuilder();
        for (Map.Entry<String, List<Integer>> sen : mapCounter.entrySet()) {
            JsonObjectBuilder obj = Json.createObjectBuilder();
            JsonArrayBuilder tokens = Json.createArrayBuilder();
            for (Integer i : sen.getValue()) {
                tokens.add(i.intValue());
            }
            obj.add(sen.getKey(), tokens);
            arrobj.add(obj);
        }
        return arrobj;
    }

    private Pair<Counter<E>, Counter<CandidatePhrase>> iterateExtractApply4Label(String label, E p0, Counter<CandidatePhrase> p0Set, BufferedWriter wordsOutput, String sentsOutFile, BufferedWriter patternsOut, Set<E> ignorePatterns, Set<CandidatePhrase> ignoreWords, CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat, TwoDimensionalCounter<CandidatePhrase, E> terms, int numIterTotal) throws IOException, ClassNotFoundException {
        if (!this.learnedPatterns.containsKey(label)) {
            this.learnedPatterns.put(label, new ClassicCounter());
        }
        if (!this.learnedPatternsEachIter.containsKey(label)) {
            this.learnedPatternsEachIter.put(label, new HashMap());
        }
        if (!this.constVars.getLearnedWordsEachIter().containsKey(label)) {
            this.constVars.getLearnedWordsEachIter().put(label, new TreeMap());
        }
        ClassicCounter<CandidatePhrase> identifiedWords = new ClassicCounter<CandidatePhrase>();
        ClassicCounter<E> patterns = new ClassicCounter<E>();
        Counter<E> patternThisIter = this.getPatterns(label, this.learnedPatterns.get(label).keySet(), p0, p0Set, ignorePatterns);
        patterns.addAll(patternThisIter);
        this.learnedPatterns.get(label).addAll(patterns);
        assert (!this.learnedPatternsEachIter.get(label).containsKey(numIterTotal)) : "How come learned patterns already have a key for " + numIterTotal + " keys are " + this.learnedPatternsEachIter.get(label).keySet();
        this.learnedPatternsEachIter.get(label).put(numIterTotal, patterns);
        if (sentsOutFile != null) {
            sentsOutFile = sentsOutFile + "_" + numIterTotal + "iter.ser";
        }
        ClassicCounter<CandidatePhrase> scoreForAllWordsThisIteration = new ClassicCounter<CandidatePhrase>();
        identifiedWords.addAll(this.scorePhrases.learnNewPhrases(label, this.patsForEachToken, patterns, this.learnedPatterns.get(label), matchedTokensByPat, scoreForAllWordsThisIteration, terms, this.wordsPatExtracted.get(label), this.patternsandWords.get(label), this.constVars.identifier, ignoreWords));
        if (identifiedWords.size() > 0) {
            if (this.constVars.usePatternResultAsLabel) {
                if (this.constVars.getLabels().contains(label)) {
                    ConstantsAndVariables.DataSentsIterator sentsIter = new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents);
                    while (sentsIter.hasNext()) {
                        Object sentsf = sentsIter.next();
                        Redwood.log(new Object[]{Redwood.DBG, "labeling sentences from " + ((Pair)sentsf).second()});
                        this.labelWords(label, (Map)((Pair)sentsf).first(), identifiedWords.keySet(), sentsOutFile, matchedTokensByPat);
                        if (!((File)((Pair)sentsf).second()).exists() || !this.constVars.batchProcessSents) continue;
                        IOUtils.writeObjectToFile(((Pair)sentsf).first(), (File)((Pair)sentsf).second());
                    }
                } else {
                    throw new RuntimeException("why is the answer label null?");
                }
                assert (!this.constVars.getLearnedWordsEachIter().get(label).containsKey(numIterTotal)) : "How come learned words already have a key for " + numIterTotal;
                this.constVars.getLearnedWordsEachIter().get(label).put(numIterTotal, identifiedWords);
            }
            if (wordsOutput != null) {
                wordsOutput.write("\n" + Counters.toSortedString(identifiedWords, identifiedWords.size(), "%1$s", "\n"));
                wordsOutput.flush();
            }
        }
        if (patternsOut != null) {
            this.writePatternsToFile(patterns, patternsOut);
        }
        return new Pair<Counter<E>, Counter<CandidatePhrase>>(patterns, identifiedWords);
    }

    private void writePatternsToFile(Counter<E> pattern, BufferedWriter outFile) throws IOException {
        for (Map.Entry<E, Double> en : pattern.entrySet()) {
            outFile.write(en.getKey() + "\t" + en.getValue() + "\n");
        }
    }

    private void writeWordsToFile(Map<Integer, Counter<CandidatePhrase>> words, BufferedWriter outFile) throws IOException {
        for (Map.Entry<Integer, Counter<CandidatePhrase>> en2 : words.entrySet()) {
            outFile.write("###Iteration " + en2.getKey() + "\n");
            for (Map.Entry<CandidatePhrase, Double> en : en2.getValue().entrySet()) {
                outFile.write(en.getKey() + "\t" + en.getValue() + "\n");
            }
        }
    }

    private static TreeMap<Integer, Counter<CandidatePhrase>> readLearnedWordsFromFile(File file) {
        TreeMap<Integer, Counter<CandidatePhrase>> learned = new TreeMap<Integer, Counter<CandidatePhrase>>();
        ClassicCounter<CandidatePhrase> words = null;
        int numIter = -1;
        for (String line : IOUtils.readLines(file)) {
            if (line.startsWith("###")) {
                if (words != null) {
                    learned.put(numIter, words);
                }
                ++numIter;
                words = new ClassicCounter<CandidatePhrase>();
                continue;
            }
            String[] t = line.split("\t");
            words.setCount(CandidatePhrase.createOrGet(t[0]), Double.parseDouble(t[1]));
        }
        if (words != null) {
            learned.put(numIter, words);
        }
        return learned;
    }

    public Counter<E> getLearnedPatterns(String label) {
        return this.learnedPatterns.get(label);
    }

    public Map<String, Counter<E>> getLearnedPatterns() {
        return this.learnedPatterns;
    }

    public Map<String, Map<Integer, Counter<E>>> getLearnedPatternsEachIter() {
        return this.learnedPatternsEachIter;
    }

    public Map<Integer, Counter<E>> getLearnedPatternsEachIter(String label) {
        return this.learnedPatternsEachIter.get(label);
    }

    public void setLearnedPatterns(Counter<E> patterns, String label) {
        this.learnedPatterns.put(label, patterns);
    }

    private static boolean countResultsPerEntity(List<CoreLabel> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background, Counter<String> wordTP, Counter<String> wordTN, Counter<String> wordFP, Counter<String> wordFN, Class<? extends TypesafeMap.Key<String>> whichClassToCompare) {
        int index = 0;
        int goldIndex = 0;
        int guessIndex = 0;
        String lastGold = background;
        String lastGuess = background;
        String str = "";
        String s = "";
        for (CoreLabel l : doc) {
            s = s + " " + l.word() + ":" + (String)l.get(CoreAnnotations.GoldAnswerAnnotation.class) + ":" + (String)l.get(whichClassToCompare);
        }
        for (CoreLabel line : doc) {
            String gold = (String)line.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)line.get(whichClassToCompare);
            if (gold == null || guess == null) {
                return false;
            }
            if (lastGold != null && !lastGold.equals(gold) && !lastGold.equals(background)) {
                if (lastGuess.equals(lastGold) && !lastGuess.equals(guess) && goldIndex == guessIndex) {
                    wordTP.incrementCount(str);
                    entityTP.incrementCount(lastGold, 1.0);
                } else {
                    wordFN.incrementCount(str);
                    entityFN.incrementCount(lastGold, 1.0);
                    str = "";
                }
            }
            if (lastGuess != null && !lastGuess.equals(guess) && !lastGuess.equals(background)) {
                if (!lastGuess.equals(lastGold) || lastGuess.equals(guess) || goldIndex != guessIndex || lastGold.equals(gold)) {
                    entityFP.incrementCount(lastGuess, 1.0);
                    wordFP.incrementCount(str);
                }
                str = "";
            }
            if (lastGuess != null && lastGold != null && lastGold.equals(background) && lastGuess.equals(background)) {
                str = "";
            }
            if (lastGold == null || !lastGold.equals(gold)) {
                lastGold = gold;
                goldIndex = index;
            }
            if (lastGuess == null || !lastGuess.equals(guess)) {
                lastGuess = guess;
                guessIndex = index;
            }
            ++index;
            if (str.isEmpty()) {
                str = line.word();
                continue;
            }
            str = str + " " + line.word();
        }
        if (lastGold != null && !lastGold.equals(background)) {
            if (lastGold.equals(lastGuess) && goldIndex == guessIndex) {
                entityTP.incrementCount(lastGold, 1.0);
                wordTP.incrementCount(str);
            } else {
                entityFN.incrementCount(lastGold, 1.0);
                wordFN.incrementCount(str);
            }
            str = "";
        }
        if (lastGuess != null && !lastGuess.equals(background)) {
            if (!lastGold.equals(lastGuess) || goldIndex != guessIndex) {
                entityFP.incrementCount(lastGuess, 1.0);
                wordFP.incrementCount(str);
            }
            str = "";
        }
        return true;
    }

    public static void countResultsPerToken(List<CoreLabel> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background, Counter<String> wordTP, Counter<String> wordTN, Counter<String> wordFP, Counter<String> wordFN, Class<? extends TypesafeMap.Key<String>> whichClassToCompare) {
        IOBUtils.countEntityResults(doc, entityTP, entityFP, entityFN, background);
        for (CoreLabel line : doc) {
            String gold = (String)line.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)line.get(whichClassToCompare);
            assert (gold != null) : "gold is null";
            assert (guess != null) : "guess is null";
            if (gold.equals(guess) && !gold.equalsIgnoreCase(background)) {
                entityTP.incrementCount(gold);
                wordTP.incrementCount(line.word());
                continue;
            }
            if (!gold.equals(guess) && !gold.equalsIgnoreCase(background) && guess.equalsIgnoreCase(background)) {
                entityFN.incrementCount(gold);
                wordFN.incrementCount(line.word());
                continue;
            }
            if (!gold.equals(guess) && !guess.equalsIgnoreCase(background) && gold.equalsIgnoreCase(background)) {
                wordFP.incrementCount(line.word());
                entityFP.incrementCount(guess);
                continue;
            }
            if (gold.equals(guess) && !gold.equalsIgnoreCase(background)) {
                wordTN.incrementCount(line.word());
                continue;
            }
            if (gold.equalsIgnoreCase(background) && guess.equalsIgnoreCase(background)) continue;
            throw new RuntimeException("don't know reached here. not meant for more than one entity label: " + gold + " and " + guess);
        }
    }

    public static void countResults(List<CoreLabel> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background, Counter<String> wordTP, Counter<String> wordTN, Counter<String> wordFP, Counter<String> wordFN, Class<? extends TypesafeMap.Key<String>> whichClassToCompare, boolean evalPerEntity) {
        if (evalPerEntity) {
            GetPatternsFromDataMultiClass.countResultsPerEntity(doc, entityTP, entityFP, entityFN, background, wordTP, wordTN, wordFP, wordFN, whichClassToCompare);
        } else {
            GetPatternsFromDataMultiClass.countResultsPerToken(doc, entityTP, entityFP, entityFN, background, wordTP, wordTN, wordFP, wordFN, whichClassToCompare);
        }
    }

    private void writeLabelDataSents(Map<String, DataInstance> sents, BufferedWriter writer) throws IOException {
        for (Map.Entry<String, DataInstance> sent : sents.entrySet()) {
            writer.write(sent.getKey() + "\t");
            HashMap<String, Boolean> lastWordLabeled = new HashMap<String, Boolean>();
            for (String label : this.constVars.getLabels()) {
                lastWordLabeled.put(label, false);
            }
            for (CoreLabel s : sent.getValue().getTokens()) {
                String str = "";
                ArrayList<String> listEndedLabels = new ArrayList<String>();
                ArrayList<String> startingLabels = new ArrayList<String>();
                for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> as : this.constVars.getAnswerClass().entrySet()) {
                    String label = as.getKey();
                    boolean lastwordlabeled = (Boolean)lastWordLabeled.get(label);
                    if (((String)s.get(as.getValue())).equals(label)) {
                        if (!lastwordlabeled) {
                            startingLabels.add(label);
                        }
                        lastWordLabeled.put(label, true);
                        continue;
                    }
                    if (lastwordlabeled) {
                        listEndedLabels.add(label);
                    }
                    lastWordLabeled.put(label, false);
                }
                for (int i = listEndedLabels.size() - 1; i >= 0; --i) {
                    str = str + " </" + (String)listEndedLabels.get(i) + ">";
                }
                for (String label : startingLabels) {
                    str = str + " <" + label + "> ";
                }
                str = str + " " + s.word();
                writer.write(str.trim() + " ");
            }
            writer.write("\n");
        }
    }

    public void writeLabeledData(String outFile) throws IOException, ClassNotFoundException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        ConstantsAndVariables.DataSentsIterator sentsIter = new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents);
        while (sentsIter.hasNext()) {
            Object sentsf = sentsIter.next();
            this.writeLabelDataSents((Map)((Pair)sentsf).first(), writer);
        }
        writer.close();
    }

    public static void writeColumnOutput(String outFile, boolean batchProcessSents, Map<String, Class<? extends TypesafeMap.Key<String>>> answerclasses) throws IOException, ClassNotFoundException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        ConstantsAndVariables.DataSentsIterator sentsIter = new ConstantsAndVariables.DataSentsIterator(batchProcessSents);
        while (sentsIter.hasNext()) {
            Object sentsf = sentsIter.next();
            GetPatternsFromDataMultiClass.writeColumnOutputSents((Map)((Pair)sentsf).first(), writer, answerclasses);
        }
        writer.close();
    }

    private static void writeColumnOutputSents(Map<String, DataInstance> sents, BufferedWriter writer, Map<String, Class<? extends TypesafeMap.Key<String>>> answerclasses) throws IOException {
        for (Map.Entry<String, DataInstance> sent : sents.entrySet()) {
            writer.write("\n\n" + sent.getKey() + "\n");
            for (CoreLabel s : sent.getValue().getTokens()) {
                writer.write(s.word() + "\t");
                HashSet<String> labels = new HashSet<String>();
                for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> as : answerclasses.entrySet()) {
                    String label = as.getKey();
                    if (!((String)s.get(as.getValue())).equals(label)) continue;
                    labels.add(label);
                }
                if (labels.isEmpty()) {
                    writer.write("O\n");
                    continue;
                }
                writer.write(StringUtils.join(labels, ",") + "\n");
            }
            writer.write("\n");
        }
    }

    public void evaluate(Map<String, DataInstance> testSentences, boolean evalPerEntity) throws IOException {
        for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> anscl : this.constVars.getAnswerClass().entrySet()) {
            String label = anscl.getKey();
            ClassicCounter<String> entityTP = new ClassicCounter<String>();
            ClassicCounter<String> entityFP = new ClassicCounter<String>();
            ClassicCounter<String> entityFN = new ClassicCounter<String>();
            ClassicCounter<String> wordTP = new ClassicCounter<String>();
            ClassicCounter<String> wordTN = new ClassicCounter<String>();
            ClassicCounter<String> wordFP = new ClassicCounter<String>();
            ClassicCounter<String> wordFN = new ClassicCounter<String>();
            for (Map.Entry<String, DataInstance> docEn : testSentences.entrySet()) {
                DataInstance doc = docEn.getValue();
                ArrayList<CoreLabel> doceval = new ArrayList<CoreLabel>();
                for (CoreLabel l : doc.getTokens()) {
                    CoreLabel l2 = new CoreLabel();
                    l2.setWord(l.word());
                    if (((String)l.get(anscl.getValue())).equals(label)) {
                        l2.set(CoreAnnotations.AnswerAnnotation.class, label);
                    } else {
                        l2.set(CoreAnnotations.AnswerAnnotation.class, ConstantsAndVariables.backgroundSymbol);
                    }
                    if (!((String)l.get(CoreAnnotations.GoldAnswerAnnotation.class)).equals(label)) {
                        l2.set(CoreAnnotations.GoldAnswerAnnotation.class, ConstantsAndVariables.backgroundSymbol);
                    } else {
                        l2.set(CoreAnnotations.GoldAnswerAnnotation.class, label);
                    }
                    doceval.add(l2);
                }
                GetPatternsFromDataMultiClass.countResults(doceval, entityTP, entityFP, entityFN, ConstantsAndVariables.backgroundSymbol, wordTP, wordTN, wordFP, wordFN, CoreAnnotations.AnswerAnnotation.class, evalPerEntity);
            }
            System.out.println("False Positives: " + Counters.toSortedString(wordFP, wordFP.size(), "%s:%.2f", ";"));
            System.out.println("False Negatives: " + Counters.toSortedString(wordFN, wordFN.size(), "%s:%.2f", ";"));
            Redwood.log(new Object[]{Redwood.DBG, "\nFor label " + label + " True Positives: " + entityTP + "\tFalse Positives: " + entityFP + "\tFalse Negatives: " + entityFN});
            Counter<String> precision = Counters.division(entityTP, Counters.add(entityTP, entityFP));
            Counter<String> recall = Counters.division(entityTP, Counters.add(entityTP, entityFN));
            Redwood.log(ConstantsAndVariables.minimaldebug, "\nFor label " + label + " Precision: " + precision + ", Recall: " + recall + ", F1 score:  " + GetPatternsFromDataMultiClass.FScore(precision, recall, 1.0));
        }
    }

    public static <D> Counter<D> FScore(Counter<D> precision, Counter<D> recall, double beta) {
        double betasq = beta * beta;
        return Counters.divisionNonNaN(Counters.scale(Counters.product(precision, recall), 1.0 + betasq), Counters.add(Counters.scale(precision, betasq), recall));
    }

    private static List<File> getAllFiles(String file) {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (String tokfile : file.split("[,;]")) {
            File dir;
            File filef = new File(tokfile);
            if (filef.isDirectory()) {
                Redwood.log(new Object[]{Redwood.DBG, "Will read from directory " + filef});
                String path = ".*";
                dir = filef;
                for (File f : IOUtils.iterFilesRecursive(dir, java.util.regex.Pattern.compile(path))) {
                    Redwood.log(ConstantsAndVariables.extremedebug, "Will read from file " + f);
                    allFiles.add(f);
                }
                continue;
            }
            if (filef.exists()) {
                Redwood.log(new Object[]{Redwood.DBG, "Will read from file " + filef});
                allFiles.add(filef);
                continue;
            }
            Redwood.log(new Object[]{Redwood.DBG, "trying to read from file " + filef});
            RegExFileFilter fileFilter = new RegExFileFilter(java.util.regex.Pattern.compile(filef.getName()));
            dir = new File(tokfile.substring(0, tokfile.lastIndexOf("/")));
            File[] files = dir.listFiles(fileFilter);
            allFiles.addAll(Arrays.asList(files));
        }
        return allFiles;
    }

    private Pair<Double, Double> getPrecisionRecall(String label, Map<String, Boolean> goldWords4Label) {
        Set<CandidatePhrase> learnedWords = this.constVars.getLearnedWords(label).keySet();
        int numcorrect = 0;
        int numincorrect = 0;
        int numgoldcorrect = 0;
        for (Map.Entry<String, Boolean> en : goldWords4Label.entrySet()) {
            if (!en.getValue().booleanValue()) continue;
            ++numgoldcorrect;
        }
        HashSet<String> assumedNeg = new HashSet<String>();
        for (CandidatePhrase e : learnedWords) {
            if (!goldWords4Label.containsKey(e.getPhrase())) {
                assumedNeg.add(e.getPhrase());
                ++numincorrect;
                continue;
            }
            if (goldWords4Label.get(e.getPhrase()).booleanValue()) {
                ++numcorrect;
                continue;
            }
            ++numincorrect;
        }
        if (!assumedNeg.isEmpty()) {
            log.info("\nGold entity list does not contain words " + assumedNeg + " for label " + label + ". *****Assuming them as negative.******");
        }
        double precision = (double)numcorrect / (double)(numcorrect + numincorrect);
        double recall = (double)numcorrect / (double)numgoldcorrect;
        return new Pair<Double, Double>(precision, recall);
    }

    private static double FScore(double precision, double recall, double beta) {
        double betasq = beta * beta;
        return (1.0 + betasq) * precision * recall / (betasq * precision + recall);
    }

    public Set<String> getNonBackgroundLabels(CoreLabel l) {
        HashSet<String> labels = new HashSet<String>();
        for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> en : this.constVars.getAnswerClass().entrySet()) {
            if (((String)l.get(en.getValue())).equals(ConstantsAndVariables.backgroundSymbol)) continue;
            labels.add(en.getKey());
        }
        return labels;
    }

    public static Map<String, Set<CandidatePhrase>> readSeedWordsFromJSONString(String str) {
        HashMap<String, Set<CandidatePhrase>> seedWords = new HashMap<String, Set<CandidatePhrase>>();
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(str));
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        for (String o : obj.keySet()) {
            seedWords.put(o, new HashSet());
            JsonArray arr = obj.getJsonArray(o);
            for (JsonValue v : arr) {
                ((Set)seedWords.get(o)).add(CandidatePhrase.createOrGet(v.toString()));
            }
        }
        return seedWords;
    }

    public static Map<String, Set<CandidatePhrase>> readSeedWords(Properties props) {
        String seedWordsFile = props.getProperty("seedWordsFiles");
        if (seedWordsFile != null) {
            return GetPatternsFromDataMultiClass.readSeedWords(seedWordsFile);
        }
        Redwood.log(new Object[]{Redwood.FORCE, "NO SEED WORDS FILES PROVIDED!!"});
        return Collections.emptyMap();
    }

    public static Map<String, Set<CandidatePhrase>> readSeedWords(String seedWordsFiles) {
        HashMap<String, Set<CandidatePhrase>> seedWords = new HashMap<String, Set<CandidatePhrase>>();
        if (seedWordsFiles == null) {
            throw new RuntimeException("Needs both seedWordsFiles and file parameters to run this class!\nseedWordsFiles has format: label1,filewithlistofwords1;label2,filewithlistofwords2;...");
        }
        for (String seedFile : seedWordsFiles.split(";")) {
            String[] t = seedFile.split(",");
            String label = t[0];
            HashSet<CandidatePhrase> seedWords4Label = new HashSet<CandidatePhrase>();
            for (int i = 1; i < t.length; ++i) {
                String seedWordsFile = t[i];
                for (File fin : ConstantsAndVariables.listFileIncludingItself(seedWordsFile)) {
                    Redwood.log(new Object[]{Redwood.DBG, "Reading seed words from " + fin + " for label " + label});
                    for (String line : IOUtils.readLines(fin)) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        line = line.split("\t")[0];
                        seedWords4Label.add(CandidatePhrase.createOrGet(line));
                    }
                }
            }
            seedWords.put(label, seedWords4Label);
            Redwood.log(ConstantsAndVariables.minimaldebug, "Number of seed words for label " + label + " is " + seedWords4Label.size());
        }
        return seedWords;
    }

    void removeLabelings(String label, Collection<String> removeLabeledPhrases) {
    }

    public Map<String, String> getAllOptions() {
        HashMap<String, String> values = new HashMap<String, String>();
        this.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x, y) -> values.put(x.toString(), y.toString())));
        values.putAll(this.constVars.getAllOptions());
        try {
            Field[] aClassFields;
            Class<?> thisClass = Class.forName(this.getClass().getName());
            for (Field f : aClassFields = thisClass.getDeclaredFields()) {
                if (!f.getGenericType().getClass().isPrimitive() && Arrays.binarySearch(printOptionClass, f.getType().getClass()) < 0) continue;
                String fName = f.getName();
                Object fvalue = f.get(this);
                values.put(fName, fvalue == null ? "null" : fvalue.toString());
            }
        }
        catch (Exception e) {
            log.warn(e);
        }
        return values;
    }

    public static Pair<Map<String, DataInstance>, Map<String, DataInstance>> processSents(Properties props, Set<String> labels) throws IOException, ExecutionException, InterruptedException, ClassNotFoundException {
        String fileFormat = props.getProperty("fileFormat");
        HashMap sents = null;
        boolean batchProcessSents = Boolean.parseBoolean(props.getProperty("batchProcessSents", "false"));
        int numMaxSentencesPerBatchFile = Integer.parseInt(props.getProperty("numMaxSentencesPerBatchFile", String.valueOf(Integer.MAX_VALUE)));
        boolean preserveSentenceSequence = Boolean.parseBoolean(props.getProperty("preserveSentenceSequence", "false"));
        if (!batchProcessSents) {
            sents = preserveSentenceSequence ? new LinkedHashMap() : new HashMap();
        } else {
            Data.sentsFiles = new ArrayList<File>();
            Data.sentId2File = new ConcurrentHashMap<String, File>();
        }
        String file = props.getProperty("file");
        String posModelPath = props.getProperty("posModelPath");
        boolean lowercase = Boolean.parseBoolean(props.getProperty("lowercaseText"));
        boolean useTargetNERRestriction = Boolean.parseBoolean(props.getProperty("useTargetNERRestriction"));
        boolean useTargetParserParentRestriction = Boolean.parseBoolean(props.getProperty(Flags.useTargetParserParentRestriction));
        boolean useContextNERRestriction = Boolean.parseBoolean(props.getProperty("useContextNERRestriction"));
        boolean addEvalSentsToTrain = Boolean.parseBoolean(props.getProperty("addEvalSentsToTrain", "true"));
        String evalFileWithGoldLabels = props.getProperty("evalFileWithGoldLabels");
        if (!(file != null || evalFileWithGoldLabels != null && addEvalSentsToTrain)) {
            throw new RuntimeException("No training data! file is " + file + " and evalFileWithGoldLabels is " + evalFileWithGoldLabels + " and addEvalSentsToTrain is " + addEvalSentsToTrain);
        }
        if (props.getProperty(Flags.patternType) == null) {
            throw new RuntimeException("PatternType not specified. Options are SURFACE and DEP");
        }
        PatternFactory.PatternType patternType = PatternFactory.PatternType.valueOf(props.getProperty(Flags.patternType));
        if (file != null) {
            String saveSentencesSerDirstr = props.getProperty("saveSentencesSerDir");
            File saveSentencesSerDir = null;
            if (saveSentencesSerDirstr != null) {
                saveSentencesSerDir = new File(saveSentencesSerDirstr);
                if (saveSentencesSerDir.exists() && !fileFormat.equalsIgnoreCase("ser")) {
                    IOUtils.deleteDirRecursively(saveSentencesSerDir);
                }
                IOUtils.ensureDir(saveSentencesSerDir);
            }
            String systemdir = System.getProperty("java.io.tmpdir");
            File tempSaveSentencesDir = File.createTempFile("sents", ".tmp", new File(systemdir));
            tempSaveSentencesDir.deleteOnExit();
            tempSaveSentencesDir.delete();
            tempSaveSentencesDir.mkdir();
            int numFilesTillNow = 0;
            if (fileFormat == null || fileFormat.equalsIgnoreCase("text") || fileFormat.equalsIgnoreCase("txt")) {
                HashMap sentsthis = preserveSentenceSequence ? new LinkedHashMap() : new HashMap();
                for (File f : GetPatternsFromDataMultiClass.getAllFiles(file)) {
                    Redwood.log(new Object[]{Redwood.DBG, "Annotating text in " + f});
                    Iterator<String> reader = IOUtils.readLines(f).iterator();
                    while (reader.hasNext()) {
                        numFilesTillNow = GetPatternsFromDataMultiClass.tokenize(reader, posModelPath, lowercase, useTargetNERRestriction || useContextNERRestriction, f.getName() + "-" + numFilesTillNow + "-", useTargetParserParentRestriction, props.getProperty(Flags.numThreads), batchProcessSents, numMaxSentencesPerBatchFile, saveSentencesSerDir == null ? tempSaveSentencesDir : saveSentencesSerDir, sentsthis, numFilesTillNow, patternType);
                    }
                    if (batchProcessSents) continue;
                    sents.putAll(sentsthis);
                }
                if (!batchProcessSents) {
                    String outfilename = (saveSentencesSerDir == null ? tempSaveSentencesDir : saveSentencesSerDir) + "/sents_" + numFilesTillNow;
                    if (saveSentencesSerDir != null) {
                        Data.inMemorySaveFileLocation = outfilename;
                    }
                    Redwood.log(new Object[]{Redwood.FORCE, "Saving sentences in " + outfilename});
                    IOUtils.writeObjectToFile((Object)sents, outfilename);
                }
            } else if (fileFormat.equalsIgnoreCase("ser")) {
                for (File f : GetPatternsFromDataMultiClass.getAllFiles(file)) {
                    Redwood.log(new Object[]{Redwood.DBG, "reading from ser file " + f});
                    if (!batchProcessSents) {
                        sents.putAll((Map)IOUtils.readObjectFromFile(f));
                        continue;
                    }
                    File newf = new File(tempSaveSentencesDir.getAbsolutePath() + "/" + f.getAbsolutePath().replaceAll(java.util.regex.Pattern.quote("/"), "_"));
                    IOUtils.cp(f, newf);
                    Data.sentsFiles.add(newf);
                }
            } else {
                throw new RuntimeException("Cannot identify the file format. Valid values are text (or txt) and ser, where the serialized file is of the type Map<String, DataInstance>.");
            }
        }
        HashMap<String, DataInstance> evalsents = new HashMap<String, DataInstance>();
        boolean evaluate = Boolean.parseBoolean(props.getProperty("evaluate"));
        if (evaluate && evalFileWithGoldLabels != null) {
            String saveEvalSentencesSerFile = props.getProperty("saveEvalSentencesSerFile");
            File saveEvalSentencesSerFileFile = null;
            if (saveEvalSentencesSerFile == null) {
                String systemdir = System.getProperty("java.io.tmpdir");
                saveEvalSentencesSerFileFile = File.createTempFile("evalsents", ".tmp", new File(systemdir));
            } else {
                saveEvalSentencesSerFileFile = new File(saveEvalSentencesSerFile);
            }
            HashMap<String, Class<? extends TypesafeMap.Key<String>>> setClassForTheseLabels = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
            List<File> allFiles = GetPatternsFromDataMultiClass.getAllFiles(evalFileWithGoldLabels);
            int numFile = 0;
            String evalFileFormat = props.getProperty("evalFileFormat");
            if (evalFileFormat == null || evalFileFormat.equalsIgnoreCase("text") || evalFileFormat.equalsIgnoreCase("txt") || evalFileFormat.startsWith("text")) {
                for (File f : allFiles) {
                    Redwood.log(new Object[]{Redwood.DBG, "Annotating text in " + f + ". Num file " + ++numFile});
                    if (evalFileFormat.equalsIgnoreCase("textCoNLLStyle")) {
                        Map<String, DataInstance> sentsEval = AnnotatedTextReader.parseColumnFile(new BufferedReader(new FileReader(f)), labels, setClassForTheseLabels, true, f.getName());
                        evalsents.putAll(GetPatternsFromDataMultiClass.runPOSNERParseOnTokens(sentsEval, props));
                        continue;
                    }
                    List<CoreMap> sentsCMs = AnnotatedTextReader.parseFile(new BufferedReader(new FileReader(f)), labels, setClassForTheseLabels, true, f.getName());
                    evalsents.putAll(GetPatternsFromDataMultiClass.runPOSNEROnTokens(sentsCMs, posModelPath, useTargetNERRestriction || useContextNERRestriction, "", useTargetParserParentRestriction, props.getProperty(Flags.numThreads), patternType));
                }
            } else if (fileFormat.equalsIgnoreCase("ser")) {
                for (File f : allFiles) {
                    evalsents.putAll((Map)IOUtils.readObjectFromFile(f));
                }
            }
            if (addEvalSentsToTrain) {
                Redwood.log(new Object[]{Redwood.DBG, "Adding " + evalsents.size() + " eval sents to the training set"});
            }
            IOUtils.writeObjectToFile(evalsents, saveEvalSentencesSerFileFile);
            if (batchProcessSents) {
                Data.sentsFiles.add(saveEvalSentencesSerFileFile);
                for (String k : evalsents.keySet()) {
                    Data.sentId2File.put(k, saveEvalSentencesSerFileFile);
                }
            } else {
                sents.putAll(evalsents);
            }
        }
        return new Pair<Map<String, DataInstance>, Map<String, DataInstance>>(sents, evalsents);
    }

    private void saveModel() throws IOException {
        String patternsWordsDir;
        String patternsWordsDirValue = this.props.getProperty("patternsWordsDir");
        if (patternsWordsDirValue.endsWith(".zip")) {
            File temp = File.createTempFile("patswords", "dir");
            temp.deleteOnExit();
            temp.delete();
            temp.mkdirs();
            patternsWordsDir = temp.getAbsolutePath();
        } else {
            patternsWordsDir = patternsWordsDirValue;
        }
        Redwood.log(new Object[]{Redwood.FORCE, "Saving output in " + patternsWordsDir});
        IOUtils.ensureDir(new File(patternsWordsDir));
        String outPropertiesFile = patternsWordsDir + "model.properties";
        this.props.store(new BufferedWriter(new FileWriter(outPropertiesFile)), "trained model properties file");
        for (String label : this.constVars.getLabels()) {
            IOUtils.ensureDir(new File(patternsWordsDir + "/" + label));
            BufferedWriter seedW = new BufferedWriter(new FileWriter(patternsWordsDir + "/" + label + "/seedwords.txt"));
            for (CandidatePhrase p : this.constVars.getSeedLabelDictionary().get(label)) {
                seedW.write(p.getPhrase() + "\n");
            }
            seedW.close();
            Map<Integer, Counter<E>> pats = this.getLearnedPatternsEachIter(label);
            IOUtils.writeObjectToFile(pats, patternsWordsDir + "/" + label + "/patternsEachIter.ser");
            BufferedWriter w = new BufferedWriter(new FileWriter(patternsWordsDir + "/" + label + "/phrases.txt"));
            this.writeWordsToFile(this.constVars.getLearnedWordsEachIter(label), w);
            GetPatternsFromDataMultiClass.writeClassesInEnv(this.constVars.env, ConstantsAndVariables.globalEnv, patternsWordsDir + "/env.txt");
            if (this.constVars.patternType.equals((Object)PatternFactory.PatternType.SURFACE)) {
                IOUtils.writeStringToFile(Token.toStringClass2KeyMapping(), patternsWordsDir + "/tokenenv.txt", "utf8");
            }
            w.close();
        }
    }

    private void evaluate(Map<String, DataInstance> evalsents) throws IOException {
        if (this.constVars.goldEntitiesEvalFiles != null) {
            for (String label : this.constVars.getLabels()) {
                if (!this.constVars.goldEntities.containsKey(label)) continue;
                Pair<Double, Double> pr = this.getPrecisionRecall(label, this.constVars.goldEntities.get(label));
                Redwood.log(ConstantsAndVariables.minimaldebug, "\nFor label " + label + ": Number of gold entities is " + this.constVars.goldEntities.get(label).size() + ", Precision is " + this.df.format(pr.first() * 100.0) + ", Recall is " + this.df.format(pr.second() * 100.0) + ", F1 is " + this.df.format(GetPatternsFromDataMultiClass.FScore(pr.first(), pr.second(), 1.0) * 100.0) + "\n\n");
            }
        }
        if (evalsents.size() > 0) {
            boolean evalPerEntity = Boolean.parseBoolean(this.props.getProperty("evalPerEntity", "true"));
            this.evaluate(evalsents, evalPerEntity);
        }
        if (evalsents.size() == 0 && this.constVars.goldEntitiesEvalFiles == null) {
            log.info("No eval sentences or list of gold entities provided to evaluate! Make sure evalFileWithGoldLabels or goldEntitiesEvalFiles is set, or turn off the evaluate flag");
        }
    }

    public static <E extends Pattern> GetPatternsFromDataMultiClass<E> run(Properties props) throws IOException, ClassNotFoundException, IllegalAccessException, InterruptedException, ExecutionException, InstantiationException, NoSuchMethodException, InvocationTargetException, SQLException {
        Map<String, Set<CandidatePhrase>> seedWords = GetPatternsFromDataMultiClass.readSeedWords(props);
        HashMap answerClasses = new HashMap();
        String ansClasses = props.getProperty("answerClasses");
        if (ansClasses != null) {
            for (String l : ansClasses.split(";")) {
                String[] t = l.split(",");
                String label = t[0];
                String cl = t[1];
                Class<?> answerClass = ClassLoader.getSystemClassLoader().loadClass(cl);
                answerClasses.put(label, answerClass);
            }
        }
        Pair<Map<String, DataInstance>, Map<String, DataInstance>> sentsPair = GetPatternsFromDataMultiClass.processSents(props, seedWords.keySet());
        boolean labelUsingSeedSets = Boolean.parseBoolean(props.getProperty("labelUsingSeedSets", "true"));
        GetPatternsFromDataMultiClass<E> model = new GetPatternsFromDataMultiClass<E>(props, sentsPair.first(), seedWords, labelUsingSeedSets);
        return GetPatternsFromDataMultiClass.runNineYards(model, props, sentsPair.second());
    }

    private static <E extends Pattern> GetPatternsFromDataMultiClass<E> runNineYards(GetPatternsFromDataMultiClass<E> model, Properties props, Map<String, DataInstance> evalsents) throws IOException, ClassNotFoundException {
        boolean evaluate;
        ArgumentParser.fillOptions(model, props);
        boolean loadSavedPatternsWordsDir = Boolean.parseBoolean(props.getProperty("loadSavedPatternsWordsDir"));
        if (loadSavedPatternsWordsDir) {
            GetPatternsFromDataMultiClass.loadFromSavedPatternsWordsDir(model, props);
        }
        if (model.constVars.learn) {
            HashMap p0 = new HashMap();
            HashMap<String, Counter<CandidatePhrase>> p0Set = new HashMap<String, Counter<CandidatePhrase>>();
            HashMap<String, Set<E>> ignorePatterns = new HashMap<String, Set<E>>();
            model.iterateExtractApply(p0, p0Set, ignorePatterns);
        }
        if (model.constVars.markedOutputTextFile != null) {
            model.writeLabeledData(model.constVars.markedOutputTextFile);
        }
        if (model.constVars.columnOutputFile != null) {
            GetPatternsFromDataMultiClass.writeColumnOutput(model.constVars.columnOutputFile, model.constVars.batchProcessSents, model.constVars.getAnswerClass());
        }
        if (model.constVars.savePatternsWordsDir) {
            super.saveModel();
        }
        if ((evaluate = Boolean.parseBoolean(props.getProperty("evaluate"))) && evalsents != null) {
            super.evaluate(evalsents);
        }
        if (model.constVars.saveInvertedIndex) {
            model.constVars.invertedIndex.saveIndex(model.constVars.invertedIndexDirectory);
        }
        if (model.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.LUCENE)) {
            model.patsForEachToken.close();
        }
        return model;
    }

    private static void addFolder(ZipOutputStream zos, String folderName, String baseFolderName) throws IOException {
        File f = new File(folderName);
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] f2;
                if (!folderName.equalsIgnoreCase(baseFolderName)) {
                    String entryName = folderName.substring(baseFolderName.length() + 1, folderName.length()) + File.separatorChar;
                    System.out.println("Adding folder entry " + entryName);
                    ZipEntry zipEntry = new ZipEntry(entryName);
                    zos.putNextEntry(zipEntry);
                }
                for (File aF2 : f2 = f.listFiles()) {
                    GetPatternsFromDataMultiClass.addFolder(zos, aF2.getAbsolutePath(), baseFolderName);
                }
            } else {
                int len;
                String entryName = folderName.substring(baseFolderName.length() + 1, folderName.length());
                ZipEntry zipEntry = new ZipEntry(entryName);
                zos.putNextEntry(zipEntry);
                FileInputStream in = new FileInputStream(folderName);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) < 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
                zos.closeEntry();
                System.out.println("OK!");
            }
        } else {
            System.out.println("File or directory not found " + folderName);
        }
    }

    public static <E extends Pattern> Map<E, String> loadFromSavedPatternsWordsDir(GetPatternsFromDataMultiClass<E> model, Properties props) throws IOException, ClassNotFoundException {
        String patternsWordsDirValue;
        boolean labelSentsUsingModel = Boolean.parseBoolean(props.getProperty("labelSentsUsingModel", "true"));
        boolean applyPatsUsingModel = Boolean.parseBoolean(props.getProperty("applyPatsUsingModel", "true"));
        int numIterationsOfSavedPatternsToLoad = Integer.parseInt(props.getProperty(Flags.numIterationsOfSavedPatternsToLoad, String.valueOf(Integer.MAX_VALUE)));
        HashMap<Pattern, String> labelsForPattterns = new HashMap<Pattern, String>();
        String patternsWordsDir = patternsWordsDirValue = props.getProperty(Flags.patternsWordsDir);
        String sentsOutFile = props.getProperty("sentsOutFile");
        String loadModelForLabels = props.getProperty(Flags.loadModelForLabels);
        List<String> loadModelForLabelsList = null;
        if (loadModelForLabels != null) {
            loadModelForLabelsList = Arrays.asList(loadModelForLabels.split("[,;]"));
        }
        for (String label : model.constVars.getLabels()) {
            File wordf;
            File patf;
            if (loadModelForLabels != null && !loadModelForLabelsList.contains(label)) continue;
            assert (new File(patternsWordsDir + "/" + label).exists()) : "Why does the directory " + patternsWordsDir + "/" + label + " not exist?";
            GetPatternsFromDataMultiClass.readClassesInEnv(patternsWordsDir + "/env.txt", model.constVars.env, ConstantsAndVariables.globalEnv);
            if (model.constVars.patternType.equals((Object)PatternFactory.PatternType.SURFACE)) {
                Token.setClass2KeyMapping(new File(patternsWordsDir + "/tokenenv.txt"));
            }
            if ((patf = new File(patternsWordsDir + "/" + label + "/patternsEachIter.ser")).exists()) {
                Map patterns = (Map)IOUtils.readObjectFromFile(patf);
                if (numIterationsOfSavedPatternsToLoad < Integer.MAX_VALUE) {
                    HashSet<Integer> toremove = new HashSet<Integer>();
                    for (Integer i : patterns.keySet()) {
                        if (i < numIterationsOfSavedPatternsToLoad) continue;
                        System.out.println("Removing patterns from iteration " + i);
                        toremove.add(i);
                    }
                    for (Integer i : toremove) {
                        patterns.remove(i);
                    }
                }
                Counter pats = Counters.flatten(patterns);
                for (Iterator p : pats.keySet()) {
                    labelsForPattterns.put((Pattern)((Object)p), label);
                }
                numIterationsLoadedModel = Math.max(numIterationsLoadedModel, patterns.size());
                model.setLearnedPatterns(pats, label);
                super.setLearnedPatternsEachIter(patterns, label);
                Redwood.log(new Object[]{Redwood.DBG, "Loaded " + model.getLearnedPatterns().get(label).size() + " patterns from " + patf});
            }
            if ((wordf = new File(patternsWordsDir + "/" + label + "/phrases.txt")).exists()) {
                TreeMap<Integer, Counter<CandidatePhrase>> words = GetPatternsFromDataMultiClass.readLearnedWordsFromFile(wordf);
                model.constVars.setLearnedWordsEachIter(words, label);
                if (numIterationsOfSavedPatternsToLoad < Integer.MAX_VALUE) {
                    Iterator p;
                    HashSet<Integer> toremove = new HashSet<Integer>();
                    for (Integer i : words.keySet()) {
                        if (i < numIterationsOfSavedPatternsToLoad) continue;
                        System.out.println("Removing patterns from iteration " + i);
                        toremove.add(i);
                    }
                    p = toremove.iterator();
                    while (p.hasNext()) {
                        Integer i;
                        i = (Integer)p.next();
                        words.remove(i);
                    }
                }
                numIterationsLoadedModel = Math.max(numIterationsLoadedModel, words.size());
                Redwood.log(new Object[]{Redwood.DBG, "Loaded " + words.size() + " phrases from " + wordf});
            }
            CollectionValuedMap matchedTokensByPat = new CollectionValuedMap();
            ConstantsAndVariables.DataSentsIterator sentsIter = new ConstantsAndVariables.DataSentsIterator(model.constVars.batchProcessSents);
            TwoDimensionalCounter wordsandLemmaPatExtracted = new TwoDimensionalCounter();
            HashSet<CandidatePhrase> alreadyLabeledWords = new HashSet<CandidatePhrase>();
            while (sentsIter.hasNext()) {
                Pair sents = (Pair)sentsIter.next();
                if (labelSentsUsingModel) {
                    Redwood.log(new Object[]{Redwood.DBG, "labeling sentences from " + sents.second() + " with the already learned words"});
                    assert (sents.first() != null) : "Why are sents null";
                    model.labelWords(label, (Map)sents.first(), model.constVars.getLearnedWords(label).keySet(), sentsOutFile, matchedTokensByPat);
                    if (((File)sents.second()).exists()) {
                        IOUtils.writeObjectToFile((Object)sents, (File)sents.second());
                    }
                }
                if (!model.constVars.restrictToMatched && !applyPatsUsingModel) continue;
                Redwood.log(new Object[]{Redwood.DBG, "Applying patterns to " + ((Map)sents.first()).size() + " sentences"});
                model.constVars.invertedIndex.add((Map)sents.first(), true);
                model.constVars.invertedIndex.add((Map)sents.first(), true);
                model.scorePhrases.applyPats(model.getLearnedPatterns(label), label, wordsandLemmaPatExtracted, matchedTokensByPat, alreadyLabeledWords);
            }
            Counters.addInPlace(model.wordsPatExtracted.get(label), wordsandLemmaPatExtracted);
            System.out.println("All Extracted phrases are " + wordsandLemmaPatExtracted.firstKeySet());
        }
        System.out.flush();
        System.err.flush();
        return labelsForPattterns;
    }

    private void setLearnedPatternsEachIter(Map<Integer, Counter<E>> patterns, String label) {
        this.learnedPatternsEachIter.put(label, patterns);
    }

    private static void readClassesInEnv(String s, Map<String, Env> env, Env globalEnv) throws ClassNotFoundException {
        for (String line : IOUtils.readLines(s)) {
            String[] toks = line.split("###");
            if (toks.length == 3) {
                String label = toks[0];
                String name = toks[1];
                Class<?> c = Class.forName(toks[2]);
                if (!env.containsKey(label)) {
                    env.put(label, TokenSequencePattern.getNewEnv());
                }
                env.get(label).bind(name, c);
                continue;
            }
            if (toks.length == 2) {
                String name = toks[0];
                Class<?> c = Class.forName(toks[1]);
                assert (c != null) : " Why is name for " + toks[1] + " null";
                globalEnv.bind(name, c);
                continue;
            }
            throw new RuntimeException("Ill formed env file!");
        }
    }

    private static void writeClassesInEnv(Map<String, Env> env, Env globalEnv, String file) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        for (Map.Entry<String, Env> en : env.entrySet()) {
            for (Map.Entry<String, Object> en2 : en.getValue().getVariables().entrySet()) {
                if (!(en2.getValue() instanceof Class)) continue;
                w.write(en.getKey() + "###" + en2.getKey() + "###" + ((Class)en2.getValue()).getName() + "\n");
            }
        }
        for (Map.Entry<String, Object> en2 : globalEnv.getVariables().entrySet()) {
            if (!(en2.getValue() instanceof Class)) continue;
            w.write(en2.getKey() + "###" + ((Class)en2.getValue()).getName() + "\n");
        }
        w.close();
    }

    public static String elapsedTime(Date d1, Date d2) {
        try {
            Duration period = Duration.between(d1.toInstant(), d2.toInstant());
            long days = period.toDays();
            period = period.minusDays(days);
            long hours = period.toHours();
            period = period.minusHours(hours);
            long minutes = period.toMinutes();
            period = period.minusMinutes(minutes);
            long seconds = period.getSeconds();
            return days + " days, " + hours + " hours, " + minutes + " minutes, " + seconds + " seconds";
        }
        catch (IllegalArgumentException e) {
            log.warn(e);
            return "";
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = StringUtils.argsToPropertiesWithResolve(args);
            GetPatternsFromDataMultiClass.run(props);
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of memory! Either change the memory allotted by running as java -mx20g ... for example if you want to allocate 20G. Or consider using batchProcessSents and numMaxSentencesPerBatchFile flags");
            log.warn(e);
        }
        catch (Exception e) {
            log.warn(e);
        }
    }

    public static class Flags {
        public static String useTargetParserParentRestriction = "useTargetParserParentRestriction";
        public static String useTargetNERRestriction = "useTargetNERRestriction";
        public static String posModelPath = "posModelPath";
        public static String numThreads = "numThreads";
        public static String patternType = "patternType";
        public static String numIterationsOfSavedPatternsToLoad = "numIterationsOfSavedPatternsToLoad";
        public static String patternsWordsDir = "patternsWordsDir";
        public static String loadModelForLabels = "loadModelForLabels";
    }

    private class CalculateSufficientStatsThreads
    implements Callable {
        private final Map<String, DataInstance> sents;
        private final PatternsForEachToken patternsForEachToken;
        private final Collection<String> sentIds;
        private final String label;
        private final Class answerClass4Label;

        public CalculateSufficientStatsThreads(PatternsForEachToken patternsForEachToken, Collection<String> sentIds, Map<String, DataInstance> sents, String label, Class answerClass4Label) {
            this.patternsForEachToken = patternsForEachToken;
            this.sentIds = sentIds;
            this.sents = sents;
            this.label = label;
            this.answerClass4Label = answerClass4Label;
        }

        public Triple<List<Pair<E, CandidatePhrase>>, List<Pair<E, CandidatePhrase>>, List<Pair<E, CandidatePhrase>>> call() throws Exception {
            ArrayList<Pair<Pattern, CandidatePhrase>> posWords = new ArrayList<Pair<Pattern, CandidatePhrase>>();
            ArrayList<Pair<Pattern, CandidatePhrase>> negWords = new ArrayList<Pair<Pattern, CandidatePhrase>>();
            ArrayList<Pair<Pattern, CandidatePhrase>> unlabWords = new ArrayList<Pair<Pattern, CandidatePhrase>>();
            for (String sentId : this.sentIds) {
                Map pat4Sent = this.patternsForEachToken.getPatternsForAllTokens(sentId);
                if (pat4Sent == null) {
                    throw new RuntimeException("How come there are no patterns for " + sentId);
                }
                DataInstance sent = this.sents.get(sentId);
                List<CoreLabel> tokens = sent.getTokens();
                for (int i = 0; i < tokens.size(); ++i) {
                    Map longestMatchingPhrases;
                    CandidatePhrase longestMatchingPhrase;
                    CoreLabel token = tokens.get(i);
                    CandidatePhrase tokenWordOrLemma = CandidatePhrase.createOrGet(token.word());
                    longestMatchingPhrase = GetPatternsFromDataMultiClass.this.constVars.useMatchingPhrase ? ((longestMatchingPhrase = (CandidatePhrase)(longestMatchingPhrases = (Map)token.get(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class)).get(this.label)) != null && longestMatchingPhrase.getPhrase().length() > tokenWordOrLemma.getPhrase().length() ? longestMatchingPhrase : tokenWordOrLemma) : tokenWordOrLemma;
                    Set pats = pat4Sent.get(i);
                    HashSet<SurfacePattern> newpats = new HashSet<SurfacePattern>();
                    boolean changedpats = false;
                    if (pats != null) {
                        for (Pattern s : pats) {
                            if (!(s instanceof SurfacePattern)) continue;
                            changedpats = true;
                            Iterator<String> snew = ((SurfacePattern)s).copyNewToken();
                            ((SurfacePattern)((Object)snew)).setNumWordsCompound(PatternFactory.numWordsCompoundMapped.get(this.label));
                            newpats.add((SurfacePattern)((Object)snew));
                        }
                    }
                    if (changedpats) {
                        pats = newpats;
                    }
                    if (pats == null) {
                        if (GetPatternsFromDataMultiClass.this.constVars.patternType.equals((Object)PatternFactory.PatternType.DEP)) continue;
                        throw new RuntimeException("Why are patterns null for sentence " + sentId + " and token " + i + "(" + tokens.get(i) + "). pat4Sent has token ids " + pat4Sent.keySet() + (GetPatternsFromDataMultiClass.this.constVars.batchProcessSents ? "" : ". The sentence is " + Data.sents.get(sentId)) + ". If you have changed parameters, recompute all patterns.");
                    }
                    if (PatternFactory.ignoreWordRegex.matcher(token.word()).matches()) continue;
                    String tag = token.tag();
                    if (GetPatternsFromDataMultiClass.this.constVars.allowedTagsInitials != null && GetPatternsFromDataMultiClass.this.constVars.allowedTagsInitials.containsKey(this.label)) {
                        boolean use = false;
                        for (String allowed : GetPatternsFromDataMultiClass.this.constVars.allowedTagsInitials.get(this.label)) {
                            if (!tag.startsWith(allowed)) continue;
                            use = true;
                            break;
                        }
                        if (!use) continue;
                    }
                    String nertag = token.ner();
                    if (GetPatternsFromDataMultiClass.this.constVars.allowedNERsforLabels != null && GetPatternsFromDataMultiClass.this.constVars.allowedNERsforLabels.containsKey(this.label) && !GetPatternsFromDataMultiClass.this.constVars.allowedNERsforLabels.get(this.label).contains(nertag)) continue;
                    if (token.get(this.answerClass4Label).equals(this.label)) {
                        for (Pattern s : pats) {
                            posWords.add(new Pair<Pattern, CandidatePhrase>(s, longestMatchingPhrase));
                        }
                        continue;
                    }
                    boolean negToken = false;
                    Map<Class, Object> ignore = GetPatternsFromDataMultiClass.this.constVars.getIgnoreWordswithClassesDuringSelection().get(this.label);
                    for (Class igCl : ignore.keySet()) {
                        if (!((Boolean)token.get(igCl)).booleanValue()) continue;
                        negToken = true;
                        break;
                    }
                    if (!negToken && (GetPatternsFromDataMultiClass.this.constVars.getOtherSemanticClassesWords().contains(token.word()) || GetPatternsFromDataMultiClass.this.constVars.getOtherSemanticClassesWords().contains(token.lemma()))) {
                        negToken = true;
                    }
                    if (!negToken) {
                        for (String labelA : GetPatternsFromDataMultiClass.this.constVars.getLabels()) {
                            if (labelA.equals(this.label) || !GetPatternsFromDataMultiClass.this.constVars.getSeedLabelDictionary().get(labelA).contains(longestMatchingPhrase) && !GetPatternsFromDataMultiClass.this.constVars.getSeedLabelDictionary().get(labelA).contains(tokenWordOrLemma) && !GetPatternsFromDataMultiClass.this.constVars.getLearnedWords(labelA).containsKey(longestMatchingPhrase) && !GetPatternsFromDataMultiClass.this.constVars.getLearnedWords(labelA).containsKey(tokenWordOrLemma)) continue;
                            negToken = true;
                            break;
                        }
                    }
                    for (Pattern sindex : pats) {
                        if (negToken) {
                            negWords.add(new Pair<Pattern, CandidatePhrase>(sindex, longestMatchingPhrase));
                            continue;
                        }
                        unlabWords.add(new Pair<Pattern, CandidatePhrase>(sindex, longestMatchingPhrase));
                    }
                }
            }
            return new Triple(posWords, negWords, unlabWords);
        }
    }

    public static class LabelWithSeedWords
    implements Callable<Pair<Map<String, DataInstance>, Counter<CandidatePhrase>>> {
        Map<CandidatePhrase, String[]> seedwordsTokens = new HashMap<CandidatePhrase, String[]>();
        Map<String, DataInstance> sents;
        List<String> keyset;
        Class labelClass;
        HashSet<String> seenFuzzyMatches = new HashSet();
        String label;
        int minLen4FuzzyForPattern;
        String backgroundSymbol = "O";
        Set<String> doNotLabelDictWords = null;
        Function<CoreLabel, String> stringTransformation;
        boolean writeMatchedTokensIdsForEachPhrase = false;
        boolean overwriteExistingLabels;
        PatternFactory.PatternType patternType;
        boolean fuzzyMatch = false;
        Map<String, String> ignoreCaseSeedMatch;

        public LabelWithSeedWords(Collection<CandidatePhrase> seedwords, Map<String, DataInstance> sents, List<String> keyset, Class labelclass, String label, boolean fuzzyMatch, int minLen4FuzzyForPattern, String backgroundSymbol, Set<String> doNotLabelDictWords, Function<CoreLabel, String> stringTransformation, boolean writeMatchedTokensIdsForEachPhrase, boolean overwriteExistingLabels, PatternFactory.PatternType type, Map<String, String> ignoreCaseSeedMatch) {
            for (CandidatePhrase s : seedwords) {
                this.seedwordsTokens.put(s, s.getPhrase().split("\\s+"));
            }
            this.sents = sents;
            this.keyset = keyset;
            this.labelClass = labelclass;
            this.label = label;
            this.minLen4FuzzyForPattern = minLen4FuzzyForPattern;
            this.backgroundSymbol = backgroundSymbol;
            this.doNotLabelDictWords = doNotLabelDictWords;
            this.stringTransformation = stringTransformation;
            this.writeMatchedTokensIdsForEachPhrase = writeMatchedTokensIdsForEachPhrase;
            this.overwriteExistingLabels = overwriteExistingLabels;
            this.patternType = type;
            this.fuzzyMatch = fuzzyMatch;
            this.ignoreCaseSeedMatch = ignoreCaseSeedMatch;
        }

        @Override
        public Pair<Map<String, DataInstance>, Counter<CandidatePhrase>> call() {
            HashMap<String, DataInstance> newsent = new HashMap<String, DataInstance>();
            ClassicCounter<CandidatePhrase> matchedPhrasesCounter = new ClassicCounter<CandidatePhrase>();
            for (String k : this.keyset) {
                DataInstance sent = this.sents.get(k);
                List<CoreLabel> tokensCore = sent.getTokens();
                SemanticGraph graph = null;
                if (this.patternType.equals((Object)PatternFactory.PatternType.DEP)) {
                    graph = ((DataInstanceDep)sent).getGraph();
                }
                String[] tokens = new String[tokensCore.size()];
                String[] tokenslemma = new String[tokensCore.size()];
                int num = 0;
                for (CoreLabel l : tokensCore) {
                    l.set(PatternsAnnotations.ProcessedTextAnnotation.class, this.stringTransformation.apply(l));
                    tokens[num] = l.word();
                    if (this.fuzzyMatch && l.lemma() == null) {
                        throw new RuntimeException("how come lemma is null");
                    }
                    tokenslemma[num] = l.lemma();
                    ++num;
                }
                boolean[] labels = new boolean[tokens.length];
                CollectionValuedMap<Integer, CandidatePhrase> matchedPhrases = new CollectionValuedMap<Integer, CandidatePhrase>();
                HashMap<Integer, CandidatePhrase> longestMatchedPhrases = new HashMap<Integer, CandidatePhrase>();
                for (Map.Entry<CandidatePhrase, String[]> sEn : this.seedwordsTokens.entrySet()) {
                    String[] s = sEn.getValue();
                    CandidatePhrase sc = sEn.getKey();
                    List<Integer> indices = GetPatternsFromDataMultiClass.getSubListIndex(s, tokens, tokenslemma, this.doNotLabelDictWords, this.seenFuzzyMatches, this.minLen4FuzzyForPattern, this.fuzzyMatch, this.ignoreCaseSeedMatch.containsKey(this.label) ? Boolean.valueOf(this.ignoreCaseSeedMatch.get(this.label)) : false);
                    if (indices == null || indices.isEmpty()) continue;
                    String ph = StringUtils.join(s, " ");
                    sc.addFeature("LENGTH-" + s.length, 1.0);
                    ArrayList<String> features = new ArrayList<String>();
                    for (int index : indices) {
                        if (graph != null) {
                            GetPatternsFromDataMultiClass.getFeatures(graph, graph.getNodeByIndex(index + 1), true, features, null);
                        }
                        if (this.writeMatchedTokensIdsForEachPhrase) {
                            GetPatternsFromDataMultiClass.addToMatchedTokensByPhrase(ph, k, index, s.length);
                        }
                        for (int i = 0; i < s.length; ++i) {
                            CandidatePhrase longPh;
                            matchedPhrases.add(index + i, sc);
                            if (graph != null) {
                                try {
                                    GetPatternsFromDataMultiClass.getFeatures(graph, graph.getNodeByIndex(index + i + 1), false, features, null);
                                }
                                catch (Exception e) {
                                    log.warn(e);
                                }
                            }
                            longPh = (longPh = (CandidatePhrase)longestMatchedPhrases.get(index + i)) != null && longPh.getPhrase().length() > sc.getPhrase().length() ? longPh : sc;
                            longestMatchedPhrases.put(index + i, longPh);
                            labels[index + i] = true;
                        }
                    }
                    sc.addFeatures(features);
                }
                int i = -1;
                for (CoreLabel l : sent.getTokens()) {
                    ++i;
                    if (!l.containsKey(PatternsAnnotations.MatchedPhrases.class) || !PatternsAnnotations.MatchedPhrases.class.isInstance(l.get(PatternsAnnotations.MatchedPhrases.class))) {
                        l.set(PatternsAnnotations.MatchedPhrases.class, new CollectionValuedMap());
                    }
                    if (!l.containsKey(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class)) {
                        l.set(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class, new HashMap());
                    }
                    if (labels[i]) {
                        l.set(this.labelClass, this.label);
                        if (!l.containsKey(PatternsAnnotations.SeedLabeledOrNot.class)) {
                            l.set(PatternsAnnotations.SeedLabeledOrNot.class, new HashMap());
                        }
                        ((Map)l.get(PatternsAnnotations.SeedLabeledOrNot.class)).put(this.labelClass, true);
                        CandidatePhrase longestMatchingPh = (CandidatePhrase)((Map)l.get(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class)).get(this.label);
                        assert (longestMatchedPhrases.containsKey(i));
                        longestMatchingPh = longestMatchingPh != null && longestMatchingPh.getPhrase().length() > ((CandidatePhrase)longestMatchedPhrases.get(i)).getPhrase().length() ? longestMatchingPh : (CandidatePhrase)longestMatchedPhrases.get(i);
                        ((Map)l.get(PatternsAnnotations.LongestMatchedPhraseForEachLabel.class)).put(this.label, longestMatchingPh);
                        matchedPhrasesCounter.incrementCount(longestMatchingPh, 1.0);
                        ((CollectionValuedMap)l.get(PatternsAnnotations.MatchedPhrases.class)).addAll(this.label, matchedPhrases.get(i));
                        Redwood.log(ConstantsAndVariables.extremedebug, "labeling " + l.word() + " or its lemma " + l.lemma() + " as " + this.label + " because of the dict phrases " + matchedPhrases.get(i));
                        continue;
                    }
                    if (!this.overwriteExistingLabels) continue;
                    l.set(this.labelClass, this.backgroundSymbol);
                }
                newsent.put(k, sent);
            }
            return new Pair<Map<String, DataInstance>, Counter<CandidatePhrase>>(newsent, matchedPhrasesCounter);
        }
    }

    static enum WordScoring {
        BPB,
        WEIGHTEDNORM;

    }

    public static enum PatternScoring {
        F1SeedPattern,
        RlogF,
        RlogFPosNeg,
        RlogFUnlabNeg,
        RlogFNeg,
        PhEvalInPat,
        PhEvalInPatLogP,
        PosNegOdds,
        YanGarber02,
        PosNegUnlabOdds,
        RatioAll,
        LOGREG,
        LOGREGlogP,
        SqrtAllRatio,
        LinICML03,
        kNN;

    }
}

