/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.GoogleNGramsSQLBacked;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PhraseScorer<E extends Pattern> {
    private static Redwood.RedwoodChannels log = Redwood.channels(PhraseScorer.class);
    ConstantsAndVariables constVars;
    double OOVExternalFeatWt = 0.5;
    double OOVdictOdds = 1.0E-10;
    double OOVDomainNgramScore = 1.0E-10;
    double OOVGoogleNgramScore = 1.0E-10;
    @ArgumentParser.Option(name="usePatternWeights")
    public boolean usePatternWeights = true;
    @ArgumentParser.Option(name="wordFreqNorm")
    Normalization wordFreqNorm = Normalization.valueOf("LOG");
    @ArgumentParser.Option(name="useAvgInsteadofMinPhraseScoring")
    boolean useAvgInsteadofMinPhraseScoring = false;
    Counter<CandidatePhrase> learnedScores = new ClassicCounter<CandidatePhrase>();

    public PhraseScorer(ConstantsAndVariables constvar) {
        this.constVars = constvar;
    }

    abstract Counter<CandidatePhrase> scorePhrases(String var1, TwoDimensionalCounter<CandidatePhrase, E> var2, TwoDimensionalCounter<CandidatePhrase, E> var3, Counter<E> var4, Set<CandidatePhrase> var5, boolean var6) throws IOException, ClassNotFoundException;

    Counter<CandidatePhrase> getLearnedScores() {
        return this.learnedScores;
    }

    double getPatTFIDFScore(CandidatePhrase word, Counter<E> patsThatExtractedThis, Counter<E> allSelectedPatterns) {
        if (Data.processedDataFreq.getCount(word) == 0.0) {
            Redwood.log(new Object[]{Redwood.WARN, "How come the processed corpus freq has count of " + word + " 0. The count in raw freq is " + Data.rawFreq.getCount(word) + " and the Data.rawFreq size is " + Data.rawFreq.size()});
            return 0.0;
        }
        double total = 0.0;
        HashSet<Pattern> rem = new HashSet<Pattern>();
        for (Map.Entry<E, Double> en2 : patsThatExtractedThis.entrySet()) {
            double weight = 1.0;
            if (this.usePatternWeights && (weight = allSelectedPatterns.getCount(en2.getKey())) == 0.0) {
                Redwood.log(new Object[]{Redwood.FORCE, "Warning: Weight zero for " + en2.getKey() + ". May be pattern was removed when choosing other patterns (if subsumed by another pattern)."});
                rem.add((Pattern)en2.getKey());
            }
            total += weight;
        }
        Counters.removeKeys(patsThatExtractedThis, rem);
        double score = total / Data.processedDataFreq.getCount(word);
        return score;
    }

    public static double getGoogleNgramScore(CandidatePhrase g) {
        double count = GoogleNGramsSQLBacked.getCount(g.getPhrase().toLowerCase()) + GoogleNGramsSQLBacked.getCount(g.getPhrase());
        if (count != -1.0) {
            if (!Data.rawFreq.containsKey(g)) {
                return 1.0;
            }
            return (1.0 + Data.rawFreq.getCount(g) * Math.sqrt(Data.ratioGoogleNgramFreqWithDataFreq)) / count;
        }
        return 0.0;
    }

    public double getDomainNgramScore(String g) {
        String gnew = g;
        if (!Data.domainNGramRawFreq.containsKey(gnew)) {
            gnew = g.replaceAll(" ", "");
        }
        if (!Data.domainNGramRawFreq.containsKey(gnew)) {
            gnew = g.replaceAll("-", "");
        } else {
            g = gnew;
        }
        if (!Data.domainNGramRawFreq.containsKey(gnew)) {
            log.info("domain count 0 for " + g);
            return 0.0;
        }
        g = gnew;
        return (1.0 + Data.rawFreq.getCount(g) * Math.sqrt(Data.ratioDomainNgramFreqWithDataFreq)) / Data.domainNGramRawFreq.getCount(g);
    }

    public double getDistSimWtScore(String ph, String label) {
        Integer num = this.constVars.getWordClassClusters().get(ph);
        if (num == null) {
            num = this.constVars.getWordClassClusters().get(ph.toLowerCase());
        }
        if (num != null && this.constVars.distSimWeights.get(label).containsKey(num)) {
            return this.constVars.distSimWeights.get(label).getCount(num);
        }
        String[] t = ph.split("\\s+");
        if (t.length < 2) {
            return this.OOVExternalFeatWt;
        }
        double totalscore = 0.0;
        double minScore = Double.MAX_VALUE;
        for (String w : t) {
            double score = this.OOVExternalFeatWt;
            Integer numw = this.constVars.getWordClassClusters().get(w);
            if (num == null) {
                num = this.constVars.getWordClassClusters().get(w.toLowerCase());
            }
            if (numw != null && this.constVars.distSimWeights.get(label).containsKey(numw)) {
                score = this.constVars.distSimWeights.get(label).getCount(numw);
            }
            if (score < minScore) {
                minScore = score;
            }
            totalscore += score;
        }
        if (this.useAvgInsteadofMinPhraseScoring) {
            return totalscore / (double)ph.length();
        }
        return minScore;
    }

    public String wordShape(String word) {
        String wordShape = this.constVars.getWordShapeCache().get(word);
        if (wordShape == null) {
            wordShape = WordShapeClassifier.wordShape(word, this.constVars.wordShaper);
            this.constVars.getWordShapeCache().put(word, wordShape);
        }
        return wordShape;
    }

    public double getWordShapeScore(String word, String label) {
        String wordShape = this.wordShape(word);
        double thislabel = 0.0;
        double alllabels = 0.0;
        for (Map.Entry<String, Counter<String>> en : this.constVars.getWordShapesForLabels().entrySet()) {
            if (en.getKey().equals(label)) {
                thislabel = en.getValue().getCount(wordShape);
            }
            alllabels += en.getValue().getCount(wordShape);
        }
        double score = thislabel / (alllabels + 1.0);
        return score;
    }

    public double getDictOddsScore(CandidatePhrase word, String label, double defaultWt) {
        Counter<CandidatePhrase> dictOddsWordWeights = this.constVars.dictOddsWeights.get(label);
        assert (dictOddsWordWeights != null) : "dictOddsWordWeights is null for label " + label;
        double dscore = dictOddsWordWeights.containsKey(word) ? dictOddsWordWeights.getCount(word) : this.getPhraseWeightFromWords(dictOddsWordWeights, word, defaultWt);
        return dscore;
    }

    public double getPhraseWeightFromWords(Counter<CandidatePhrase> weights, CandidatePhrase ph, double defaultWt) {
        String[] t = ph.getPhrase().split("\\s+");
        if (t.length < 2) {
            if (weights.containsKey(ph)) {
                return weights.getCount(ph);
            }
            return defaultWt;
        }
        double totalscore = 0.0;
        double minScore = Double.MAX_VALUE;
        for (String w : t) {
            double score = defaultWt;
            if (weights.containsKey(CandidatePhrase.createOrGet(w))) {
                score = weights.getCount(w);
            }
            if (score < minScore) {
                minScore = score;
            }
            totalscore += score;
        }
        if (this.useAvgInsteadofMinPhraseScoring) {
            return totalscore / (double)ph.getPhrase().length();
        }
        return minScore;
    }

    public abstract Counter<CandidatePhrase> scorePhrases(String var1, Set<CandidatePhrase> var2, boolean var3) throws IOException, ClassNotFoundException;

    public abstract void printReasonForChoosing(Counter<CandidatePhrase> var1);

    public static enum Similarities {
        NUMITEMS,
        AVGSIM,
        MAXSIM;

    }

    public static enum Normalization {
        NONE,
        SQRT,
        LOG;

    }
}

