/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class ChineseSegmenterRegressionITest
extends TestCase {
    public StanfordCoreNLP pipeline;
    public ArrayList<String> inputStrings = new ArrayList();
    ArrayList<ArrayList<String>> expectedTokenLists = new ArrayList();

    public void setUp() {
        Properties props = StringUtils.argsToProperties("-props", "StanfordCoreNLP-chinese.properties");
        props.setProperty("annotators", "tokenize,ssplit");
        this.pipeline = new StanfordCoreNLP(props);
        this.inputStrings = new ArrayList();
        this.expectedTokenLists = new ArrayList();
        this.inputStrings.add("\u5df4\u62c9\u514b\u00b7\u5965\u5df4\u9a6c\u662f\u7f8e\u56fd\u603b\u7edf\u3002\u4ed6\u57282008\u5e74\u5f53\u9009");
        ArrayList<String> exampleOneTokenList = new ArrayList<String>(Arrays.asList("\u5df4\u62c9\u514b\u00b7\u5965\u5df4\u9a6c", "\u662f", "\u7f8e\u56fd", "\u603b\u7edf", "\u3002", "\u4ed6", "\u5728", "2008\u5e74", "\u5f53\u9009"));
        this.expectedTokenLists.add(exampleOneTokenList);
        this.inputStrings.add("\u58f0\u660e\u5168\u6587\u5982\u4e0b:\n    \n   \n\u4e2d\u56fd\u653f\u5e9c\u6b22\u8fce\u4e4c\u514b\u5170\u9500\u6bc1\u5176\u5883\u5185\u5168\u90e8\u6838\u6b66\u5668\u7684\u51b3\u5b9a,\n\u5bf9\u4e4c\u514b\u5170\u8bae\u4f1a\u4e8e11\u670816\u65e5\u6279\u51c6\u4e4c\u514b\u5170\u4f5c\u4e3a\u65e0\u6838\u6b66\u5668\u56fd\n\u5bb6\u52a0\u5165\u300a\u4e0d\u6269\u6563\u6838\u6b66\u5668\u6761\u7ea6\u300b\u8868\u793a\u8d5e\u8d4f\u3002");
        ArrayList<String> exampleTwoTokenList = new ArrayList<String>(Arrays.asList("\u58f0\u660e", "\u5168", "\u6587", "\u5982\u4e0b", ":", "\u4e2d\u56fd", "\u653f\u5e9c", "\u6b22\u8fce", "\u4e4c\u514b\u5170", "\u9500\u6bc1", "\u5176", "\u5883\u5185", "\u5168\u90e8", "\u6838\u6b66\u5668", "\u7684", "\u51b3\u5b9a", ",", "\u5bf9", "\u4e4c\u514b\u5170", "\u8bae\u4f1a", "\u4e8e", "11\u6708", "16\u65e5", "\u6279\u51c6", "\u4e4c\u514b\u5170", "\u4f5c\u4e3a", "\u65e0\u6838\u6b66\u5668", "\u56fd\u5bb6", "\u52a0\u5165", "\u300a", "\u4e0d\u6269\u6563", "\u6838\u6b66\u5668", "\u6761\u7ea6", "\u300b", "\u8868\u793a", "\u8d5e\u8d4f", "\u3002"));
        this.expectedTokenLists.add(exampleTwoTokenList);
        this.inputStrings.add("\u534f\u5b9a\u89c4\u5b9a,\u81ea\u534f\u5b9a\u7b7e\u7f72\u4e4b\u65e5\u8d77\u4e00\u5e74\u540e,\u7f14\u7ea6\u56db\u56fd\u4e4b\u95f4\n\u5b9e\u73b0\u6f9c\u6ca7\u6c5f-\u6e44\u516c\u6cb3\u5546\u8239\u901a\u822a,\u7f14\u7ea6\u4efb\u4f55\u4e00\u65b9\u7684\u8239\u8236\u5747\u53ef\n\u6309\u7167\u534f\u5b9a\u7684\u89c4\u5b9a\u5728\u4e2d\u56fd\u7684\u601d\u8305\u6e2f\u548c\u8001\u631d\u7684\u7405\u52c3\u62c9\u90a6\u6e2f\u4e4b\u95f4\n\u81ea\u7531\u822a\u884c\u3002");
        ArrayList<String> exampleThreeTokenList = new ArrayList<String>(Arrays.asList("\u534f\u5b9a", "\u89c4\u5b9a", ",", "\u81ea", "\u534f\u5b9a", "\u7b7e\u7f72", "\u4e4b\u65e5\u8d77", "\u4e00", "\u5e74", "\u540e", ",", "\u7f14\u7ea6", "\u56db", "\u56fd", "\u4e4b\u95f4", "\u5b9e\u73b0", "\u6f9c\u6ca7\u6c5f", "-", "\u6e44\u516c\u6cb3", "\u5546\u8239", "\u901a\u822a", ",", "\u7f14\u7ea6", "\u4efb\u4f55", "\u4e00", "\u65b9", "\u7684", "\u8239\u8236", "\u5747", "\u53ef", "\u6309\u7167", "\u534f\u5b9a", "\u7684", "\u89c4\u5b9a", "\u5728", "\u4e2d\u56fd", "\u7684", "\u601d\u8305", "\u6e2f", "\u548c", "\u8001\u631d", "\u7684", "\u7405\u52c3\u62c9\u90a6", "\u6e2f", "\u4e4b\u95f4", "\u81ea\u7531", "\u822a\u884c", "\u3002"));
        this.expectedTokenLists.add(exampleThreeTokenList);
    }

    public void testChineseSegmentation() {
        int exampleCount = 0;
        for (String inputString : this.inputStrings) {
            Annotation ann = new Annotation(inputString);
            this.pipeline.annotate(ann);
            ArrayList<String> foundTokens = new ArrayList<String>();
            for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
                for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                    foundTokens.add(token.word());
                }
            }
            ChineseSegmenterRegressionITest.assertEquals(this.expectedTokenLists.get(exampleCount), foundTokens);
            ++exampleCount;
        }
    }
}

