/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoNLLOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import junit.framework.TestCase;

public class CoNLLOutputterTest
extends TestCase {
    public void testSimpleSentence() throws IOException {
        Annotation ann = new Annotation("CoNLL is neat. Better than XML.");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize, ssplit"));
        pipeline.annotate(ann);
        String actual = new CoNLLOutputter().print(ann);
        String expected = "1\tCoNLL\t_\t_\t_\t_\t_\n2\tis\t_\t_\t_\t_\t_\n3\tneat\t_\t_\t_\t_\t_\n4\t.\t_\t_\t_\t_\t_\n\n1\tBetter\t_\t_\t_\t_\t_\n2\tthan\t_\t_\t_\t_\t_\n3\tXML\t_\t_\t_\t_\t_\n4\t.\t_\t_\t_\t_\t_\n\n";
        CoNLLOutputterTest.assertEquals((String)expected, (String)actual);
    }

    public void testCustomSimpleSentence() throws IOException {
        Annotation ann = new Annotation("CoNLL is neat. Better than XML.");
        String outputKeys = "word,pos";
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize, ssplit", "output.columns", outputKeys));
        pipeline.annotate(ann);
        String actual = new CoNLLOutputter().print(ann, pipeline);
        String expected = "CoNLL\t_\nis\t_\nneat\t_\n.\t_\n\nBetter\t_\nthan\t_\nXML\t_\n.\t_\n\n";
        CoNLLOutputterTest.assertEquals((String)expected, (String)actual);
    }
}

