/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreSentence;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CoreEntityMention {
    private CoreMap entityMentionCoreMap;
    private CoreSentence sentence;

    public CoreEntityMention(CoreSentence mySentence, CoreMap coreMapEntityMention) {
        this.sentence = mySentence;
        this.entityMentionCoreMap = coreMapEntityMention;
    }

    public CoreMap coreMap() {
        return this.entityMentionCoreMap;
    }

    public CoreSentence sentence() {
        return this.sentence;
    }

    public String text() {
        return (String)this.entityMentionCoreMap.get(CoreAnnotations.TextAnnotation.class);
    }

    public List<CoreLabel> tokens() {
        return (List)this.entityMentionCoreMap.get(CoreAnnotations.TokensAnnotation.class);
    }

    public Pair<Integer, Integer> charOffsets() {
        int beginCharOffset = (Integer)this.entityMentionCoreMap.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int endCharOffset = (Integer)this.entityMentionCoreMap.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        return new Pair<Integer, Integer>(beginCharOffset, endCharOffset);
    }

    public String entityType() {
        return (String)this.entityMentionCoreMap.get(CoreAnnotations.EntityTypeAnnotation.class);
    }

    public Map<String, Double> entityTypeConfidences() {
        return (Map)this.entityMentionCoreMap.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
    }

    public String entity() {
        return (String)this.entityMentionCoreMap.get(CoreAnnotations.WikipediaEntityAnnotation.class);
    }

    public Optional<CoreEntityMention> canonicalEntityMention() {
        CoreDocument myDocument = this.sentence.document();
        Optional<Integer> canonicalEntityMentionIndex = Optional.ofNullable((Integer)this.coreMap().get(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class));
        return canonicalEntityMentionIndex.isPresent() ? Optional.of(this.sentence.document().entityMentions().get(canonicalEntityMentionIndex.get())) : Optional.empty();
    }

    public String toString() {
        return this.coreMap().toString();
    }
}

