/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.List;
import java.util.stream.Collectors;

public class CoreSentence {
    private CoreDocument document;
    private CoreMap sentenceCoreMap;
    private List<CoreEntityMention> entityMentions;

    public CoreSentence(CoreDocument myDocument, CoreMap coreMapSentence) {
        this.document = myDocument;
        this.sentenceCoreMap = coreMapSentence;
    }

    public void wrapEntityMentions() {
        if (this.sentenceCoreMap.get(CoreAnnotations.MentionsAnnotation.class) != null) {
            this.entityMentions = ((List)this.sentenceCoreMap.get(CoreAnnotations.MentionsAnnotation.class)).stream().map(coreMapEntityMention -> new CoreEntityMention(this, (CoreMap)coreMapEntityMention)).collect(Collectors.toList());
        }
    }

    public CoreDocument document() {
        return this.document;
    }

    public CoreMap coreMap() {
        return this.sentenceCoreMap;
    }

    public String text() {
        return (String)this.sentenceCoreMap.get(CoreAnnotations.TextAnnotation.class);
    }

    public Pair<Integer, Integer> charOffsets() {
        int beginCharOffset = (Integer)this.sentenceCoreMap.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int endCharOffset = (Integer)this.sentenceCoreMap.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        return new Pair<Integer, Integer>(beginCharOffset, endCharOffset);
    }

    public List<CoreLabel> tokens() {
        return (List)this.sentenceCoreMap.get(CoreAnnotations.TokensAnnotation.class);
    }

    public List<String> posTags() {
        return this.tokens().stream().map(token -> token.tag()).collect(Collectors.toList());
    }

    public List<String> nerTags() {
        return this.tokens().stream().map(token -> token.ner()).collect(Collectors.toList());
    }

    public Tree constituencyParse() {
        return (Tree)this.sentenceCoreMap.get(TreeCoreAnnotations.TreeAnnotation.class);
    }

    public SemanticGraph dependencyParse() {
        return (SemanticGraph)this.sentenceCoreMap.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
    }

    public String sentiment() {
        return (String)this.sentenceCoreMap.get(SentimentCoreAnnotations.SentimentClass.class);
    }

    public Tree sentimentTree() {
        return (Tree)this.sentenceCoreMap.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
    }

    public List<CoreEntityMention> entityMentions() {
        return this.entityMentions;
    }

    public List<RelationTriple> relations() {
        return (List)this.sentenceCoreMap.get(CoreAnnotations.KBPTriplesAnnotation.class);
    }

    public String toString() {
        return this.coreMap().toString();
    }
}

