/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefSystem;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.CorefMentionAnnotator;
import edu.stanford.nlp.pipeline.TextAnnotationCreator;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class CorefAnnotator
extends TextAnnotationCreator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CorefAnnotator.class);
    private final CorefSystem corefSystem;
    private boolean performMentionDetection;
    private CorefMentionAnnotator mentionAnnotator;
    private final Properties props;

    public CorefAnnotator(Properties props) {
        this.props = props;
        try {
            if (CorefProperties.algorithm(props).equals((Object)CorefProperties.CorefAlgorithmType.HYBRID) && CorefProperties.getLanguage(props).equals(Locale.ENGLISH)) {
                log.error("Error: coref.algorithm=hybrid is not supported for English, please change coref.algorithm or coref.language");
                throw new RuntimeException();
            }
            props.setProperty("coref.printConLLLoadingMessage", "false");
            this.corefSystem = new CorefSystem(props);
            props.remove("coref.printConLLLoadingMessage");
        }
        catch (Exception e) {
            log.error("Error creating CorefAnnotator...terminating pipeline construction!");
            log.error(e);
            throw new RuntimeException(e);
        }
        boolean bl = this.performMentionDetection = !PropertiesUtils.getBool(props, "coref.useCustomMentionDetection", false);
        if (this.performMentionDetection) {
            this.mentionAnnotator = new CorefMentionAnnotator(props);
        }
    }

    private static void setNamedEntityTagGranularity(Annotation annotation, String granularity) {
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        Class sourceNERTagClass = granularity.equals("fine") ? CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class : (granularity.equals("coarse") ? CoreAnnotations.CoarseNamedEntityTagAnnotation.class : CoreAnnotations.NamedEntityTagAnnotation.class);
        for (CoreLabel token : tokens) {
            if (StringUtils.isNullOrEmpty((String)token.get(sourceNERTagClass))) continue;
            token.set(CoreAnnotations.NamedEntityTagAnnotation.class, (String)token.get(sourceNERTagClass));
        }
    }

    private static Optional<CoreMap> findBestCoreferentEntityMention(CoreMap em, Annotation ann) {
        Optional matchingCorefMention;
        Function<Optional, Integer> lengthOfOptionalEntityMention = v -> v.isPresent() ? ((String)((CoreMap)v.get()).get(CoreAnnotations.TextAnnotation.class)).length() : -1;
        Optional<CoreMap> bestCoreferentEntityMention = Optional.empty();
        int entityMentionIndex = (Integer)em.get(CoreAnnotations.EntityMentionIndexAnnotation.class);
        Optional<Integer> matchingCorefMentionIndex = Optional.ofNullable((Integer)((Map)ann.get(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class)).get(entityMentionIndex));
        Optional<Object> optional = matchingCorefMention = matchingCorefMentionIndex.isPresent() ? Optional.of((Mention)((List)ann.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)).get(matchingCorefMentionIndex.get())) : Optional.empty();
        if (matchingCorefMention.isPresent()) {
            Optional<CorefChain> matchingCorefChain = Optional.ofNullable((CorefChain)((Map)ann.get(CorefCoreAnnotations.CorefChainAnnotation.class)).get(((Mention)matchingCorefMention.get()).corefClusterID));
            List<Object> corefMentionsInTextualOrder = matchingCorefChain.isPresent() ? matchingCorefChain.get().getMentionsInTextualOrder() : new ArrayList();
            for (CorefChain.CorefMention corefMention : corefMentionsInTextualOrder) {
                Optional<Integer> candidateCoreferentEntityMentionIndex = Optional.ofNullable((Integer)((Map)ann.get(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class)).get(corefMention.mentionID));
                Optional<Object> candidateCoreferentEntityMention = candidateCoreferentEntityMentionIndex.isPresent() ? Optional.ofNullable((CoreMap)((List)ann.get(CoreAnnotations.MentionsAnnotation.class)).get(candidateCoreferentEntityMentionIndex.get())) : Optional.empty();
                if (lengthOfOptionalEntityMention.apply(candidateCoreferentEntityMention) <= lengthOfOptionalEntityMention.apply(bestCoreferentEntityMention)) continue;
                bestCoreferentEntityMention = candidateCoreferentEntityMention;
            }
        }
        return bestCoreferentEntityMention;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.performMentionDetection) {
            this.mentionAnnotator.annotate(annotation);
        }
        CorefAnnotator.setNamedEntityTagGranularity(annotation, "coarse");
        try {
            if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                log.error("this coreference resolution system requires SentencesAnnotation!");
                return;
            }
            if (CorefAnnotator.hasSpeakerAnnotations(annotation)) {
                annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
            }
            this.corefSystem.annotate(annotation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CorefAnnotator.setNamedEntityTagGranularity(annotation, "fine");
        }
        for (CoreMap entityMention : (List)annotation.get(CoreAnnotations.MentionsAnnotation.class)) {
            Optional<CoreMap> bestCoreferentEntityMention = CorefAnnotator.findBestCoreferentEntityMention(entityMention, annotation);
            if (!bestCoreferentEntityMention.isPresent()) continue;
            entityMention.set(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class, (Integer)bestCoreferentEntityMention.get().get(CoreAnnotations.EntityMentionIndexAnnotation.class));
        }
    }

    public static List<Pair<IntTuple, IntTuple>> getLinks(Map<Integer, CorefChain> result) {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        CorefChain.CorefMentionComparator comparator = new CorefChain.CorefMentionComparator();
        for (CorefChain c : result.values()) {
            List<CorefChain.CorefMention> s = c.getMentionsInTextualOrder();
            for (CorefChain.CorefMention m1 : s) {
                for (CorefChain.CorefMention m2 : s) {
                    if (comparator.compare(m1, m2) <= 0) continue;
                    links.add(new Pair<IntTuple, IntTuple>(m1.position, m2.position));
                }
            }
        }
        return links;
    }

    private static boolean hasSpeakerAnnotations(Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel t : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                if (t.get(CoreAnnotations.SpeakerAnnotation.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.EntityTypeAnnotation.class, CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.EntityMentionIndexAnnotation.class, CoreAnnotations.CoarseNamedEntityTagAnnotation.class, CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class));
        if (CorefProperties.mdType(this.props) != CorefProperties.MentionDetectionType.DEPENDENCY) {
            requirements.add(TreeCoreAnnotations.TreeAnnotation.class);
            requirements.add(CoreAnnotations.CategoryAnnotation.class);
        }
        if (!this.performMentionDetection) {
            requirements.add(CorefCoreAnnotations.CorefMentionsAnnotation.class);
        }
        return Collections.unmodifiableSet(requirements);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        HashSet<Class<? extends CoreAnnotation>> requirements = new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CorefCoreAnnotations.CorefChainAnnotation.class, CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class));
        return requirements;
    }
}

