/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CustomAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomAnnotationSerializerITest {
    private static StanfordCoreNLP fullPipeline;
    private static CustomAnnotationSerializer serializer;
    private final Class[] tokenAnnotations = new Class[]{CoreAnnotations.TextAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() {
        Class<CustomAnnotationSerializerITest> clazz = CustomAnnotationSerializerITest.class;
        synchronized (CustomAnnotationSerializerITest.class) {
            if (fullPipeline == null) {
                fullPipeline = new StanfordCoreNLP();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Test
    public void testSimple() throws IOException {
        Annotation annotation = new Annotation("This is a test");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    @Test
    public void testCollapsedGraphs() throws IOException {
        Annotation annotation = new Annotation("I bought a bone for my dog.");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    @Test
    public void testTwoSentences() throws IOException {
        Annotation annotation = new Annotation("I bought a bone for my dog.  He chews it every day.");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    @Test
    public void testCopyWordGraphs() throws IOException {
        Annotation annotation = new Annotation("I went over the river and through the woods");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    private void runTest(Annotation annotation) throws IOException {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        serializer.write(annotation, out2);
        byte[] serialized = out2.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(serialized);
        Annotation deserialized = serializer.read(in).first();
        Assert.assertEquals((long)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).size(), (long)((List)deserialized.get(CoreAnnotations.SentencesAnnotation.class)).size());
        for (int i = 0; i < ((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).size(); ++i) {
            this.verifySentence((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(i), (CoreMap)((List)deserialized.get(CoreAnnotations.SentencesAnnotation.class)).get(i));
        }
    }

    private void verifySentence(CoreMap expected, CoreMap result) {
        Assert.assertEquals((long)((List)expected.get(CoreAnnotations.TokensAnnotation.class)).size(), (long)((List)result.get(CoreAnnotations.TokensAnnotation.class)).size());
        for (int i = 0; i < ((List)expected.get(CoreAnnotations.TokensAnnotation.class)).size(); ++i) {
            this.verifyWord((CoreLabel)((List)expected.get(CoreAnnotations.TokensAnnotation.class)).get(i), (CoreLabel)((List)result.get(CoreAnnotations.TokensAnnotation.class)).get(i));
        }
        CustomAnnotationSerializerITest.verifyTree((Tree)expected.get(TreeCoreAnnotations.TreeAnnotation.class), (Tree)result.get(TreeCoreAnnotations.TreeAnnotation.class));
        CustomAnnotationSerializerITest.verifyGraph((SemanticGraph)expected.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class), (SemanticGraph)result.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        CustomAnnotationSerializerITest.verifyGraph((SemanticGraph)expected.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class), (SemanticGraph)result.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
        CustomAnnotationSerializerITest.verifyGraph((SemanticGraph)expected.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class), (SemanticGraph)result.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
    }

    private static void verifyTree(Tree expected, Tree result) {
        if (expected == null) {
            Assert.assertEquals((Object)expected, (Object)result);
            return;
        }
        Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
    }

    private static void verifyGraph(SemanticGraph expected, SemanticGraph result) {
        if (expected == null) {
            Assert.assertEquals((Object)expected, (Object)result);
            return;
        }
        Assert.assertEquals(expected.vertexSet(), result.vertexSet());
        Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
    }

    private void verifyWord(CoreLabel expected, CoreLabel result) {
        for (Class annotation : this.tokenAnnotations) {
            if (expected.get(annotation) == null && result.get(annotation) != null && "".equals(result.get(annotation))) continue;
            Assert.assertEquals((String)("Different for class " + annotation), expected.get(annotation), result.get(annotation));
        }
    }

    static {
        serializer = new CustomAnnotationSerializer(false, false);
    }
}

