/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class EPEOutputter
extends JSONOutputter {
    private static String OUTPUT_REPRESENTATION = System.getProperty("outputRepresentation", "basic");

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        PrintWriter writer = new PrintWriter(IOUtils.encodedOutputStreamWriter(target, options.encoding));
        JSONOutputter.JSONWriter l0 = new JSONOutputter.JSONWriter(writer, options);
        if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().forEach(sentence -> {
                l0.object(l1 -> {
                    l1.set("id", (Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class) + 1);
                    SemanticGraph sg = OUTPUT_REPRESENTATION.equalsIgnoreCase("basic") ? (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class) : (OUTPUT_REPRESENTATION.equalsIgnoreCase("enhanced") ? (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class) : (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class));
                    l1.set("nodes", EPEOutputter.getNodes(sg));
                });
                l0.writer.append("\n");
                l0.writer.flush();
            });
        }
    }

    private static Object getNodes(SemanticGraph graph) {
        if (graph != null) {
            List<IndexedWord> vertexList = graph.vertexListSorted();
            int maxIndex = vertexList.get(vertexList.size() - 1).index();
            return vertexList.stream().map(token -> node -> {
                if (token.copyCount() == 0) {
                    node.set("id", EPEOutputter.getNodeIndex(token, maxIndex));
                    node.set("start", token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
                    node.set("end", token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                } else {
                    node.set("id", EPEOutputter.getNodeIndex(token, maxIndex));
                    node.set("source", token.index());
                }
                node.set("form", token.word());
                if (graph.getRoots().contains(token)) {
                    node.set("top", true);
                }
                node.set("properties", propertiesWriter -> {
                    propertiesWriter.set("xpos", token.tag());
                    propertiesWriter.set("upos", token.get(CoreAnnotations.CoarseTagAnnotation.class));
                    propertiesWriter.set("lemma", token.lemma());
                });
                node.set("edges", graph.getOutEdgesSorted((IndexedWord)token).stream().map(dep -> edge -> {
                    edge.set("target", EPEOutputter.getNodeIndex(dep.getDependent(), maxIndex));
                    edge.set("label", dep.getRelation().toString());
                }));
            });
        }
        return null;
    }

    private static int getNodeIndex(IndexedWord token, int maxIndex) {
        if (token.copyCount() == 0) {
            return token.index();
        }
        return token.index() + maxIndex * token.copyCount();
    }
}

