/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Iterables;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PipelineITest {
    @Test
    public void testPipeline() throws Exception {
        AnnotationPipeline pipeline = new AnnotationPipeline();
        pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
        pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
        pipeline.addAnnotator(new POSTaggerAnnotator(false));
        pipeline.addAnnotator(new MorphaAnnotator(false));
        pipeline.addAnnotator(new NERCombinerAnnotator(false));
        pipeline.addAnnotator(new ParserAnnotator(false, -1));
        String text = "Dan Ramage is working for\nMicrosoft. He's in Seattle! \n";
        Annotation document = new Annotation(text);
        Assert.assertEquals((Object)text, (Object)document.toString());
        Assert.assertEquals((Object)text, document.get(CoreAnnotations.TextAnnotation.class));
        pipeline.annotate(document);
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                String tokenText = (String)token.get(CoreAnnotations.TextAnnotation.class);
                String tokenPOS = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String tokenLemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
                String tokenNE = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                Assert.assertNotNull((Object)tokenText);
                Assert.assertNotNull((Object)tokenPOS);
                Assert.assertNotNull((Object)tokenLemma);
                Assert.assertNotNull((Object)tokenNE);
            }
            Assert.assertNotNull((Object)tree);
        }
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        String tokensText = "Dan Ramage is working for Microsoft . He 's in Seattle !";
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((long)12L, (long)tokens.size());
        Assert.assertEquals((Object)tokensText, (Object)PipelineITest.join(tokens));
        Assert.assertEquals((long)0L, (long)((Integer)((CoreLabel)tokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)((CoreLabel)tokens.get(0)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)).intValue());
        Assert.assertEquals((Object)"NNP", ((CoreLabel)tokens.get(0)).get(CoreAnnotations.PartOfSpeechAnnotation.class));
        Assert.assertEquals((Object)"VBZ", ((CoreLabel)tokens.get(2)).get(CoreAnnotations.PartOfSpeechAnnotation.class));
        Assert.assertEquals((Object)".", ((CoreLabel)tokens.get(11)).get(CoreAnnotations.PartOfSpeechAnnotation.class));
        Assert.assertEquals((Object)"Ramage", ((CoreLabel)tokens.get(1)).get(CoreAnnotations.LemmaAnnotation.class));
        Assert.assertEquals((Object)"be", ((CoreLabel)tokens.get(2)).get(CoreAnnotations.LemmaAnnotation.class));
        Assert.assertEquals((Object)"PERSON", ((CoreLabel)tokens.get(0)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((Object)"PERSON", ((CoreLabel)tokens.get(1)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((Object)"CITY", ((CoreLabel)tokens.get(10)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((long)2L, (long)sentences.size());
        String text1 = "Dan Ramage is working for\nMicrosoft.";
        CoreMap sentence1 = (CoreMap)sentences.get(0);
        Assert.assertEquals((Object)text1, (Object)sentence1.toString());
        Assert.assertEquals((Object)text1, sentence1.get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((long)0L, (long)((Integer)sentence1.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)36L, (long)((Integer)sentence1.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)sentence1.get(CoreAnnotations.TokenBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)sentence1.get(CoreAnnotations.TokenEndAnnotation.class)).intValue());
        Tree tree1 = Tree.valueOf("(ROOT (S (NP (NNP Dan) (NNP Ramage)) (VP (VBZ is) (VP (VBG working) (PP (IN for) (NP (NNP Microsoft))))) (. .)))");
        Assert.assertEquals((Object)tree1, sentence1.get(TreeCoreAnnotations.TreeAnnotation.class));
        String tokenText1 = "Dan Ramage is working for Microsoft .";
        List tokens1 = (List)sentence1.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens1);
        Assert.assertEquals((long)7L, (long)tokens1.size());
        Assert.assertEquals((Object)tokenText1, (Object)PipelineITest.join(tokens1));
        Assert.assertEquals((long)4L, (long)((Integer)((CoreLabel)tokens1.get(1)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)((CoreLabel)tokens1.get(1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)).intValue());
        Assert.assertEquals((Object)"IN", ((CoreLabel)tokens1.get(4)).get(CoreAnnotations.PartOfSpeechAnnotation.class));
        Assert.assertEquals((Object)"NNP", ((CoreLabel)tokens1.get(5)).get(CoreAnnotations.PartOfSpeechAnnotation.class));
        Assert.assertEquals((Object)"work", ((CoreLabel)tokens1.get(3)).get(CoreAnnotations.LemmaAnnotation.class));
        Assert.assertEquals((Object)".", ((CoreLabel)tokens1.get(6)).get(CoreAnnotations.LemmaAnnotation.class));
        Assert.assertEquals((Object)"ORGANIZATION", ((CoreLabel)tokens1.get(5)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        String text2 = "He's in Seattle!";
        CoreMap sentence2 = (CoreMap)sentences.get(1);
        Assert.assertEquals((Object)text2, (Object)sentence2.toString());
        Assert.assertEquals((Object)text2, sentence2.get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((long)37L, (long)((Integer)sentence2.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)53L, (long)((Integer)sentence2.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)sentence2.get(CoreAnnotations.TokenBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)sentence2.get(CoreAnnotations.TokenEndAnnotation.class)).intValue());
        Tree tree2 = Tree.valueOf("(ROOT (S (NP (PRP He)) (VP (VBZ 's) (PP (IN in) (NP (NNP Seattle)))) (. !)))");
        Assert.assertEquals((Object)tree2, sentence2.get(TreeCoreAnnotations.TreeAnnotation.class));
        String tokenText2 = "He 's in Seattle !";
        List tokens2 = (List)sentence2.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens2);
        Assert.assertEquals((long)5L, (long)tokens2.size());
        Assert.assertEquals((Object)tokenText2, (Object)PipelineITest.join(tokens2));
        Assert.assertEquals((long)39L, (long)((Integer)((CoreLabel)tokens2.get(1)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue());
        Assert.assertEquals((long)41L, (long)((Integer)((CoreLabel)tokens2.get(1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)).intValue());
        Assert.assertEquals((Object)"VBZ", ((CoreLabel)tokens2.get(1)).get(CoreAnnotations.PartOfSpeechAnnotation.class));
        Assert.assertEquals((Object)"be", ((CoreLabel)tokens2.get(1)).get(CoreAnnotations.LemmaAnnotation.class));
        Assert.assertEquals((Object)"CITY", ((CoreLabel)tokens2.get(3)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
    }

    private static String join(List<CoreLabel> tokens) {
        return StringUtils.join(Iterables.transform(tokens, token -> (String)token.get(CoreAnnotations.TextAnnotation.class)));
    }
}

