/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.QuantifiableEntityNormalizer;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class QuantifiableEntityNormalizingAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(QuantifiableEntityNormalizingAnnotator.class);
    private Timing timer = new Timing();
    private final boolean VERBOSE;
    private static final String DEFAULT_BACKGROUND_SYMBOL = "O";
    private final boolean collapse;
    public static final String BACKGROUND_SYMBOL_PROPERTY = "background";
    public static final String COLLAPSE_PROPERTY = "collapse";

    public QuantifiableEntityNormalizingAnnotator() {
        this(DEFAULT_BACKGROUND_SYMBOL, true);
    }

    public QuantifiableEntityNormalizingAnnotator(boolean verbose) {
        this(DEFAULT_BACKGROUND_SYMBOL, verbose);
    }

    public QuantifiableEntityNormalizingAnnotator(String name, Properties props) {
        String backgroundSymbol;
        String property = name + "." + BACKGROUND_SYMBOL_PROPERTY;
        QuantifiableEntityNormalizer.BACKGROUND_SYMBOL = backgroundSymbol = props.getProperty(property, DEFAULT_BACKGROUND_SYMBOL);
        property = name + "." + COLLAPSE_PROPERTY;
        this.collapse = PropertiesUtils.getBool(props, property, false);
        if (this.collapse) {
            log.info("WARNING: QuantifiableEntityNormalizingAnnotator does not work well with collapse=true");
        }
        this.VERBOSE = false;
    }

    public QuantifiableEntityNormalizingAnnotator(String backgroundSymbol, boolean verbose) {
        this(backgroundSymbol, verbose, false);
    }

    public QuantifiableEntityNormalizingAnnotator(boolean verbose, boolean collapse) {
        this(DEFAULT_BACKGROUND_SYMBOL, verbose, collapse);
    }

    public QuantifiableEntityNormalizingAnnotator(String backgroundSymbol, boolean verbose, boolean collapse) {
        QuantifiableEntityNormalizer.BACKGROUND_SYMBOL = backgroundSymbol;
        this.VERBOSE = verbose;
        this.collapse = collapse;
        if (this.collapse) {
            log.info("WARNING: QuantifiableEntityNormalizingAnnotator does not work well with collapse=true");
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            this.timer.start();
            log.info("Normalizing quantifiable entities...");
        }
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                this.annotateTokens(tokens);
            }
            if (this.VERBOSE) {
                this.timer.stop("done.");
                log.info("output: " + sentences + '\n');
            }
        } else if (annotation.containsKey(CoreAnnotations.TokensAnnotation.class)) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            this.annotateTokens(tokens);
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private <TOKEN extends CoreLabel> void annotateTokens(List<TOKEN> tokens) {
        ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
        for (CoreLabel token : tokens) {
            CoreLabel word = new CoreLabel();
            word.setWord(token.word());
            word.setNER(token.ner());
            word.setTag(token.tag());
            NumberSequenceClassifier.transferAnnotations(token, word);
            words.add(word);
        }
        this.doOneSentence(words);
        for (int i = 0; i < words.size(); ++i) {
            String ner = ((CoreLabel)words.get(i)).ner();
            ((CoreLabel)tokens.get(i)).setNER(ner);
            ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, (String)((CoreLabel)words.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
        }
    }

    private <TOKEN extends CoreLabel> void doOneSentence(List<TOKEN> words) {
        QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(words, this.collapse);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
    }
}

