/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Assert;

public class QuoteAnnotatorITest
extends TestCase {
    private static StanfordCoreNLP pipeline;
    private static StanfordCoreNLP pipelineNoSingleQuotes;
    private static StanfordCoreNLP pipelineMaxFive;
    private static StanfordCoreNLP pipelineAsciiQuotes;
    private static StanfordCoreNLP pipelineAllowEmbeddedSame;
    private static StanfordCoreNLP pipelineUnclosedQuotes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        Class<QuoteAnnotatorITest> clazz = QuoteAnnotatorITest.class;
        synchronized (QuoteAnnotatorITest.class) {
            Properties props;
            if (pipeline == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote1");
                props.setProperty("customAnnotatorClass.quote1", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("quote1.attributeQuotes", "false");
                props.setProperty("quote1.singleQuotes", "true");
                pipeline = new StanfordCoreNLP(props);
            }
            if (pipelineNoSingleQuotes == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote2");
                props.setProperty("customAnnotatorClass.quote2", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("quote2.attributeQuotes", "false");
                pipelineNoSingleQuotes = new StanfordCoreNLP(props);
            }
            if (pipelineMaxFive == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote3");
                props.setProperty("customAnnotatorClass.quote3", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("quote3.maxLength", "5");
                props.setProperty("quote3.attributeQuotes", "false");
                pipelineMaxFive = new StanfordCoreNLP(props);
            }
            if (pipelineAsciiQuotes == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote4");
                props.setProperty("customAnnotatorClass.quote4", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("quote4.asciiQuotes", "true");
                props.setProperty("quote4.attributeQuotes", "false");
                pipelineAsciiQuotes = new StanfordCoreNLP(props);
            }
            if (pipelineAllowEmbeddedSame == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote5");
                props.setProperty("customAnnotatorClass.quote5", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("quote5.allowEmbeddedSame", "true");
                props.setProperty("quote5.attributeQuotes", "false");
                pipelineAllowEmbeddedSame = new StanfordCoreNLP(props);
            }
            if (pipelineUnclosedQuotes == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote6");
                props.setProperty("customAnnotatorClass.quote6", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("quote6.extractUnclosedQuotes", "true");
                props.setProperty("quote6.attributeQuotes", "false");
                pipelineUnclosedQuotes = new StanfordCoreNLP(props);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testBasicEmbeddedSameUnicode() {
        String text = "\u201cHello,\u201d he said, \u201chow \u201care\u201d you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipeline);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201chow \u201care\u201d you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(1).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorITest.assertEquals((int)embedded.size(), (int)0);
    }

    public void testBasicAllowEmbeddedSameUnicode() {
        String text = "\u201cHello,\u201d he said, \u201chow \u201care\u201d you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201chow \u201care\u201d you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("\u201care\u201d", "\u201chow \u201care\u201d you doing?\u201d", quotes);
    }

    public void testBasicAsciiQuotes() {
        String text = "\u201cHello,\u201c he said, \u201chow are you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineAsciiQuotes);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201c", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201chow are you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMaxLength() {
        String text = "`Hel,' he said, ``how are \"you\" blar a \"farrrrrooom\"";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineMaxFive);
        QuoteAnnotatorITest.assertEquals((String)"`Hel,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\"you\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testTis() {
        String text = "\"'Tis Impossible, \u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d, impossible, when 'tis I am not acquainted with him\n myself; how can you be so teasing?\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("\u201cMr. Bennet\u201d", "\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", quotes);
        QuoteAnnotatorITest.assertEmbedded("\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", text, quotes);
    }

    public void testDashes() {
        String text = "\"Hello\"--said Mr. Cornwallaby";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\"Hello\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        text = "\u201c-Wish- you success!\u201d\u2014In what";
        quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\u201c-Wish- you success!\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        text = "\"-Wish- you success!\"\u2014In what";
        quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\"-Wish- you success!\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testBasicInternalPunc() {
        String text = "\"Impossible, Mr. Bennet, impossible, when I am not acquainted with him\n myself; how can you be so teasing?\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 24);
    }

    public void testBasicLatexQuotes() {
        String text = "`Hello,' he said, ``how are you doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"`Hello,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"``how are you doing?''", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 3);
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(1), 1, 0, 0, 7, 13);
    }

    public void testLatexQuotesWithDirectedApostrophes() {
        String text = "John`s he said, ``how are you doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"``how are you doing?''", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testEmbeddedLatexQuotes() {
        String text = "``Hello ``how are you doing?''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("``how are you doing?''", text, quotes);
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 9);
    }

    public void testEmbeddedLatexQuotesNoEmbedded() {
        String text = "``Hello ``how are you doing?''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipeline);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(0).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorITest.assertEquals((int)0, (int)embedded.size());
    }

    public void testEmbeddedSingleLatexQuotes() {
        String text = "`Hello `how are you doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("`how are you doing?'", text, quotes);
    }

    public void testEmbeddedLatexQuotesAllEndSamePlace() {
        String text = "``Hello ``how `are ``you doing?'''''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("``how `are ``you doing?'''''", text, quotes);
        QuoteAnnotatorITest.assertEmbedded("`are ``you doing?'''", "``how `are ``you doing?'''''", quotes);
        QuoteAnnotatorITest.assertEmbedded("``you doing?''", "`are ``you doing?'''", quotes);
    }

    public void testEmbeddedLatexQuotesAllEndSamePlaceNoEmbedded() {
        String text = "``Hello ``how ``are ``you doing?''''''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipeline);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(0).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorITest.assertEquals((int)0, (int)embedded.size());
    }

    public void testTripleEmbeddedLatexQuotes() {
        String text = "``Hel ``lo ``how'' are you'' doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("``lo ``how'' are you''", text, quotes);
        QuoteAnnotatorITest.assertEmbedded("``how''", "``lo ``how'' are you''", quotes);
    }

    public void testTripleEmbeddedLatexQuotesNoEmbedded() {
        String text = "``Hel ``lo ``how'' are you'' doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineNoSingleQuotes);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(0).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorITest.assertEquals((int)0, (int)embedded.size());
    }

    public void testTripleEmbeddedUnicodeQuotes() {
        String text = "\u201cHel \u00ablo \u201chow\u201d are you\u00bb doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("\u00ablo \u201chow\u201d are you\u00bb", text, quotes);
        QuoteAnnotatorITest.assertEmbedded("\u201chow\u201d", "\u00ablo \u201chow\u201d are you\u00bb", quotes);
    }

    public void testBasicIgnoreSingleQuotes() {
        String text = "\u201cHello,\u201d he 'said', \u201chow are you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201chow are you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        text = "\"'Tis Impossible, \u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d, impossible, when 'tis I am not acquainted with him\n myself; how can you be so teasing?\"";
        quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("\u201cMr. Bennet\u201d", "\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", quotes);
        QuoteAnnotatorITest.assertEmbedded("\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", text, quotes);
    }

    public void testBasicUnicodeQuotes() {
        String text = "\u201cHello,\u201d he said, \u201chow are you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201chow are you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnicodeQuotesWithBadUnicodeQuotes() {
        String text = "\u201cHello,\u201d he said, \u201chow\u201a are\u2018 you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201chow\u201a are\u2018 you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnicodeQuotesWithApostrophes() {
        String text = "\u201cHello,\u201d he said, \u201cwhere is the dog\u2018s ball today?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\u201cwhere is the dog\u2018s ball today?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testBasicDoubleQuotes() {
        String text = "\"Hello,\" he said, \"how are you doing?\"";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"\"Hello,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((int)((List)quotes.get(0).get(CoreAnnotations.TokensAnnotation.class)).size(), (int)4);
        QuoteAnnotatorITest.assertEquals((String)"\"how are you doing?\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedInitialQuotes() {
        String text = "Hello,   \" he said, 'how are you doing?'";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"'how are you doing?'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedLastDoubleQuotes() {
        String text = "\"Hello,\" he said, \"how are you doing?";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\"Hello,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testDoubleEnclosedInSingle() {
        String text = "'\"Hello,\" he said, \"how are you doing?\"'";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"'\"Hello,\" he said, \"how are you doing?\"'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("\"Hello,\"", text, quotes);
        QuoteAnnotatorITest.assertEmbedded("\"how are you doing?\"", text, quotes);
    }

    public void testSingleEnclosedInDouble() {
        String text = "\"'Hello,' he said, 'how are you doing?'\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEmbedded("'Hello,'", text, quotes);
        QuoteAnnotatorITest.assertEmbedded("'how are you doing?'", text, quotes);
    }

    public void testEmbeddedQuotes() {
        String text = "\"'Enter,' said De Lacy; 'and I will\n\ntry in what manner I can relieve your\n\nwants; but, unfortunately, my children\n\nare from home, and, as I am blind, I\n\nam afraid I shall find it difficult to procure\n\nfood for you.'\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEmbedded("'Enter,'", text, quotes);
        String second = "'and I will\n\ntry in what manner I can relieve your\n\nwants; but, unfortunately, my children\n\nare from home, and, as I am blind, I\n\nam afraid I shall find it difficult to procure\n\nfood for you.'";
        QuoteAnnotatorITest.assertEmbedded(second, text, quotes);
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 55);
    }

    public void testEmbeddedQuotesTwo() {
        String text = "It was all very well to say 'Drink me,' but the wise little Alice was\nnot going to do THAT in a hurry. 'No, I'll \"look\" first,' she said, 'and\nsee whether it's marked \"poison\" or not';";
        List<CoreMap> quotes = this.runQuotes(text, 3);
        QuoteAnnotatorITest.assertEmbedded("\"poison\"", "'and\nsee whether it's marked \"poison\" or not'", quotes);
        QuoteAnnotatorITest.assertEmbedded("\"look\"", "'No, I'll \"look\" first,'", quotes);
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 7, 11);
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(1), 1, 1, 1, 27, 37);
    }

    public void testEmbeddedMixedComplicated() {
        String text = "It was all very \u300cwell to say `Drink me,' but the wise little Alice was\nnot going to do THAT in a hurry. \u2018No, I'll \"look\" first,\u2019 she said, \u00aband\nsee whether it's marked ``poison'' or \"not\u00bb";
        List<CoreMap> quotes = this.runQuotes(text, 3);
        QuoteAnnotatorITest.assertEmbedded("``poison''", "\u00aband\nsee whether it's marked ``poison'' or \"not\u00bb", quotes);
        QuoteAnnotatorITest.assertEmbedded("\"look\"", "\u2018No, I'll \"look\" first,\u2019", quotes);
    }

    public void testQuotesFollowEachother() {
        String text = "\"Where?\"\n\n\"I don't see 'im!\"\n\n\"Bigger, he's behind the trunk!\" the girl whimpered.";
        List<CoreMap> quotes = this.runQuotes(text, 3);
        QuoteAnnotatorITest.assertEquals((String)"\"Where?\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\"I don't see 'im!\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\"Bigger, he's behind the trunk!\"", (String)((String)quotes.get(2).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testBasicSingleQuotes() {
        String text = "'Hello,' he said, 'how are you doing?'";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"'Hello,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"'how are you doing?'", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedLastSingleQuotes() {
        String text = "'Hello,' he said, 'how are you doing?";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"'Hello,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMultiParagraphQuoteDouble() {
        String text = "Words blah bla \"Hello,\n\n \"I am the second paragraph.\n\n\"I am the last.\" followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\"Hello,\n\n \"I am the second paragraph.\n\n\"I am the last.\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMultiParagraphQuoteSingle() {
        String text = "Words blah bla 'Hello,\n\n 'I am the second paragraph.\n\n'I am the second to last.\n\n'see there's more here.' followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"'Hello,\n\n 'I am the second paragraph.\n\n'I am the second to last.\n\n'see there's more here.'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 2, 3, 28);
    }

    public void testMultiLineQuoteDouble() {
        String text = "Words blah bla \"Hello,\nI am the second paragraph.\nI am the last.\" followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\"Hello,\nI am the second paragraph.\nI am the last.\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMultiLineQuoteSingle() {
        String text = "Words blah bla 'Hello,\nI am the second paragraph.\nI am the last.' followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"'Hello,\nI am the second paragraph.\nI am the last.'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testWordBeginningWithApostropheAtQuoteBeginningSingleQuotes() {
        String text = "''Tis nobler' Words blah bla 'I went to the house yesterday,' he said";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"''Tis nobler'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"'I went to the house yesterday,'", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testWordsWithApostropheTerminalsInOneDoubleQuote() {
        String text = "\"Jones' cow is cuter!\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorITest.assertEquals((String)"\"Jones' cow is cuter!\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testWordsWithApostropheTerminalsInDoubleQuotes() {
        String text = "\"I said that Jones' cow was better,\" but then he rebutted. I was shocked--\"My cow is better than any one of Jones' bovines!\"";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorITest.assertEquals((String)"\"I said that Jones' cow was better,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\"My cow is better than any one of Jones' bovines!\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedLastDoubleQuotesUnclosedAnnotation() {
        String text = "\"Hello,\" he said, \"how are you doing?";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        List<CoreMap> unclosedQuotes = this.runUnclosedQuotes(text, 1, pipelineUnclosedQuotes);
        QuoteAnnotatorITest.assertEquals((String)"\"Hello,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorITest.assertEquals((String)"\"how are you doing?", (String)((String)unclosedQuotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public List<CoreMap> runQuotes(String text, int numQuotes) {
        return this.runQuotes(text, numQuotes, pipeline);
    }

    public List<CoreMap> runQuotes(String text, int numQuotes, StanfordCoreNLP pipeline) {
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        Assert.assertNotNull((Object)quotes);
        Assert.assertEquals((long)numQuotes, (long)quotes.size());
        return quotes;
    }

    public static void assertInnerAnnotationValues(CoreMap quote, int quoteIndex, int sentenceBegin, int sentenceEnd, int tokenBegin, int tokenEnd) {
        QuoteAnnotatorITest.assertEquals((int)((Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class)), (int)quoteIndex);
        QuoteAnnotatorITest.assertEquals((int)((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class)), (int)sentenceBegin);
        QuoteAnnotatorITest.assertEquals((int)((Integer)quote.get(CoreAnnotations.SentenceEndAnnotation.class)), (int)sentenceEnd);
        QuoteAnnotatorITest.assertEquals((int)((Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class)), (int)tokenBegin);
        QuoteAnnotatorITest.assertEquals((int)((Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class)), (int)tokenEnd);
        List quoteTokens = (List)quote.get(CoreAnnotations.TokensAnnotation.class);
        if (quoteTokens != null && quote.get(CoreAnnotations.QuotationsAnnotation.class) == null) {
            for (CoreLabel qt : quoteTokens) {
                QuoteAnnotatorITest.assertEquals((int)((Integer)qt.get(CoreAnnotations.QuotationIndexAnnotation.class)), (int)quoteIndex);
            }
        }
    }

    public static void assertEmbedded(String embedded, String bed, List<CoreMap> quotes) {
        boolean found = QuoteAnnotatorITest.assertEmbeddedHelper(embedded, bed, quotes);
        QuoteAnnotatorITest.assertTrue((boolean)found);
    }

    public static boolean assertEmbeddedHelper(String embedded, String bed, List<CoreMap> quotes) {
        for (CoreMap b : quotes) {
            if (((String)b.get(CoreAnnotations.TextAnnotation.class)).equals(bed)) {
                List eqs = (List)b.get(CoreAnnotations.QuotationsAnnotation.class);
                for (CoreMap eq : eqs) {
                    if (!((String)eq.get(CoreAnnotations.TextAnnotation.class)).equals(embedded)) continue;
                    return true;
                }
                continue;
            }
            List bEmbed = (List)b.get(CoreAnnotations.QuotationsAnnotation.class);
            boolean recurse = QuoteAnnotatorITest.assertEmbeddedHelper(embedded, bed, bEmbed);
            if (!recurse) continue;
            return true;
        }
        return false;
    }

    public List<CoreMap> runUnclosedQuotes(String text, int numQuotes, StanfordCoreNLP pipeline) {
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        List quotes = (List)doc.get(CoreAnnotations.UnclosedQuotationsAnnotation.class);
        Assert.assertNotNull((Object)quotes);
        Assert.assertEquals((long)numQuotes, (long)quotes.size());
        return quotes;
    }
}

