/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.quoteattribution.BammanCorefReader;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class QuoteAttributionUtils {
    static DependencyParser parser = DependencyParser.loadFromModelFile("edu/stanford/nlp/models/parser/nndep/english_UD.gz", new Properties());

    public static Pair<Integer, Integer> getRemainderInSentence(Annotation doc, CoreMap quote) {
        Pair<Integer, Integer> range = QuoteAttributionUtils.getTokenRangePrecedingQuote(doc, quote);
        if (range == null) {
            range = QuoteAttributionUtils.getTokenRangeFollowingQuote(doc, quote);
        }
        return range;
    }

    public static int getQuoteParagraphIndex(Annotation doc, CoreMap quote) {
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        return (Integer)((CoreMap)sentences.get((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class))).get(CoreAnnotations.ParagraphIndexAnnotation.class);
    }

    private static CoreMap constructSentence(List<CoreLabel> sentenceTokens, CoreMap prevSentence, CoreMap sentence) {
        int begin = (Integer)sentenceTokens.get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int last = sentenceTokens.size() - 1;
        int end = (Integer)sentenceTokens.get(last).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        String sentenceText = (String)prevSentence.get(CoreAnnotations.TextAnnotation.class) + (String)sentence.get(CoreAnnotations.TextAnnotation.class);
        Annotation newSentence = new Annotation(sentenceText);
        newSentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
        newSentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
        newSentence.set(CoreAnnotations.TokensAnnotation.class, sentenceTokens);
        newSentence.set(CoreAnnotations.TokenBeginAnnotation.class, (Integer)prevSentence.get(CoreAnnotations.TokenBeginAnnotation.class));
        newSentence.set(CoreAnnotations.TokenEndAnnotation.class, (Integer)sentence.get(CoreAnnotations.TokenEndAnnotation.class));
        newSentence.set(CoreAnnotations.ParagraphIndexAnnotation.class, (Integer)sentence.get(CoreAnnotations.ParagraphIndexAnnotation.class));
        newSentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, QuoteAttributionUtils.getParse(newSentence));
        return newSentence;
    }

    public static void addEnhancedSentences(Annotation doc) {
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        WordToSentenceProcessor wsp = new WordToSentenceProcessor(WordToSentenceProcessor.NewlineIsSentenceBreak.NEVER);
        boolean prevParagraph = false;
        for (int i = 1; i < sentences.size(); ++i) {
            CoreMap sentence = (CoreMap)sentences.get(i);
            CoreMap prevSentence = (CoreMap)sentences.get(i - 1);
            ArrayList tokensConcat = new ArrayList();
            tokensConcat.addAll((Collection)prevSentence.get(CoreAnnotations.TokensAnnotation.class));
            tokensConcat.addAll((Collection)sentence.get(CoreAnnotations.TokensAnnotation.class));
            List sentenceTokens = wsp.process(tokensConcat);
            if (sentenceTokens.size() != 1) continue;
            sentence.set(EnhancedSentenceAnnotation.class, QuoteAttributionUtils.constructSentence(sentenceTokens.get(0), prevSentence, sentence));
        }
    }

    public static Pair<Integer, Integer> getTokenRangePrecedingQuote(Annotation doc, CoreMap quote) {
        List docSentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        int quoteBeginTokenIndex = (Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (quoteBeginTokenIndex <= 2) {
            return null;
        }
        int quoteBeginSentenceIndex = (Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class);
        CoreMap beginSentence = (CoreMap)docSentences.get(quoteBeginSentenceIndex);
        if (beginSentence.get(EnhancedSentenceAnnotation.class) != null) {
            beginSentence = (CoreMap)beginSentence.get(EnhancedSentenceAnnotation.class);
        }
        int quoteIndex = (Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class);
        if ((Integer)beginSentence.get(CoreAnnotations.TokenBeginAnnotation.class) < quoteBeginTokenIndex - 1) {
            CoreMap prevQuote;
            int prevQuoteTokenEnd;
            if (quoteIndex > 0 && (prevQuoteTokenEnd = ((Integer)(prevQuote = (CoreMap)((List)doc.get(CoreAnnotations.QuotationsAnnotation.class)).get(quoteIndex - 1)).get(CoreAnnotations.TokenEndAnnotation.class)).intValue()) > (Integer)beginSentence.get(CoreAnnotations.TokenBeginAnnotation.class)) {
                if (prevQuoteTokenEnd + 1 == quoteBeginTokenIndex) {
                    return null;
                }
                return new Pair<Integer, Integer>(prevQuoteTokenEnd + 1, quoteBeginTokenIndex - 1);
            }
            return new Pair<Integer, Integer>((Integer)beginSentence.get(CoreAnnotations.TokenBeginAnnotation.class), quoteBeginTokenIndex - 1);
        }
        if (quoteBeginSentenceIndex > 0) {
            int currParagraph = (Integer)beginSentence.get(CoreAnnotations.ParagraphIndexAnnotation.class);
            CoreMap prevSentence = (CoreMap)docSentences.get(quoteBeginSentenceIndex - 1);
            if ((Integer)prevSentence.get(CoreAnnotations.ParagraphIndexAnnotation.class) == currParagraph && quoteIndex > 0) {
                CoreMap prevQuote = (CoreMap)((List)doc.get(CoreAnnotations.QuotationsAnnotation.class)).get(quoteIndex - 1);
                int prevQuoteTokenEnd = (Integer)prevQuote.get(CoreAnnotations.TokenEndAnnotation.class);
                if (prevQuoteTokenEnd > (Integer)prevSentence.get(CoreAnnotations.TokenBeginAnnotation.class)) {
                    if (prevQuoteTokenEnd + 1 == quoteBeginTokenIndex) {
                        return null;
                    }
                    return new Pair<Integer, Integer>(prevQuoteTokenEnd + 1, quoteBeginTokenIndex - 1);
                }
                return new Pair<Integer, Integer>((Integer)prevSentence.get(CoreAnnotations.TokenBeginAnnotation.class), quoteBeginTokenIndex - 1);
            }
        }
        return null;
    }

    public static Pair<Integer, Integer> getTokenRangeFollowingQuote(Annotation doc, CoreMap quote) {
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        int quoteEndTokenIndex = (Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class);
        if (quoteEndTokenIndex >= ((List)doc.get(CoreAnnotations.TokensAnnotation.class)).size() - 2) {
            return null;
        }
        int quoteEndSentenceIndex = (Integer)quote.get(CoreAnnotations.SentenceEndAnnotation.class);
        CoreMap endSentence = (CoreMap)sentences.get(quoteEndSentenceIndex);
        int quoteIndex = (Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class);
        if (quoteEndTokenIndex < (Integer)endSentence.get(CoreAnnotations.TokenEndAnnotation.class) - 2) {
            CoreMap nextQuote;
            int nextQuoteTokenBegin;
            if (quoteIndex < quotes.size() - 1 && (nextQuoteTokenBegin = ((Integer)(nextQuote = (CoreMap)quotes.get(quoteIndex + 1)).get(CoreAnnotations.TokenBeginAnnotation.class)).intValue()) < (Integer)endSentence.get(CoreAnnotations.TokenEndAnnotation.class) - 1) {
                if (quoteEndTokenIndex + 1 == nextQuoteTokenBegin) {
                    return null;
                }
                return new Pair<Integer, Integer>(quoteEndTokenIndex + 1, nextQuoteTokenBegin - 1);
            }
            return new Pair<Integer, Integer>(quoteEndTokenIndex + 1, (Integer)endSentence.get(CoreAnnotations.TokenEndAnnotation.class) - 1);
        }
        if (quoteEndSentenceIndex < sentences.size() - 1) {
            CoreMap nextSentence = (CoreMap)sentences.get(quoteEndSentenceIndex + 1);
            int currParagraph = (Integer)endSentence.get(CoreAnnotations.ParagraphIndexAnnotation.class);
            if ((Integer)nextSentence.get(CoreAnnotations.ParagraphIndexAnnotation.class) == currParagraph && quoteIndex < quotes.size() - 1) {
                CoreMap nextQuote = (CoreMap)quotes.get(quoteIndex + 1);
                int nextQuoteTokenBegin = (Integer)nextQuote.get(CoreAnnotations.TokenBeginAnnotation.class);
                if (nextQuoteTokenBegin < (Integer)nextSentence.get(CoreAnnotations.TokenEndAnnotation.class) - 1) {
                    if (quoteEndTokenIndex + 1 == nextQuoteTokenBegin) {
                        return null;
                    }
                    return new Pair<Integer, Integer>(quoteEndTokenIndex + 1, nextQuoteTokenBegin - 1);
                }
                return new Pair<Integer, Integer>(quoteEndTokenIndex + 1, (Integer)nextSentence.get(CoreAnnotations.TokenEndAnnotation.class) - 1);
            }
        }
        return null;
    }

    private static CoreMap constructCoreMap(Annotation doc, Pair<Integer, Integer> run) {
        int endTokenIndex;
        List tokens = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        for (endTokenIndex = ((Integer)run.second).intValue(); endTokenIndex > 0 && ((Boolean)((CoreLabel)tokens.get(endTokenIndex)).get(CoreAnnotations.IsNewlineAnnotation.class)).booleanValue(); --endTokenIndex) {
        }
        int begin = (Integer)((CoreLabel)tokens.get((Integer)run.first)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int end = (Integer)((CoreLabel)tokens.get(endTokenIndex)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        String sentenceText = ((String)doc.get(CoreAnnotations.TextAnnotation.class)).substring(begin, end);
        List sentenceTokens = tokens.subList((Integer)run.first, endTokenIndex + 1);
        Annotation sentence = new Annotation(sentenceText);
        sentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
        sentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
        sentence.set(CoreAnnotations.TokensAnnotation.class, sentenceTokens);
        return sentence;
    }

    private static SemanticGraph getParse(CoreMap sentence) {
        GrammaticalStructure gs = parser.predict(sentence);
        GrammaticalStructure.Extras maximal = GrammaticalStructure.Extras.MAXIMAL;
        SemanticGraph ccDeps = SemanticGraphFactory.generateEnhancedPlusPlusDependencies(gs);
        return ccDeps;
    }

    public static void annotateForDependencyParse(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (CoreMap quote : quotes) {
            Pair<Integer, Integer> range = QuoteAttributionUtils.getRemainderInSentence(doc, quote);
            if (range == null) continue;
            CoreMap sentenceQuoteRemoved = QuoteAttributionUtils.constructCoreMap(doc, range);
            quote.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, QuoteAttributionUtils.getParse(sentenceQuoteRemoved));
        }
    }

    public static int getParagraphRank(Annotation doc, CoreMap quote) {
        int quoteParaBegin = QuoteAttributionUtils.getParagraphBeginNumber(quote);
        List<CoreMap> sents = QuoteAttributionUtils.getSentsInParagraph(doc, quoteParaBegin);
        ArrayList<CoreMap> quotesInParagraph = Generics.newArrayList();
        for (CoreMap q : (List)doc.get(CoreAnnotations.QuotationsAnnotation.class)) {
            if (QuoteAttributionUtils.getParagraphBeginNumber(q) != quoteParaBegin) continue;
            quotesInParagraph.add(q);
        }
        return quotesInParagraph.indexOf(quote);
    }

    public static int getParagraphBeginNumber(CoreMap quote) {
        List sents = (List)quote.get(CoreAnnotations.SentencesAnnotation.class);
        return (Integer)((CoreMap)sents.get(0)).get(CoreAnnotations.ParagraphIndexAnnotation.class);
    }

    public static int getParagraphEndNumber(CoreMap quote) {
        List sents = (List)quote.get(CoreAnnotations.SentencesAnnotation.class);
        return (Integer)((CoreMap)sents.get(sents.size() - 1)).get(CoreAnnotations.ParagraphIndexAnnotation.class);
    }

    public static List<CoreMap> getSentsInParagraph(Annotation doc, int paragraph) {
        List sents = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        ArrayList<CoreMap> targets = Generics.newArrayList();
        for (CoreMap sent : sents) {
            if ((Integer)sent.get(CoreAnnotations.ParagraphIndexAnnotation.class) != paragraph) continue;
            targets.add(sent);
        }
        return sents;
    }

    public static List<CoreMap> getSentsForQuoteParagraphs(Annotation doc, CoreMap quote) {
        List sents = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        int paragraphBegin = QuoteAttributionUtils.getParagraphBeginNumber(quote);
        int paragraphEnd = QuoteAttributionUtils.getParagraphEndNumber(quote);
        ArrayList<CoreMap> targets = Generics.newArrayList();
        for (CoreMap sent : sents) {
            if ((Integer)sent.get(CoreAnnotations.ParagraphIndexAnnotation.class) < paragraphBegin || (Integer)sent.get(CoreAnnotations.ParagraphIndexAnnotation.class) > paragraphEnd) continue;
            targets.add(sent);
        }
        return sents;
    }

    public static Map<String, Person.Gender> readGenderedNounList(String filename) {
        Map<String, Person.Gender> genderMap = Generics.newHashMap();
        List<String> lines = IOUtils.linesFromFile(filename);
        for (String line : lines) {
            String[] nounAndStats = line.split("\\t");
            String[] stats = nounAndStats[1].split(" ");
            Person.Gender gender = Integer.parseInt(stats[0]) >= Integer.parseInt(stats[1]) ? Person.Gender.MALE : Person.Gender.FEMALE;
            genderMap.put(nounAndStats[0], gender);
        }
        return genderMap;
    }

    public static Set<String> readFamilyRelations(String filename) {
        Set<String> familyRelations = Generics.newHashSet();
        List<String> lines = IOUtils.linesFromFile(filename);
        for (String line : lines) {
            if (line.trim().length() <= 0) continue;
            familyRelations.add(line.toLowerCase().trim());
        }
        return familyRelations;
    }

    public static Set<String> readAnimacyList(String filename) {
        Set<String> animacyList = Generics.newHashSet();
        List<String> lines = IOUtils.linesFromFile(filename);
        for (String line : lines) {
            if (Character.isUpperCase(line.charAt(0))) continue;
            animacyList.add(line);
        }
        return animacyList;
    }

    public static Map<String, List<Person>> readPersonMap(List<Person> personList) {
        HashMap<String, List<Person>> personMap = new HashMap<String, List<Person>>();
        for (Person person : personList) {
            for (String alias : person.aliases) {
                if (personMap.get(alias) == null) {
                    personMap.put(alias, new ArrayList());
                }
                ((List)personMap.get(alias)).add(person);
            }
        }
        return personMap;
    }

    public static Map<String, List<Person>> readPersonMap(String fileName) {
        return QuoteAttributionUtils.readPersonMap(QuoteAttributionUtils.readCharacterList(fileName));
    }

    public static ArrayList<Person> readCharacterList(String filename) {
        ArrayList<Person> characterList = new ArrayList<Person>();
        for (String line : IOUtils.readLines(new File(filename))) {
            String[] terms = line.split(";");
            if (terms.length == 2) {
                characterList.add(new Person(terms[0], terms[1], null));
                continue;
            }
            ArrayList<String> aliases = new ArrayList<String>();
            for (int l = 2; l < terms.length; ++l) {
                aliases.add(terms[l]);
            }
            aliases.add(terms[0]);
            characterList.add(new Person(terms[0], terms[1], aliases));
        }
        return characterList;
    }

    public static boolean isPronominal(String potentialPronoun) {
        return potentialPronoun.toLowerCase().equals("he") || potentialPronoun.toLowerCase().equals("she");
    }

    public static Map<Integer, String> setupCoref(String bammanFile, Map<String, List<Person>> characterMap, Annotation doc) {
        if (bammanFile != null) {
            Map<Integer, List<CoreLabel>> bammanTokens = BammanCorefReader.readTokenFile(bammanFile, doc);
            Map<Integer, String> pronounCorefMap = QuoteAttributionUtils.mapBammanToCharacterMap(bammanTokens, characterMap);
            return pronounCorefMap;
        }
        HashMap<Integer, String> pronounCorefMap = new HashMap<Integer, String>();
        for (CorefChain cc : ((Map)doc.get(CorefCoreAnnotations.CorefChainAnnotation.class)).values()) {
            String representativeMention = cc.getRepresentativeMention().mentionSpan;
            for (CorefChain.CorefMention cm : cc.getMentionsInTextualOrder()) {
                if (!QuoteAttributionUtils.isPronominal(cm.mentionSpan)) continue;
                CoreMap cmSentence = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(cm.sentNum - 1);
                List cmTokens = (List)cmSentence.get(CoreAnnotations.TokensAnnotation.class);
                int charBegin = (Integer)((CoreLabel)cmTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                pronounCorefMap.put(charBegin, representativeMention);
            }
        }
        return pronounCorefMap;
    }

    protected static Map<Integer, String> mapBammanToCharacterMap(Map<Integer, List<CoreLabel>> BammanTokens, Map<String, List<Person>> characterMap) {
        HashMap<Integer, String> indexToCharacterName = new HashMap<Integer, String>();
        for (Integer characterID : BammanTokens.keySet()) {
            List<CoreLabel> tokens = BammanTokens.get(characterID);
            ClassicCounter<String> names = new ClassicCounter<String>();
            int prevEnd = -2;
            String prevName = "";
            for (CoreLabel token : tokens) {
                if (token.tag().equals("NNP")) {
                    int beginIndex = token.beginPosition();
                    if (prevEnd + 1 == beginIndex) {
                        prevName = prevName + " " + token.word();
                        continue;
                    }
                    if (!prevName.equals("")) {
                        names.incrementCount(prevName, 1.0);
                    }
                    prevName = token.word();
                    prevEnd = token.endPosition();
                    continue;
                }
                if (!prevName.equals("")) {
                    names.incrementCount(prevName, 1.0);
                }
                prevName = "";
                prevEnd = -2;
            }
            boolean flag = false;
            for (String name : Counters.toSortedList(names)) {
                if (!characterMap.keySet().contains(name)) continue;
                indexToCharacterName.put(characterID, name);
                flag = true;
                break;
            }
            if (!flag) {
                for (String charName : characterMap.keySet()) {
                    for (String name : Counters.toSortedList(names)) {
                        if (!charName.contains(name)) continue;
                        indexToCharacterName.put(characterID, charName);
                        flag = true;
                        System.out.println("contingency name found" + characterID);
                        for (String n : Counters.toSortedList(names)) {
                            System.out.print(n + "|");
                        }
                        System.out.println();
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
                System.out.println();
            }
            if (flag) continue;
            System.err.println("no name found :( " + characterID);
            for (String name : Counters.toSortedList(names)) {
                System.err.print(name + "| ");
            }
            System.err.println();
        }
        HashMap<Integer, String> beginIndexToName = new HashMap<Integer, String>();
        for (Integer charId : BammanTokens.keySet()) {
            if (indexToCharacterName.get(charId) == null) continue;
            List<CoreLabel> tokens = BammanTokens.get(charId);
            for (CoreLabel btoken : tokens) {
                if (!btoken.tag().equals("PRP")) continue;
                beginIndexToName.put(btoken.beginPosition(), (String)indexToCharacterName.get(charId));
            }
        }
        return beginIndexToName;
    }

    public static boolean rangeContains(Pair<Integer, Integer> r1, Pair<Integer, Integer> r2) {
        return (Integer)r1.first <= (Integer)r2.first && (Integer)r1.second >= (Integer)r2.first || (Integer)r1.first <= (Integer)r2.second && (Integer)r1.second >= (Integer)r2.second;
    }

    public static class EnhancedSentenceAnnotation
    implements CoreAnnotation<CoreMap> {
        @Override
        public Class<CoreMap> getType() {
            return CoreMap.class;
        }
    }
}

