/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import java.util.function.Function;
import junit.framework.TestCase;

public class SemanticGraphUtilsTest
extends TestCase {
    SemanticGraph graph;

    public void testCreateSemgrexPattern() {
        try {
            SemanticGraph graph = SemanticGraph.valueOf("[ate subj>Bill]");
            Function<IndexedWord, String> transformNode = o -> "{word: " + o.word().toLowerCase() + "; tag: " + o.tag() + "; ner: " + o.ner() + "}";
            String pat = SemanticGraphUtils.semgrexFromGraphOrderedNodes(graph, null, null, transformNode);
            SemanticGraphUtilsTest.assertEquals((String)"{word: ate; tag: null; ner: null}=ate  >subj=E1 {word: bill; tag: null; ner: null}=Bill", (String)pat.trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

