/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.DeleteGraphFromNode;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.RemoveNamedEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonPattern;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class SsurgeonTest {
    @Test
    public void simpleTest() throws Exception {
        SemanticGraph sg = SemanticGraph.valueOf("[mixed/VBN nsubj>[Joe/NNP appos>[bartender/NN det>the/DT]]  dobj>[drink/NN det>a/DT]]");
        SemgrexPattern semgrexPattern = SemgrexPattern.compile("{}=a1 >appos=e1 {}=a2 <nsubj=e2 {}=a3");
        SsurgeonPattern pattern = new SsurgeonPattern(semgrexPattern);
        System.out.println("Start = " + sg.toCompactString());
        RemoveNamedEdge apposSnip = new RemoveNamedEdge("e1", "a1", "a2");
        pattern.addEdit(apposSnip);
        RemoveNamedEdge nsubjSnip = new RemoveNamedEdge("e2", "a3", "a1");
        pattern.addEdit(nsubjSnip);
        AddEdge reattachSubj = new AddEdge("a2", "a1", EnglishGrammaticalRelations.NOMINAL_SUBJECT);
        pattern.addEdit(reattachSubj);
        IndexedWord isNode = new IndexedWord();
        isNode.set(CoreAnnotations.TextAnnotation.class, "is");
        isNode.set(CoreAnnotations.LemmaAnnotation.class, "is");
        isNode.set(CoreAnnotations.OriginalTextAnnotation.class, "is");
        isNode.set(CoreAnnotations.PartOfSpeechAnnotation.class, "VBN");
        AddDep addCopula = new AddDep("a2", EnglishGrammaticalRelations.COPULA, isNode);
        pattern.addEdit(addCopula);
        DeleteGraphFromNode destroySubgraph = new DeleteGraphFromNode("a3");
        pattern.addEdit(destroySubgraph);
        Collection<SemanticGraph> newSgs = pattern.execute(sg);
        for (SemanticGraph newSg : newSgs) {
            System.out.println("Modified = " + newSg.toCompactString());
        }
        String firstGraphString = newSgs.iterator().next().toCompactString().trim();
        Assert.assertEquals((Object)firstGraphString, (Object)"[bartender cop>is nsubj>Joe det>the]");
    }
}

