/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ChineseSegmenterAnnotator;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.util.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class ChineseDocument
extends Document {
    private static final Lazy<Annotator> chineseSegmenter = Lazy.of(() -> new ChineseSegmenterAnnotator("segment", new Properties(){
        {
            this.setProperty("segment.model", "edu/stanford/nlp/models/segmenter/chinese/ctb.gz");
            this.setProperty("segment.sighanCorporaDict", "edu/stanford/nlp/models/segmenter/chinese");
            this.setProperty("segment.serDictionary", "edu/stanford/nlp/models/segmenter/chinese/dict-chris6.ser.gz");
            this.setProperty("segment.sighanPostProcessing", "true");
        }
    }));
    static final Properties EMPTY_PROPS = new Properties(){
        {
            try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-chinese.properties");){
                this.load(is);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "chinese");
            this.setProperty("annotators", "");
            this.setProperty("parse.binaryTrees", "true");
        }
    };

    public ChineseDocument(String text) {
        super(EMPTY_PROPS, text);
    }

    public ChineseDocument(Annotation ann) {
        super(EMPTY_PROPS, ann);
    }

    public ChineseDocument(CoreNLPProtos.Document proto) {
        super(EMPTY_PROPS, proto);
    }

    protected ChineseDocument(Properties props, String text) {
        super(props, text);
    }

    @Override
    public List<Sentence> sentences(Properties props) {
        return this.sentences(props, chineseSegmenter.get());
    }

    @Override
    protected Document runLemma(Properties props) {
        return this.mockLemma(props);
    }

    @Override
    protected Document runSentiment(Properties props) {
        throw new IllegalArgumentException("Sentiment analysis is not implemented for Chinese");
    }

    @Override
    Document runDepparse(Properties props) {
        return this.runParse(props);
    }
}

